/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.helper;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import com.hippoagent.HippoActivityLifecycleCallback;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u00a8\u0006\n"}, d2={"Lcom/hippoagent/helper/ConnectionUtils;", "", "()V", "isAppRunning", "", "context", "Landroid/content/Context;", "isMyServiceRunning", "serviceClass", "Ljava/lang/Class;", "hippoagentsdk_release"})
public final class ConnectionUtils {
    public static final ConnectionUtils INSTANCE;

    public final boolean isAppRunning(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("activity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.ActivityManager");
        }
        ActivityManager activityManager = (ActivityManager)object;
        List taskList = activityManager.getRunningTasks(10);
        if (taskList != null && taskList.size() > 0) {
            for (ActivityManager.RunningTaskInfo task : taskList) {
                ComponentName componentName = task.topActivity;
                Intrinsics.checkExpressionValueIsNotNull((Object)componentName, (String)"task.topActivity");
                if (!HippoActivityLifecycleCallback.hippoClasses.contains(componentName.getClassName())) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isMyServiceRunning(@NotNull Context context, @NotNull Class<?> serviceClass) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(serviceClass, (String)"serviceClass");
        Object object = context.getSystemService("activity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.ActivityManager");
        }
        ActivityManager manager = (ActivityManager)object;
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            String string2 = serviceClass.getName();
            ComponentName componentName = service.service;
            Intrinsics.checkExpressionValueIsNotNull((Object)componentName, (String)"service.service");
            if (!Intrinsics.areEqual((Object)string2, (Object)componentName.getClassName())) continue;
            return true;
        }
        return false;
    }

    private ConnectionUtils() {
    }

    static {
        ConnectionUtils connectionUtils;
        INSTANCE = connectionUtils = new ConnectionUtils();
    }
}

