/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.fragments;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.fragment.app.Fragment;
import com.google.android.material.appbar.AppBarLayout;
import com.google.android.material.appbar.CollapsingToolbarLayout;
import com.google.gson.Gson;
import com.hippoagent.MyApplication;
import com.hippoagent.R;
import com.hippoagent.activities.BroadcastListActivity;
import com.hippoagent.activities.PlansActivity;
import com.hippoagent.activities.ProfileActivityName;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.ApiResponseFlags;
import com.hippoagent.dialogs.DialogPop;
import com.hippoagent.eventbus.BusProvider;
import com.hippoagent.eventbus.FragmentEvent;
import com.hippoagent.eventbus.OnResume;
import com.hippoagent.fragments.BaseFragment;
import com.hippoagent.fragments.EditProfileFragment;
import com.hippoagent.model.EditProfileResponse;
import com.hippoagent.model.LoginResponse.LoginResponse;
import com.hippoagent.model.agent_profile_response.AgentProfileDetails;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonParams;
import com.hippoagent.retrofit.MultipartParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.LoadImageFile;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.SwitchButton;
import com.hippoagent.utils.UniqueIMEIID;
import com.hippoagent.utils.filelogger.Logger;
import com.squareup.otto.Subscribe;
import io.paperdb.Paper;
import retrofit2.Callback;

public class ViewProfileFragment
extends BaseFragment
implements View.OnClickListener {
    private SwitchButton switchOnline;
    private TextView tvAgentName;
    private TextView logout;
    private TextView changePassword;
    private TextView broadcastChat;
    private TextView savedPlan;
    private TextView account;
    private ImageView ivUserImage;
    private AgentProfileDetails agentProfileDetails;
    private AppCompatImageView ivEdit;
    private TextView tvAgentStatus;
    private CollapsingToolbarLayout collapsingToolbarLayout;
    private LinearLayout llToolbar;
    private AppBarLayout mAppBarLayout;

    public static ViewProfileFragment newInstance() {
        ViewProfileFragment fragment = new ViewProfileFragment();
        return fragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_view_profile, container, false);
        this.initViews(view);
        return view;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (view != null) {
            InputMethodManager imm = (InputMethodManager)this.getActivity().getSystemService("input_method");
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    public void onStart() {
        super.onStart();
        BusProvider.getInstance().register((Object)this);
    }

    public void onStop() {
        super.onStop();
        BusProvider.getInstance().unregister((Object)this);
    }

    private void initViews(View view) {
        this.tvAgentStatus = (TextView)view.findViewById(R.id.tvAgentStatus);
        this.tvAgentName = (TextView)view.findViewById(R.id.tvAgentName);
        this.switchOnline = (SwitchButton)view.findViewById(R.id.switchOnline);
        this.ivUserImage = (ImageView)view.findViewById(R.id.ivUserImage);
        this.changePassword = (TextView)view.findViewById(R.id.changePassword);
        this.collapsingToolbarLayout = (CollapsingToolbarLayout)view.findViewById(R.id.collapsing_toolbar);
        this.llToolbar = (LinearLayout)view.findViewById(R.id.llToolbar);
        this.mAppBarLayout = (AppBarLayout)view.findViewById(R.id.appbar);
        this.collapsingToolbarLayout.setTitle((CharSequence)"");
        this.changePassword.setOnClickListener((View.OnClickListener)this);
        this.broadcastChat = (TextView)view.findViewById(R.id.broadcastChat);
        this.broadcastChat.setOnClickListener((View.OnClickListener)this);
        this.savedPlan = (TextView)view.findViewById(R.id.savedPlan);
        this.savedPlan.setOnClickListener((View.OnClickListener)this);
        this.ivEdit = (AppCompatImageView)view.findViewById(R.id.ivEdit);
        this.ivEdit.setOnClickListener((View.OnClickListener)this);
        this.logout = (TextView)view.findViewById(R.id.logout);
        this.logout.setOnClickListener((View.OnClickListener)this);
        this.account = (TextView)view.findViewById(R.id.account);
        this.account.setOnClickListener((View.OnClickListener)this);
        this.savedPlan.setVisibility(8);
        try {
            if (MyApplication.getInstance().getUserData().getAgentType() == 11) {
                this.broadcastChat.setVisibility(8);
            }
            if (MyApplication.getInstance().getUserData().getBusinessProperty().isAskPaymentAllowed()) {
                this.savedPlan.setVisibility(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.llToolbar.setVisibility(8);
        this.mAppBarLayout.addOnOffsetChangedListener(new AppBarLayout.OnOffsetChangedListener(){
            int scrollRange = -1;
            boolean isShow = false;

            public void onOffsetChanged(AppBarLayout appBarLayout, int verticalOffset) {
                if (this.scrollRange == -1) {
                    this.scrollRange = appBarLayout.getTotalScrollRange();
                }
                if (this.scrollRange + verticalOffset == 0) {
                    this.isShow = true;
                    ViewProfileFragment.this.llToolbar.setVisibility(0);
                } else if (this.isShow) {
                    this.isShow = false;
                    ViewProfileFragment.this.llToolbar.setVisibility(8);
                }
            }
        });
        this.setAgentData();
        this.switchOnline.setOnCheckedChangeListener(new SwitchButton.OnCheckedChangeListener(){

            @Override
            public void onCheckedChanged(SwitchButton compoundButton, boolean b) {
                if (ViewProfileFragment.this.isNetworkAvailable()) {
                    ViewProfileFragment.this.setAgentOnlineStatus();
                } else {
                    Toast.makeText((Context)ViewProfileFragment.this.getActivity(), (CharSequence)ViewProfileFragment.this.getString(R.string.fugu_unable_to_connect_internet), (int)0).show();
                    if (b) {
                        ViewProfileFragment.this.switchOnline.updateStatus(false);
                    } else {
                        ViewProfileFragment.this.switchOnline.updateStatus(true);
                    }
                }
            }
        });
        if (MyApplication.getInstance().getUserData().getOnlineStatus().equals("AVAILABLE")) {
            this.switchOnline.updateStatus(true);
            this.tvAgentStatus.setText(R.string.available);
        } else if (MyApplication.getInstance().getUserData().getOnlineStatus().equals("AWAY")) {
            this.switchOnline.updateStatus(false);
            this.tvAgentStatus.setText(R.string.away);
        } else {
            this.switchOnline.updateStatus(false);
            this.tvAgentStatus.setText(R.string.offline);
        }
    }

    @Subscribe
    public void onFragmentEvent(FragmentEvent fragmentEvent) {
        if (fragmentEvent.fragmentType != 2) {
            return;
        }
        switch (fragmentEvent.dataType) {
            case 1: {
                boolean flag = (Boolean)fragmentEvent.object;
                if (flag) {
                    this.switchOnline.updateStatus(true);
                    this.updateStatus();
                    break;
                }
                this.switchOnline.updateStatus(false);
                this.updateStatus();
                break;
            }
            case 2: {
                this.setAgentData();
            }
        }
    }

    private void updateStatus() {
        if (MyApplication.getInstance().getUserData().getOnlineStatus().equals("AVAILABLE")) {
            this.tvAgentStatus.setText(R.string.available);
        } else if (MyApplication.getInstance().getUserData().getOnlineStatus().equals("AWAY")) {
            this.tvAgentStatus.setText(R.string.away);
        } else {
            this.tvAgentStatus.setText(R.string.offline);
        }
    }

    private void setAgentOnlineStatus() {
        MultipartParams.Builder multipartBuilder = new MultipartParams.Builder();
        MultipartParams multipartParams = multipartBuilder.add("access_token", MyApplication.getInstance().getUserData().getAccessToken()).add("en_user_id", MyApplication.getInstance().getUserData().getEnUserId()).add("agent_type", String.valueOf(MyApplication.getInstance().getUserData().getAgentType())).add("business_id", String.valueOf(MyApplication.getInstance().getUserData().getBusinessId())).add("device_id", UniqueIMEIID.getUniqueIMEIId((Context)this.getActivity())).add("device_type", "1").add("online_status", this.switchOnline.isChecked() ? "AVAILABLE" : "AWAY").build();
        String value = new Gson().toJson(multipartParams.getMap());
        Logger.INSTANCE.apiRequest("/api/agent/editInfo", value);
        RestClient.getApiInterface().editAgentInfo(multipartParams.getMap()).enqueue((Callback)new ResponseResolver<EditProfileResponse>((Activity)this.getActivity(), Boolean.valueOf(true), Boolean.valueOf(false)){

            @Override
            public void success(EditProfileResponse editProfileResponse) {
                Logger.INSTANCE.apiResponse("/api/agent/editInfo", "");
                try {
                    if (ViewProfileFragment.this.switchOnline.isChecked()) {
                        MyApplication.getInstance().getUserData().setOnlineStatus("AVAILABLE");
                        BusProvider.getInstance().post((Object)new FragmentEvent(1, 1, true));
                    } else {
                        MyApplication.getInstance().getUserData().setOnlineStatus("AWAY");
                        BusProvider.getInstance().post((Object)new FragmentEvent(1, 1, false));
                    }
                    ViewProfileFragment.this.updateStatus();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void failure(APIError error) {
                Logger.INSTANCE.apiFailed("/api/agent/editInfo", error.getMessage());
                Toast.makeText((Context)ViewProfileFragment.this.getActivity(), (CharSequence)error.getMessage(), (int)0).show();
                ViewProfileFragment.this.switchOnline.updateStatus(!ViewProfileFragment.this.switchOnline.isChecked());
            }
        });
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.tvEditProfile) {
            EditProfileFragment editProfileFragment = new EditProfileFragment();
            Bundle bundle = new Bundle();
            bundle.putParcelable("agentData", (Parcelable)this.agentProfileDetails);
            editProfileFragment.setArguments(bundle);
            this.getActivity().getSupportFragmentManager().beginTransaction().setCustomAnimations(R.anim.anim_slide_in_left, R.anim.anim_slide_out_left, R.anim.anim_slide_in_right, R.anim.anim_slide_out_right).add(R.id.llContainer, (Fragment)editProfileFragment, EditProfileFragment.class.getName()).commit();
        } else if (id2 == R.id.changePassword) {
            Intent profile = new Intent((Context)this.getActivity(), ProfileActivityName.class);
            profile.putExtra("fragment_type", 1);
            this.startActivity(profile);
        } else if (id2 == R.id.broadcastChat) {
            this.startActivity(new Intent((Context)this.getActivity(), BroadcastListActivity.class));
        } else if (id2 == R.id.savedPlan) {
            Intent planIntent = new Intent((Context)this.getActivity(), PlansActivity.class);
            this.startActivity(planIntent);
        } else if (id2 == R.id.ivEdit) {
            Intent profileEdit = new Intent((Context)this.getActivity(), ProfileActivityName.class);
            profileEdit.putExtra("isEditable", true);
            this.startActivity(profileEdit);
        } else if (id2 == R.id.account) {
            this.startActivity(new Intent((Context)this.getActivity(), ProfileActivityName.class));
        } else if (id2 == R.id.logout) {
            this.performLogout();
        }
    }

    private void setAgentData() {
        try {
            this.agentProfileDetails = MyApplication.getInstance().getAgentProfileDetails();
            this.tvAgentName.setText((CharSequence)this.agentProfileDetails.getData().getFullName());
            Log.e("TAG", "URL = " + this.agentProfileDetails.getData().getUserImage());
            LoadImageFile.getInstance().loadImage((Context)this.getActivity(), this.agentProfileDetails.getData().getUserImage(), this.ivUserImage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Subscribe
    public void onActivityResume(OnResume onResume) {
        this.setAgentData();
    }

    public void onResume() {
        super.onResume();
    }

    private void performLogout() {
        DialogPop dialogPop = new DialogPop();
        dialogPop.alertPopupWithTwoButton((Context)this.getActivity(), "", this.getResources().getString(R.string.logout_message), this.getResources().getString(R.string.logout_caps), this.getResources().getString(R.string.cancel), new DialogPop.Callback(){

            @Override
            public void onPositiveClick() {
                ViewProfileFragment.this.apiLogout();
            }

            @Override
            public void onNegativeClick() {
            }
        });
    }

    private void apiLogout() {
        if (this.isNetworkAvailable()) {
            Paper.book((String)CommonData.name).delete("latest_version");
            CommonParams commonParams = new CommonParams.Builder().add("access_token", MyApplication.getInstance().getUserData().getAccessToken()).add("device_id", UniqueIMEIID.getUniqueIMEIId((Context)this.getActivity())).add("device_type", "1").build();
            Logger.INSTANCE.apiRequest("/api/agent/agentLogout", new Gson().toJson(commonParams.getMap()));
            RestClient.getApiInterface().logout(commonParams.getMap()).enqueue((Callback)new ResponseResolver<LoginResponse>((Activity)this.getActivity(), Boolean.valueOf(true), Boolean.valueOf(true)){

                @Override
                public void success(LoginResponse loginResponse) {
                    Logger.INSTANCE.apiResponse("/api/agent/agentLogout", "");
                    try {
                        if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == loginResponse.getStatusCode().intValue()) {
                            MyApplication.getInstance().logout((Activity)ViewProfileFragment.this.getActivity());
                        }
                    }
                    catch (Exception e) {
                        Logger.INSTANCE.apiFailed("/api/agent/agentLogout", e.getLocalizedMessage());
                        e.printStackTrace();
                    }
                }

                @Override
                public void failure(APIError error) {
                    Logger.INSTANCE.apiFailed("/api/agent/agentLogout", error.getMessage());
                    Log.e("error", "error");
                }
            });
        } else {
            Toast.makeText((Context)this.getActivity(), (CharSequence)this.getString(R.string.fugu_unable_to_connect_internet), (int)0).show();
        }
    }
}

