/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.fragments;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.google.android.material.R;
import com.google.android.material.snackbar.Snackbar;
import com.google.gson.Gson;
import com.hippoagent.MyApplication;
import com.hippoagent.R;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.activities.HomeActivity;
import com.hippoagent.activities.PaymentViewActivity;
import com.hippoagent.adapters.ConversationChatAdapter;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.ApiResponseFlags;
import com.hippoagent.datastructure.ConversationMode;
import com.hippoagent.datastructure.MessageMode;
import com.hippoagent.datastructure.MessageType;
import com.hippoagent.datastructure.NotificationType;
import com.hippoagent.datastructure.Overlay;
import com.hippoagent.eventbus.BusProvider;
import com.hippoagent.eventbus.ConnectionMessage;
import com.hippoagent.eventbus.FilterEvent;
import com.hippoagent.eventbus.FragmentEvent;
import com.hippoagent.eventbus.ReceivedMessage;
import com.hippoagent.eventbus.UpdateEvent;
import com.hippoagent.fcm.AudioPlay;
import com.hippoagent.fcm.NotificationDatabase;
import com.hippoagent.fcm.NotificationUtils;
import com.hippoagent.helper.VersionUpdate;
import com.hippoagent.model.Conversation;
import com.hippoagent.model.Filter;
import com.hippoagent.model.FilterModel;
import com.hippoagent.model.GetConversationResponse;
import com.hippoagent.model.LoginResponse.ChannelFilter;
import com.hippoagent.model.LoginResponse.Tag;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonParamsObj;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.DateUtils;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.Utils;
import com.hippoagent.utils.filelogger.Logger;
import com.hippoagent.utils.loadingBox.LoadingBox;
import com.hippoagent.utils.recylerviewAnimation.FadeInLeftAnimator;
import com.squareup.otto.Subscribe;
import io.paperdb.Paper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.CopyOnWriteArraySet;
import org.json.JSONObject;
import retrofit2.Callback;

public class HomeFragment
extends Fragment
implements SwipeRefreshLayout.OnRefreshListener {
    private static final String ARG_PARAM1 = "selectedMode";
    private static final String ARG_PARAM2 = "param2";
    private static final String ARG_PARAM3 = "position";
    private int selectedMode = MessageMode.OPEN_CHAT.getOrdinal();
    private String mParam2;
    private View root;
    private RelativeLayout relative;
    private boolean isPagingApiInProgress;
    private ArrayList<Conversation> conversationChatList = new ArrayList();
    private boolean getConversationApiHit;
    private int pos = -1;
    public MenuItem filerIcon;
    public MenuItem updateIcon;
    private boolean isPressed1 = false;
    private Context mContext;
    Activity activity;
    private RelativeLayout rlUpdatingConvo;
    private LinearLayout retryLayout;
    private TextView btnRetry;
    private RelativeLayout rlPaymentView;
    private TextView tvPaymentMessage;
    private Button btnAddCard;
    private Button btnCancel;
    public static final String RECIEVER_MSG = "com.fugu.agent.msg";
    public static final String RECIEVER_MSG_AGENT_REFRESH = "com.fugu.agent.refresh.msg";
    public boolean hasPagination = true;
    private SwipeRefreshLayout srLayout;
    private RecyclerView rvAll;
    private ConversationChatAdapter conversationChatAdapter;
    private ArrayList<Object> conversationsList = new ArrayList();
    LinearLayoutManager layoutManager;
    private int pastVisiblesItems;
    private int visibleItemCount;
    private int totalItemCount;
    private LinearLayout llNoConversation;
    private Handler handler = new Handler();
    private final int OVERLAY_TIME = 1000;
    private int chatType = MessageType.MY_CHAT.getOrdinal();
    boolean firstTimeFetch = true;
    boolean isFrontView = false;
    int position = 0;
    private ConversationChatAdapter.ProgressBarItem progressBarItem;
    boolean firstTime = false;
    int removePos = -1;
    String lastMuid = "";
    private int pageEnd = 0;
    boolean isApiInProgress = false;
    boolean isApiGetAgents = false;
    HashSet<String> apiRunning = new HashSet();
    boolean isSnackbarVisible = false;
    private Snackbar snackbar;
    private int newMessageCount = 0;
    private FilterModel filterModel;
    public boolean loadmore = true;
    private boolean isFromFilter = false;
    public String selectedPeople = null;
    public String selectedPeopleUserId = null;
    public ArrayList<Tag> labels = new ArrayList();
    private int[] statusIntArray = new int[]{MessageMode.OPEN_CHAT.getOrdinal()};
    private int[] typeIntArray = new int[]{ConversationMode.DEFAULT.getOrdinal()};
    private int[] labelsIntArray = new int[0];
    private int[] channelsIntArray = new int[0];

    public static HomeFragment newInstance(int selectedMode, String param2) {
        HomeFragment fragment = new HomeFragment();
        Bundle args = new Bundle();
        args.putInt(ARG_PARAM1, selectedMode);
        args.putString(ARG_PARAM2, param2);
        fragment.setArguments(args);
        return fragment;
    }

    public void setUserVisibleHint(boolean visible) {
        super.setUserVisibleHint(visible);
        this.isFrontView = visible;
        if (visible && this.isResumed() && this.position > 0 && this.firstTimeFetch) {
            this.firstTimeFetch = false;
            this.onresumeHandler(true, -1, true);
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
        if (this.getArguments() != null) {
            this.selectedMode = this.getArguments().getInt(ARG_PARAM1);
            this.mParam2 = this.getArguments().getString(ARG_PARAM2);
            this.position = this.getArguments().getInt(ARG_PARAM3);
            this.chatType = this.getArguments().getInt(ARG_PARAM3);
        }
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.mContext = context;
        if (context instanceof Activity) {
            this.activity = (Activity)context;
        }
    }

    public void onStart() {
        super.onStart();
        BusProvider.getInstance().register((Object)this);
    }

    public void onStop() {
        super.onStop();
        BusProvider.getInstance().unregister((Object)this);
    }

    public SwipeRefreshLayout getSrLayout() {
        return this.srLayout;
    }

    public void toggleProgressBarVisibility(boolean isVisible) {
        if (isVisible) {
            if (this.progressBarItem == null) {
                this.progressBarItem = new ConversationChatAdapter.ProgressBarItem();
            }
            if (!this.conversationsList.contains(this.progressBarItem)) {
                this.conversationsList.add(this.progressBarItem);
                this.rvAll.post(new Runnable(){

                    @Override
                    public void run() {
                        HomeFragment.this.conversationChatAdapter.notifyItemInserted(HomeFragment.this.conversationsList.size() - 1);
                    }
                });
            }
        } else if (this.progressBarItem != null && this.conversationsList.contains(this.progressBarItem)) {
            this.conversationsList.remove(this.progressBarItem);
            this.conversationChatAdapter.notifyItemRemoved(this.conversationsList.size() - 1);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.root = inflater.inflate(R.layout.home_fragment, container, false);
        this.relative = (RelativeLayout)this.root.findViewById(R.id.root);
        this.rlUpdatingConvo = (RelativeLayout)this.root.findViewById(R.id.rlUpdatingConvo);
        this.btnRetry = (TextView)this.root.findViewById(R.id.btnRetry);
        this.retryLayout = (LinearLayout)this.root.findViewById(R.id.retry_layout);
        this.rlPaymentView = (RelativeLayout)this.root.findViewById(R.id.rlPaymentView);
        this.tvPaymentMessage = (TextView)this.root.findViewById(R.id.tvPaymentMessage);
        this.btnAddCard = (Button)this.root.findViewById(R.id.btn_add);
        this.btnCancel = (Button)this.root.findViewById(R.id.btn_cancel);
        this.srLayout = (SwipeRefreshLayout)this.root.findViewById(R.id.srLayout);
        this.srLayout.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)this);
        this.srLayout.setColorSchemeResources(new int[]{R.color.white});
        this.srLayout.setProgressBackgroundColorSchemeResource(R.color.colorPrimary);
        this.srLayout.setSize(1);
        this.llNoConversation = (LinearLayout)this.root.findViewById(R.id.llNoConversation);
        this.rvAll = (RecyclerView)this.root.findViewById(R.id.rvAll);
        this.layoutManager = new LinearLayoutManager((Context)this.activity);
        this.rvAll.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.rvAll.setItemAnimator((RecyclerView.ItemAnimator)new FadeInLeftAnimator());
        this.rvAll.getItemAnimator().setAddDuration(500L);
        this.rvAll.getItemAnimator().setRemoveDuration(500L);
        this.rvAll.setHasFixedSize(false);
        if (this.chatType == MessageType.ALL_CHAT.getOrdinal()) {
            this.typeIntArray = new int[]{ConversationMode.ALL.getOrdinal()};
        } else if (this.chatType == MessageType.P2P_CHAT.getOrdinal()) {
            this.typeIntArray = new int[]{ConversationMode.P2P.getOrdinal()};
        }
        this.setupViewPager();
        this.btnAddCard.setOnClickListener(v -> {
            Intent intent = new Intent((Context)this.getActivity(), PaymentViewActivity.class);
            this.startActivity(intent);
        });
        this.btnCancel.setOnClickListener(v -> {
            try {
                this.rlPaymentView.setVisibility(8);
                MyApplication.getInstance().getUserData().setExpiryInfo(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.setFilterAdapter();
        return this.root;
    }

    private void updateExpiryInfo() {
        this.rlPaymentView.setVisibility(8);
        if (MyApplication.getInstance().getUserData().getExpiryInfo() != null) {
            this.rlPaymentView.setVisibility(0);
            this.tvPaymentMessage.setText((CharSequence)MyApplication.getInstance().getUserData().getExpiryInfo().getMessage());
            if (MyApplication.getInstance().getUserData().getExpiryInfo().getKeepShowing().booleanValue()) {
                this.btnCancel.setVisibility(8);
            } else {
                this.btnCancel.setVisibility(0);
            }
            if (MyApplication.getInstance().getUserData().getExpiryInfo().getAllowCardDetail().booleanValue()) {
                this.btnAddCard.setVisibility(0);
            } else {
                this.btnAddCard.setVisibility(8);
            }
            if (MyApplication.getInstance().getUserData().getExpiryInfo().getKeepShowing().booleanValue() && !MyApplication.getInstance().getUserData().getExpiryInfo().getAllowCardDetail().booleanValue()) {
                this.tvPaymentMessage.setGravity(17);
            }
        } else {
            this.rlPaymentView.setVisibility(8);
        }
    }

    @Subscribe
    public void onConnectionMessage(ConnectionMessage connectionMessage) {
        this.setConnectionMessage(connectionMessage.type);
    }

    private void preLoader(final int endPoint) {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                boolean hasConversation = false;
                if (!HomeFragment.this.isNetworkAvailable()) {
                    HomeFragment.this.setConnectionMessage(3);
                } else if (!HomeFragment.this.isFromFilter && (HomeFragment.this.firstTime || HomeFragment.this.position == 0) && HomeFragment.this.isFrontView) {
                    if (HomeFragment.this.conversationChatList != null && HomeFragment.this.conversationChatList.size() > 0) {
                        try {
                            HomeFragment.this.rlUpdatingConvo.setVisibility(0);
                        }
                        catch (Exception e) {
                            HomeFragment.this.getActivity().runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    HomeFragment.this.rlUpdatingConvo.setVisibility(0);
                                }
                            });
                        }
                    }
                    HomeFragment.this.onresumeHandler(true, endPoint, !HomeFragment.this.firstTime);
                }
                HomeFragment.this.firstTime = true;
            }
        }, 50L);
    }

    public void onResume() {
        super.onResume();
        this.updateExpiryInfo();
        int endPoint = -1;
        if (this.conversationChatList != null && this.conversationChatList.size() > 0) {
            endPoint = this.conversationChatList.size();
            this.checkBKSound(-1);
        }
        this.preLoader(endPoint);
    }

    private void onresumeHandler(final boolean hasConversation, final int endPoint, final boolean showLoader) {
        try {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (MyApplication.getInstance() != null && MyApplication.getInstance().getUserData() != null && MyApplication.getInstance().getUserData().getUserId() != null && hasConversation) {
                            HomeFragment.this.apiGetConversation(String.valueOf(MyApplication.getInstance().getUserData().getUserId()), HomeFragment.this.getStatusIntArray(), HomeFragment.this.getTypeIntArray(), HomeFragment.this.getLabelsIntArray(), 1, false, showLoader, false, endPoint);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, 1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onHiddenChanged(boolean hidden) {
        super.onHiddenChanged(hidden);
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public boolean isGetConversationApiHit() {
        return this.getConversationApiHit;
    }

    public boolean isPagingApiInProgress() {
        return this.isPagingApiInProgress;
    }

    public void setPagingApiInProgress(boolean pagingApiInProgress) {
        this.isPagingApiInProgress = pagingApiInProgress;
    }

    private void setupViewPager() {
        this.conversationChatAdapter = new ConversationChatAdapter(this.conversationsList, this.activity, new ConversationChatAdapter.Callback(){

            @Override
            public void onClick(int position, Conversation conversation) {
                if (!Utils.preventMultipleClicks()) {
                    return;
                }
                Intent chatIntent = new Intent((Context)HomeFragment.this.activity, FuguChatActivity.class);
                if (HomeFragment.this.chatType == MessageType.P2P_CHAT.getOrdinal()) {
                    chatIntent.putExtra("is_p2p_chat", true);
                } else {
                    chatIntent.putExtra("is_p2p_chat", false);
                }
                chatIntent.putExtra("conversation", new Gson().toJson((Object)conversation, Conversation.class));
                HomeFragment.this.startActivityForResult(chatIntent, 100);
            }
        }, this.rvAll);
        this.rvAll.setAdapter((RecyclerView.Adapter)this.conversationChatAdapter);
        this.rvAll.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                Log.v("scroll state ", "changed");
            }

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                if (dy > 0) {
                    HomeFragment.this.visibleItemCount = HomeFragment.this.layoutManager.getChildCount();
                    HomeFragment.this.totalItemCount = HomeFragment.this.layoutManager.getItemCount();
                    HomeFragment.this.pastVisiblesItems = HomeFragment.this.layoutManager.findFirstVisibleItemPosition();
                    if (HomeFragment.this.isNetworkAvailable() && HomeFragment.this.hasPagination && !HomeFragment.this.isPagingApiInProgress() && HomeFragment.this.visibleItemCount + HomeFragment.this.pastVisiblesItems >= HomeFragment.this.totalItemCount) {
                        try {
                            if (HomeFragment.this.loadmore) {
                                HomeFragment.this.fetchNextPage();
                            }
                        }
                        catch (Exception e) {
                            HomeFragment.this.fetchNextPage();
                        }
                    }
                } else if (HomeFragment.this.snackbar != null && HomeFragment.this.layoutManager.findFirstVisibleItemPosition() == 1) {
                    HomeFragment.this.snackbar.dismiss();
                }
            }
        });
    }

    private void fetchNextPage() {
        this.setPagingApiInProgress(true);
        this.toggleProgressBarVisibility(true);
        int pageStart = this.conversationsList.size();
        if (this.conversationsList.contains(this.progressBarItem)) {
            pageStart = this.conversationsList.size();
        }
        this.isApiInProgress = false;
        if (this.selectedPeople == null && !this.isFromFilter) {
            this.apiGetConversation(String.valueOf(MyApplication.getInstance().getUserData().getUserId()), this.getStatusIntArray(), this.getTypeIntArray(), this.getLabelsIntArray(), pageStart, true, false, true);
        } else {
            String customLabel = null;
            if (this.getFilterModel().getSearchCustomLabel() > 0) {
                customLabel = Integer.toString(this.getFilterModel().getSearchCustomLabel());
            }
            this.apiGetConversation(this.selectedPeopleUserId, String.valueOf(MyApplication.getInstance().getUserData().getUserId()), this.getStatusIntArray(), this.getTypeIntArray(), this.getLabelsIntArray(), pageStart, true, false, true, this.getChannelFilter(), customLabel, this.getFilterModel());
        }
    }

    public void onRefresh() {
        this.getSrLayout().setRefreshing(true);
        if (!this.isNetworkAvailable()) {
            this.getSrLayout().setRefreshing(false);
            return;
        }
        this.loadmore = true;
        if (this.selectedPeople == null && !this.isFromFilter) {
            this.apiGetConversation(String.valueOf(MyApplication.getInstance().getUserData().getUserId()), this.getStatusIntArray(), this.getTypeIntArray(), this.getLabelsIntArray(), 1, false, false, true);
        } else {
            String customLabel = null;
            if (this.getFilterModel().getSearchCustomLabel() > 0) {
                customLabel = Integer.toString(this.getFilterModel().getSearchCustomLabel());
            }
            this.apiGetConversation(this.selectedPeopleUserId, String.valueOf(MyApplication.getInstance().getUserData().getUserId()), this.getStatusIntArray(), this.getTypeIntArray(), this.getLabelsIntArray(), 1, false, false, true, this.getChannelFilter(), customLabel, this.getFilterModel());
        }
    }

    public void add(String text, int position) {
        Conversation conversation = new Conversation();
        conversation.setChannelId(321);
        conversation.setChannelName("Abc");
        conversation.setUserId(197);
        conversation.setLastUpdatedAt("");
        conversation.setMessage("message");
        conversation.setLabel("label");
        conversation.setStatus(1);
        conversation.setBotChannelName("su");
        conversation.setUnreadCount(1);
        conversation.setAgentId(197);
        this.conversationsList.add(position, conversation);
        this.conversationChatAdapter.notifyItemInserted(position);
        if (this.layoutManager.findFirstVisibleItemPosition() == 0) {
            this.rvAll.scrollToPosition(0);
        }
    }

    private void clearNotification(int channelId) {
        try {
            NotificationUtils.clearNotifications((Context)this.activity, channelId);
            NotificationDatabase.INSTANCE.removeNotifications(channelId);
            CommonData.removeNotificationChannel(channelId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void remove(final int position) {
        Conversation conversation = this.getConversationChatList().get(position);
        conversation.setOverlay(Overlay.ASSIGNMENT.getOrdinal());
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                HomeFragment.this.conversationChatAdapter.notifyItemChanged(position);
            }
        });
        this.clearNotification(conversation.getChannelId());
        this.removeConversation(conversation.getChannelId());
    }

    public void removeConversation(final int channelId) {
        this.removePos = -1;
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                try {
                    if (HomeFragment.this.activity == null) {
                        HomeFragment.this.activity = HomeFragment.this.getActivity();
                    }
                    HomeFragment.this.activity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (HomeFragment.this.conversationChatList.size() > 0) {
                                for (int i = 0; i < HomeFragment.this.conversationChatList.size(); ++i) {
                                    if (channelId != ((Conversation)HomeFragment.this.conversationChatList.get(i)).getChannelId()) continue;
                                    HomeFragment.this.removePos = i;
                                    break;
                                }
                            }
                            if (HomeFragment.this.removePos != -1) {
                                try {
                                    HomeFragment.this.conversationChatList.remove(HomeFragment.this.removePos);
                                    HomeFragment.this.conversationChatAdapter.notifyItemRemoved(HomeFragment.this.removePos);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            HomeFragment.this.setLlNoConversation();
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, 1000L);
    }

    public void setLlNoConversation() {
        if (this.llNoConversation != null) {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (HomeFragment.this.conversationsList.size() == 0) {
                        HomeFragment.this.llNoConversation.setVisibility(0);
                    } else {
                        HomeFragment.this.llNoConversation.setVisibility(8);
                    }
                }
            });
        }
    }

    private void removeOverlay(final Conversation conversation) {
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                HomeFragment.this.activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (conversation != null) {
                            conversation.setOverlay(Overlay.DEFAULT.getOrdinal());
                            HomeFragment.this.conversationChatAdapter.notifyDataSetChanged();
                        }
                    }
                });
            }
        }, 1000L);
    }

    public ArrayList<Conversation> getConversationChatList() {
        return this.conversationChatList;
    }

    public void setInRideTill(JSONObject jsonObject) {
        String inRideTxt = jsonObject.optString("inride_text");
        int inRideTime = jsonObject.optInt("estimated_inride_secs", 0);
        for (Conversation conversation : this.conversationChatList) {
            if (!conversation.getChannelId().equals(jsonObject.optInt("channel_id"))) continue;
            if (inRideTime > 1) {
                conversation.setUserOnline(true);
                conversation.setInRideText(inRideTxt);
                conversation.setEndTime(DateUtils.getInstance().getRemainingTime(inRideTime));
                conversation.setInRideTime(inRideTime);
            } else {
                conversation.setUserOnline(false);
                conversation.setInRideText(inRideTxt);
                conversation.setInRideTime(inRideTime);
            }
            this.setConversationChatData(this.conversationChatList, false);
            break;
        }
    }

    @Subscribe
    public void onReceivedMessage(ReceivedMessage message) {
        switch (message.type) {
            case 1: {
                this.setControlChannelData(message.object);
                break;
            }
            case 2: {
                this.updateList(message.object);
                break;
            }
            case 3: {
                this.setInRideTill(message.object);
                break;
            }
            case 4: {
                this.setBotInProgress(message.object);
                break;
            }
            case 5: {
                this.setControlChannelData(message.object);
                break;
            }
        }
    }

    public void setBotInProgress(JSONObject jsonObject) {
        for (Conversation conversation : this.conversationChatList) {
            if (!conversation.getChannelId().equals(jsonObject.optInt("channel_id"))) continue;
            conversation.setBotEnabled(jsonObject.optInt("is_bot_in_progress", 0));
            conversation.setDisableReply(jsonObject.optInt("disable_reply", 0));
            this.setConversationChatData(this.conversationChatList, false);
            break;
        }
    }

    public void setControlChannelData(final JSONObject jsonObject) {
        block29: {
            try {
                try {
                    Log.e("HomeActivity", "lastMuid = ******************** " + this.lastMuid);
                    if (!TextUtils.isEmpty((CharSequence)this.lastMuid) && this.lastMuid.equalsIgnoreCase(jsonObject.optString("muid"))) {
                        Log.e("HomeActivity", "********************");
                        final JSONObject jsonObject1 = jsonObject;
                        if (!jsonObject.has("is_bot_in_progress")) {
                            return;
                        }
                        new Handler().postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                for (Conversation conversation : HomeFragment.this.conversationChatList) {
                                    if (!conversation.getChannelId().equals(jsonObject1.optInt("channel_id"))) continue;
                                    conversation.setMessage(jsonObject1.optString("message", ""));
                                    conversation.setAgentId(jsonObject1.optInt("agent_id", 0));
                                    String userImage = jsonObject1.optString("user_image", "");
                                    if (!TextUtils.isEmpty((CharSequence)userImage)) {
                                        conversation.setUserImage(userImage);
                                    }
                                    conversation.setLast_sent_by_id(jsonObject1.optInt("last_sent_by_id"));
                                    conversation.setLast_sent_by_full_name(jsonObject1.optString("last_sent_by_full_name"));
                                    if (jsonObject1.has("last_sent_by_user_type")) {
                                        conversation.setLast_sent_by_user_type(jsonObject1.optInt("last_sent_by_user_type", 2));
                                    }
                                    if (jsonObject1.has("is_bot_in_progress")) {
                                        conversation.setBotEnabled(jsonObject1.optInt("is_bot_in_progress"));
                                    }
                                    conversation.setLastUpdatedAt(jsonObject1.optString("date_time", ""));
                                    if (jsonObject1.optInt("last_sent_by_id", 0) != MyApplication.getInstance().getUserData().getUserId().intValue() && jsonObject1.optInt("channel_id", -1) != FuguChatActivity.pushChannelId) {
                                        conversation.setUnreadCount(conversation.getUnreadCount() + 1);
                                    }
                                    if (jsonObject1.optInt("last_sent_by_id", -1) == MyApplication.getInstance().getUserData().getUserId().intValue()) {
                                        conversation.setUnreadCount(0);
                                    }
                                    try {
                                        String inRideTxt = jsonObject1.optString("inride_text");
                                        int inRideTime = jsonObject1.optInt("estimated_inride_secs", 0);
                                        if (inRideTime <= 1) break;
                                        conversation.setUserOnline(true);
                                        conversation.setInRideText(inRideTxt);
                                        conversation.setEndTime(DateUtils.getInstance().getRemainingTime(inRideTime));
                                        conversation.setInRideTime(inRideTime);
                                    }
                                    catch (Exception exception) {}
                                    break;
                                }
                                if (!HomeFragment.this.isAllChats() && jsonObject.optInt("notification_type") == NotificationType.ASSIGNMENT.getOrdinal() && jsonObject.optInt("assigned_to") != MyApplication.getInstance().getUserData().getUserId().intValue()) {
                                    HomeFragment.this.pos = -1;
                                    for (int i = 0; i < HomeFragment.this.conversationChatList.size(); ++i) {
                                        if (jsonObject.optInt("channel_id") != ((Conversation)HomeFragment.this.conversationChatList.get(i)).getChannelId().intValue()) continue;
                                        HomeFragment.this.pos = i;
                                        break;
                                    }
                                    if (HomeFragment.this.pos > -1) {
                                        HomeFragment.this.remove(HomeFragment.this.pos);
                                    }
                                } else {
                                    Collections.sort(HomeFragment.this.conversationChatList, new Comparator<Conversation>(){

                                        @Override
                                        public int compare(Conversation o1, Conversation o2) {
                                            if (o1.getLastUpdatedAt() == null || o2.getLastUpdatedAt() == null) {
                                                return 0;
                                            }
                                            return o2.getLastUpdatedAt().compareTo(o1.getLastUpdatedAt());
                                        }
                                    });
                                    HomeFragment.this.setConversationChatData(HomeFragment.this.conversationChatList, false);
                                }
                            }
                        }, 500L);
                        return;
                    }
                    this.lastMuid = jsonObject.optString("muid");
                }
                catch (Exception jsonObject1) {
                    // empty catch block
                }
                if (this.isP2pChats() && jsonObject.optInt("chat_type") != 1) {
                    return;
                }
                if (this.chatType == MessageType.MY_CHAT.getOrdinal() && jsonObject.optInt("is_my_chat", 1) == 0) {
                    return;
                }
                boolean newConversation = true;
                for (Conversation conversation : this.conversationChatList) {
                    String userImage;
                    if (!conversation.getChannelId().equals(jsonObject.optInt("channel_id"))) continue;
                    newConversation = false;
                    conversation.setMessage(jsonObject.optString("message", ""));
                    conversation.setAgentId(jsonObject.optInt("agent_id", 0));
                    conversation.setLast_sent_by_id(jsonObject.optInt("last_sent_by_id"));
                    conversation.setLast_sent_by_full_name(jsonObject.optString("last_sent_by_full_name"));
                    if (jsonObject.has("last_sent_by_user_type")) {
                        conversation.setLast_sent_by_user_type(jsonObject.optInt("last_sent_by_user_type", 2));
                    }
                    if (jsonObject.has("is_bot_in_progress")) {
                        conversation.setBotEnabled(jsonObject.optInt("is_bot_in_progress"));
                    }
                    if (!TextUtils.isEmpty((CharSequence)(userImage = jsonObject.optString("user_image", "")))) {
                        conversation.setUserImage(userImage);
                    }
                    conversation.setLastUpdatedAt(jsonObject.optString("date_time", ""));
                    if (jsonObject.optInt("last_sent_by_id", 0) != MyApplication.getInstance().getUserData().getUserId().intValue() && jsonObject.optInt("channel_id", -1) != FuguChatActivity.pushChannelId) {
                        conversation.setUnreadCount(conversation.getUnreadCount() + 1);
                    }
                    if (jsonObject.optInt("last_sent_by_id", -1) == MyApplication.getInstance().getUserData().getUserId().intValue()) {
                        conversation.setUnreadCount(0);
                    }
                    try {
                        String inRideTxt = jsonObject.optString("inride_text");
                        int inRideTime = jsonObject.optInt("estimated_inride_secs", 0);
                        if (inRideTime <= 1) break;
                        conversation.setUserOnline(true);
                        conversation.setInRideText(inRideTxt);
                        conversation.setEndTime(DateUtils.getInstance().getRemainingTime(inRideTime));
                        conversation.setInRideTime(inRideTime);
                    }
                    catch (Exception exception) {}
                    break;
                }
                try {
                    this.lastMuid = jsonObject.optString("muid");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (newConversation) {
                    Log.v("New chat arrived", "send to unasssigned");
                    Conversation conversation = new Conversation();
                    conversation.setChannelId(jsonObject.optInt("channel_id"));
                    conversation.setChannelName(jsonObject.optString("channel_name", ""));
                    conversation.setUserId(jsonObject.optInt("user_id"));
                    conversation.setLastUpdatedAt(jsonObject.optString("date_time", ""));
                    conversation.setMessage(jsonObject.optString("message", ""));
                    conversation.setUserImage(jsonObject.optString("user_image", ""));
                    conversation.setLabel(jsonObject.optString("label", ""));
                    if (jsonObject.has("chat_status") && jsonObject.optInt("status", 1) == 0) {
                        conversation.setStatus(1);
                    } else {
                        conversation.setStatus(jsonObject.optInt("status", 1));
                    }
                    conversation.setBotChannelName(jsonObject.optString("bot_channel_name", ""));
                    conversation.setUnreadCount(jsonObject.optInt("unread_count", 1));
                    conversation.setAgentId(jsonObject.optInt("agent_id", 0));
                    conversation.setOverlay(Overlay.DEFAULT.getOrdinal());
                    if (jsonObject.has("is_bot_in_progress")) {
                        conversation.setBotEnabled(jsonObject.optInt("is_bot_in_progress"));
                    }
                    try {
                        String inRideTxt = jsonObject.optString("inride_text");
                        int inRideTime = jsonObject.optInt("estimated_inride_secs", 0);
                        if (inRideTime > 1) {
                            conversation.setUserOnline(true);
                            conversation.setInRideText(inRideTxt);
                            conversation.setEndTime(DateUtils.getInstance().getRemainingTime(inRideTime));
                            conversation.setInRideTime(inRideTime);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.conversationChatList.add(0, conversation);
                    this.conversationsList.add(0, conversation);
                    this.setLlNoConversation();
                    this.getActivity().runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            HomeFragment.this.conversationChatAdapter.notifyItemInserted(0);
                            if (HomeFragment.this.layoutManager.findFirstVisibleItemPosition() == 0) {
                                HomeFragment.this.rvAll.scrollToPosition(0);
                            } else if (HomeFragment.this.layoutManager.findFirstVisibleItemPosition() > 0) {
                                HomeFragment.this.newConversationSnackBar();
                            }
                        }
                    });
                    break block29;
                }
                if (!this.isAllChats() && jsonObject.optInt("notification_type") == NotificationType.ASSIGNMENT.getOrdinal() && jsonObject.optInt("assigned_to") != MyApplication.getInstance().getUserData().getUserId().intValue()) {
                    this.pos = -1;
                    for (int i = 0; i < this.conversationChatList.size(); ++i) {
                        if (jsonObject.getInt("channel_id") != this.conversationChatList.get(i).getChannelId().intValue()) continue;
                        this.pos = i;
                        break;
                    }
                    if (this.pos > -1) {
                        this.remove(this.pos);
                    }
                } else {
                    Collections.sort(this.conversationChatList, new Comparator<Conversation>(){

                        @Override
                        public int compare(Conversation o1, Conversation o2) {
                            if (o1.getLastUpdatedAt() == null || o2.getLastUpdatedAt() == null) {
                                return 0;
                            }
                            return o2.getLastUpdatedAt().compareTo(o1.getLastUpdatedAt());
                        }
                    });
                    this.setConversationChatData(this.conversationChatList, false);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int[] getAgentsFilter(FilterModel filterModel) {
        ArrayList<Integer> agentArrayList = new ArrayList<Integer>();
        for (int i = 0; i < filterModel.getAgentList().size(); ++i) {
            agentArrayList.add(filterModel.getAgentList().get(i).getId());
        }
        int[] agentIntArray = new int[agentArrayList.size()];
        for (int i = 0; i < agentIntArray.length; ++i) {
            agentIntArray[i] = (Integer)agentArrayList.get(i);
        }
        return agentIntArray;
    }

    public void apiGetConversation(String searchUserId, String userId, int[] statusArray, int[] typeArray, int[] labelsArray, int pageStart, final boolean isPagination, boolean showLoading, boolean fromOther, int[] channelArray, String search_custom_label, FilterModel filterModel) {
        if (this.isNetworkAvailable()) {
            Log.v("statusArray......------", Arrays.toString(statusArray).equals("[]") ? "[1]" : Arrays.toString(statusArray));
            Log.v("typeArray......------", Arrays.toString(typeArray));
            Log.v("labelsArray....------", Arrays.toString(labelsArray));
            Log.v("channelArray....------", Arrays.toString(channelArray));
            pageStart = pageStart > 0 ? pageStart : 1;
            this.pageEnd = pageStart + 20 - 1;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("access_token", String.valueOf(MyApplication.getInstance().getUserData().getAccessToken()));
            params.put("channel_status", Arrays.toString(statusArray).equals("[]") ? "[1]" : Arrays.toString(statusArray));
            params.put("device_type", "1");
            params.put("app_version", 256);
            params.put("page_offset", pageStart);
            params.put("row_count", this.pageEnd);
            if (searchUserId == null) {
                searchUserId = userId;
            }
            if (!searchUserId.equalsIgnoreCase(userId)) {
                params.put("search_user_id", searchUserId);
            }
            if (labelsArray.length > 0) {
                params.put("label_list", Arrays.toString(labelsArray));
            }
            if (!TextUtils.isEmpty((CharSequence)search_custom_label)) {
                params.put("search_custom_label", search_custom_label);
            }
            if (channelArray != null && channelArray.length > 0) {
                params.put("default_channels", Arrays.toString(channelArray));
            }
            if (filterModel != null && filterModel.isHasDateFilter()) {
                params.put("start_date", filterModel.getFromDate());
                if (filterModel.getDatePos() == 2 || filterModel.getDatePos() == 5) {
                    params.put("end_date", filterModel.getToDate());
                }
            }
            try {
                int[] agentsArray;
                if (filterModel != null && filterModel.getAgentList() != null && filterModel.getAgentList().size() > 0 && (agentsArray = this.getAgentsFilter(filterModel)) != null && agentsArray.length > 0) {
                    params.put("agent_ids", Arrays.toString(agentsArray));
                }
            }
            catch (Exception agentsArray) {
                // empty catch block
            }
            boolean fetchMyChatBool = true;
            if (typeArray != null && typeArray.length > 0) {
                block10: for (int i = 0; i < typeArray.length; ++i) {
                    switch (typeArray[i]) {
                        case 0: {
                            continue block10;
                        }
                        case 1: {
                            fetchMyChatBool = false;
                            params.put("fetch_my_chats_only", true);
                            continue block10;
                        }
                        case 2: {
                            fetchMyChatBool = false;
                            params.put("show_unassigned_chats", true);
                            continue block10;
                        }
                        case 3: {
                            fetchMyChatBool = false;
                            params.put("fetch_my_tagged_chats", true);
                            continue block10;
                        }
                        case 10: {
                            fetchMyChatBool = false;
                            params.put("fetch_all_chats", true);
                            continue block10;
                        }
                        case 11: {
                            fetchMyChatBool = false;
                            params.put("fetch_p2p_chats", true);
                        }
                    }
                }
                if (fetchMyChatBool) {
                    params.put("fetch_my_chats", true);
                }
            }
            if (this.isAllChats()) {
                params.put("fetch_all_chats", true);
            }
            CommonParamsObj paramsObj = new CommonParamsObj.Builder().addAll(params).build();
            Logger.INSTANCE.apiRequest("/api/conversation/v2/getConversations", new Gson().toJson(paramsObj.getMap()));
            RestClient.getApiInterface().getConversation(paramsObj.getMap()).enqueue((Callback)new ResponseResolver<GetConversationResponse>((Activity)this.getActivity(), Boolean.valueOf(showLoading), Boolean.valueOf(false)){

                @Override
                public void success(GetConversationResponse getConversationResponse) {
                    Logger.INSTANCE.apiResponse("/api/conversation/v2/getConversations", "");
                    LoadingBox.showOn((Activity)HomeFragment.this.getActivity());
                    try {
                        Log.e("Size of Array", getConversationResponse.getData().getConversation().size() + "");
                        if (getConversationResponse != null && ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == getConversationResponse.getStatusCode().intValue()) {
                            try {
                                if (getConversationResponse.getData().getConversation().size() < 20) {
                                    HomeFragment.this.loadmore = false;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                for (Conversation conversation : getConversationResponse.getData().getConversation()) {
                                    if (conversation.getInRideTime() <= 1) continue;
                                    conversation.setUserOnline(true);
                                    conversation.setEndTime(DateUtils.getInstance().getRemainingTime(conversation.getInRideTime()));
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (getConversationResponse.getData().getVersion() != null && getConversationResponse.getData().getVersion().getIsForce() != null) {
                                if (getConversationResponse.getData().getVersion().getLatestVersion() > 256) {
                                    if (getConversationResponse.getData().getVersion().getIsForce().equals(1)) {
                                        HomeFragment.this.SingleBtnUpdateWindow(getConversationResponse);
                                        Paper.book((String)CommonData.name).delete("latest_version");
                                        Paper.book((String)CommonData.name).write("latest_version", (Object)getConversationResponse.getData().getVersion().getIsForce());
                                        HomeFragment.this.getSrLayout().setRefreshing(false);
                                    } else if (getConversationResponse.getData().getVersion().getIsForce().equals(0)) {
                                        Paper.book((String)CommonData.name).delete("latest_version");
                                        Paper.book((String)CommonData.name).write("latest_version", (Object)getConversationResponse.getData().getVersion().getLatestVersion());
                                        HomeFragment.this.getConversationApiHit = true;
                                        HomeFragment.this.conversationChatList.clear();
                                        HomeFragment.this.conversationChatList.addAll(getConversationResponse.getData().getConversation());
                                        HomeFragment.this.setConversationChatData(HomeFragment.this.conversationChatList, isPagination);
                                        HomeFragment.this.toggleProgressBarVisibility(false);
                                        HomeFragment.this.getSrLayout().setRefreshing(false);
                                        HomeFragment.this.setPagingApiInProgress(false);
                                        Paper.book((String)CommonData.name).delete("latest_version");
                                        Paper.book((String)CommonData.name).write("latest_version", (Object)getConversationResponse.getData().getVersion().getLatestVersion());
                                        HomeFragment.this.showUpdateWindowTwoBtns(getConversationResponse, isPagination);
                                    } else {
                                        Paper.book((String)CommonData.name).delete("latest_version");
                                        Paper.book((String)CommonData.name).write("latest_version", (Object)getConversationResponse.getData().getVersion().getLatestVersion());
                                        HomeFragment.this.getConversationApiHit = true;
                                        HomeFragment.this.conversationChatList.clear();
                                        HomeFragment.this.conversationChatList.addAll(getConversationResponse.getData().getConversation());
                                        HomeFragment.this.setConversationChatData(HomeFragment.this.conversationChatList, isPagination);
                                        HomeFragment.this.toggleProgressBarVisibility(false);
                                        HomeFragment.this.getSrLayout().setRefreshing(false);
                                        HomeFragment.this.setPagingApiInProgress(false);
                                    }
                                } else {
                                    Paper.book((String)CommonData.name).delete("latest_version");
                                    Paper.book((String)CommonData.name).write("latest_version", (Object)getConversationResponse.getData().getVersion().getLatestVersion());
                                    HomeFragment.this.getConversationApiHit = true;
                                    HomeFragment.this.conversationChatList.clear();
                                    HomeFragment.this.conversationChatList.addAll(getConversationResponse.getData().getConversation());
                                    HomeFragment.this.setConversationChatData(HomeFragment.this.conversationChatList, isPagination);
                                    HomeFragment.this.toggleProgressBarVisibility(false);
                                    HomeFragment.this.getSrLayout().setRefreshing(false);
                                    HomeFragment.this.setPagingApiInProgress(false);
                                }
                            } else {
                                HomeFragment.this.getConversationApiHit = true;
                                HomeFragment.this.conversationChatList.clear();
                                HomeFragment.this.conversationChatList.addAll(getConversationResponse.getData().getConversation());
                                HomeFragment.this.setConversationChatData(HomeFragment.this.conversationChatList, isPagination);
                                HomeFragment.this.toggleProgressBarVisibility(false);
                                HomeFragment.this.getSrLayout().setRefreshing(false);
                                HomeFragment.this.setPagingApiInProgress(false);
                            }
                        }
                        LoadingBox.hide();
                    }
                    catch (Exception e) {
                        Logger.INSTANCE.apiFailed("/api/conversation/v2/getConversations", e.getLocalizedMessage());
                        e.printStackTrace();
                    }
                }

                @Override
                public void failure(APIError error) {
                    Logger.INSTANCE.apiFailed("/api/conversation/v2/getConversations", error.getMessage());
                    Log.e("error", "error" + error.getMessage());
                    LoadingBox.hide();
                    try {
                        Toast.makeText((Context)HomeFragment.this.getActivity(), (CharSequence)error.getMessage(), (int)0).show();
                        if (error.getStatusCode() == ApiResponseFlags.SESSION_EXPIRED.getOrdinal()) {
                            MyApplication.getInstance().logout((Activity)HomeFragment.this.getActivity());
                            MyApplication.getInstance().clearData();
                            Paper.book((String)CommonData.name).delete("latest_version");
                        }
                        HomeFragment.this.getSrLayout().setRefreshing(false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } else {
            Toast.makeText((Context)this.getActivity(), (CharSequence)this.getString(R.string.fugu_unable_to_connect_internet), (int)0).show();
        }
    }

    public void apiGetConversation(String userId, int[] statusArray, int[] typeArray, int[] labelsArray, int pageStart, boolean isPagination, boolean showLoading, boolean fromOther) {
        this.apiGetConversation(userId, statusArray, typeArray, labelsArray, pageStart, isPagination, showLoading, fromOther, -1);
    }

    public void apiGetConversation(String userId, int[] statusArray, int[] typeArray, int[] labelsArray, int pageStart, final boolean isPagination, boolean showLoading, boolean fromOther, int endPage) {
        if (this.isApiInProgress) {
            return;
        }
        if (this.isNetworkAvailable()) {
            Log.v("statusArray......------", Arrays.toString(statusArray).equals("[]") ? "[1]" : Arrays.toString(statusArray));
            Log.v("typeArray......------", Arrays.toString(typeArray));
            this.isApiInProgress = true;
            pageStart = pageStart > 0 ? pageStart : 1;
            endPage = endPage > 0 ? endPage : 20;
            endPage = endPage + pageStart - 1;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("access_token", String.valueOf(MyApplication.getInstance().getUserData().getAccessToken()));
            params.put("channel_status", Arrays.toString(statusArray).equals("[]") ? "[1]" : Arrays.toString(statusArray));
            params.put("device_type", "1");
            params.put("app_version", 256);
            params.put("page_offset", pageStart);
            params.put("row_count", endPage);
            if (labelsArray.length > 0) {
                params.put("label_list", Arrays.toString(labelsArray));
            }
            if (labelsArray.length > 0) {
                params.put("label_list", Arrays.toString(labelsArray));
            }
            boolean fetchMyChatBool = true;
            if (typeArray != null && typeArray.length > 0) {
                block10: for (int i = 0; i < typeArray.length; ++i) {
                    switch (typeArray[i]) {
                        case 0: {
                            continue block10;
                        }
                        case 1: {
                            fetchMyChatBool = false;
                            params.put("fetch_my_chats_only", true);
                            continue block10;
                        }
                        case 2: {
                            fetchMyChatBool = false;
                            params.put("show_unassigned_chats", true);
                            continue block10;
                        }
                        case 3: {
                            fetchMyChatBool = false;
                            params.put("fetch_my_tagged_chats", true);
                            continue block10;
                        }
                        case 10: {
                            fetchMyChatBool = false;
                            params.put("fetch_all_chats", true);
                            continue block10;
                        }
                        case 11: {
                            fetchMyChatBool = false;
                            params.put("fetch_p2p_chats", true);
                        }
                    }
                }
                if (fetchMyChatBool) {
                    params.put("fetch_my_chats", true);
                }
            }
            if (this.isAllChats()) {
                params.put("fetch_all_chats", true);
            }
            try {
                if (!TextUtils.isEmpty((CharSequence)((HomeActivity)this.getActivity()).getChannelId())) {
                    params.put("append_channel_id", ((HomeActivity)this.getActivity()).getChannelId());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            CommonParamsObj paramsObj = new CommonParamsObj.Builder().addAll(params).build();
            String value = new Gson().toJson(paramsObj.getMap());
            Logger.INSTANCE.apiRequest("/api/conversation/v2/getConversations", value);
            RestClient.getApiInterface().getConversation(paramsObj.getMap()).enqueue((Callback)new ResponseResolver<GetConversationResponse>((Activity)this.getActivity(), Boolean.valueOf(showLoading), Boolean.valueOf(false)){

                @Override
                public void success(GetConversationResponse getConversationResponse) {
                    try {
                        Logger.INSTANCE.apiResponse("/api/conversation/v2/getConversations", "");
                        Log.e("Size of Array", getConversationResponse.getData().getConversation().size() + "");
                        if (getConversationResponse != null) {
                            if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == getConversationResponse.getStatusCode().intValue()) {
                                try {
                                    if (getConversationResponse.getData().getConversation().size() < 20) {
                                        HomeFragment.this.loadmore = false;
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                try {
                                    for (Conversation conversation : getConversationResponse.getData().getConversation()) {
                                        if (conversation.getInRideTime() <= 1) continue;
                                        conversation.setUserOnline(true);
                                        conversation.setEndTime(DateUtils.getInstance().getRemainingTime(conversation.getInRideTime()));
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                try {
                                    if (!TextUtils.isEmpty((CharSequence)((HomeActivity)HomeFragment.this.getActivity()).getChannelId())) {
                                        ((HomeActivity)HomeFragment.this.getActivity()).openChannelConversation(getConversationResponse);
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                if (getConversationResponse.getData().getVersion() != null && getConversationResponse.getData().getVersion().getIsForce() != null) {
                                    if (getConversationResponse.getData().getVersion().getLatestVersion() > 256) {
                                        if (getConversationResponse.getData().getVersion().getIsForce().equals(1)) {
                                            HomeFragment.this.SingleBtnUpdateWindow(getConversationResponse);
                                            Paper.book((String)CommonData.name).delete("latest_version");
                                            Paper.book((String)CommonData.name).write("latest_version", (Object)getConversationResponse.getData().getVersion().getIsForce());
                                            HomeFragment.this.getSrLayout().setRefreshing(false);
                                        } else if (getConversationResponse.getData().getVersion().getIsForce().equals(0)) {
                                            Log.v("Latest Version--->>>>>>", String.valueOf(MyApplication.getInstance().getLatestVersion()));
                                            Paper.book((String)CommonData.name).delete("latest_version");
                                            Paper.book((String)CommonData.name).write("latest_version", (Object)getConversationResponse.getData().getVersion().getLatestVersion());
                                            HomeFragment.this.getConversationApiHit = true;
                                            HomeFragment.this.conversationChatList.clear();
                                            HomeFragment.this.conversationChatList.addAll(getConversationResponse.getData().getConversation());
                                            HomeFragment.this.setConversationChatData(HomeFragment.this.conversationChatList, isPagination);
                                            HomeFragment.this.toggleProgressBarVisibility(false);
                                            HomeFragment.this.getSrLayout().setRefreshing(false);
                                            HomeFragment.this.setPagingApiInProgress(false);
                                            Paper.book((String)CommonData.name).delete("latest_version");
                                            Paper.book((String)CommonData.name).write("latest_version", (Object)getConversationResponse.getData().getVersion().getLatestVersion());
                                            HomeFragment.this.showUpdateWindowTwoBtns(getConversationResponse, isPagination);
                                        } else {
                                            Paper.book((String)CommonData.name).delete("latest_version");
                                            Paper.book((String)CommonData.name).write("latest_version", (Object)getConversationResponse.getData().getVersion().getLatestVersion());
                                            HomeFragment.this.getConversationApiHit = true;
                                            HomeFragment.this.conversationChatList.clear();
                                            HomeFragment.this.conversationChatList.addAll(getConversationResponse.getData().getConversation());
                                            HomeFragment.this.setConversationChatData(HomeFragment.this.conversationChatList, isPagination);
                                            HomeFragment.this.toggleProgressBarVisibility(false);
                                            HomeFragment.this.getSrLayout().setRefreshing(false);
                                            HomeFragment.this.setPagingApiInProgress(false);
                                        }
                                    } else {
                                        Paper.book((String)CommonData.name).delete("latest_version");
                                        Paper.book((String)CommonData.name).write("latest_version", (Object)getConversationResponse.getData().getVersion().getLatestVersion());
                                        HomeFragment.this.getConversationApiHit = true;
                                        HomeFragment.this.conversationChatList.clear();
                                        HomeFragment.this.conversationChatList.addAll(getConversationResponse.getData().getConversation());
                                        HomeFragment.this.setConversationChatData(HomeFragment.this.conversationChatList, isPagination);
                                        HomeFragment.this.toggleProgressBarVisibility(false);
                                        HomeFragment.this.getSrLayout().setRefreshing(false);
                                        HomeFragment.this.setPagingApiInProgress(false);
                                    }
                                } else {
                                    HomeFragment.this.getConversationApiHit = true;
                                    HomeFragment.this.conversationChatList.clear();
                                    HomeFragment.this.conversationChatList.addAll(getConversationResponse.getData().getConversation());
                                    HomeFragment.this.setConversationChatData(HomeFragment.this.conversationChatList, isPagination);
                                    HomeFragment.this.toggleProgressBarVisibility(false);
                                    HomeFragment.this.getSrLayout().setRefreshing(false);
                                    HomeFragment.this.setPagingApiInProgress(false);
                                }
                            }
                            HomeFragment.this.hasPagination = true;
                            if (getConversationResponse.getData().getConversation().size() == 0) {
                                HomeFragment.this.hasPagination = false;
                            }
                        }
                        HomeFragment.this.getSrLayout().setEnabled(true);
                        HomeFragment.this.rlUpdatingConvo.setVisibility(8);
                        HomeFragment.this.isApiInProgress = false;
                    }
                    catch (Exception e) {
                        Logger.INSTANCE.apiFailed("/api/conversation/v2/getConversations", e.getLocalizedMessage());
                        e.printStackTrace();
                    }
                }

                @Override
                public void failure(APIError error) {
                    Logger.INSTANCE.apiFailed("/api/conversation/v2/getConversations", error.getMessage());
                    Log.e("error", "error" + error.getMessage());
                    try {
                        LoadingBox.hide();
                        HomeFragment.this.isApiInProgress = false;
                        HomeFragment.this.rlUpdatingConvo.setVisibility(8);
                        try {
                            Toast.makeText((Context)HomeFragment.this.getActivity(), (CharSequence)error.getMessage(), (int)0).show();
                            if (error.getStatusCode() == ApiResponseFlags.SESSION_EXPIRED.getOrdinal()) {
                                MyApplication.getInstance().logout((Activity)HomeFragment.this.getActivity());
                                MyApplication.getInstance().clearData();
                                Paper.book((String)CommonData.name).delete("latest_version");
                            }
                            HomeFragment.this.getSrLayout().setRefreshing(false);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        HomeFragment.this.getSrLayout().setEnabled(true);
                    }
                    catch (Exception e) {
                        Logger.INSTANCE.apiFailed("/api/conversation/v2/getConversations", e.getLocalizedMessage());
                        e.printStackTrace();
                    }
                }
            });
        } else {
            this.rlUpdatingConvo.setVisibility(8);
            Toast.makeText((Context)this.getActivity(), (CharSequence)this.getString(R.string.fugu_unable_to_connect_internet), (int)0).show();
        }
    }

    public boolean isAllChats() {
        return this.position == 1;
    }

    public boolean isP2pChats() {
        return this.position == 2;
    }

    private void showUpdateWindowTwoBtns(GetConversationResponse getConversationResponse, boolean isPagination) {
        VersionUpdate update = CommonData.getVersionInfo();
        if (update == null) {
            update = new VersionUpdate(getConversationResponse.getData().getVersion().getLatestVersion(), 0, true, 0L, getConversationResponse.getData().getVersion().getAlertInterval(), getConversationResponse.getData().getVersion().getText(), getConversationResponse.getData().getVersion().getDownloadLink());
        } else {
            update.setVersion(getConversationResponse.getData().getVersion().getLatestVersion());
            update.setInterval(getConversationResponse.getData().getVersion().getAlertInterval());
            update.setText(getConversationResponse.getData().getVersion().getText());
            update.setLink(getConversationResponse.getData().getVersion().getDownloadLink());
        }
        CommonData.saveVersionInfo(update);
        BusProvider.getInstance().post((Object)new UpdateEvent(2));
    }

    private void SingleBtnUpdateWindow(GetConversationResponse getConversationResponse) {
        try {
            BusProvider.getInstance().post((Object)new UpdateEvent(1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void checkBKSound(Integer channelId) {
        try {
            CopyOnWriteArraySet<Integer> arrayList = CommonData.getPushChannelID();
            if (channelId > -1) {
                try {
                    this.stopAlarmRing(channelId);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                arrayList.remove(channelId);
            }
            ArrayList<Integer> integers = new ArrayList<Integer>();
            integers.addAll(arrayList);
            if (arrayList != null && arrayList.size() > 0) {
                for (int i = 0; i < this.conversationChatList.size(); ++i) {
                    for (Integer id2 : arrayList) {
                        if (!id2.equals(this.conversationChatList.get(i).getChannelId()) || this.conversationChatList.get(i).getUnreadCount() >= 1) continue;
                        arrayList.remove(id2);
                    }
                }
                if (arrayList.size() == 0) {
                    CommonData.savePushChannels(new CopyOnWriteArraySet<Integer>());
                }
            } else {
                CommonData.savePushChannels(new CopyOnWriteArraySet<Integer>());
            }
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (CommonData.getPushChannelID() == null || CommonData.getPushChannelID().size() == 0) {
                            HomeFragment.this.stopAlarmRing(-101);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, 1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
    }

    public void stopAlarmRing(final Integer channelId) throws Exception {
        try {
            if (this.isMyServiceRunning(AudioPlay.class)) {
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Intent intent = new Intent((Context)HomeFragment.this.getActivity(), AudioPlay.class);
                            intent.putExtra("channelId", (Serializable)channelId);
                            intent.putExtra("type", 2);
                            HomeFragment.this.getActivity().startService(intent);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }, 50L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean isMyServiceRunning(Class<?> serviceClass) {
        try {
            ActivityManager manager = (ActivityManager)this.getActivity().getSystemService("activity");
            for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
                if (!serviceClass.getName().equals(service.service.getClassName())) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void setConnectionMessage(int status2) {
        try {
            if (this.isNetworkAvailable()) {
                switch (status2) {
                    case 0: {
                        this.getActivity().runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    if (HomeFragment.this.retryLayout != null) {
                                        HomeFragment.this.retryLayout.setVisibility(8);
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                        break;
                    }
                    case 1: {
                        this.getActivity().runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    HomeFragment.this.retryLayout.setVisibility(0);
                                    HomeFragment.this.btnRetry.setText((CharSequence)HomeFragment.this.getString(R.string.fetching_messages));
                                    HomeFragment.this.retryLayout.setBackgroundColor(Color.parseColor((String)"#00AA00"));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                        break;
                    }
                    case 2: {
                        this.getActivity().runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    HomeFragment.this.retryLayout.setVisibility(0);
                                    HomeFragment.this.btnRetry.setText((CharSequence)"Server disconnected");
                                    HomeFragment.this.retryLayout.setBackgroundColor(Color.parseColor((String)"#FF0000"));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                        break;
                    }
                    case 3: {
                        this.getActivity().runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    HomeFragment.this.retryLayout.setVisibility(0);
                                    HomeFragment.this.btnRetry.setText((CharSequence)"No internet connected");
                                    HomeFragment.this.retryLayout.setBackgroundColor(Color.parseColor((String)"#FF0000"));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                        break;
                    }
                    case 4: {
                        this.getActivity().runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    HomeFragment.this.retryLayout.setVisibility(0);
                                    HomeFragment.this.btnRetry.setText((CharSequence)"Server connecting...");
                                    HomeFragment.this.retryLayout.setBackgroundColor(Color.parseColor((String)"#00AA00"));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                        break;
                    }
                }
            } else {
                this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            HomeFragment.this.retryLayout.setVisibility(0);
                            HomeFragment.this.btnRetry.setText((CharSequence)"No internet connected");
                            HomeFragment.this.retryLayout.setBackgroundColor(Color.parseColor((String)"#FF0000"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateList(JSONObject jsonObject) {
        boolean flag = false;
        try {
            for (Conversation conversation : this.conversationChatList) {
                if (!conversation.getUserId().equals(jsonObject.optInt("user_id"))) continue;
                conversation.setUserId(jsonObject.optInt("migrated_to", 0));
                conversation.setLabel(jsonObject.optString("full_name"));
                flag = true;
                break;
            }
            if (flag) {
                this.setConversationChatData(this.conversationChatList, false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager)this.getActivity().getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        if (cm != null) {
            networkInfo = cm.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }

    public void setConversationChatData(ArrayList<Conversation> allChatData, boolean isPagination) {
        this.setConversationChatData(allChatData, isPagination, true);
    }

    public void setConversationChatData(ArrayList<Conversation> allChatData, boolean isPagination, boolean soundRefresh) {
        block5: {
            if (!isPagination) {
                this.conversationsList.clear();
            }
            try {
                if (!((HomeActivity)this.activity).isNotifiacrionClicked()) break block5;
                Integer channelId = ((HomeActivity)this.activity).getConversation().getChannelId();
                ((HomeActivity)this.activity).setNotifiacrionClick(false);
                for (int i = 0; i < allChatData.size(); ++i) {
                    if (channelId.intValue() != allChatData.get(i).getChannelId().intValue()) continue;
                    allChatData.get(i).setUnreadCount(0);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.conversationsList.addAll(allChatData);
        if (this.getView() != null && this.conversationChatAdapter != null) {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    HomeFragment.this.conversationChatAdapter.notifyDataSetChanged();
                }
            });
        }
        this.setLlNoConversation();
    }

    public void newConversationSnackBar() {
        if (this.isSnackbarVisible) {
            return;
        }
        ++this.newMessageCount;
        String message = this.newMessageCount > 1 ? this.newMessageCount + " new Chats" : this.newMessageCount + " new Chat";
        this.snackbar = Snackbar.make((View)this.relative, (CharSequence)message, (int)0).setAction((CharSequence)this.getResources().getString(R.string.tap_to_view), new View.OnClickListener(){

            public void onClick(View view) {
                HomeFragment.this.newMessageCount = 0;
            }
        });
        this.snackbar.setActionTextColor(-1);
        View sbView = this.snackbar.getView();
        sbView.setBackgroundColor(ContextCompat.getColor((Context)this.getActivity(), (int)R.color.green));
        TextView textView = (TextView)sbView.findViewById(R.id.snackbar_text);
        textView.setTextColor(-1);
        Button button = (Button)sbView.findViewById(R.id.snackbar_action);
        this.snackbar.setDuration(-2);
        this.snackbar.show();
    }

    public FilterModel getFilterModel() {
        return this.filterModel;
    }

    public int[] getStatusFilter() {
        ArrayList<Integer> statusArrayList = new ArrayList<Integer>();
        if (this.filterModel.getStatusArrayList().get(0).getChecked()) {
            statusArrayList.add(MessageMode.OPEN_CHAT.getOrdinal());
        }
        if (this.filterModel.getStatusArrayList().get(1).getChecked()) {
            statusArrayList.add(MessageMode.CLOSED_CHAT.getOrdinal());
        }
        Collections.sort(statusArrayList);
        this.statusIntArray = new int[statusArrayList.size()];
        for (int i = 0; i < this.statusIntArray.length; ++i) {
            this.statusIntArray[i] = (Integer)statusArrayList.get(i);
        }
        return this.statusIntArray;
    }

    public int[] getTypeFilter() {
        int i;
        ArrayList<Integer> typeArrayList = new ArrayList<Integer>();
        if (this.isFromFilter) {
            for (i = 0; i < this.filterModel.getTypeArrayList().size(); ++i) {
                if (!this.filterModel.getTypeArrayList().get(i).getChecked()) continue;
                typeArrayList.add(this.filterModel.getTypeArrayList().get(i).getId());
            }
            if (typeArrayList.size() == 0) {
                if (this.chatType == MessageType.ALL_CHAT.getOrdinal()) {
                    typeArrayList.add(ConversationMode.ALL.getOrdinal());
                } else {
                    typeArrayList.add(ConversationMode.DEFAULT.getOrdinal());
                }
            }
        } else if (this.chatType == MessageType.ALL_CHAT.getOrdinal()) {
            typeArrayList.add(ConversationMode.ALL.getOrdinal());
        } else {
            for (i = 0; i < this.filterModel.getTypeArrayList().size(); ++i) {
                if (!this.filterModel.getTypeArrayList().get(i).getChecked()) continue;
                typeArrayList.add(this.filterModel.getTypeArrayList().get(i).getId());
            }
            if (typeArrayList.size() == 0) {
                typeArrayList.add(ConversationMode.DEFAULT.getOrdinal());
            }
        }
        Collections.sort(typeArrayList);
        this.typeIntArray = new int[typeArrayList.size()];
        for (i = 0; i < this.typeIntArray.length; ++i) {
            this.typeIntArray[i] = (Integer)typeArrayList.get(i);
        }
        return this.typeIntArray;
    }

    public int[] getLabelsFilter() {
        int i;
        ArrayList<Integer> labelsList = new ArrayList<Integer>();
        for (i = 0; i < this.filterModel.getLabelsList().size(); ++i) {
            if (!this.filterModel.getLabelsList().get(i).getChecked()) continue;
            labelsList.add(this.filterModel.getLabelsList().get(i).getId());
        }
        Collections.sort(labelsList);
        this.labelsIntArray = new int[labelsList.size()];
        for (i = 0; i < this.labelsIntArray.length; ++i) {
            this.labelsIntArray[i] = (Integer)labelsList.get(i);
        }
        return this.labelsIntArray;
    }

    public int[] getChannelFilter() {
        int i;
        ArrayList<Integer> channelsList = new ArrayList<Integer>();
        for (i = 0; i < this.filterModel.getChannelList().size(); ++i) {
            if (!this.filterModel.getChannelList().get(i).getChecked()) continue;
            channelsList.add(this.filterModel.getChannelList().get(i).getId());
        }
        Collections.sort(channelsList);
        this.channelsIntArray = new int[channelsList.size()];
        for (i = 0; i < this.channelsIntArray.length; ++i) {
            this.channelsIntArray[i] = (Integer)channelsList.get(i);
        }
        return this.channelsIntArray;
    }

    public int[] getStatusIntArray() {
        return this.statusIntArray;
    }

    public int[] getTypeIntArray() {
        return this.typeIntArray;
    }

    public int[] getLabelsIntArray() {
        return this.labelsIntArray;
    }

    public void setFilterAdapter() {
        Filter filter;
        int i;
        this.isFromFilter = false;
        this.labels = new ArrayList();
        this.labels = (ArrayList)MyApplication.getInstance().getUserData().getTags();
        this.filterModel = new FilterModel();
        this.filterModel.setAgentList(new ArrayList<Filter>());
        for (i = 0; i < 2; ++i) {
            filter = new Filter();
            if (i == 0) {
                filter.setId(1);
                filter.setName("Open Chats");
                filter.setChecked(true);
            } else {
                filter.setId(2);
                filter.setName("Closed Chats");
                filter.setChecked(false);
            }
            this.filterModel.getStatusArrayList().add(filter);
        }
        for (i = 0; i < 3; ++i) {
            filter = new Filter();
            if (i == 0) {
                filter.setId(1);
                filter.setName("My Chats");
                filter.setChecked(false);
            } else if (i == 1) {
                filter.setId(2);
                filter.setName("Unassigned");
                filter.setChecked(false);
            } else {
                filter.setId(3);
                filter.setName("Tagged");
                filter.setChecked(false);
            }
            this.filterModel.getTypeArrayList().add(filter);
        }
        for (i = 0; i < this.labels.size(); ++i) {
            filter = new Filter();
            filter.setId(this.labels.get(i).getTagId());
            filter.setName(this.labels.get(i).getTagName());
            filter.setChecked(false);
            this.filterModel.getLabelsList().add(filter);
        }
        ArrayList<ChannelFilter> channelFilters = new ArrayList<ChannelFilter>();
        channelFilters.addAll(MyApplication.getInstance().getUserData().getChannelFilter());
        for (int i2 = 0; i2 < channelFilters.size(); ++i2) {
            Filter filter2 = new Filter();
            filter2.setId(((ChannelFilter)channelFilters.get(i2)).getId());
            filter2.setName(((ChannelFilter)channelFilters.get(i2)).getName());
            filter2.setChecked(false);
            this.filterModel.getChannelList().add(filter2);
        }
        this.filterModel.setSelectedPeople("");
        this.filterModel.setSelectedPeopleUserId("");
        this.filterModel.setSearchCustomName("");
        this.filterModel.setSearchCustomLabel(-1);
        try {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    BusProvider.getInstance().post((Object)new FragmentEvent(1, HomeFragment.this.isAllChats() ? 3 : 2, HomeFragment.this.filterModel));
                }
            }, 100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Subscribe
    public void onFilterEvent(FilterEvent filterEvent) {
        if (this.chatType == filterEvent.filterType) {
            this.isFromFilter = true;
            this.filterModel = (FilterModel)new Gson().fromJson(filterEvent.data.getStringExtra("filterData"), FilterModel.class);
            switch (this.filterModel.getViewType()) {
                case 0: {
                    this.loadmore = true;
                    this.selectedPeopleUserId = null;
                    this.selectedPeople = null;
                    this.applyFilter(this.filterModel);
                    BusProvider.getInstance().post((Object)new FragmentEvent(1, this.isAllChats() ? 5 : 4, false));
                    try {
                        new Handler().postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                HomeFragment.this.isFromFilter = false;
                            }
                        }, 1000L);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 1: {
                    this.loadmore = true;
                    this.selectPeopleItem();
                    BusProvider.getInstance().post((Object)new FragmentEvent(1, this.isAllChats() ? 5 : 4, true));
                    break;
                }
                case 2: {
                    this.loadmore = true;
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            Intent chatIntent = new Intent((Context)HomeFragment.this.getActivity(), FuguChatActivity.class);
                            chatIntent.putExtra("conversation", new Gson().toJson((Object)HomeFragment.this.filterModel.getConversation(), Conversation.class));
                            HomeFragment.this.startActivityForResult(chatIntent, 100);
                            HomeFragment.this.isFromFilter = false;
                            BusProvider.getInstance().post((Object)new FragmentEvent(1, HomeFragment.this.isAllChats() ? 5 : 4, false));
                        }
                    }, 50L);
                    break;
                }
                default: {
                    this.loadmore = true;
                    this.applyFilter(this.filterModel);
                    BusProvider.getInstance().post((Object)new FragmentEvent(1, this.isAllChats() ? 5 : 4, true));
                }
            }
        }
    }

    private void selectPeopleItem() {
        this.selectedPeopleUserId = null;
        this.selectedPeopleUserId = this.filterModel.getSelectedPeopleUserId();
        String customLabel = null;
        if (this.filterModel.getSearchCustomLabel() > 0) {
            customLabel = Integer.toString(this.filterModel.getSearchCustomLabel());
        }
        this.apiGetConversation(this.selectedPeopleUserId, String.valueOf(MyApplication.getInstance().getUserData().getUserId()), this.getStatusFilter(), this.getTypeFilter(), this.getLabelsFilter(), 0, false, true, true, this.getChannelFilter(), customLabel, this.filterModel);
        this.selectedPeople = null;
        this.selectedPeople = this.filterModel.getSelectedPeople();
    }

    private void applyFilter(FilterModel filterModel) {
        String customLabel = null;
        if (filterModel.getSearchCustomLabel() > 0) {
            customLabel = Integer.toString(filterModel.getSearchCustomLabel());
        }
        String searchUserId = String.valueOf(MyApplication.getInstance().getUserData().getUserId());
        if (!TextUtils.isEmpty((CharSequence)this.selectedPeopleUserId)) {
            searchUserId = this.selectedPeopleUserId;
        }
        this.apiGetConversation(searchUserId, String.valueOf(MyApplication.getInstance().getUserData().getUserId()), this.getStatusFilter(), this.getTypeFilter(), this.getLabelsFilter(), 0, false, true, true, this.getChannelFilter(), customLabel, filterModel);
    }
}

