/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.fragments;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.google.gson.Gson;
import com.hippoagent.R;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.adapters.ConversationChatAdapter;
import com.hippoagent.datastructure.MessageMode;
import com.hippoagent.datastructure.MessageType;
import com.hippoagent.datastructure.Overlay;
import com.hippoagent.model.Conversation;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.Utils;
import com.hippoagent.utils.recylerviewAnimation.FadeInLeftAnimator;
import java.util.ArrayList;
import java.util.List;

public class ConversationFragment
extends Fragment
implements SwipeRefreshLayout.OnRefreshListener {
    private View root;
    private SwipeRefreshLayout srLayout;
    private RecyclerView rvAll;
    private ConversationChatAdapter conversationChatAdapter;
    private ArrayList<Object> conversationsList = new ArrayList();
    LinearLayoutManager layoutManager;
    private int pastVisiblesItems;
    private int visibleItemCount;
    private int totalItemCount;
    private LinearLayout llNoConversation;
    private Handler handler = new Handler();
    private final int OVERLAY_TIME = 1000;
    private Activity activity;
    private int chatType = MessageType.MY_CHAT.getOrdinal();
    int position = -1;
    private ConversationChatAdapter.ProgressBarItem progressBarItem;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.chatType = this.getArguments().getInt("chat_type", 0);
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.root = inflater.inflate(R.layout.conversation_fragment, container, false);
        return this.root;
    }

    public RecyclerView getRvAll() {
        return this.rvAll;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof Activity) {
            this.activity = (Activity)context;
        }
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.srLayout = (SwipeRefreshLayout)view.findViewById(R.id.srLayout);
        this.srLayout.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)this);
        this.srLayout.setColorSchemeResources(new int[]{R.color.white});
        this.srLayout.setProgressBackgroundColorSchemeResource(R.color.colorPrimary);
        this.srLayout.setSize(1);
        this.llNoConversation = (LinearLayout)this.root.findViewById(R.id.llNoConversation);
        this.rvAll = (RecyclerView)view.findViewById(R.id.rvAll);
        this.layoutManager = new LinearLayoutManager((Context)this.activity);
        this.rvAll.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.rvAll.setItemAnimator((RecyclerView.ItemAnimator)new FadeInLeftAnimator());
        this.rvAll.getItemAnimator().setAddDuration(500L);
        this.rvAll.getItemAnimator().setRemoveDuration(500L);
        this.rvAll.setHasFixedSize(false);
        this.conversationChatAdapter = new ConversationChatAdapter(this.conversationsList, this.activity, new ConversationChatAdapter.Callback(){

            @Override
            public void onClick(int position, Conversation conversation) {
                if (!Utils.preventMultipleClicks()) {
                    return;
                }
                Intent chatIntent = new Intent((Context)ConversationFragment.this.activity, FuguChatActivity.class);
                if (ConversationFragment.this.chatType == MessageType.P2P_CHAT.getOrdinal()) {
                    chatIntent.putExtra("is_p2p_chat", true);
                } else {
                    chatIntent.putExtra("is_p2p_chat", false);
                }
                chatIntent.putExtra("conversation", new Gson().toJson((Object)conversation, Conversation.class));
                ConversationFragment.this.startActivityForResult(chatIntent, 100);
            }
        }, this.rvAll);
        this.rvAll.setAdapter((RecyclerView.Adapter)this.conversationChatAdapter);
        this.rvAll.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                Log.v("scroll state ", "changed");
            }

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            }
        });
    }

    public LinearLayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    public void setConversationChatCount(Conversation conversationCount) throws Exception {
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        Log.v("onActivityResult", "enter");
        if (requestCode == 100) {
            if (resultCode == MessageMode.OPEN_CHAT.getOrdinal()) {
                int channelId = Integer.parseInt(data.getExtras().getString("channel_id"));
                this.setOverlayTransition(channelId, MessageMode.OPEN_CHAT.getOrdinal(), resultCode);
            } else if (resultCode == MessageMode.CLOSED_CHAT.getOrdinal()) {
                int channelId = Integer.parseInt(data.getExtras().getString("channel_id"));
                this.setOverlayTransition(channelId, MessageMode.CLOSED_CHAT.getOrdinal(), resultCode);
            } else if (resultCode == Overlay.ASSIGNMENT.getOrdinal()) {
                int channelId = Integer.parseInt(data.getExtras().getString("channel_id"));
                this.setOverlayTransition(channelId, MessageMode.OPEN_CHAT.getOrdinal(), resultCode);
            }
        }
    }

    private void setOverlayTransition(int channelId, int messageMode, int resultCode) {
        boolean success = false;
        int pos = -1;
        Conversation overlayConversation = null;
        for (int i = 0; i < this.conversationsList.size(); ++i) {
            Conversation conversation1;
            if (!(this.conversationsList.get(i) instanceof Conversation)) continue;
            overlayConversation = conversation1 = (Conversation)this.conversationsList.get(i);
            if (!conversation1.getChannelId().equals(channelId)) continue;
            pos = i;
            success = true;
            if (resultCode != Overlay.ASSIGNMENT.getOrdinal()) {
                conversation1.setStatus(messageMode);
            }
            conversation1.setOverlay(resultCode);
            break;
        }
        if (success) {
            this.conversationChatAdapter.notifyDataSetChanged();
        }
    }

    public void removeConversation(final int channelId) {
        this.position = -1;
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                try {
                    if (ConversationFragment.this.activity == null) {
                        ConversationFragment.this.activity = (Activity)ConversationFragment.this.getActivity();
                    }
                    ConversationFragment.this.activity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationFragment.this.conversationsList.size() > 0) {
                                for (int i = 0; i < ConversationFragment.this.conversationsList.size(); ++i) {
                                    if (channelId != ((Conversation)ConversationFragment.this.conversationsList.get(i)).getChannelId()) continue;
                                    ConversationFragment.this.position = i;
                                    break;
                                }
                            }
                            if (ConversationFragment.this.position != -1) {
                                try {
                                    ConversationFragment.this.conversationsList.remove(ConversationFragment.this.position);
                                    ConversationFragment.this.conversationChatAdapter.notifyItemRemoved(ConversationFragment.this.position);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            ConversationFragment.this.setLlNoConversation();
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, 1000L);
    }

    private void removeOverlay(final Conversation conversation) {
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                ConversationFragment.this.activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (conversation != null) {
                            conversation.setOverlay(Overlay.DEFAULT.getOrdinal());
                            ConversationFragment.this.conversationChatAdapter.notifyDataSetChanged();
                        }
                    }
                });
            }
        }, 1000L);
    }

    public LinearLayout getLlNoConversation() {
        return this.llNoConversation;
    }

    public SwipeRefreshLayout getSrLayout() {
        return this.srLayout;
    }

    private void fetchNextPage() {
    }

    public void toggleProgressBarVisibility(boolean isVisible) {
        if (isVisible) {
            if (this.progressBarItem == null) {
                this.progressBarItem = new ConversationChatAdapter.ProgressBarItem();
            }
            if (!this.conversationsList.contains(this.progressBarItem)) {
                this.conversationsList.add(this.progressBarItem);
                this.rvAll.post(new Runnable(){

                    @Override
                    public void run() {
                        ConversationFragment.this.conversationChatAdapter.notifyItemInserted(ConversationFragment.this.conversationsList.size() - 1);
                    }
                });
            }
        } else if (this.progressBarItem != null && this.conversationsList.contains(this.progressBarItem)) {
            this.conversationsList.remove(this.progressBarItem);
            this.conversationChatAdapter.notifyItemRemoved(this.conversationsList.size() - 1);
        }
    }

    public ConversationChatAdapter getConversationChatAdapter() {
        return this.conversationChatAdapter;
    }

    public ArrayList<Object> getConversationList() {
        return this.conversationsList;
    }

    private ArrayList<Object> getAdapterList(List<Conversation> allChatDetailList) {
        if (this.conversationsList == null) {
            this.conversationsList = new ArrayList();
        }
        this.conversationsList.clear();
        if (allChatDetailList != null && allChatDetailList.size() > 0) {
            this.conversationsList.addAll(allChatDetailList);
        }
        return this.conversationsList;
    }

    public void setConversationChatData(ArrayList<Conversation> allChatData, boolean isPagination) {
        this.setConversationChatData(allChatData, isPagination, true);
    }

    public void setConversationChatData(ArrayList<Conversation> allChatData, boolean isPagination, boolean soundRefresh) {
        if (!isPagination) {
            this.conversationsList.clear();
        }
        this.conversationsList.addAll(allChatData);
        if (this.getView() != null && this.conversationChatAdapter != null) {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ConversationFragment.this.conversationChatAdapter.notifyDataSetChanged();
                }
            });
        }
        this.setLlNoConversation();
    }

    public void setLlNoConversation() {
        if (this.llNoConversation != null) {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (ConversationFragment.this.conversationsList.size() == 0) {
                        ConversationFragment.this.llNoConversation.setVisibility(0);
                    } else {
                        ConversationFragment.this.llNoConversation.setVisibility(8);
                    }
                }
            });
        }
    }

    public void onRefresh() {
        if (!this.isNetworkAvailable()) {
            this.getSrLayout().setRefreshing(false);
            return;
        }
    }

    private boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager)this.getActivity().getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        if (cm != null) {
            networkInfo = cm.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }
}

