/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.dialogs;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.view.WindowManager;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.gson.Gson;
import com.hippoagent.MyApplication;
import com.hippoagent.R;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.activities.HippoPaymentActivity;
import com.hippoagent.adapters.SavedPlanAdapter;
import com.hippoagent.callback.OnPlanListener;
import com.hippoagent.model.payment.GetPaymentLinks;
import com.hippoagent.model.payment.PlanData;
import com.hippoagent.model.payment.SavedPlanResponse;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import retrofit2.Callback;

public class SavedPlanDialog {
    private Activity context;
    private Dialog dialog;
    private SavedPlanAdapter adapter;
    private ArrayList<PlanData> plansList = new ArrayList();

    public SavedPlanDialog(Activity context) {
        this.context = context;
    }

    public Dialog show() {
        try {
            this.dialog = new Dialog((Context)this.context, R.style.HippoAppTheme);
            this.dialog.getWindow().getAttributes().windowAnimations = R.style.Animations_LoadingDialogFade;
            this.dialog.setContentView(R.layout.dialog_show_agents);
            WindowManager.LayoutParams layoutParams = this.dialog.getWindow().getAttributes();
            layoutParams.dimAmount = 0.6f;
            this.dialog.getWindow().addFlags(2);
            TextView tvTitle = (TextView)this.dialog.findViewById(R.id.tvTitle);
            TextView tvSavedData = (TextView)this.dialog.findViewById(R.id.tvSavedData);
            tvSavedData.setVisibility(8);
            tvTitle.setText((CharSequence)this.context.getResources().getString(R.string.saved_plan));
            ProgressBar pbLoadReply = (ProgressBar)this.dialog.findViewById(R.id.pbLoadReply);
            pbLoadReply.setVisibility(8);
            ImageView ivClose = (ImageView)this.dialog.findViewById(R.id.ivClose);
            ImageButton ibSearch = (ImageButton)this.dialog.findViewById(R.id.ibSearch);
            ibSearch.setVisibility(8);
            ivClose.setVisibility(8);
            ImageView backBtn = (ImageView)this.dialog.findViewById(R.id.backBtn);
            ImageView ivAddNew = (ImageView)this.dialog.findViewById(R.id.ivAddNew);
            ivAddNew.setVisibility(0);
            backBtn.setVisibility(0);
            backBtn.setOnClickListener(v -> this.dialog.dismiss());
            ivAddNew.setOnClickListener(v -> {
                Intent paymentIntent = new Intent((Context)this.context, HippoPaymentActivity.class);
                this.context.startActivityForResult(paymentIntent, 1536);
                this.dialog.dismiss();
            });
            RecyclerView rvAgents = (RecyclerView)this.dialog.findViewById(R.id.rvAgents);
            rvAgents.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.context));
            rvAgents.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
            rvAgents.setHasFixedSize(false);
            this.adapter = new SavedPlanAdapter(new OnPlanListener(){

                @Override
                public void onPlanClicked(int pos, @NotNull PlanData planData) {
                    Intent paymentIntent = new Intent((Context)SavedPlanDialog.this.context, HippoPaymentActivity.class);
                    paymentIntent.putExtra("send_plan", true);
                    paymentIntent.putExtra("data", new Gson().toJson((Object)planData));
                    SavedPlanDialog.this.context.startActivityForResult(paymentIntent, 1536);
                    SavedPlanDialog.this.dialog.dismiss();
                }

                @Override
                public void onDeleteClicked(int pos, @NotNull PlanData planData) {
                }
            }, true);
            ivClose.setOnClickListener(v -> this.dialog.dismiss());
            rvAgents.setAdapter((RecyclerView.Adapter)this.adapter);
            this.getSavedCard();
            this.dialog.show();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return this.dialog;
    }

    private void getSavedCard() {
        if (((FuguChatActivity)this.context).isNetworkAvailable()) {
            ArrayList<Integer> array2 = new ArrayList<Integer>();
            array2.add(1);
            GetPaymentLinks paymentLinks = new GetPaymentLinks(MyApplication.getInstance().getUserData().getAccessToken(), 0, array2);
            RestClient.getApiInterface().getPaymentLinks(paymentLinks).enqueue((Callback)new ResponseResolver<SavedPlanResponse>(this.context, Boolean.valueOf(true), Boolean.valueOf(true)){

                @Override
                public void success(SavedPlanResponse savedPlanResponse) {
                    try {
                        SavedPlanDialog.this.plansList.addAll(savedPlanResponse.getData());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    SavedPlanDialog.this.adapter.setData(SavedPlanDialog.this.plansList);
                    if (SavedPlanDialog.this.plansList.size() == 0) {
                        Intent paymentIntent = new Intent((Context)SavedPlanDialog.this.context, HippoPaymentActivity.class);
                        SavedPlanDialog.this.context.startActivityForResult(paymentIntent, 1536);
                        SavedPlanDialog.this.dialog.dismiss();
                    }
                }

                @Override
                public void failure(APIError error) {
                }
            });
        } else {
            Toast.makeText((Context)this.context, (CharSequence)this.context.getString(R.string.fugu_unable_to_connect_internet), (int)0).show();
        }
    }
}

