/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.dialogs;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import com.google.gson.Gson;
import com.hippoagent.R;
import com.hippoagent.model.onBoard.UserConfig;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.Pref1;
import com.hippoagent.utils.Utils;

public class ConfirmationDialog {
    private static final String TAG = ConfirmationDialog.class.getSimpleName();
    private Dialog optionsDialog;
    private Listener listener;
    private Activity activity;
    private String title;
    private String message;
    private String positiveButton;
    private String negativeButton;
    private String conditionLink = "";
    private String policyLink = "";

    private ConfirmationDialog init() {
        try {
            this.optionsDialog = new Dialog((Context)this.activity, 0x1030010);
            this.optionsDialog.setContentView(R.layout.dialog_confirmation);
            Window dialogWindow = this.optionsDialog.getWindow();
            WindowManager.LayoutParams layoutParams = dialogWindow.getAttributes();
            layoutParams.dimAmount = 0.6f;
            dialogWindow.getAttributes().windowAnimations = R.style.CustomHippoDialog;
            dialogWindow.addFlags(2);
            this.optionsDialog.setCancelable(false);
            this.optionsDialog.setCanceledOnTouchOutside(false);
            TextView tvTitle = (TextView)this.optionsDialog.findViewById(R.id.tvTitle);
            TextView tvMessage = (TextView)this.optionsDialog.findViewById(R.id.tvMessage);
            tvTitle.setText((CharSequence)this.title);
            this.setTocSpannableText(this.activity, tvMessage);
            Button btnConfirm = (Button)this.optionsDialog.findViewById(R.id.btnAction);
            Button btnCancel = (Button)this.optionsDialog.findViewById(R.id.btnNegative);
            btnConfirm.setText((CharSequence)this.positiveButton);
            btnCancel.setText((CharSequence)this.negativeButton);
            btnConfirm.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    ConfirmationDialog.this.optionsDialog.dismiss();
                    if (ConfirmationDialog.this.listener != null) {
                        ConfirmationDialog.this.listener.performPositiveAction();
                    }
                }
            });
            btnCancel.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    ConfirmationDialog.this.optionsDialog.dismiss();
                    if (ConfirmationDialog.this.listener != null) {
                        ConfirmationDialog.this.listener.performNegativeAction();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e(TAG, "init: " + e.getMessage());
        }
        return this;
    }

    public void show() {
        if (this.activity != null && this.optionsDialog != null) {
            this.optionsDialog.show();
        }
    }

    private void setTocSpannableText(final Activity activity, TextView textView) {
        String spanText = activity.getResources().getString(R.string.terms_of_service);
        String privacyText = activity.getResources().getString(R.string.privacy_policy);
        String fullText = activity.getResources().getString(R.string.tnc_message);
        SpannableString spannableString = new SpannableString((CharSequence)activity.getResources().getString(R.string.tnc_message));
        ClickableSpan terms = new ClickableSpan(){

            public void onClick(View widget) {
                Utils.redirectUserToUrl(activity, ConfirmationDialog.this.getLink(activity, 1));
            }

            public void updateDrawState(TextPaint ds) {
                ds.setUnderlineText(false);
                ds.setColor(ContextCompat.getColor((Context)activity, (int)R.color.colorPrimaryDark));
            }
        };
        ClickableSpan privacy = new ClickableSpan(){

            public void onClick(View widget) {
                Utils.redirectUserToUrl(activity, ConfirmationDialog.this.getLink(activity, 2));
            }

            public void updateDrawState(TextPaint ds) {
                ds.setUnderlineText(false);
                ds.setColor(ContextCompat.getColor((Context)activity, (int)R.color.colorPrimaryDark));
            }
        };
        spannableString.setSpan((Object)terms, fullText.indexOf(spanText), fullText.indexOf(spanText) + spanText.length(), 0);
        spannableString.setSpan((Object)privacy, fullText.indexOf(privacyText), fullText.indexOf(privacyText) + privacyText.length(), 0);
        textView.setMovementMethod(LinkMovementMethod.getInstance());
        textView.setText((CharSequence)spannableString, TextView.BufferType.SPANNABLE);
        textView.setSelected(true);
    }

    private String getLink(Activity activity, int type) {
        try {
            UserConfig userConfig = (UserConfig)new Gson().fromJson(Pref1.with((Context)activity).getString("userConfig", ""), UserConfig.class);
            this.conditionLink = userConfig.getData().getTermsAndCondition();
            this.policyLink = userConfig.getData().getPrivacyPolicy();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.conditionLink = activity.getString(R.string.terms_of_service_link);
            this.policyLink = activity.getString(R.string.privacy_policy_link);
        }
        if (type == 1) {
            return this.conditionLink;
        }
        return this.policyLink;
    }

    public static class Builder {
        private ConfirmationDialog optionsDialog = new ConfirmationDialog();

        public Builder(Activity activity) {
            this.optionsDialog.activity = activity;
            if (activity instanceof Listener) {
                this.optionsDialog.listener = (Listener)activity;
            }
        }

        public Builder(Fragment fragment) {
            this.optionsDialog.activity = (Activity)fragment.getActivity();
            if (fragment instanceof Listener) {
                this.optionsDialog.listener = (Listener)fragment;
            }
        }

        public Builder listener(Listener listener) {
            this.optionsDialog.listener = listener;
            return this;
        }

        public Builder title(String title) {
            this.optionsDialog.title = title;
            return this;
        }

        public Builder message(String message) {
            this.optionsDialog.message = message;
            return this;
        }

        public Builder positiveButton(String buttonText) {
            this.optionsDialog.positiveButton = buttonText;
            return this;
        }

        public Builder negativeButton(String cancel) {
            this.optionsDialog.negativeButton = cancel;
            return this;
        }

        public ConfirmationDialog build() {
            this.optionsDialog.title = this.getString(R.string.tnc_title);
            this.optionsDialog.message = this.getString(R.string.tnc_message);
            this.optionsDialog.positiveButton = this.getString(R.string.accept);
            this.optionsDialog.negativeButton = this.getString(R.string.decline);
            return this.optionsDialog.init();
        }

        private String getString(int resourceId) {
            return this.optionsDialog.activity.getString(resourceId);
        }
    }

    public static interface Listener {
        public void performPositiveAction();

        public void performNegativeAction();
    }
}

