/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.confcall;

import android.content.ContentResolver;
import android.content.Context;
import android.media.AudioManager;
import android.media.SoundPool;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hippoagent.R;
import com.hippoagent.confcall.IncomingRinger;
import com.hippoagent.confcall.OutgoingRinger;
import com.hippoagent.utils.Utils;

public class HippoAudioManager {
    private static final String TAG = HippoAudioManager.class.getSimpleName();
    private final Context context;
    private final IncomingRinger incomingRinger;
    private final OutgoingRinger outgoingRinger;
    private final SoundPool soundPool;
    private final int connectedSoundId;
    private final int disconnectedSoundId;
    private static HippoAudioManager instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized HippoAudioManager getInstance(Context context) {
        if (instance != null) return instance;
        Class<HippoAudioManager> clazz = HippoAudioManager.class;
        synchronized (HippoAudioManager.class) {
            if (instance != null) return instance;
            instance = new HippoAudioManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void distroyAudioManager() {
        if (instance != null) {
            instance = null;
        }
    }

    private HippoAudioManager(Context context) {
        this.context = context.getApplicationContext();
        this.incomingRinger = new IncomingRinger(context);
        this.outgoingRinger = new OutgoingRinger(context);
        this.soundPool = new SoundPool(1, 0, 0);
        this.connectedSoundId = this.soundPool.load(context, R.raw.webrtc_completed, 1);
        this.disconnectedSoundId = this.soundPool.load(context, R.raw.disconnet_call, 1);
    }

    public void initializeAudioForCall() {
        AudioManager audioManager = Utils.getAudioManager(this.context);
        audioManager.requestAudioFocus(null, 0, 4);
    }

    public void startIncomingRinger() {
        this.initializeAudioForCall();
        Uri ringtone = this.getCallNotificationRingtone(this.context);
        this.startIncomingRinger(ringtone, this.isCallNotificationVibrateEnabled(this.context));
    }

    private boolean isCallNotificationVibrateEnabled(Context context) {
        boolean defaultValue = true;
        if (Build.VERSION.SDK_INT >= 23) {
            defaultValue = Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"vibrate_when_ringing", (int)1) == 1;
        }
        return defaultValue;
    }

    @NonNull
    private Uri getCallNotificationRingtone(Context context) {
        String result = Settings.System.DEFAULT_RINGTONE_URI.toString();
        if (result != null && result.startsWith("file:")) {
            result = Settings.System.DEFAULT_RINGTONE_URI.toString();
        }
        return Uri.parse((String)result);
    }

    public void startIncomingRinger(@Nullable Uri ringtoneUri, boolean vibrate) {
        AudioManager audioManager = Utils.getAudioManager(this.context);
        boolean speaker = !audioManager.isWiredHeadsetOn() && !audioManager.isBluetoothScoOn();
        audioManager.setMode(1);
        audioManager.setMicrophoneMute(false);
        audioManager.setSpeakerphoneOn(speaker);
        this.incomingRinger.start(ringtoneUri, vibrate);
    }

    public void startOutgoingRinger(OutgoingRinger.Type type) {
        AudioManager audioManager = Utils.getAudioManager(this.context);
        audioManager.setMicrophoneMute(false);
        audioManager.setMode(3);
        this.outgoingRinger.start(type);
    }

    public void silenceIncomingRinger() {
        this.incomingRinger.stop();
    }

    public void startCommunication(boolean preserveSpeakerphone) {
        AudioManager audioManager = Utils.getAudioManager(this.context);
        this.incomingRinger.stop();
        this.outgoingRinger.stop();
        audioManager.setMode(3);
        if (!preserveSpeakerphone) {
            audioManager.setSpeakerphoneOn(false);
        }
        this.soundPool.play(this.connectedSoundId, 1.0f, 1.0f, 0, 0, 1.0f);
    }

    public void stop(boolean playDisconnected) {
        AudioManager audioManager = Utils.getAudioManager(this.context);
        this.incomingRinger.stop();
        this.outgoingRinger.stop();
        if (playDisconnected) {
            this.soundPool.play(this.disconnectedSoundId, 1.0f, 1.0f, 0, 0, 1.0f);
        }
        if (audioManager.isBluetoothScoOn()) {
            audioManager.setBluetoothScoOn(false);
            audioManager.stopBluetoothSco();
        }
        audioManager.setSpeakerphoneOn(false);
        audioManager.setMicrophoneMute(false);
        audioManager.setMode(0);
        audioManager.abandonAudioFocus(null);
    }
}

