/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.adapters;

import android.content.Context;
import android.graphics.Typeface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.TextView;
import androidx.databinding.DataBindingUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.hippoagent.R;
import com.hippoagent.adapters.PeopleAdapter;
import com.hippoagent.databinding.LayoutLoadmoreBinding;
import com.hippoagent.model.Filter;
import java.util.ArrayList;

public class LabelsAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final String TAG = LabelsAdapter.class.getSimpleName();
    private ArrayList<Filter> tagsArrayList;
    private Typeface proximaRegular;
    private boolean isMultiSelectionMode;
    private int totalChannels;
    private LabelInterface labelInterface;
    private Context context;
    private static final int VIEW_TYPE = 1;
    private static final int VIEW_TYPE_LOADING = 2;

    public LabelsAdapter(ArrayList<Filter> tagsArrayList) {
        this.tagsArrayList = tagsArrayList;
    }

    public LabelsAdapter(ArrayList<Filter> tagsArrayList, LabelInterface labelInterface) {
        this.tagsArrayList = tagsArrayList;
        this.labelInterface = labelInterface;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        this.context = parent.getContext();
        if (viewType == 2) {
            return new LoadMoreHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.layout_loadmore, parent, false));
        }
        return new ViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.list_item_labels, parent, false), this.context);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int position) {
        if (viewHolder instanceof ViewHolder) {
            ViewHolder holder = (ViewHolder)viewHolder;
            Filter tags = this.tagsArrayList.get(position);
            if (this.isMultiSelectionMode) {
                holder.textView.setVisibility(0);
                holder.cbLabel.setVisibility(8);
                holder.textView.setText((CharSequence)tags.getName());
            } else {
                holder.textView.setVisibility(8);
                holder.cbLabel.setVisibility(0);
                holder.cbLabel.setTag((Object)position);
                holder.cbLabel.setText((CharSequence)tags.getName());
                holder.cbLabel.setChecked(tags.getChecked());
            }
        } else if (viewHolder instanceof PeopleAdapter.LoadMoreHolder) {
            LoadMoreHolder holder2 = (LoadMoreHolder)viewHolder;
            ((LoadMoreHolder)holder2).loadmoreBinding.progressWheel.setVisibility(8);
            ((LoadMoreHolder)holder2).loadmoreBinding.tvLoadmore.setVisibility(0);
        }
    }

    public int getItemCount() {
        if (this.tagsArrayList == null || this.tagsArrayList.size() == 0) {
            return 0;
        }
        if (this.totalChannels > this.tagsArrayList.size()) {
            return this.tagsArrayList.size() + 1;
        }
        return this.tagsArrayList.size();
    }

    public int getItemViewType(int position) {
        try {
            if (this.isPositionFooter(position)) {
                return 2;
            }
            return 1;
        }
        catch (Exception e) {
            return 1;
        }
    }

    private boolean isPositionFooter(int position) {
        return position == this.tagsArrayList.size();
    }

    public void setData(ArrayList<Filter> tagsArrayList) {
        this.tagsArrayList = tagsArrayList;
        this.notifyDataSetChanged();
    }

    public void setData(ArrayList<Filter> tagsArrayList, boolean isMultiSelectionMode, int totalChannels) {
        this.tagsArrayList = tagsArrayList;
        this.totalChannels = totalChannels;
        this.isMultiSelectionMode = isMultiSelectionMode;
        this.notifyDataSetChanged();
    }

    public static interface LabelInterface {
        public void onLoadMoreClick();

        public void onSingleItemClick(Filter var1, int var2);

        public void removeCustomFilter();
    }

    public class LoadMoreHolder
    extends RecyclerView.ViewHolder {
        private LayoutLoadmoreBinding loadmoreBinding;

        public LoadMoreHolder(View itemView) {
            super(itemView);
            this.loadmoreBinding = (LayoutLoadmoreBinding)DataBindingUtil.bind((View)itemView);
            this.loadmoreBinding.rlMainLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (LabelsAdapter.this.labelInterface != null) {
                        LabelsAdapter.this.labelInterface.onLoadMoreClick();
                    }
                }
            });
        }
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        public CheckBox cbLabel;
        public TextView textView;

        public ViewHolder(View itemView, Context context) {
            super(itemView);
            this.cbLabel = (CheckBox)itemView.findViewById(R.id.cbLabel);
            this.textView = (TextView)itemView.findViewById(R.id.channel_view);
            this.cbLabel.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                    if (compoundButton.isPressed()) {
                        ((Filter)LabelsAdapter.this.tagsArrayList.get(ViewHolder.this.getAdapterPosition())).setChecked(b);
                        if (LabelsAdapter.this.labelInterface != null) {
                            LabelsAdapter.this.labelInterface.removeCustomFilter();
                        }
                    }
                }
            });
            this.textView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    LabelsAdapter.this.labelInterface.onSingleItemClick((Filter)LabelsAdapter.this.tagsArrayList.get(ViewHolder.this.getAdapterPosition()), ViewHolder.this.getAdapterPosition());
                }
            });
        }
    }
}

