/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.adapters;

import android.os.Bundle;
import android.text.TextUtils;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentStatePagerAdapter;
import com.google.gson.Gson;
import com.hippoagent.fragments.BasicInfoFragment;
import com.hippoagent.fragments.ChatOptionFragment;
import com.hippoagent.fragments.HistoryFragment;
import com.hippoagent.model.Conversation;
import com.hippoagent.model.TagData;
import java.util.ArrayList;

public class InfoPagerAdapter
extends FragmentStatePagerAdapter {
    private Conversation conversation;
    private int pageCount;
    private ArrayList<TagData> tags;
    private String dealId;
    private Boolean hasBotRunning = false;

    public InfoPagerAdapter(FragmentManager fm, Conversation conversation, int pageCount, ArrayList<TagData> tags, String dealId, Boolean hasBotRunning) {
        super(fm);
        this.pageCount = pageCount;
        this.conversation = conversation;
        this.tags = tags;
        this.dealId = dealId;
        this.hasBotRunning = hasBotRunning;
    }

    public Fragment getItem(int position) {
        switch (position) {
            case 0: {
                ChatOptionFragment basicInfoFragment = new ChatOptionFragment();
                Bundle basicInfo = new Bundle();
                basicInfo.putString("conversation", new Gson().toJson((Object)this.conversation, Conversation.class));
                basicInfo.putBoolean("btnHistory", false);
                basicInfo.putBoolean("hasBotRunning", this.hasBotRunning.booleanValue());
                if (!TextUtils.isEmpty((CharSequence)this.dealId)) {
                    basicInfo.putString("deal_id", this.dealId);
                }
                if (this.tags != null) {
                    basicInfo.putParcelableArrayList("tag_data", this.tags);
                }
                basicInfoFragment.setArguments(basicInfo);
                return basicInfoFragment;
            }
            case 1: {
                HistoryFragment customDataFragment = new HistoryFragment();
                Bundle customInfo = new Bundle();
                customInfo.putString("conversation", new Gson().toJson((Object)this.conversation, Conversation.class));
                customDataFragment.setArguments(customInfo);
                return customDataFragment;
            }
        }
        BasicInfoFragment basicInfoFragment1 = new BasicInfoFragment();
        Bundle basicInfo1 = new Bundle();
        basicInfo1.putString("conversation", new Gson().toJson((Object)this.conversation, Conversation.class));
        if (!TextUtils.isEmpty((CharSequence)this.dealId)) {
            basicInfo1.putString("deal_id", this.dealId);
        }
        if (this.pageCount == 2) {
            basicInfo1.putBoolean("btnHistory", true);
        }
        if (this.tags != null) {
            basicInfo1.putParcelableArrayList("tag_data", this.tags);
        }
        basicInfoFragment1.setArguments(basicInfo1);
        return basicInfoFragment1;
    }

    public int getCount() {
        return this.pageCount;
    }
}

