/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.adapters;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.hippoagent.R;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.model.FuguConversation;
import com.hippoagent.utils.DateUtils;
import com.hippoagent.utils.Log;
import java.io.Serializable;
import java.util.ArrayList;

public class FuguChannelsAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    LayoutInflater inflater;
    private ArrayList<FuguConversation> fuguConversationList = new ArrayList();
    private Activity activity;
    private String userName;
    private String businessName;
    private Long userId = -1L;

    public FuguChannelsAdapter(Activity activity, ArrayList<FuguConversation> fuguConversationList, String userName, Long userId, String businessName) {
        this.inflater = LayoutInflater.from((Context)activity.getApplicationContext());
        this.fuguConversationList = fuguConversationList;
        this.activity = activity;
        this.userName = userName;
        this.businessName = businessName;
        this.userId = userId;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = this.inflater.inflate(R.layout.fugu_item_channels, parent, false);
        ChannelViewHolder holder = new ChannelViewHolder(view);
        return holder;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        ChannelViewHolder channelViewHolder = (ChannelViewHolder)holder;
        final FuguConversation currentChannelItem = this.fuguConversationList.get(position);
        channelViewHolder.tvChannelName.setText((CharSequence)currentChannelItem.getLabel());
        channelViewHolder.tvMessage.setText((CharSequence)currentChannelItem.getMessage());
        if (currentChannelItem.getChannelId().compareTo(-1L) == 0) {
            channelViewHolder.tvDate.setVisibility(8);
        } else {
            TextView textView = channelViewHolder.tvDate;
            DateUtils.getInstance();
            textView.setText((CharSequence)DateUtils.getRelativeDate(DateUtils.getInstance().convertToLocal(currentChannelItem.getDateTime()), true));
            channelViewHolder.tvDate.setVisibility(0);
        }
        channelViewHolder.rlRoot.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent chatIntent = new Intent((Context)FuguChannelsAdapter.this.activity, FuguChatActivity.class);
                chatIntent.putExtra("label", currentChannelItem.getLabel());
                chatIntent.putExtra("channelId", (Serializable)currentChannelItem.getChannelId());
                chatIntent.putExtra("labelId", (Serializable)currentChannelItem.getLabelId());
                chatIntent.putExtra("defaultMessage", currentChannelItem.getMessage());
                chatIntent.putExtra("businessName", FuguChannelsAdapter.this.businessName);
                chatIntent.putExtra("userId", (Serializable)FuguChannelsAdapter.this.userId);
                chatIntent.putExtra("userName", FuguChannelsAdapter.this.userName);
                chatIntent.putExtra("status", currentChannelItem.getStatus());
                FuguChannelsAdapter.this.activity.startActivityForResult(chatIntent, 200);
            }
        });
    }

    public int getItemCount() {
        Log.e("fuguConversationList size", "==" + this.fuguConversationList.size());
        return this.fuguConversationList.size();
    }

    class ChannelViewHolder
    extends RecyclerView.ViewHolder {
        private RelativeLayout rlRoot;
        private TextView tvChannelName;
        private TextView tvMessage;
        private TextView tvDate;
        private ImageView ivChannelIcon;

        public ChannelViewHolder(View itemView) {
            super(itemView);
            this.rlRoot = (RelativeLayout)itemView.findViewById(R.id.rlRoot);
            this.tvChannelName = (TextView)itemView.findViewById(R.id.tvChannelName);
            this.tvMessage = (TextView)itemView.findViewById(R.id.tvMessage);
            this.tvDate = (TextView)itemView.findViewById(R.id.tvDate);
            this.ivChannelIcon = (ImageView)itemView.findViewById(R.id.ivChannelIcon);
        }
    }
}

