/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.hippoagent.R;
import com.hippoagent.model.CannedMessageResponse;
import com.hippoagent.utils.Log;
import java.util.ArrayList;

public class CannedMessageAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements Filterable {
    private Context context;
    private ArrayList<CannedMessageResponse.Data> cannedList;
    private ArrayList<CannedMessageResponse.Data> mFilteredList;
    private Callback callback;

    public CannedMessageAdapter(Context context, ArrayList<CannedMessageResponse.Data> cannedList, Callback callback) {
        this.context = context;
        this.cannedList = cannedList;
        this.mFilteredList = cannedList;
        this.callback = callback;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.list_item_canned_messages, parent, false);
        return new ViewHolder(v);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        ViewHolder viewholder = (ViewHolder)holder;
        CannedMessageResponse.Data canned = this.mFilteredList.get(position);
        viewholder.llContainer.setTag((Object)position);
        viewholder.tvTitle.setText((CharSequence)canned.getTitle());
        viewholder.tvMessage.setText((CharSequence)canned.getMessage());
        viewholder.llContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int pos = (Integer)v.getTag();
                CannedMessageAdapter.this.callback.onClick(pos, (CannedMessageResponse.Data)CannedMessageAdapter.this.mFilteredList.get(pos));
            }
        });
    }

    public int getItemCount() {
        return this.mFilteredList == null ? 0 : this.mFilteredList.size();
    }

    public Filter getFilter() {
        return new Filter(){

            protected Filter.FilterResults performFiltering(CharSequence charSequence) {
                Log.v("performFiltering ", "performFiltering start");
                String charString = charSequence.toString();
                if (charString.isEmpty()) {
                    CannedMessageAdapter.this.mFilteredList = CannedMessageAdapter.this.cannedList;
                } else {
                    ArrayList<CannedMessageResponse.Data> filteredList = new ArrayList<CannedMessageResponse.Data>();
                    for (CannedMessageResponse.Data canned : CannedMessageAdapter.this.cannedList) {
                        if (!canned.getMessage().toLowerCase().contains(charString) && !canned.getTitle().toLowerCase().contains(charString)) continue;
                        filteredList.add(canned);
                    }
                    CannedMessageAdapter.this.mFilteredList = filteredList;
                }
                Filter.FilterResults filterResults = new Filter.FilterResults();
                filterResults.values = CannedMessageAdapter.this.mFilteredList;
                Log.v("performFiltering ", "performFiltering end");
                return filterResults;
            }

            protected void publishResults(CharSequence charSequence, Filter.FilterResults filterResults) {
                CannedMessageAdapter.this.mFilteredList = (ArrayList)filterResults.values;
                CannedMessageAdapter.this.notifyDataSetChanged();
                Log.v("publishResults ", "publishResults called");
            }
        };
    }

    public static interface Callback {
        public void onClick(int var1, CannedMessageResponse.Data var2);
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        public LinearLayout llContainer;
        public TextView tvTitle;
        public TextView tvMessage;

        public ViewHolder(View itemView) {
            super(itemView);
            this.llContainer = (LinearLayout)itemView.findViewById(R.id.llContainer);
            this.tvTitle = (TextView)itemView.findViewById(R.id.tvTitle);
            this.tvMessage = (TextView)itemView.findViewById(R.id.tvMessage);
        }
    }
}

