/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.adapters;

import android.content.Context;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StyleSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.databinding.DataBindingUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.hippoagent.R;
import com.hippoagent.adapters.OnItemClickListener;
import com.hippoagent.databinding.LayoutBroadcastItemHistoryBinding;
import com.hippoagent.model.BroadCastObjectModel;
import com.hippoagent.utils.DateUtils;
import com.hippoagent.utils.ProgressBarDisplayRunnable;
import com.hippoagent.utils.Utils;
import java.util.ArrayList;

public class BroadcastListAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final String TAG = BroadcastListAdapter.class.getSimpleName();
    private Context context;
    private ArrayList<BroadCastObjectModel> arrayList = new ArrayList();
    private static final int VIEW_TYPE = 1;
    private static final int VIEW_TYPE_LOADING = 2;
    private RecyclerView recyclerView;
    private String STANDARD_DATE_FORMAT_TZ = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private String OUTPUT_FORMAT = "MMM dd, yyyy, hh:mm aa";
    private OnItemClickListener onItemClickListener;
    private ProgressBarDisplayRunnable progressBarDisplayRunnable;

    public BroadcastListAdapter(RecyclerView recyclerView, OnItemClickListener onItemClickListener) {
        this.recyclerView = recyclerView;
        this.onItemClickListener = onItemClickListener;
    }

    public void setData(ArrayList<BroadCastObjectModel> arrayList) {
        this.arrayList = arrayList;
        this.notifyDataSetChanged();
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        this.context = parent.getContext();
        if (viewType == 2) {
            return new LoadMoreHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.layout_loaddata, parent, false));
        }
        return new ViewHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.layout_broadcast_item_history, parent, false));
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof ViewHolder) {
            ViewHolder viewHolder = (ViewHolder)holder;
            BroadCastObjectModel objectModel = this.arrayList.get(position);
            ((ViewHolder)viewHolder).historyBinding.textViewFromValue.setText((CharSequence)objectModel.getFullName());
            String localDate = DateUtils.getInstance().convertToLocal(objectModel.getCreatedAt(), this.STANDARD_DATE_FORMAT_TZ, this.OUTPUT_FORMAT);
            ((ViewHolder)viewHolder).historyBinding.textViewDateValue.setText((CharSequence)localDate);
            ((ViewHolder)viewHolder).historyBinding.textViewTitleValue.setText((CharSequence)objectModel.getBroadcastTitle());
            Utils.setColor(this.context, ((ViewHolder)viewHolder).historyBinding.textViewMsgValue, objectModel.getMessage());
            if (!TextUtils.isEmpty((CharSequence)objectModel.getFallbackText())) {
                ((ViewHolder)viewHolder).historyBinding.textViewFallbackValue.setText((CharSequence)objectModel.getFallbackText());
                ((ViewHolder)viewHolder).historyBinding.rlFallback.setVisibility(0);
            } else {
                ((ViewHolder)viewHolder).historyBinding.rlFallback.setVisibility(8);
            }
            if (!TextUtils.isEmpty((CharSequence)objectModel.getBroadcastType())) {
                ((ViewHolder)viewHolder).historyBinding.layoutType.setVisibility(0);
                if (objectModel.getBroadcastType().equalsIgnoreCase("email")) {
                    ((ViewHolder)viewHolder).historyBinding.textViewTypeValue.setText((CharSequence)"Email");
                } else {
                    ((ViewHolder)viewHolder).historyBinding.textViewTypeValue.setText((CharSequence)"In App");
                }
            } else {
                ((ViewHolder)viewHolder).historyBinding.layoutType.setVisibility(8);
            }
        }
    }

    public int getItemCount() {
        return this.arrayList == null ? 0 : this.arrayList.size();
    }

    public int getItemViewType(int position) {
        try {
            if (this.arrayList.get(position).getChannelId().equals(-1)) {
                return 2;
            }
            return 1;
        }
        catch (Exception e) {
            return 1;
        }
    }

    public void showPaginationProgressBar(boolean show, boolean notifyAdapter) {
        boolean isProgressBarExist;
        if (this.arrayList == null || this.arrayList.size() == 0) {
            return;
        }
        boolean bl = isProgressBarExist = this.arrayList.get(this.arrayList.size() - 1).getChannelId() != null && this.arrayList.get(this.arrayList.size() - 1).getChannelId() == -1;
        if (show) {
            if (!isProgressBarExist) {
                this.arrayList.add(ProgressBarModel.getInstance());
                if (notifyAdapter) {
                    this.recyclerView.post((Runnable)this.getProgressDisplayRunnable(true, this.arrayList.size()));
                }
            }
        } else if (this.arrayList.remove(ProgressBarModel.getInstance()) && notifyAdapter) {
            this.recyclerView.post((Runnable)this.getProgressDisplayRunnable(false, this.arrayList.size()));
        }
    }

    private ProgressBarDisplayRunnable getProgressDisplayRunnable(boolean isInsert, int position) {
        if (this.progressBarDisplayRunnable == null) {
            this.progressBarDisplayRunnable = new ProgressBarDisplayRunnable(this);
        }
        this.progressBarDisplayRunnable.setInsert(isInsert);
        this.progressBarDisplayRunnable.setPosition(position);
        return this.progressBarDisplayRunnable;
    }

    public String getBtnString(Context context, String text) {
        String msg = text.replace("{{{full_name}}}", "@");
        String[] data = msg.split("@");
        if (data.length > 1) {
            String first = data[0];
            String name = "First Name";
            String last = data[1];
            String finalmsg = first + name + last;
            SpannableStringBuilder title = new SpannableStringBuilder((CharSequence)finalmsg);
            StyleSpan boldTitleSpan = new StyleSpan(1);
            RelativeSizeSpan relativeValidDateSpan = new RelativeSizeSpan(2.2f);
            ForegroundColorSpan foregroundColorSpan = new ForegroundColorSpan(ContextCompat.getColor((Context)context, (int)R.color.colorPrimary));
            title.setSpan((Object)boldTitleSpan, finalmsg.indexOf(name), finalmsg.indexOf(name) + name.length(), 33);
            title.setSpan((Object)relativeValidDateSpan, finalmsg.indexOf(name), finalmsg.indexOf(name) + name.length(), 33);
            title.setSpan((Object)foregroundColorSpan, finalmsg.indexOf(name), finalmsg.indexOf(name) + name.length(), 33);
            return title.toString();
        }
        return text;
    }

    private static class ProgressBarModel {
        private static BroadCastObjectModel progressBarModel;

        private ProgressBarModel() {
        }

        public static BroadCastObjectModel getInstance() {
            if (progressBarModel == null) {
                progressBarModel = new BroadCastObjectModel(-1);
            }
            return progressBarModel;
        }
    }

    public class LoadMoreHolder
    extends RecyclerView.ViewHolder {
        public LoadMoreHolder(View itemView) {
            super(itemView);
        }
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private LayoutBroadcastItemHistoryBinding historyBinding;

        public ViewHolder(View itemView) {
            super(itemView);
            this.historyBinding = (LayoutBroadcastItemHistoryBinding)DataBindingUtil.bind((View)itemView);
            this.historyBinding.relative.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (BroadcastListAdapter.this.onItemClickListener != null) {
                        BroadcastListAdapter.this.onItemClickListener.onClickItem(ViewHolder.this.getAdapterPosition());
                    }
                }
            });
        }
    }
}

