/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.adapters;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.hippoagent.MyApplication;
import com.hippoagent.R;
import com.hippoagent.model.Conversation;
import com.hippoagent.utils.DateUtils;
import java.util.ArrayList;

public class AllChatAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int TYPE_HEADER = 2;
    private static final int TYPE_ITEM = 1;
    public static final int ITEM_PROGRESS_BAR = 3;
    private ArrayList<Object> allChatList;
    private Activity activity;
    private Callback callback;
    private RecyclerView recyclerView;

    public AllChatAdapter(ArrayList<Object> allChatList, Activity activity, Callback callback, RecyclerView recyclerView) {
        this.allChatList = allChatList;
        this.activity = activity;
        this.callback = callback;
        this.recyclerView = recyclerView;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 2) {
            View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.list_item_header, parent, false);
            return new ViewHolderHeader(v);
        }
        if (viewType == 3) {
            View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.custom_loading_list_item, parent, false);
            return new ProgressBarViewHolder(v);
        }
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.list_item_chat, parent, false);
        return new ViewHolder(v);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder viewholder, int position) {
        if (viewholder instanceof ViewHolder) {
            ViewHolder holder = (ViewHolder)viewholder;
            Conversation conversation = (Conversation)this.allChatList.get(position);
            holder.rlChat.setTag((Object)position);
            holder.tvMessage.setText((CharSequence)conversation.getMessage());
            holder.tvName.setText((CharSequence)conversation.getLabel());
            if (!TextUtils.isEmpty((CharSequence)conversation.getBotChannelName())) {
                holder.tvChannelName.setVisibility(0);
                holder.tvChannelName.setText((CharSequence)conversation.getBotChannelName());
            } else {
                holder.tvChannelName.setVisibility(8);
            }
            if (conversation.getUserId() == MyApplication.getInstance().getUserData().getUserId()) {
                holder.tvMessenger.setText((CharSequence)this.activity.getString(R.string.you_colon));
            } else {
                holder.tvMessenger.setText((CharSequence)this.activity.getString(R.string.user_colon));
            }
            if (!conversation.getUnreadCount().equals(0)) {
                holder.tvUnread.setVisibility(0);
                holder.tvUnread.setText((CharSequence)String.valueOf(conversation.getUnreadCount()));
            } else {
                holder.tvUnread.setVisibility(8);
            }
            TextView textView = holder.tvTime;
            DateUtils.getInstance();
            textView.setText((CharSequence)DateUtils.getRelativeDate(DateUtils.getInstance().convertToLocal(conversation.getLastUpdatedAt()), true));
            holder.rlChat.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int pos = (Integer)v.getTag();
                    Conversation conversation = (Conversation)AllChatAdapter.this.allChatList.get(pos);
                    AllChatAdapter.this.callback.onClick(pos, conversation);
                }
            });
        } else if (viewholder instanceof ViewHolderHeader) {
            ViewHolderHeader holder = (ViewHolderHeader)viewholder;
            holder.tvHeader.setText((CharSequence)("2 " + this.activity.getResources().getString(R.string.open_conversations)));
        }
    }

    public int getItemCount() {
        if (this.allChatList == null || this.allChatList.size() == 0) {
            return 0;
        }
        return this.allChatList.size();
    }

    public int getItemViewType(int position) {
        if (this.allChatList.get(position) instanceof ProgressBarItem) {
            return 3;
        }
        return 1;
    }

    public static interface Callback {
        public void onClick(int var1, Conversation var2);
    }

    public static class ProgressBarItem {
    }

    private static class ProgressBarViewHolder
    extends RecyclerView.ViewHolder {
        public ProgressBarViewHolder(View itemView) {
            super(itemView);
        }
    }

    public class ViewHolderHeader
    extends RecyclerView.ViewHolder {
        public TextView tvHeader;

        public ViewHolderHeader(View itemView) {
            super(itemView);
            this.tvHeader = (TextView)itemView.findViewById(R.id.tvHeader);
        }
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        public RelativeLayout rlChat;
        public TextView tvMessage;
        public TextView tvName;
        public TextView tvChannelName;
        public TextView tvMessenger;
        public TextView tvTime;
        public TextView tvUnread;

        public ViewHolder(View itemView) {
            super(itemView);
            this.rlChat = (RelativeLayout)itemView.findViewById(R.id.rlChat);
            this.tvMessage = (TextView)itemView.findViewById(R.id.tvMessage);
            this.tvName = (TextView)itemView.findViewById(R.id.tvName);
            this.tvChannelName = (TextView)itemView.findViewById(R.id.tvChannelName);
            this.tvMessenger = (TextView)itemView.findViewById(R.id.tvMessenger);
            this.tvTime = (TextView)itemView.findViewById(R.id.tvTime);
            this.tvUnread = (TextView)itemView.findViewById(R.id.tvUnread);
        }
    }
}

