/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.activities;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hippoagent.HippoConfigAttributes;
import com.hippoagent.callback.LoginApiCallBack;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.ApiResponseFlags;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.model.LoginResponse.LoginResponse;
import com.hippoagent.model.LoginResponse.UserData;
import com.hippoagent.model.user_details.DeviceDetails;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.ApiInterface;
import com.hippoagent.retrofit.CommonParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.UniqueIMEIID;
import io.paperdb.Book;
import io.paperdb.Paper;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Callback;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e\u00a8\u0006\u0010"}, d2={"Lcom/hippoagent/activities/LoginApi;", "Lcom/hippoagent/datastructure/FuguAppConstant;", "()V", "getAppVersion", "", "context", "Landroid/app/Activity;", "login", "", "configAttributes", "Lcom/hippoagent/HippoConfigAttributes;", "loginApicallBack", "Lcom/hippoagent/callback/LoginApiCallBack;", "showLoader", "", "parseData", "hippoagentsdk_release"})
public final class LoginApi
implements FuguAppConstant {
    public static final LoginApi INSTANCE;

    public final void login(@NotNull Activity context, @NotNull HippoConfigAttributes configAttributes, @NotNull LoginApiCallBack loginApicallBack, boolean showLoader, boolean parseData) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)configAttributes, (String)"configAttributes");
        Intrinsics.checkParameterIsNotNull((Object)loginApicallBack, (String)"loginApicallBack");
        Gson gson = new GsonBuilder().create();
        JsonObject deviceDetailsJson = null;
        try {
            JsonElement jsonElement = gson.toJsonTree((Object)new DeviceDetails(this.getAppVersion(context)).getDeviceDetails());
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"gson.toJsonTree(DeviceDe\u2026(context)).deviceDetails)");
            deviceDetailsJson = jsonElement.getAsJsonObject();
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        CommonParams.Builder builder2 = new CommonParams.Builder();
        builder2.add("access_token", configAttributes.getAuthToken());
        builder2.add("device_type", "1");
        builder2.add("device_token", configAttributes.getDeviceToken());
        builder2.add("app_version_code", 256);
        builder2.add("device_id", UniqueIMEIID.getUniqueIMEIId((Context)context));
        builder2.add("device_details", deviceDetailsJson);
        builder2.add("source", String.valueOf(2));
        if (configAttributes.getIsWhitelabel()) {
            builder2.add("app_type", configAttributes.getAppType());
        }
        CommonParams commonParams = builder2.build();
        ApiInterface apiInterface = RestClient.getApiInterface();
        CommonParams commonParams2 = commonParams;
        Intrinsics.checkExpressionValueIsNotNull((Object)commonParams2, (String)"commonParams");
        apiInterface.login((Map<String, String>)commonParams2.getMap()).enqueue((Callback)new ResponseResolver<LoginResponse>(parseData, loginApicallBack, context, showLoader, context, Boolean.valueOf(showLoader), Boolean.valueOf(true)){
            final /* synthetic */ boolean $parseData;
            final /* synthetic */ LoginApiCallBack $loginApicallBack;
            final /* synthetic */ Activity $context;
            final /* synthetic */ boolean $showLoader;

            public void success(@NotNull LoginResponse loginResponse) {
                Intrinsics.checkParameterIsNotNull((Object)loginResponse, (String)"loginResponse");
                if (!this.$parseData) {
                    this.$loginApicallBack.onApiSuccess(loginResponse);
                    return;
                }
                try {
                    Integer n = loginResponse.getStatusCode();
                    if (n != null && ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == n.intValue()) {
                        Paper.book((String)CommonData.name).delete("user_data");
                        Paper.book((String)CommonData.name).write("user_data", (Object)loginResponse.getUserData());
                        Book book = Paper.book((String)CommonData.name);
                        UserData userData = loginResponse.getUserData();
                        Intrinsics.checkExpressionValueIsNotNull((Object)userData, (String)"loginResponse.userData");
                        book.write("tags", userData.getTags());
                        Paper.book((String)CommonData.name).delete("latest_version");
                        this.$loginApicallBack.onApiSuccess(loginResponse);
                    } else {
                        Integer n2 = loginResponse.getStatusCode();
                        if (n2 != null && ApiResponseFlags.LOGIN_ERROR.getOrdinal() == n2.intValue()) {
                            Log.e("Error", "Something went wrong");
                            this.$loginApicallBack.onErrorMessage(loginResponse);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void failure(@Nullable APIError error) {
                this.$loginApicallBack.onApiFailed(error);
            }
            {
                this.$parseData = $captured_local_variable$0;
                this.$loginApicallBack = $captured_local_variable$1;
                this.$context = $captured_local_variable$2;
                this.$showLoader = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        });
    }

    public final int getAppVersion(@NotNull Activity context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        try {
            return 256;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private LoginApi() {
    }

    static {
        LoginApi loginApi;
        INSTANCE = loginApi = new LoginApi();
    }
}

