/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatButton;
import androidx.appcompat.widget.Toolbar;
import androidx.core.widget.NestedScrollView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.gson.Gson;
import com.hippoagent.R;
import com.hippoagent.activities.FuguBaseActivity;
import com.hippoagent.adapters.HippoPaymentAdapter;
import com.hippoagent.callback.OnItemOpertionListener;
import com.hippoagent.model.PaymentData;
import com.hippoagent.model.PaymentModelData;
import com.hippoagent.model.payment.PlanData;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.countrypicker.Country;
import com.hippoagent.utils.countrypicker.CurrencyPicker;
import com.hippoagent.utils.countrypicker.OnCountryPickerListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;

public class HippoPaymentActivity
extends FuguBaseActivity
implements OnItemOpertionListener {
    private static final String TAG = HippoPaymentActivity.class.getSimpleName();
    private HippoPaymentAdapter paymentAdapter;
    private ArrayList<PaymentModelData> paymentModelData = new ArrayList();
    private Country countryCurrency;
    private EditText planTitle;
    private TextView addOptionView;
    private TextView totalCount;
    private RecyclerView recyclerView;
    private NestedScrollView scrollView;
    private Toolbar toolbar;
    private AppCompatButton buttonSubmit;
    private LinearLayout topLayout;
    private PlanData planData;
    private int planType = 0;
    private boolean showEditBtn = true;
    private DecimalFormat decimalFormatMoney;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.hippo_activity_payment);
        this.paymentModelData = new ArrayList();
        if (this.getIntent().getBooleanExtra("edit_plan", false)) {
            this.planType = 1;
            this.planData = (PlanData)new Gson().fromJson(this.getIntent().getStringExtra("data"), PlanData.class);
            if (this.planData.getPlans().size() > 0) {
                for (int i = 0; i < this.planData.getPlans().size(); ++i) {
                    PaymentModelData modelData = new PaymentModelData();
                    modelData.setTitle(this.planData.getPlans().get(i).getTitle());
                    modelData.setItemDescription(this.planData.getPlans().get(i).getDescription());
                    modelData.setPrice("" + this.planData.getPlans().get(i).getAmount());
                    this.paymentModelData.add(modelData);
                    new Handler().post(new Runnable(){

                        @Override
                        public void run() {
                            HippoPaymentActivity.this.hideKeyboard((Activity)HippoPaymentActivity.this);
                        }
                    });
                }
            }
            if (!this.getIntent().getBooleanExtra("is_editable", true)) {
                this.showEditBtn = false;
            }
        } else if (this.getIntent().getBooleanExtra("add_plan", false)) {
            this.planType = 2;
            PaymentModelData modelData = new PaymentModelData();
            modelData.setTitle("");
            modelData.setItemDescription("");
            modelData.setPrice("");
            this.paymentModelData.add(modelData);
        } else if (this.getIntent().getBooleanExtra("send_plan", false)) {
            this.planData = (PlanData)new Gson().fromJson(this.getIntent().getStringExtra("data"), PlanData.class);
            for (int i = 0; i < this.planData.getPlans().size(); ++i) {
                PaymentModelData modelData = new PaymentModelData();
                modelData.setTitle(this.planData.getPlans().get(i).getTitle());
                modelData.setItemDescription(this.planData.getPlans().get(i).getDescription());
                modelData.setPrice("" + this.planData.getPlans().get(i).getAmount());
                this.paymentModelData.add(modelData);
                this.hideKeyboard((Activity)this);
            }
        } else {
            PaymentModelData modelData = new PaymentModelData();
            modelData.setTitle("");
            modelData.setItemDescription("");
            modelData.setPrice("");
            this.paymentModelData.add(modelData);
        }
    }

    protected void onPostCreate(@Nullable Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        this.toolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(this.toolbar);
        this.setToolbar(this.toolbar, "Payment Request");
        this.planTitle = (EditText)this.findViewById(R.id.plan_title);
        this.topLayout = (LinearLayout)this.findViewById(R.id.top_layout);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recycler_view);
        this.addOptionView = (TextView)this.findViewById(R.id.add_option_view);
        this.buttonSubmit = (AppCompatButton)this.findViewById(R.id.buttonSubmit);
        this.planTitle.setVisibility(8);
        this.topLayout.setVisibility(8);
        if (this.planType == 1) {
            this.planTitle.setEnabled(false);
            this.buttonSubmit.setVisibility(8);
            this.addOptionView.setVisibility(8);
            this.planTitle.setVisibility(0);
            this.topLayout.setVisibility(0);
        } else if (this.planType == 2) {
            this.planTitle.setVisibility(0);
            this.topLayout.setVisibility(0);
        }
        this.totalCount = (TextView)this.findViewById(R.id.total_count);
        this.totalCount.setVisibility(8);
        this.paymentAdapter = new HippoPaymentAdapter(this.paymentModelData, this, this.planType);
        LinearLayoutManager layoutManager = new LinearLayoutManager((Context)this);
        layoutManager.setOrientation(1);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.paymentAdapter);
        this.addOptionView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (HippoPaymentActivity.this.paymentModelData.size() > 0 && (TextUtils.isEmpty((CharSequence)((PaymentModelData)HippoPaymentActivity.this.paymentModelData.get(HippoPaymentActivity.this.paymentModelData.size() - 1)).getTitle().trim()) || TextUtils.isEmpty((CharSequence)((PaymentModelData)HippoPaymentActivity.this.paymentModelData.get(HippoPaymentActivity.this.paymentModelData.size() - 1)).getItemDescription().trim()) || TextUtils.isEmpty((CharSequence)((PaymentModelData)HippoPaymentActivity.this.paymentModelData.get(HippoPaymentActivity.this.paymentModelData.size() - 1)).getPrice().trim()))) {
                    Toast.makeText((Context)HippoPaymentActivity.this, (CharSequence)"Please fill previous fields", (int)0).show();
                    return;
                }
                PaymentModelData modelData = new PaymentModelData();
                modelData.setTitle("");
                modelData.setItemDescription("");
                modelData.setPrice("");
                HippoPaymentActivity.this.paymentModelData.add(modelData);
                HippoPaymentActivity.this.paymentAdapter.notifyDataSetChanged();
            }
        });
        this.buttonSubmit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                HippoPaymentActivity.this.hideKeyboard((Activity)HippoPaymentActivity.this);
                ArrayList<PaymentData> paymentData = new ArrayList<PaymentData>();
                if (HippoPaymentActivity.this.planTitle.getVisibility() == 0 && TextUtils.isEmpty((CharSequence)HippoPaymentActivity.this.planTitle.getText().toString().trim())) {
                    HippoPaymentActivity.this.planTitle.setError((CharSequence)"Field can't be empty");
                    return;
                }
                for (int i = 0; i < HippoPaymentActivity.this.paymentModelData.size(); ++i) {
                    PaymentData data1 = new PaymentData();
                    PaymentModelData modelData = (PaymentModelData)HippoPaymentActivity.this.paymentModelData.get(i);
                    if (TextUtils.isEmpty((CharSequence)modelData.getTitle().trim()) && TextUtils.isEmpty((CharSequence)modelData.getItemDescription().trim()) && TextUtils.isEmpty((CharSequence)modelData.getPrice().trim())) continue;
                    ((PaymentModelData)HippoPaymentActivity.this.paymentModelData.get(i)).setErrorTitle(null);
                    ((PaymentModelData)HippoPaymentActivity.this.paymentModelData.get(i)).setErrorDesc(null);
                    ((PaymentModelData)HippoPaymentActivity.this.paymentModelData.get(i)).setErrorPrice(null);
                    if (TextUtils.isEmpty((CharSequence)modelData.getTitle().trim())) {
                        ((PaymentModelData)HippoPaymentActivity.this.paymentModelData.get(i)).setErrorTitle("Field can't be empty");
                        HippoPaymentActivity.this.paymentAdapter.notifyItemChanged(i);
                        return;
                    }
                    if (TextUtils.isEmpty((CharSequence)modelData.getItemDescription().trim())) {
                        ((PaymentModelData)HippoPaymentActivity.this.paymentModelData.get(i)).setErrorDesc("Field can't be empty");
                        HippoPaymentActivity.this.paymentAdapter.notifyItemChanged(i);
                        return;
                    }
                    if (TextUtils.isEmpty((CharSequence)modelData.getPrice().trim())) {
                        ((PaymentModelData)HippoPaymentActivity.this.paymentModelData.get(i)).setErrorPrice("Field can't be empty");
                        HippoPaymentActivity.this.paymentAdapter.notifyItemChanged(i);
                        return;
                    }
                    Double aDouble = null;
                    try {
                        aDouble = Double.parseDouble(modelData.getPrice().trim());
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                        ((PaymentModelData)HippoPaymentActivity.this.paymentModelData.get(i)).setErrorPrice("Invalid price");
                        HippoPaymentActivity.this.paymentAdapter.notifyItemChanged(i);
                        return;
                    }
                    if (aDouble == null) {
                        ((PaymentModelData)HippoPaymentActivity.this.paymentModelData.get(i)).setErrorPrice("Invalid price");
                        HippoPaymentActivity.this.paymentAdapter.notifyItemChanged(i);
                        return;
                    }
                    data1.setId(i + 1);
                    data1.setTransactionId(UUID.randomUUID().toString() + "." + new Date().getTime());
                    data1.setDescription(modelData.getItemDescription().trim());
                    data1.setAmount(aDouble);
                    if (HippoPaymentActivity.this.countryCurrency != null) {
                        data1.setCurrency(HippoPaymentActivity.this.countryCurrency.getCurrency());
                        data1.setCurrencySymbol(HippoPaymentActivity.this.countryCurrency.getSymbol());
                    } else {
                        data1.setCurrency("INR");
                        data1.setCurrencySymbol("\u20b9");
                    }
                    data1.setTitle(modelData.getTitle().trim());
                    paymentData.add(data1);
                }
                if (paymentData.size() == 0) {
                    ((PaymentModelData)HippoPaymentActivity.this.paymentModelData.get(0)).setErrorTitle("Field can't be empty");
                    HippoPaymentActivity.this.paymentAdapter.notifyItemChanged(0);
                    return;
                }
                Log.e(TAG, "data = " + new Gson().toJson(paymentData));
                Intent intent = new Intent();
                intent.putExtra("data", paymentData);
                intent.putExtra("planData", new Gson().toJson((Object)HippoPaymentActivity.this.planData));
                if (HippoPaymentActivity.this.planTitle.getVisibility() == 0) {
                    intent.putExtra("plan_name", HippoPaymentActivity.this.planTitle.getText().toString().trim());
                }
                HippoPaymentActivity.this.setResult(-1, intent);
                HippoPaymentActivity.this.finish();
            }
        });
        this.setEditView();
    }

    private void setEditView() {
        switch (this.planType) {
            case 1: {
                this.buttonSubmit.setText((CharSequence)"Update Plan");
                break;
            }
            case 2: {
                this.buttonSubmit.setText((CharSequence)"Add Plan");
            }
        }
        if (this.planData != null && this.planData.getPlans() != null && this.planData.getPlans().size() > 0) {
            this.planTitle.setText((CharSequence)this.planData.getPlanName());
            try {
                this.countryCurrency = new Country();
                this.countryCurrency.setSymbol(this.planData.getPlans().get(0).getCurrencySymbol());
                this.countryCurrency.setCurrency(this.planData.getPlans().get(0).getCurrency());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    protected void onPause() {
        super.onPause();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        if (this.planType == 1 && this.showEditBtn) {
            this.getMenuInflater().inflate(R.menu.menu_edit_plan, menu2);
            return true;
        }
        return super.onCreateOptionsMenu(menu2);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
        } else if (item.getItemId() == R.id.edit_plan) {
            this.enabledView();
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        super.onBackPressed();
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    @Override
    public void onItemAdded() {
        Double totalPrice = 0.0;
        if (this.paymentModelData != null && this.paymentModelData.size() > 0) {
            for (PaymentModelData modelData : this.paymentModelData) {
                if (modelData == null || TextUtils.isEmpty((CharSequence)modelData.getPrice())) continue;
                try {
                    totalPrice = totalPrice + Double.parseDouble(modelData.getPrice().trim());
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    return;
                }
            }
        }
    }

    @Override
    public void onItemRemoved(int position) {
        this.paymentModelData.remove(position);
        this.paymentAdapter.notifyDataSetChanged();
    }

    private void enabledView() {
        if (this.buttonSubmit.getVisibility() == 8) {
            this.planTitle.setEnabled(true);
            this.addOptionView.setVisibility(0);
            this.buttonSubmit.setVisibility(0);
            if (this.paymentAdapter != null) {
                this.paymentAdapter.updateEnabled(0);
            }
            this.showEditBtn = false;
            this.invalidateOptionsMenu();
        }
    }

    private void openPicker(final TextView textView) {
        CurrencyPicker currencyPicker = new CurrencyPicker.Builder().with((Context)this).sortBy(1).listener(new OnCountryPickerListener(){

            @Override
            public void onSelectCountry(Country country) {
                HippoPaymentActivity.this.countryCurrency = country;
                textView.setText((CharSequence)(country.getCode() + "(" + country.getSymbol() + ")"));
            }
        }).build();
        currencyPicker.showDialog(this.getSupportFragmentManager());
    }

    public DecimalFormat getDecimalFormat() {
        if (this.decimalFormatMoney == null) {
            this.decimalFormatMoney = new DecimalFormat("#.##");
        }
        return this.decimalFormatMoney;
    }
}

