/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.activities;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.Toolbar;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.gson.Gson;
import com.hippoagent.MyApplication;
import com.hippoagent.R;
import com.hippoagent.activities.FuguBaseActivity;
import com.hippoagent.adapters.ChatMembersAdapter;
import com.hippoagent.model.ChatMembersModel;
import com.hippoagent.model.Conversation;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.filelogger.Logger;
import java.util.ArrayList;
import retrofit2.Callback;

public class ChatMembersActivity
extends FuguBaseActivity {
    private static final String TAG = ChatMembersActivity.class.getSimpleName();
    private RecyclerView recyclerView;
    private ChatMembersAdapter membersAdapter;
    private Toolbar toolbar;
    private Conversation conversation;
    private LinearLayout llNoConversation;
    private TextView titleView;
    private TextView reasions;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_chat_members);
        this.conversation = (Conversation)new Gson().fromJson(this.getIntent().getStringExtra("conversation"), Conversation.class);
        this.initView();
    }

    private void initView() {
        this.toolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(this.toolbar);
        this.setToolbar(this.toolbar, this.getResources().getString(R.string.members));
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recycler_view);
        this.llNoConversation = (LinearLayout)this.findViewById(R.id.llNoConversation);
        this.titleView = (TextView)this.findViewById(R.id.title);
        this.reasions = (TextView)this.findViewById(R.id.reasions);
        this.llNoConversation.setVisibility(8);
        this.membersAdapter = new ChatMembersAdapter();
        LinearLayoutManager layoutManager = new LinearLayoutManager((Context)this);
        layoutManager.setOrientation(1);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.membersAdapter);
        if (this.isNetworkAvailable()) {
            this.getMembersData();
        } else {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.fugu_unable_to_connect_internet), (int)0).show();
        }
    }

    private void getMembersData() {
        CommonParams commonParams = new CommonParams.Builder().add("access_token", MyApplication.getInstance().getUserData().getAccessToken()).add("channel_id", this.conversation.getChannelId()).build();
        Logger.INSTANCE.apiRequest("/api/chat/getMembers", new Gson().toJson(commonParams.getMap()));
        RestClient.getApiInterface().getChatMembers(commonParams.getMap()).enqueue((Callback)new ResponseResolver<ChatMembersModel>((Activity)this, Boolean.valueOf(true), Boolean.valueOf(true)){

            @Override
            public void success(ChatMembersModel membersModel) {
                Logger.INSTANCE.apiResponse("/api/chat/getMembers", "");
                if (membersModel.getData() != null && membersModel.getData().size() > 0) {
                    ChatMembersActivity.this.membersAdapter.setMembersData((ArrayList)membersModel.getData());
                } else {
                    ChatMembersActivity.this.llNoConversation.setVisibility(0);
                    ChatMembersActivity.this.titleView.setText((CharSequence)"No members found");
                    ChatMembersActivity.this.reasions.setVisibility(8);
                }
            }

            @Override
            public void failure(APIError error) {
                Logger.INSTANCE.apiFailed("/api/chat/getMembers", error.getMessage());
            }
        });
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    protected void onPause() {
        super.onPause();
    }

    protected void onDestroy() {
        super.onDestroy();
    }
}

