/*
 * Decompiled with CFR 0.152.
 */
package faye;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.google.gson.Gson;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.filelogger.Logger;
import faye.FayeServiceListener;
import faye.FuguAgentFayeClientListener;
import faye.FuguAgentMetaMessage;
import faye.FuguAgentWebSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.NotYetConnectedException;
import java.util.HashSet;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.java_websocket.WebSocketImpl;
import org.java_websocket.exceptions.WebsocketNotConnectedException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FuguAgentFayeClient {
    private static final String LOG_TAG = FuguAgentFayeClient.class.getSimpleName();
    private FuguAgentWebSocket mFuguAgentWebSocket = null;
    private FuguAgentFayeClientListener mManagerListener = null;
    private FayeServiceListener serviceListener = null;
    private HashSet<String> mChannels;
    private String mServerUrl = "";
    private boolean mFayeConnected = false;
    private boolean mIsConnectedServer = false;
    private FuguAgentMetaMessage mFuguAgentMetaMessage;
    private Handler mMessageHandler;

    public FuguAgentFayeClient(String url, FuguAgentMetaMessage meta) {
        HandlerThread thread = new HandlerThread("FayeHandler");
        thread.start();
        this.mMessageHandler = new Handler(thread.getLooper()){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                switch (msg.what) {
                    case 1: {
                        Log.i(LOG_TAG, "onOpen() executed");
                        FuguAgentFayeClient.this.mIsConnectedServer = true;
                        FuguAgentFayeClient.this.handShake();
                        break;
                    }
                    case 2: {
                        Log.i(LOG_TAG, "onClosed() executed");
                        FuguAgentFayeClient.this.mIsConnectedServer = false;
                        FuguAgentFayeClient.this.mFayeConnected = false;
                        if (FuguAgentFayeClient.this.mManagerListener != null) {
                            FuguAgentFayeClient.this.mManagerListener.onDisconnectedServer(FuguAgentFayeClient.this);
                        }
                        if (FuguAgentFayeClient.this.serviceListener != null) {
                            FuguAgentFayeClient.this.serviceListener.onDisconnectedServer(FuguAgentFayeClient.this);
                        }
                        Logger.INSTANCE.fayeDisconnected();
                        break;
                    }
                    case 3: {
                        try {
                            Log.i(LOG_TAG, "onMessage executed");
                            FuguAgentFayeClient.this.handleFayeMessage((String)msg.obj);
                        }
                        catch (NotYetConnectedException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case 5: {
                        if (FuguAgentFayeClient.this.mManagerListener != null) {
                            FuguAgentFayeClient.this.mManagerListener.onPongReceived();
                        }
                        if (FuguAgentFayeClient.this.serviceListener == null) break;
                        FuguAgentFayeClient.this.serviceListener.onPongReceived();
                        break;
                    }
                    case 6: {
                        if (FuguAgentFayeClient.this.mManagerListener == null) break;
                        FuguAgentFayeClient.this.mManagerListener.onNotConnected();
                    }
                }
            }
        };
        Log.w("faye url", "faye url = " + url);
        this.mServerUrl = url;
        this.mFuguAgentMetaMessage = meta;
        this.mChannels = new HashSet();
    }

    public FuguAgentFayeClientListener getmManagerListener() {
        return this.mManagerListener;
    }

    public void setmManagerListener(FuguAgentFayeClientListener mManagerListener) {
        this.mManagerListener = mManagerListener;
    }

    public FayeServiceListener getServiceListener() {
        return this.serviceListener;
    }

    public void setServiceListener(FayeServiceListener serviceListener) {
        this.serviceListener = serviceListener;
    }

    public void addChannel(String channel) {
        this.mChannels.add(channel);
    }

    public boolean isConnectedServer() {
        return this.mIsConnectedServer;
    }

    public boolean isFayeConnected() {
        return this.mFayeConnected;
    }

    public void connectServer() {
        this.openWebSocketConnection();
    }

    public void disconnectServer() {
        Log.e("disconnectServer", "disconnectServer");
        for (String channel : this.mChannels) {
            this.unsubscribe(channel);
        }
        this.mChannels.clear();
        this.disconnect();
    }

    public void subscribeChannel(String channel) {
        Log.e("subscribeChannel", "subscribeChannel");
        this.mChannels.add(channel);
        this.subscribe(channel);
        Logger.INSTANCE.fayeSubscribed(channel);
        Log.v("channel------>>>>>>>>>>--------------", channel);
    }

    public void subscribeToChannels(String ... channels) {
        for (String channel : channels) {
            this.mChannels.add(channel);
            this.subscribe(channel);
        }
    }

    public void unsubscribeChannel(String channel) {
        Log.e("unsubscribeChannel", "unsubscribeChannel");
        if (this.mChannels.contains(channel)) {
            this.unsubscribe(channel);
            this.mChannels.remove(channel);
            Logger.INSTANCE.fayeUnsubscribed(channel);
        }
    }

    public void unsubscribeChannels(String ... channels) {
        Log.e("unsubscribeChannels", "unsubscribeChannels");
        for (String channel : channels) {
            this.unsubscribe(channel);
        }
    }

    public void unsubscribeAll() {
        Log.e("unsubscribeAll", "unsubscribeAll");
        for (String channel : this.mChannels) {
            this.unsubscribe(channel);
            Logger.INSTANCE.fayeUnsubscribed(channel);
        }
    }

    public void publish(String channel, JSONObject data) {
        this.publish(channel, data, null, null);
    }

    public void publish(String channel, JSONObject data, String ext, String id2) {
        try {
            android.util.Log.w((String)"data sent", (String)(channel + " <<<<    channel + data = " + new Gson().toJson((Object)data)));
            String publish = this.mFuguAgentMetaMessage.publish(channel, data, ext, id2);
            this.mFuguAgentWebSocket.send(publish);
        }
        catch (JSONException e) {
            Log.e(LOG_TAG, "Build publish message to JSON error" + (Object)((Object)e));
        }
        catch (Exception e) {
            Log.e(LOG_TAG, "Build publish message to error" + e);
        }
    }

    private Socket getSSLWebSocket() {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, null, null);
            SSLSocketFactory factory = sslContext.getSocketFactory();
            return factory.createSocket();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void openWebSocketConnection() {
        WebSocketImpl.DEBUG = false;
        if (this.mFuguAgentWebSocket != null) {
            this.mFuguAgentWebSocket.close();
        }
        try {
            URI uri = new URI(this.mServerUrl);
            this.mFuguAgentWebSocket = new FuguAgentWebSocket(uri, this.mMessageHandler);
            this.mFuguAgentWebSocket.setConnectionLostTimeout(60);
            if (uri.getScheme().equals("https") || uri.getScheme().equals("wss")) {
                this.mFuguAgentWebSocket.setSocket(this.getSSLWebSocket());
            }
            this.mFuguAgentWebSocket.connect();
        }
        catch (URISyntaxException e) {
            Log.e(LOG_TAG, "Server URL error" + e);
        }
    }

    private void closeWebSocketConnection() {
        if (this.mFuguAgentWebSocket != null) {
            this.mFuguAgentWebSocket.close();
        }
    }

    private void handShake() {
        try {
            String handshake = this.mFuguAgentMetaMessage.handShake();
            this.mFuguAgentWebSocket.send(handshake);
        }
        catch (JSONException e) {
            Log.e(LOG_TAG, "HandShake message error" + (Object)((Object)e));
        }
        catch (Exception e) {
            Log.e(LOG_TAG, "HandShake message error" + e);
            e.printStackTrace();
        }
    }

    private void subscribe(String channel) {
        try {
            String subscribe = this.mFuguAgentMetaMessage.subscribe(channel);
            this.mFuguAgentWebSocket.send(subscribe);
            Log.v("Channel subscribe", "Successfully");
        }
        catch (WebsocketNotConnectedException e) {
            if (this.mManagerListener != null) {
                this.mManagerListener.onWebSocketError();
            }
            if (this.serviceListener != null) {
                this.serviceListener.onWebSocketError();
            }
            this.mFayeConnected = false;
            e.printStackTrace();
            Logger.INSTANCE.fayeError();
            Log.e(LOG_TAG, "Subscribe message error" + (Object)((Object)e));
        }
        catch (Exception e) {
            Log.e(LOG_TAG, "Subscribe message error" + e);
        }
    }

    private void unsubscribe(String channel) {
        try {
            String unsubscribe = this.mFuguAgentMetaMessage.unsubscribe(channel);
            this.mFuguAgentWebSocket.send(unsubscribe);
            Log.i(LOG_TAG, "UnSubscribe:" + channel);
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e(LOG_TAG, "Unsubscribe message error" + e);
        }
    }

    private void connect() {
        try {
            String connect = this.mFuguAgentMetaMessage.connect();
            this.mFuguAgentWebSocket.send(connect);
            this.mFuguAgentWebSocket.setConnectionLostTimeout(10);
        }
        catch (Exception e) {
            Log.e(LOG_TAG, "Connect message error" + e);
        }
    }

    private void reconnectFaye() {
    }

    private void disconnect() {
        try {
            String disconnect = this.mFuguAgentMetaMessage.disconnect();
            this.mFuguAgentWebSocket.send(disconnect);
        }
        catch (JSONException e) {
            Log.e(LOG_TAG, "Disconnect message error" + (Object)((Object)e));
        }
    }

    private void handleFayeMessage(String message) {
        JSONArray arr = null;
        try {
            arr = new JSONArray(message);
        }
        catch (JSONException e) {
            Log.e(LOG_TAG, "Unknown message type: " + message + (Object)((Object)e));
        }
        int length = arr.length();
        for (int i = 0; i < length; ++i) {
            JSONObject obj = arr.optJSONObject(i);
            if (obj == null) continue;
            String channel = obj.optString("channel");
            boolean successful = obj.optBoolean("successful");
            if (channel.equals("/meta/handshake")) {
                if (successful) {
                    this.mFuguAgentMetaMessage.setClient(obj.optString("clientId"));
                    if (this.mManagerListener != null) {
                        this.mManagerListener.onConnectedServer(this);
                    }
                    if (this.serviceListener != null) {
                        this.serviceListener.onConnectedServer(this);
                    }
                    this.connect();
                } else {
                    Log.e(LOG_TAG, "Handshake Error: " + obj.toString());
                }
                return;
            }
            if (channel.equals("/meta/connect")) {
                if (successful) {
                    this.mFayeConnected = true;
                    this.connect();
                } else {
                    Log.e(LOG_TAG, "Connecting Error: " + obj.toString());
                }
                return;
            }
            if (channel.equals("/meta/disconnect")) {
                if (successful) {
                    if (this.mManagerListener != null) {
                        this.mManagerListener.onDisconnectedServer(this);
                    }
                    if (this.serviceListener != null) {
                        this.serviceListener.onDisconnectedServer(this);
                    }
                    this.mFayeConnected = false;
                    this.closeWebSocketConnection();
                    Logger.INSTANCE.fayeDisconnected();
                } else {
                    Log.e(LOG_TAG, "Disconnecting Error: " + obj.toString());
                }
                return;
            }
            if (channel.equals("/meta/subscribe")) {
                String subscription = obj.optString("subscription");
                if (successful) {
                    this.mFayeConnected = true;
                    Log.i(LOG_TAG, "Subscribed channel " + subscription);
                } else {
                    Log.e(LOG_TAG, "Subscribing channel " + subscription + " Error: " + obj.toString());
                }
                return;
            }
            if (channel.equals("/meta/unsubscribe")) {
                String subscription = obj.optString("subscription");
                if (successful) {
                    Log.i(LOG_TAG, "Unsubscribed channel " + subscription);
                } else {
                    Log.e(LOG_TAG, "Unsubscribing channel " + subscription + " Error: " + obj.toString());
                }
                return;
            }
            if (this.mChannels.contains(channel)) {
                String data = obj.optString("data", null);
                if (data != null) {
                    if (this.mManagerListener != null) {
                        this.mManagerListener.onReceivedMessage(this, data, channel);
                    }
                    if (this.serviceListener != null) {
                        this.serviceListener.onReceivedMessage(this, data, channel);
                    }
                } else {
                    try {
                        if (obj.has("error")) {
                            if (this.mManagerListener != null) {
                                this.mManagerListener.onErrorReceived(this, obj.optString("error"), channel);
                            }
                            if (this.serviceListener != null) {
                                this.serviceListener.onErrorReceived(this, obj.optString("error"), channel);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                Log.e(LOG_TAG, "Cannot handle this message: " + obj.toString());
                if (obj.has("error")) {
                    if (this.mManagerListener != null) {
                        this.mManagerListener.onErrorReceived(this, obj.optString("error"), channel);
                    }
                    if (this.serviceListener != null) {
                        this.serviceListener.onErrorReceived(this, obj.optString("error"), channel);
                    }
                } else {
                    String data = obj.optString("data", null);
                    System.out.println("3333333 ~~~> " + data);
                    if (this.serviceListener != null) {
                        this.serviceListener.onReceivedMessage(this, data, channel);
                    }
                    if (this.mManagerListener != null) {
                        this.mManagerListener.onReceivedMessage(this, data, channel);
                    }
                }
            }
            return;
        }
    }

    public boolean hasChannel(String channel) {
        return this.mChannels.contains(channel);
    }

    public HashSet<String> getmChannels() {
        return this.mChannels;
    }

    public boolean isChannelSubscribed(String mChannel) {
        return this.getmChannels() != null && this.getmChannels().contains(mChannel);
    }

    public boolean hasSubscribed(String s) {
        return !this.mChannels.contains(s);
    }

    public boolean isOpened() {
        return this.mFuguAgentWebSocket != null && this.mFuguAgentWebSocket.isOpen() && this.mFuguAgentWebSocket.getSocket().isConnected();
    }
}

