/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils.typekit;

import android.graphics.Paint;
import android.graphics.Typeface;
import android.os.Parcel;
import android.text.TextPaint;
import android.text.style.StyleSpan;
import com.hippoagent.utils.typekit.Typekit;

public class TypekitSpan
extends StyleSpan {
    private final Typekit mTypekit;

    public TypekitSpan(int style2, Typekit typekit) {
        super(style2);
        this.mTypekit = typekit;
    }

    public TypekitSpan(Parcel src, Typekit typekit) {
        super(src);
        this.mTypekit = typekit;
    }

    public void updateDrawState(TextPaint ds) {
        TypekitSpan.apply((Paint)ds, this.getStyle(), this.mTypekit);
    }

    public void updateMeasureState(TextPaint paint) {
        TypekitSpan.apply((Paint)paint, this.getStyle(), this.mTypekit);
    }

    private static void apply(Paint paint, int style2, Typekit typekit) {
        Typeface old = paint.getTypeface();
        int oldStyle = old == null ? 0 : old.getStyle();
        int want = oldStyle | style2;
        Typeface tf = null;
        switch (want) {
            case 1: {
                tf = typekit.get(Typekit.Style.Bold);
                break;
            }
            case 2: {
                tf = typekit.get(Typekit.Style.Italic);
                break;
            }
            case 3: {
                tf = typekit.get(Typekit.Style.BoldItalic);
                break;
            }
            default: {
                tf = null;
            }
        }
        if (tf == null) {
            tf = old == null ? Typeface.defaultFromStyle((int)want) : Typeface.create((Typeface)old, (int)want);
            int fake = want & ~tf.getStyle();
            if ((fake & 1) != 0) {
                paint.setFakeBoldText(true);
            }
            if ((fake & 2) != 0) {
                paint.setTextSkewX(-0.25f);
            }
        }
        paint.setTypeface(tf);
    }
}

