/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils.loadingBox;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;
import com.hippoagent.R;
import com.hippoagent.langs.Restring;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.loadingBox.FuguAgentProgressWheel;

public class LoadingBox {
    private static Dialog progressDialog;
    private static TextView tvProgress;
    private static TextView innerProgress;

    public static void showOn(Activity activity) {
        Log.e("activity loderbox", activity + "");
        if (activity != null) {
            LoadingBox.showOn(activity, Restring.getString((Context)activity, R.string.fugu_loading));
        }
    }

    public static void showOn(Activity activity, String message) {
        try {
            if (progressDialog != null && progressDialog.isShowing()) {
                tvProgress.setText((CharSequence)message);
                return;
            }
            progressDialog = new Dialog((Context)activity, R.style.Theme_AppCompat_Translucent_Hippo);
            progressDialog.setContentView(R.layout.fugu_dialog_progress);
            tvProgress = (TextView)progressDialog.findViewById(R.id.tvProgress);
            innerProgress = (TextView)progressDialog.findViewById(R.id.progress);
            tvProgress.setText((CharSequence)message);
            innerProgress.setText((CharSequence)"");
            ((FuguAgentProgressWheel)progressDialog.findViewById(R.id.progress_wheel)).spin();
            Window dialogWindow = progressDialog.getWindow();
            WindowManager.LayoutParams layoutParams = dialogWindow.getAttributes();
            layoutParams.dimAmount = 0.0f;
            dialogWindow.addFlags(2);
            progressDialog.setCancelable(false);
            progressDialog.setCanceledOnTouchOutside(false);
            progressDialog.show();
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e("PROGRESS DIALOG", "EXCEPTION: " + e.getMessage());
        }
    }

    public static void updateProgress(int percentage) {
        innerProgress.setText((CharSequence)(Integer.toString(percentage) + "%"));
    }

    public static boolean hide() {
        return LoadingBox.hide(null);
    }

    public static boolean hide(Canceled canceled) {
        Log.e("PROGRESS DIALOG", "DISMISSED");
        if (progressDialog != null && progressDialog.isShowing()) {
            try {
                progressDialog.dismiss();
            }
            catch (Exception ex) {
                Log.e("Dismiss Loading Dialog", ex.toString());
            }
            progressDialog = null;
            tvProgress = null;
            innerProgress = null;
            if (canceled != null) {
                canceled.onClosed();
            }
            return true;
        }
        if (canceled != null) {
            canceled.onClosed();
        }
        return false;
    }

    public static interface Canceled {
        public void onClosed();
    }
}

