/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils.filelogger;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;

class KeyLocker {
    private ConcurrentMap<String, Semaphore> semaphoreMap = new ConcurrentHashMap<String, Semaphore>();

    KeyLocker() {
    }

    void acquire(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key couldn't be null");
        }
        if (!this.semaphoreMap.containsKey(key)) {
            this.semaphoreMap.put(key, new Semaphore(1, true));
        }
        Semaphore semaphore = (Semaphore)this.semaphoreMap.get(key);
        semaphore.acquireUninterruptibly();
    }

    void release(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key couldn't be null");
        }
        Semaphore semaphore = (Semaphore)this.semaphoreMap.get(key);
        if (semaphore == null) {
            throw new IllegalStateException("Couldn't release semaphore. The acquire() with the same key '" + key + "' has to be called prior to calling release()");
        }
        semaphore.release();
    }
}

