/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils.filePicker;

import android.app.ActivityManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.webkit.MimeTypeMap;
import androidx.core.app.NotificationCompat;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.hippoagent.Config;
import com.hippoagent.HippoApplication;
import com.hippoagent.R;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.model.FileuploadModel;
import com.hippoagent.model.FuguUploadImageResponse;
import com.hippoagent.model.Message;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.MultipartParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.DateUtils;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.filePicker.Prefs;
import com.hippoagent.utils.filePicker.ProgressRequestBody;
import com.hippoagent.utils.filelogger.Logger;
import faye.FayeServiceListener;
import faye.FuguAgentFayeClient;
import faye.FuguAgentMetaMessage;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Callback;

public class UploadingService
extends Service
implements FayeServiceListener,
FuguAppConstant,
ProgressRequestBody.UploadCallbacks {
    private static final String TAG = UploadingService.class.getSimpleName();
    private String inputFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private String outputFormat = "yyyy-MM-dd";
    private Handler h;
    private Runnable r;
    FuguAgentFayeClient mClient = null;
    int counter = 0;
    private Type fileuploadType = new TypeToken<List<FileuploadModel>>(){}.getType();
    NotificationManager manager;
    NotificationCompat.Builder builder;
    FileuploadModel fileuploadModel;
    ArrayList<FileuploadModel> fileuploadModels = new ArrayList();
    boolean apiInProgress;
    boolean isFirstTime;

    public IBinder onBind(Intent intent) {
        return null;
    }

    private Notification updateNotification() {
        ++this.counter;
        Context context = this.getApplicationContext();
        this.manager = (NotificationManager)this.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26) {
            String CHANNEL_ID = "hippo_file_uploading";
            NotificationChannel channel = new NotificationChannel(CHANNEL_ID, (CharSequence)this.getString(R.string.app_name), 3);
            channel.setDescription("File uploading");
            this.manager.createNotificationChannel(channel);
            this.builder = new NotificationCompat.Builder((Context)this, CHANNEL_ID);
        } else {
            this.builder = new NotificationCompat.Builder(context);
        }
        this.builder.setProgress(100, this.counter, false);
        return this.builder.setContentTitle((CharSequence)this.getString(R.string.uploading)).setTicker((CharSequence)"").setOnlyAlertOnce(true).setContentText((CharSequence)this.getString(R.string.uploading_in_progress)).setSmallIcon(R.mipmap.hippo_notif).setOngoing(true).build();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent.getAction().contains("start")) {
            this.startForeground(102, this.updateNotification());
            this.uploadFileServerCall();
        } else {
            this.stopFayeClient();
            this.stopForeground(true);
            this.stopSelf();
        }
        return 1;
    }

    public void stopFayeClient() {
        if (this.mClient == null) {
            return;
        }
        try {
            HandlerThread thread = new HandlerThread("TerminateThread");
            thread.start();
            new Handler(thread.getLooper()).post(new Runnable(){

                @Override
                public void run() {
                    UploadingService.this.mClient.setServiceListener(null);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateProgress(int uploaded, int total) {
        Log.e(TAG, "uploaded progress = " + uploaded);
        if (this.builder != null && this.manager != null) {
            this.builder.setProgress(total, uploaded, false);
            this.manager.notify(102, this.builder.build());
        } else {
            this.startForeground(102, this.updateNotification());
        }
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager)this.getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        if (cm != null) {
            networkInfo = cm.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }

    private void uploadFileServerCall() {
        try {
            if (this.apiInProgress) {
                Log.e(TAG, "***************ApiInProgress*************");
                return;
            }
            if (this.isNetworkAvailable()) {
                this.getClient();
                String data = Prefs.with((Context)this).getString("pref_upload_data", "");
                Log.v(TAG, "uploadFileServerCall 1: " + data);
                this.fileuploadModels = (ArrayList)new Gson().fromJson(data, this.fileuploadType);
                if (this.fileuploadModels == null || this.fileuploadModels.size() == 0) {
                    Prefs.with((Context)this).removeAll();
                    this.stopFayeClient();
                    this.stopForeground(true);
                    this.stopSelf();
                    return;
                }
                this.fileuploadModel = this.fileuploadModels.get(0);
                LinkedHashMap<String, JSONObject> unsentMessageMapNew = CommonData.getUnsentMessageMapByChannel(this.fileuploadModel.getChannelId());
                if (unsentMessageMapNew == null || unsentMessageMapNew.size() == 0) {
                    Log.e(TAG, "File item not found " + this.fileuploadModel.getMuid());
                    this.updatePref();
                    return;
                }
                if (!unsentMessageMapNew.containsKey(this.fileuploadModel.getMuid())) {
                    Log.e(TAG, "File item not found " + this.fileuploadModel.getMuid());
                    this.updatePref();
                    return;
                }
                this.isFirstTime = true;
                ProgressRequestBody fileBody = new ProgressRequestBody(new File(this.fileuploadModel.getFilePath()), this, this.getMimeType(this.fileuploadModel.getFilePath()), this.fileuploadModel.getFilePath(), this.fileuploadModel.getMessageIndex(), this.fileuploadModel.getMuid());
                MultipartBody.Part filePart = MultipartBody.Part.createFormData((String)"file", (String)this.fileuploadModel.getFileName(), (RequestBody)fileBody);
                MultipartParams.Builder multipartBuilder = new MultipartParams.Builder();
                MultipartParams multipartParams = multipartBuilder.add("access_token", HippoApplication.getInstance().getUserData().getAccessToken()).add("app_version", "2.5.6").add("device_type", 1).add("allow_all_mime_type", true).add("file_name", this.fileuploadModel.getFileName()).build();
                this.apiInProgress = true;
                Log.v("map = ", multipartParams.getMap().toString());
                Logger.INSTANCE.apiRequest("/api/conversation/uploadFile", new Gson().toJson(multipartParams.getMap()));
                RestClient.getApiInterface().uploadFile(HippoApplication.getInstance().getUserData().getAccessToken(), 1, 256, filePart, multipartParams.getMap()).enqueue((Callback)new ResponseResolver<FuguUploadImageResponse>(){

                    @Override
                    public void success(FuguUploadImageResponse fuguUploadImageResponse) {
                        Logger.INSTANCE.apiResponse("/api/conversation/uploadFile", "");
                        String image_url = fuguUploadImageResponse.getData().getUrl();
                        String thumbnail_url = fuguUploadImageResponse.getData().getThumbnailUrl();
                        String data = Prefs.with((Context)UploadingService.this).getString("pref_upload_data", "");
                        Log.v(TAG, "In response: " + data);
                        UploadingService.this.fileuploadModels = (ArrayList)new Gson().fromJson(data, UploadingService.this.fileuploadType);
                        JSONObject jsonObject = UploadingService.this.fileuploadModels.get(0).getMessageObject();
                        try {
                            jsonObject.put("image_url", (Object)image_url);
                            jsonObject.put("thumbnail_url", (Object)thumbnail_url);
                            jsonObject.put("url", (Object)image_url);
                            jsonObject.remove("local_url");
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                        UploadingService.this.fileuploadModels.get(0).setFileUploaded(true);
                        UploadingService.this.fileuploadModels.get(0).setMessageObject(jsonObject);
                        if (UploadingService.this.fileuploadModels.get(0).getChannelId() < 1) {
                            Intent mIntent = new Intent("HIPPO_FILE_UPLOAD");
                            mIntent.putExtra("broadcast_status", 4);
                            mIntent.putExtra("fileuploadModel", new Gson().toJson((Object)UploadingService.this.fileuploadModels.get(0)));
                            LocalBroadcastManager.getInstance((Context)HippoApplication.getInstance().getApplicationContext()).sendBroadcast(mIntent);
                            UploadingService.this.updatePref();
                        } else {
                            data = new Gson().toJson(UploadingService.this.fileuploadModels, UploadingService.this.fileuploadType);
                            Log.e(TAG, "In response else case " + data);
                            Prefs.with((Context)UploadingService.this).save("pref_upload_data", data);
                            UploadingService.this.fileuploadModel = UploadingService.this.fileuploadModels.get(0);
                            if (UploadingService.this.isOpenedChatActivityMsg(UploadingService.this.fileuploadModel.getChannelId())) {
                                Log.e(TAG, "in isOpenedChatActivityMsg");
                                Intent mIntent = new Intent("HIPPO_FILE_UPLOAD");
                                mIntent.putExtra("broadcast_status", 0);
                                mIntent.putExtra("channelId", UploadingService.this.fileuploadModel.getChannelId());
                                mIntent.putExtra("muid", UploadingService.this.fileuploadModel.getMuid());
                                mIntent.putExtra("messageIndex", UploadingService.this.fileuploadModel.getMessageIndex());
                                mIntent.putExtra("image_url", image_url);
                                mIntent.putExtra("thumbnail_url", thumbnail_url);
                                mIntent.putExtra("fileuploadModel", new Gson().toJson((Object)UploadingService.this.fileuploadModel));
                                LocalBroadcastManager.getInstance((Context)HippoApplication.getInstance().getApplicationContext()).sendBroadcast(mIntent);
                                UploadingService.this.updatePref();
                            } else {
                                UploadingService.this.updateLocalMessageObj(UploadingService.this.fileuploadModel.getChannelId(), false, image_url, thumbnail_url, jsonObject, new UpdateLocalMsgListener(){

                                    @Override
                                    public void onUpdation(JSONObject jsonObject) {
                                        UploadingService.this.apiInProgress = false;
                                        UploadingService.this.getClient(UploadingService.this.fileuploadModel.getChannelId(), jsonObject);
                                    }
                                });
                            }
                        }
                    }

                    @Override
                    public void failure(APIError error) {
                        Logger.INSTANCE.apiFailed("/api/conversation/uploadFile", error.getMessage());
                        Log.e(TAG, "In uploading failure");
                        UploadingService.this.handleException();
                    }
                });
            } else {
                Log.e(TAG, "In uploading else");
                this.handleException();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e(TAG, "In uploading else 2");
            this.handleException();
        }
    }

    private void handleException() {
        Log.e(TAG, "In handleException failure");
        try {
            String data = Prefs.with((Context)this).getString("pref_upload_data", "");
            Log.e(TAG, "In response else case " + data);
            this.fileuploadModels = (ArrayList)new Gson().fromJson(data, this.fileuploadType);
            if (this.fileuploadModels == null || this.fileuploadModels.size() == 0) {
                Prefs.with((Context)this).removeAll();
                this.stopFayeClient();
                this.stopForeground(true);
                this.stopSelf();
                return;
            }
            this.fileuploadModel = this.fileuploadModels.get(0);
            this.apiInProgress = false;
            if (this.isOpenedChatActivityMsg(this.fileuploadModel.getChannelId())) {
                this.setMessageExpired();
                Intent mIntent = new Intent("HIPPO_FILE_UPLOAD");
                mIntent.putExtra("broadcast_status", 1);
                mIntent.putExtra("channelId", this.fileuploadModel.getChannelId());
                mIntent.putExtra("muid", this.fileuploadModel.getMuid());
                mIntent.putExtra("messageIndex", this.fileuploadModel.getMessageIndex());
                mIntent.putExtra("fileuploadModel", new Gson().toJson((Object)this.fileuploadModel));
                LocalBroadcastManager.getInstance((Context)HippoApplication.getInstance().getApplicationContext()).sendBroadcast(mIntent);
            } else {
                this.uploadingFailed(this.fileuploadModel.getChannelId());
                this.setMessageExpired();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Prefs.with((Context)this).removeAll();
            this.stopFayeClient();
            this.stopForeground(true);
            this.stopSelf();
        }
    }

    public String getMimeType(String url) {
        String type = null;
        String extension = MimeTypeMap.getFileExtensionFromUrl((String)url);
        if (extension != null) {
            type = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        return type;
    }

    private void updatePref() {
        Log.e(TAG, "updatePref: " + Prefs.with((Context)this).getString("pref_upload_data", ""));
        this.fileuploadModels = (ArrayList)new Gson().fromJson(Prefs.with((Context)this).getString("pref_upload_data", ""), this.fileuploadType);
        if (this.fileuploadModels == null || this.fileuploadModels.size() == 0) {
            Prefs.with((Context)this).removeAll();
            this.stopFayeClient();
            this.stopForeground(true);
            this.stopSelf();
        } else {
            this.fileuploadModels.remove(0);
            String data = new Gson().toJson(this.fileuploadModels, this.fileuploadType);
            Prefs.with((Context)this).save("pref_upload_data", data);
            Log.e(TAG, "int updatePref set data : " + data);
            if (this.fileuploadModels.size() == 0) {
                Prefs.with((Context)this).removeAll();
                this.stopFayeClient();
                this.stopForeground(true);
                this.stopSelf();
            } else {
                this.apiInProgress = false;
                this.uploadFileServerCall();
            }
        }
    }

    @Override
    public void onProgressUpdate(int percentage, int mMessageIndex, String muid) {
        if (this.isFirstTime && percentage == 10) {
            this.isFirstTime = false;
            return;
        }
        if (!this.isFirstTime && percentage == 10) {
            this.isFirstTime = true;
        }
        if (this.isFirstTime) {
            this.updateProgress(percentage, 100);
        }
    }

    @Override
    public void onError(int percentage, int mMessageIndex, String muid) {
        Log.e(TAG, "In onError else 2");
    }

    @Override
    public void onFinish(int percentage, int mMessageIndex, String muid) {
        Log.e(TAG, "In onFinish else 2");
    }

    public void getClient() {
        if (this.mClient == null) {
            FuguAgentMetaMessage meta = new FuguAgentMetaMessage();
            JSONObject jsonExt = new JSONObject();
            try {
                if (HippoApplication.getInstance().getUserData() != null) {
                    jsonExt.put("user_id", (Object)HippoApplication.getInstance().getUserData().getUserId());
                    jsonExt.put("device_type", 1);
                    jsonExt.put("source", 1);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            meta.setAllExt(jsonExt.toString());
            this.mClient = new FuguAgentFayeClient(Config.getFayeServerUrl() + "faye", meta);
            this.mClient.connectServer();
        }
    }

    private void getClient(int channelId, JSONObject messageJson) {
        try {
            Log.e(TAG, "In getClient");
            if (this.mClient == null) {
                FuguAgentMetaMessage meta = new FuguAgentMetaMessage();
                JSONObject jsonExt = new JSONObject();
                try {
                    if (HippoApplication.getInstance().getUserData() != null) {
                        jsonExt.put("user_id", (Object)HippoApplication.getInstance().getUserData().getUserId());
                        jsonExt.put("device_type", 1);
                        jsonExt.put("source", 1);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                meta.setAllExt(jsonExt.toString());
                this.mClient = new FuguAgentFayeClient(Config.getFayeServerUrl() + "faye", meta);
                this.mClient.connectServer();
                Log.e(TAG, "In mClient null");
            }
            if (this.mClient == null) {
                Log.e(TAG, "In mClient null return");
                return;
            }
            this.afterSetUpFayeConnection(channelId, messageJson);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void afterSetUpFayeConnection(int channelId, JSONObject messageJson) {
        this.mClient.setServiceListener(this);
        if (!this.mClient.isConnectedServer() && this.isNetworkAvailable()) {
            this.mClient.connectServer();
            this.mClient.publish("/" + String.valueOf(channelId), messageJson);
            this.updatePref();
            Log.e(TAG, "************isConnectedServer*********");
        } else if (this.mClient.isConnectedServer()) {
            Log.e(TAG, "************publish*********");
            this.mClient.publish("/" + String.valueOf(channelId), messageJson);
            this.updatePref();
        } else if (!this.isNetworkAvailable()) {
            Log.e(TAG, "************isNetworkAvailable*********");
            Intent mIntent = new Intent("HIPPO_FILE_UPLOAD");
            mIntent.putExtra("broadcast_status", 0);
            LocalBroadcastManager.getInstance((Context)HippoApplication.getInstance().getApplicationContext()).sendBroadcast(mIntent);
            this.updatePref();
        }
    }

    @Override
    public void onConnectedServer(FuguAgentFayeClient fc) {
        Log.e(TAG, "************onConnectedServer*********");
        ArrayList fileuploadModels = (ArrayList)new Gson().fromJson(Prefs.with((Context)this).getString("pref_upload_data", ""), this.fileuploadType);
        for (FileuploadModel fileuploadModel : fileuploadModels) {
            if (!fileuploadModel.isFileUploaded()) continue;
            if (this.mClient.hasSubscribed("/" + String.valueOf(fileuploadModel.getChannelId()))) {
                this.mClient.subscribeChannel("/" + String.valueOf(fileuploadModel.getChannelId()));
            }
            this.mClient.publish("/" + String.valueOf(fileuploadModel.getChannelId()), fileuploadModel.getMessageObject());
            break;
        }
    }

    @Override
    public void onDisconnectedServer(FuguAgentFayeClient fc) {
    }

    @Override
    public void onReceivedMessage(FuguAgentFayeClient fc, String msg, String channel) {
        try {
            JSONObject messageJson = new JSONObject(msg);
            if (messageJson.optInt("message_type", 0) == 10 || messageJson.optInt("message_type", 0) == 11) {
                int value = messageJson.optInt("channel_id");
                if (!this.isOpenedChatActivityMsg(value)) {
                    this.updateLocalMessageObj(value, true, "", "", null, null);
                }
                this.updatePref();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onPongReceived() {
    }

    @Override
    public void onWebSocketError() {
    }

    @Override
    public void onErrorReceived(FuguAgentFayeClient fc, String msg, String channel) {
    }

    private boolean isOpenedChatActivityMsg(int channelId) {
        ActivityManager mngr = (ActivityManager)this.getSystemService("activity");
        List taskList = mngr.getRunningTasks(10);
        return ((ActivityManager.RunningTaskInfo)taskList.get((int)0)).topActivity.getClassName().equals("com.hippoagent.activities.FuguChatActivity") && FuguChatActivity.currentChannelId == channelId;
    }

    private void uploadingFailed(int channelId) {
        String data = Prefs.with((Context)this).getString("pref_upload_data", "empty");
        if (data.equals("empty")) {
            this.apiInProgress = false;
            Log.v(TAG, "data = " + data);
            return;
        }
        ArrayList fileuploadModels = (ArrayList)new Gson().fromJson(data, this.fileuploadType);
        int index = fileuploadModels.indexOf(new FileuploadModel(channelId));
        if (index == -1) {
            return;
        }
        FileuploadModel fileuploadModel = (FileuploadModel)fileuploadModels.get(index);
        LinkedHashMap<String, Message> unsentMessages = CommonData.getUnsentMessageByChannel(channelId);
        LinkedHashMap<String, JSONObject> unsentMessageMapNew = CommonData.getUnsentMessageMapByChannel(channelId);
        Message listItem = unsentMessages.get(fileuploadModel.getMuid());
        if (listItem == null) {
            return;
        }
        Message message = listItem;
        message.setUploadStatus(0);
        message.setMessageStatus(6);
        message.setIsMessageExpired(1);
        message.setLocalImagePath(fileuploadModel.getFilePath());
        unsentMessages.put(fileuploadModel.getMuid(), message);
        CommonData.setUnsentMessageByChannel(channelId, unsentMessages);
    }

    private void updateLocalMessageObj(int channelId, boolean isPublished, String url, String thumbnailUrl, JSONObject jsonObject, UpdateLocalMsgListener msgListener) {
        String data = Prefs.with((Context)this).getString("pref_upload_data", "empty");
        Log.v(TAG, "data = " + data);
        if (data.equals("empty")) {
            this.apiInProgress = false;
            this.updatePref();
            return;
        }
        ArrayList fileuploadModels = (ArrayList)new Gson().fromJson(data, this.fileuploadType);
        int index = fileuploadModels.indexOf(new FileuploadModel(channelId));
        if (index == -1) {
            this.updatePref();
            return;
        }
        FileuploadModel fileuploadModel = (FileuploadModel)fileuploadModels.get(index);
        LinkedHashMap<String, Message> sentMessages = CommonData.getSentMessageByChannel(channelId);
        LinkedHashMap<String, Message> unsentMessages = CommonData.getUnsentMessageByChannel(channelId);
        LinkedHashMap<String, JSONObject> unsentMessageMapNew = CommonData.getUnsentMessageMapByChannel(channelId);
        Message listItem = unsentMessages.get(fileuploadModel.getMuid());
        Log.v(TAG, "listItem data = " + new Gson().toJson((Object)listItem));
        if (listItem == null) {
            this.updatePref();
            return;
        }
        if (isPublished) {
            listItem.setMessageStatus(1);
            ArrayList<String> reverseOrderedKeys = new ArrayList<String>(sentMessages.keySet());
            Collections.reverse(reverseOrderedKeys);
            String tempSentAtUTC = "";
            for (String key : reverseOrderedKeys) {
                if (!sentMessages.get(key).isDateView()) continue;
                tempSentAtUTC = key;
                break;
            }
            String time = listItem.getSentAtUtc();
            String localDate = DateUtils.getInstance().convertToLocal(time, this.inputFormat, this.outputFormat);
            if (!tempSentAtUTC.equalsIgnoreCase(localDate)) {
                sentMessages.put(localDate, new Message(localDate, true));
            }
            sentMessages.put(fileuploadModel.getMuid(), listItem);
            unsentMessages.remove(fileuploadModel.getMuid());
            unsentMessageMapNew.remove(fileuploadModel.getMuid());
            CommonData.setSentMessageByChannel(channelId, sentMessages);
        } else {
            Message message = listItem;
            message.setFileUrl(url);
            message.setUrl(url);
            message.setThumbnailUrl(thumbnailUrl);
            message.setUploadStatus(3);
            unsentMessages.put(fileuploadModel.getMuid(), message);
            JSONObject object = null;
            try {
                object = unsentMessageMapNew.get(fileuploadModel.getMuid());
                object.put("image_url", (Object)url);
                object.put("thumbnail_url", (Object)thumbnailUrl);
                object.put("url", (Object)url);
                unsentMessageMapNew.put(fileuploadModel.getMuid(), object);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        CommonData.setUnsentMessageByChannel(channelId, unsentMessages);
        CommonData.setUnsentMessageMapByChannel(channelId, unsentMessageMapNew);
        Log.v(TAG, "unsentMessageMapNew data = " + new Gson().toJson(unsentMessageMapNew));
        if (msgListener != null) {
            msgListener.onUpdation(jsonObject);
        }
    }

    private void setAllMessageExpired() {
        this.fileuploadModels = (ArrayList)new Gson().fromJson(Prefs.with((Context)this).getString("pref_upload_data", ""), this.fileuploadType);
        if (this.fileuploadModels == null || this.fileuploadModels.size() == 0) {
            Prefs.with((Context)this).remove("pref_upload_data");
            this.stopFayeClient();
            this.stopForeground(true);
            this.stopSelf();
            return;
        }
        for (FileuploadModel fileuploadModel : this.fileuploadModels) {
            if (this.isOpenedChatActivityMsg(fileuploadModel.getChannelId())) {
                this.sendLocalBroadcast(fileuploadModel);
                continue;
            }
            this.updateLocalMessages(this.fileuploadModels.get(0));
        }
        this.fileuploadModels.clear();
        Prefs.with((Context)this).remove("pref_upload_data");
        this.stopFayeClient();
        this.stopForeground(true);
        this.stopSelf();
    }

    private void setMessageExpired() {
        String data = Prefs.with((Context)this).getString("pref_upload_data", "");
        Log.e(TAG, "In setMessageExpired: " + data);
        this.fileuploadModels = (ArrayList)new Gson().fromJson(data, this.fileuploadType);
        if (this.fileuploadModels == null || this.fileuploadModels.size() == 0) {
            Prefs.with((Context)this).removeAll();
            this.stopFayeClient();
            this.stopForeground(true);
            this.stopSelf();
        } else {
            if (this.isOpenedChatActivityMsg(this.fileuploadModels.get(0).getChannelId())) {
                this.sendLocalBroadcast(this.fileuploadModels.get(0));
            } else {
                this.updateLocalMessages(this.fileuploadModels.get(0));
            }
            this.fileuploadModels.remove(0);
            data = new Gson().toJson(this.fileuploadModels, this.fileuploadType);
            Log.e(TAG, "In setMessageExpired after update: " + data);
            Prefs.with((Context)this).save("pref_upload_data", data);
            this.uploadFileServerCall();
        }
    }

    private void sendLocalBroadcast(FileuploadModel fileuploadModel) {
        Intent mIntent = new Intent("HIPPO_FILE_UPLOAD");
        mIntent.putExtra("muid", fileuploadModel.getMuid());
        mIntent.putExtra("messageIndex", fileuploadModel.getMessageIndex());
        mIntent.putExtra("broadcast_status", 3);
        LocalBroadcastManager.getInstance((Context)HippoApplication.getInstance().getApplicationContext()).sendBroadcast(mIntent);
    }

    private void updateLocalMessages(FileuploadModel fileuploadModel) {
        String muid = fileuploadModel.getMuid();
        LinkedHashMap<String, Message> unsentMessages = CommonData.getUnsentMessageByChannel(fileuploadModel.getChannelId());
        LinkedHashMap<String, JSONObject> unsentMessageMapNew = CommonData.getUnsentMessageMapByChannel(fileuploadModel.getChannelId());
        if (unsentMessages == null) {
            unsentMessages = new LinkedHashMap();
        }
        Message listItem = unsentMessages.get(muid);
        listItem.setIsMessageExpired(1);
        try {
            JSONObject messageJson = unsentMessageMapNew.get(muid);
            messageJson.put("is_message_expired", 1);
            unsentMessageMapNew.put(muid, messageJson);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CommonData.setUnsentMessageByChannel(fileuploadModel.getChannelId(), unsentMessages);
        CommonData.setUnsentMessageMapByChannel(fileuploadModel.getChannelId(), unsentMessageMapNew);
    }

    public static interface UpdateLocalMsgListener {
        public void onUpdation(JSONObject var1);
    }
}

