/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Environment;
import android.os.SystemClock;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.util.Patterns;
import android.widget.TextView;
import android.widget.Toast;
import androidx.core.content.ContextCompat;
import com.google.android.gms.common.GoogleApiAvailability;
import com.hippoagent.HippoConfig;
import com.hippoagent.R;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.langs.Restring;
import java.io.File;

public class Utils
implements FuguAppConstant {
    private static final int MULTIPLE_CLICK_THRESHOLD = 2000;
    private static long mLastClickTime = 0L;
    private static final String AppName = HippoConfig.getInstance().getAttributes().getAppName();
    private static final int NOT_FOUND = -1;
    public static final char EXTENSION_SEPARATOR = '.';
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static int REQ_CODE_PLAY_SERVICES_RESOLUTION = 16061;

    public static final boolean isValidEmail(CharSequence target) {
        if (target == null) {
            return false;
        }
        return Patterns.EMAIL_ADDRESS.matcher(target).matches();
    }

    public static final boolean isValidPhoneNumber(String phoneNo) {
        if (!TextUtils.isEmpty((CharSequence)phoneNo) && phoneNo.length() > 7 && phoneNo.length() < 14 && Utils.checkIfOnlyDigits(phoneNo)) {
            return Utils.isPhoneValid(phoneNo);
        }
        return false;
    }

    private static boolean checkIfOnlyDigits(String strTocheck) {
        return strTocheck.matches("[0-9+]+");
    }

    private static boolean isPhoneValid(CharSequence phone) {
        return Patterns.PHONE.matcher(phone).matches();
    }

    public static String assign(String assignable, String alternative) {
        return assignable == null ? (alternative == null ? "" : alternative) : (assignable.equals("null") ? Utils.assign(alternative) : assignable);
    }

    public static String assign(String assignable) {
        return assignable == null || assignable.equalsIgnoreCase("[]") ? "" : assignable;
    }

    public static void redirectUserToUrl(Activity activity, String webUrl) {
        if (webUrl == null) {
            return;
        }
        if (webUrl.isEmpty()) {
            return;
        }
        boolean isRecognizable = webUrl.startsWith("http://") || webUrl.startsWith("https://");
        webUrl = (isRecognizable ? "" : "http://") + webUrl;
        try {
            Intent openWebUrl = new Intent("android.intent.action.VIEW");
            openWebUrl.setData(Uri.parse((String)webUrl));
            activity.startActivity(openWebUrl);
        }
        catch (ActivityNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static boolean preventMultipleClicks() {
        if (SystemClock.elapsedRealtime() - mLastClickTime < 2000L) {
            return false;
        }
        mLastClickTime = SystemClock.elapsedRealtime();
        return true;
    }

    public static String getDirectoryPath(String folder) {
        return Environment.getExternalStorageDirectory() + File.separator + AppName + File.separator + folder;
    }

    public static String getExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int index = Utils.indexOfExtension(filename);
        if (index == -1) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public static int indexOfExtension(String filename) {
        if (filename == null) {
            return -1;
        }
        int extensionPos = filename.lastIndexOf(46);
        int lastSeparator = Utils.indexOfLastSeparator(filename);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    public static int indexOfLastSeparator(String filename) {
        if (filename == null) {
            return -1;
        }
        int lastUnixPos = filename.lastIndexOf(47);
        int lastWindowsPos = filename.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1024 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.2f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String humanReadableSize(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1024 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.0f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String getOrCreateDirectoryPath(String folderName) {
        String path = Environment.getExternalStorageDirectory() + File.separator + AppName + File.separator + folderName;
        File folder = new File(path);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return path;
    }

    public static String setImageFullPath(String fileName) {
        String destinationDirectoryPath = Utils.getOrCreateDirectoryPath((String)FOLDER_TYPE.get(FuguAppConstant.DocumentType.IMAGE.type));
        return destinationDirectoryPath + File.separator + fileName;
    }

    public static String getFileName(String filename, String muid) {
        if (!filename.contains(muid)) {
            String ext = Utils.getExtension(filename);
            String name = Utils.extractFileNameWithoutSuffix(filename);
            filename = name + "_" + muid + "." + ext;
        }
        return filename;
    }

    public static String extractFileNameWithoutSuffix(String url) {
        try {
            return url.substring(url.lastIndexOf("/") + 1, url.lastIndexOf("."));
        }
        catch (StringIndexOutOfBoundsException e) {
            try {
                return url.substring(url.lastIndexOf("/") + 1);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                e.printStackTrace();
                return "";
            }
        }
    }

    public static String getMuid(String name) {
        try {
            return name.substring(name.lastIndexOf("_") + 1, name.lastIndexOf("."));
        }
        catch (StringIndexOutOfBoundsException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String extractFileNameWithSuffix(String url) {
        return url.substring(url.lastIndexOf("/") + 1);
    }

    public static void setColor(Context context, TextView view, String text) {
        String subtext = "First Name";
        String fulltext = text.replace("{{{full_name}}}", subtext);
        view.setText((CharSequence)fulltext, TextView.BufferType.SPANNABLE);
        Spannable str = (Spannable)view.getText();
        int i = fulltext.indexOf(subtext);
        if (i < 0) {
            return;
        }
        str.setSpan((Object)new ForegroundColorSpan(ContextCompat.getColor((Context)context, (int)R.color.colorPrimary)), i, i + subtext.length(), 33);
        str.setSpan((Object)new RelativeSizeSpan(1.1f), i, i + subtext.length(), 33);
    }

    public static int dp2px(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    public static boolean checkPlayServices(Context context) {
        GoogleApiAvailability apiAvailability = GoogleApiAvailability.getInstance();
        int resultCode = apiAvailability.isGooglePlayServicesAvailable(context);
        if (resultCode != 0) {
            if (apiAvailability.isUserResolvableError(resultCode)) {
                apiAvailability.getErrorDialog((Activity)context, resultCode, REQ_CODE_PLAY_SERVICES_RESOLUTION).show();
            } else {
                Toast.makeText((Context)context, (CharSequence)Restring.getString(context, R.string.error_device_not_supported), (int)0).show();
            }
            return false;
        }
        return true;
    }

    public static AudioManager getAudioManager(Context context) {
        return (AudioManager)context.getSystemService("audio");
    }
}

