/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils;

import android.content.Context;
import android.util.Log;
import android.view.View;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

public class LinearLayoutManagerForResizableRecyclerView
extends LinearLayoutManager {
    private static final int CHILD_WIDTH = 0;
    private static final int CHILD_HEIGHT = 1;
    private static final int DEFAULT_CHILD_SIZE = 100;
    private final int[] childDimensions = new int[2];
    private int childSize = 100;
    private boolean hasChildSize;

    public LinearLayoutManagerForResizableRecyclerView(Context context) {
        super(context);
    }

    public LinearLayoutManagerForResizableRecyclerView(Context context, int orientation, boolean reverseLayout) {
        super(context, orientation, reverseLayout);
    }

    public static int makeUnspecifiedSpec() {
        return View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
    }

    public void onMeasure(RecyclerView.Recycler recycler, RecyclerView.State state, int widthSpec, int heightSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightSpec);
        boolean exactWidth = widthMode == 0x40000000;
        boolean exactHeight = heightMode == 0x40000000;
        int unspecified = LinearLayoutManagerForResizableRecyclerView.makeUnspecifiedSpec();
        if (exactWidth && exactHeight) {
            super.onMeasure(recycler, state, widthSpec, heightSpec);
            return;
        }
        boolean vertical = this.getOrientation() == 1;
        this.initChildDimensions(widthSize, heightSize, vertical);
        int width = 0;
        int height = 0;
        recycler.clear();
        int stateItemCount = state.getItemCount();
        int adapterItemCount = this.getItemCount();
        for (int i = 0; i < adapterItemCount; ++i) {
            if (vertical) {
                if (!this.hasChildSize) {
                    if (i < stateItemCount) {
                        this.measureChild(recycler, i, widthSpec, unspecified, this.childDimensions);
                    } else {
                        this.logMeasureWarning(i);
                    }
                }
                height += this.childDimensions[1];
                if (i == 0) {
                    width = this.childDimensions[0];
                }
                if (height < heightSize) continue;
                break;
            }
            if (!this.hasChildSize) {
                if (i < stateItemCount) {
                    this.measureChild(recycler, i, unspecified, heightSpec, this.childDimensions);
                } else {
                    this.logMeasureWarning(i);
                }
            }
            width += this.childDimensions[0];
            if (i == 0) {
                height = this.childDimensions[1];
            }
            if (width >= widthSize) break;
        }
        if (vertical && height < heightSize || !vertical && width < widthSize) {
            width = exactWidth ? widthSize : (width += this.getPaddingLeft() + this.getPaddingRight());
            height = exactHeight ? heightSize : (height += this.getPaddingTop() + this.getPaddingBottom());
            this.setMeasuredDimension(width, height);
        } else {
            super.onMeasure(recycler, state, widthSpec, heightSpec);
        }
    }

    private void logMeasureWarning(int child) {
        Log.w((String)"LinearLayoutManager", (String)("Can't measure child #" + child + ", previously used dimensions will be reused.To remove this message either use #setChildSize() method or don't run RecyclerView animations"));
    }

    private void initChildDimensions(int width, int height, boolean vertical) {
        if (this.childDimensions[0] != 0 || this.childDimensions[1] != 0) {
            return;
        }
        if (vertical) {
            this.childDimensions[0] = width;
            this.childDimensions[1] = this.childSize;
        } else {
            this.childDimensions[0] = this.childSize;
            this.childDimensions[1] = height;
        }
    }

    public void setOrientation(int orientation) {
        if (this.childDimensions != null && this.getOrientation() != orientation) {
            this.childDimensions[0] = 0;
            this.childDimensions[1] = 0;
        }
        super.setOrientation(orientation);
    }

    public void clearChildSize() {
        this.hasChildSize = false;
        this.setChildSize(100);
    }

    public void setChildSize(int childSize) {
        this.hasChildSize = true;
        if (this.childSize != childSize) {
            this.childSize = childSize;
            this.requestLayout();
        }
    }

    private void measureChild(RecyclerView.Recycler recycler, int position, int widthSpec, int heightSpec, int[] dimensions) {
        View child = recycler.getViewForPosition(position);
        RecyclerView.LayoutParams p = (RecyclerView.LayoutParams)child.getLayoutParams();
        int hPadding = this.getPaddingLeft() + this.getPaddingRight();
        int vPadding = this.getPaddingTop() + this.getPaddingBottom();
        int hMargin = p.leftMargin + p.rightMargin;
        int vMargin = p.topMargin + p.bottomMargin;
        int hDecoration = this.getRightDecorationWidth(child) + this.getLeftDecorationWidth(child);
        int vDecoration = this.getTopDecorationHeight(child) + this.getBottomDecorationHeight(child);
        int childWidthSpec = LinearLayoutManagerForResizableRecyclerView.getChildMeasureSpec((int)widthSpec, (int)(hPadding + hMargin + hDecoration), (int)p.width, (boolean)this.canScrollHorizontally());
        int childHeightSpec = LinearLayoutManagerForResizableRecyclerView.getChildMeasureSpec((int)heightSpec, (int)(vPadding + vMargin + vDecoration), (int)p.height, (boolean)this.canScrollVertically());
        child.measure(childWidthSpec, childHeightSpec);
        dimensions[0] = this.getDecoratedMeasuredWidth(child) + p.leftMargin + p.rightMargin;
        dimensions[1] = this.getDecoratedMeasuredHeight(child) + p.bottomMargin + p.topMargin;
        recycler.recycleView(child);
    }
}

