/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.utils;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.hippoagent.R;

public class GridDividerItemDecoration
extends RecyclerView.ItemDecoration {
    private Drawable mDivider;
    private int mInsets;

    public GridDividerItemDecoration(Context context) {
        this.mDivider = ContextCompat.getDrawable((Context)context, (int)R.drawable.fugu_grid_divider);
        this.mInsets = context.getResources().getDimensionPixelSize(R.dimen.fugu_card_inset);
    }

    public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
        this.drawVertical(c, parent);
        this.drawHorizontal(c, parent);
    }

    private void drawVertical(Canvas c, RecyclerView parent) {
        if (parent.getChildCount() == 0) {
            return;
        }
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            int left = child.getLeft() - params.leftMargin - this.mInsets;
            int right = child.getRight() + params.rightMargin + this.mInsets;
            int top = child.getBottom() + params.bottomMargin + this.mInsets;
            int bottom = top + this.mDivider.getIntrinsicHeight();
            this.mDivider.setBounds(left, top, right, bottom);
            this.mDivider.draw(c);
        }
    }

    private void drawHorizontal(Canvas c, RecyclerView parent) {
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            int left = child.getRight() + params.rightMargin + this.mInsets;
            int right = left + this.mDivider.getIntrinsicWidth();
            int top = child.getTop() - params.topMargin - this.mInsets;
            int bottom = child.getBottom() + params.bottomMargin + this.mInsets;
            this.mDivider.setBounds(left, top, right, bottom);
            this.mDivider.draw(c);
        }
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        outRect.set(this.mInsets, this.mInsets, this.mInsets, this.mInsets);
    }
}

