/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.mentions;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import com.hippoagent.mentions.MentionCheckerLogic;
import com.hippoagent.mentions.MentionInsertionLogic;
import com.hippoagent.mentions.Mentionable;
import com.hippoagent.mentions.QueryListener;
import com.hippoagent.mentions.SuggestionsListener;
import java.util.ArrayList;
import java.util.List;

public class Mentions {
    protected final Context context;
    protected final EditText editText;
    protected QueryListener queryListener;
    protected SuggestionsListener suggestionsListener;
    protected final MentionCheckerLogic mentionCheckerLogic;
    protected final MentionInsertionLogic mentionInsertionLogic;

    private Mentions(Context context, EditText editText) {
        this.context = context;
        this.editText = editText;
        this.mentionCheckerLogic = new MentionCheckerLogic(editText);
        this.mentionInsertionLogic = new MentionInsertionLogic(editText);
    }

    public void addMentions(List<? extends Mentionable> mentionables) {
        this.mentionInsertionLogic.addMentions(mentionables);
    }

    public List<Mentionable> getInsertedMentions() {
        return new ArrayList<Mentionable>(this.mentionInsertionLogic.getMentions());
    }

    private void hookupOnClickListener() {
        this.editText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (Mentions.this.mentionCheckerLogic.currentWordStartsWithAtSign()) {
                    String query = Mentions.this.mentionCheckerLogic.doMentionCheck();
                    Mentions.this.queryReceived(query);
                } else {
                    Mentions.this.suggestionsListener.displaySuggestions(false);
                }
            }
        });
    }

    private void hookupInternalTextWatcher() {
        this.editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int start, int count, int after) {
                Mentions.this.mentionInsertionLogic.checkIfProgrammaticallyClearedEditText(charSequence, start, count, after);
            }

            public void onTextChanged(CharSequence charSequence, int start, int before, int count) {
                Mentions.this.mentionInsertionLogic.updateInternalMentionsArray(start, before, count);
            }

            public void afterTextChanged(Editable s) {
                String query = Mentions.this.mentionCheckerLogic.doMentionCheck();
                Mentions.this.queryReceived(query);
            }
        });
    }

    public void insertMention(Mentionable mentionable) {
        this.mentionInsertionLogic.insertMention(mentionable);
        this.suggestionsListener.displaySuggestions(false);
    }

    public void queryReceived(String query) {
        if (this.queryListener != null && query != null) {
            this.queryListener.onQueryReceived(query);
        } else {
            this.suggestionsListener.displaySuggestions(false);
        }
    }

    public static class Builder {
        private final Mentions mentionsLib;

        public Builder(Context context, EditText editText) {
            if (context == null) {
                throw new IllegalArgumentException("Context must not be null.");
            }
            if (editText == null) {
                throw new IllegalArgumentException("EditText must not be null.");
            }
            this.mentionsLib = new Mentions(context, editText);
        }

        public Builder addMentions(List<? extends Mentionable> mentions) {
            this.mentionsLib.mentionInsertionLogic.addMentions(mentions);
            return this;
        }

        public Builder highlightColor(int color2) {
            this.mentionsLib.mentionInsertionLogic.setTextHighlightColor(color2);
            return this;
        }

        public Builder maxCharacters(int maxCharacters) {
            this.mentionsLib.mentionCheckerLogic.setMaxCharacters(maxCharacters);
            return this;
        }

        public Builder queryListener(QueryListener queryListener) {
            this.mentionsLib.queryListener = queryListener;
            return this;
        }

        public Builder suggestionsListener(SuggestionsListener suggestionsListener) {
            this.mentionsLib.suggestionsListener = suggestionsListener;
            return this;
        }

        public Mentions build() {
            this.mentionsLib.hookupInternalTextWatcher();
            this.mentionsLib.hookupOnClickListener();
            return this.mentionsLib;
        }
    }
}

