/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.hippocall;

import android.content.Context;
import android.util.Log;
import org.webrtc.DataChannel;
import org.webrtc.IceCandidate;
import org.webrtc.MediaStream;
import org.webrtc.PeerConnection;
import org.webrtc.RtpReceiver;

class CustomPeerConnectionObserver
implements PeerConnection.Observer {
    private Context videoCallActivity;
    private String logTag = "CustomPeerConnectionObserver";

    CustomPeerConnectionObserver(String logTag, Context videoCallActivity) {
        this.logTag = this.logTag + " " + logTag;
        this.videoCallActivity = videoCallActivity;
    }

    public void onSignalingChange(PeerConnection.SignalingState signalingState) {
        Log.d((String)this.logTag, (String)("onSignalingChange() called with: signalingState = [" + signalingState + "]"));
    }

    public void onIceConnectionChange(PeerConnection.IceConnectionState iceConnectionState) {
        Log.d((String)this.logTag, (String)("onIceConnectionChange() called with: iceConnectionState = [" + iceConnectionState + "]"));
    }

    public void onIceConnectionReceivingChange(boolean b) {
        Log.d((String)this.logTag, (String)("onIceConnectionReceivingChange() called with: b = [" + b + "]"));
    }

    public void onIceGatheringChange(PeerConnection.IceGatheringState iceGatheringState) {
        Log.d((String)this.logTag, (String)("onIceGatheringChange() called with: iceGatheringState = [" + iceGatheringState + "]"));
    }

    public void onIceCandidate(IceCandidate iceCandidate) {
        Log.d((String)this.logTag, (String)("onIceCandidate() called with: iceCandidate = [" + iceCandidate + "]"));
    }

    public void onIceCandidatesRemoved(IceCandidate[] iceCandidates) {
        Log.d((String)this.logTag, (String)("onIceCandidatesRemoved() called with: iceCandidates = [" + iceCandidates + "]"));
    }

    public void onAddStream(MediaStream mediaStream) {
        Log.d((String)this.logTag, (String)("onAddStream() called with: mediaStream = [" + mediaStream + "]"));
    }

    public void onRemoveStream(MediaStream mediaStream) {
        Log.d((String)this.logTag, (String)("onRemoveStream() called with: mediaStream = [" + mediaStream + "]"));
    }

    public void onDataChannel(DataChannel dataChannel) {
        Log.d((String)this.logTag, (String)("onDataChannel() called with: dataChannel = [" + dataChannel + "]"));
    }

    public void onRenegotiationNeeded() {
        Log.d((String)this.logTag, (String)"onRenegotiationNeeded() called");
    }

    public void onAddTrack(RtpReceiver rtpReceiver, MediaStream[] mediaStreams) {
    }
}

