/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.fragments;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.RecyclerView;
import com.hippoagent.R;
import com.hippoagent.activities.FilterActivity;
import com.hippoagent.adapters.LabelsAdapter;
import com.hippoagent.databinding.FragmentPeopleBinding;
import com.hippoagent.langs.Restring;
import com.hippoagent.model.Filter;
import com.hippoagent.utils.SearchViewNetworkQueryHelper;
import java.util.ArrayList;

public class LablesFragment
extends Fragment
implements SearchViewNetworkQueryHelper.SearchCallbacks {
    private static final String TAG = LablesFragment.class.getSimpleName();
    private SearchViewNetworkQueryHelper mSearchNetworkQueryHelper;
    private FragmentPeopleBinding fragmentBinding;
    private ArrayList<Filter> tagsArrayList = new ArrayList();
    private ArrayList<Filter> tempTagsArrayList = new ArrayList();
    private LabelsAdapter labelsAdapter;
    private FilterActivity activity;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.fragmentBinding = (FragmentPeopleBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.fragment_people, (ViewGroup)container, (boolean)false);
        View view = this.fragmentBinding.getRoot();
        this.tagsArrayList.addAll(this.activity.getFilterModel().getLabelsList());
        this.tempTagsArrayList.addAll(this.tagsArrayList);
        this.labelsAdapter = new LabelsAdapter(this.tagsArrayList);
        this.fragmentBinding.searchList.setAdapter((RecyclerView.Adapter)this.labelsAdapter);
        this.fragmentBinding.searchView.setHint((CharSequence)Restring.getString((Context)this.getActivity(), R.string.search_here));
        this.fragmentBinding.noDataFound.setText((CharSequence)Restring.getString((Context)this.getActivity(), R.string.no_data_found));
        return view;
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.mSearchNetworkQueryHelper = new SearchViewNetworkQueryHelper(this.fragmentBinding.searchView, this);
        this.mSearchNetworkQueryHelper.setSuggestCountThreshold(2);
        this.mSearchNetworkQueryHelper.setSuggestWaitThreshold(100);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.activity = (FilterActivity)this.getActivity();
    }

    @Override
    public void showLoader() {
    }

    @Override
    public void performQuery(String query) {
        this.tempTagsArrayList.clear();
        for (Filter filter : this.tagsArrayList) {
            if (!filter.getName().toLowerCase().contains(query.toLowerCase())) continue;
            this.tempTagsArrayList.add(filter);
        }
        this.labelsAdapter.setData(this.tempTagsArrayList);
        if (this.tempTagsArrayList.size() == 0) {
            this.fragmentBinding.noDataFound.setVisibility(0);
            this.fragmentBinding.searchList.setVisibility(8);
        } else {
            this.fragmentBinding.noDataFound.setVisibility(8);
            this.fragmentBinding.searchList.setVisibility(0);
        }
    }

    @Override
    public void showAllData() {
        this.labelsAdapter.setData(this.tagsArrayList);
        this.fragmentBinding.noDataFound.setVisibility(8);
        this.fragmentBinding.searchList.setVisibility(0);
    }
}

