/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.fragments;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import com.google.gson.Gson;
import com.hbb20.CountryCodePicker;
import com.hippoagent.HippoApplication;
import com.hippoagent.R;
import com.hippoagent.activities.HomeActivity;
import com.hippoagent.activities.ProfileActivityName;
import com.hippoagent.appData.UserOnBoard;
import com.hippoagent.model.EditProfileResponse;
import com.hippoagent.model.agent_profile_response.AgentProfileDetails;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.MultipartParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.ImageChooser;
import com.hippoagent.utils.LoadImageFile;
import com.hippoagent.utils.PhoneFunctions;
import com.hippoagent.utils.UniqueIMEIID;
import com.hippoagent.utils.ValidateClass;
import com.hippoagent.utils.filePicker.ImageUtils;
import com.hippoagent.utils.filelogger.Logger;
import com.kbeanie.multipicker.api.entity.ChosenImage;
import de.hdodenhof.circleimageview.CircleImageView;
import java.io.File;
import java.util.List;
import retrofit2.Callback;

public class EditProfileFragment
extends Fragment
implements View.OnClickListener,
ImageChooser.OnImageSelectListener {
    private CountryCodePicker countryCodePicker;
    private ImageUtils imageUtils;
    private RelativeLayout rlImage;
    private RelativeLayout rlParent;
    private CircleImageView ivAgentImage;
    private AgentProfileDetails agentProfileDetails;
    private EditText etAgentName;
    private EditText etAgentEmail;
    private EditText etPhone;
    private Button btnSaveInfo;
    private ImageChooser imageChooser;
    private File profileImgFile;
    private String imageFile;
    private int userOnBoardingValue = 0;
    private ProfileActivityName profileActivity;

    public static EditProfileFragment newInstance() {
        EditProfileFragment fragment = new EditProfileFragment();
        return fragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_edit_profile, container, false);
        this.profileActivity = (ProfileActivityName)this.getActivity();
        if (this.getArguments() != null && this.getArguments().getInt("user_onboard_value") != 0) {
            this.userOnBoardingValue = this.getArguments().getInt("user_onboard_value");
        }
        this.initView(view);
        if (this.userOnBoardingValue == 0) {
            this.getSetData();
        }
        return view;
    }

    private void initView(View view) {
        this.countryCodePicker = (CountryCodePicker)view.findViewById(R.id.ccp);
        this.rlImage = (RelativeLayout)view.findViewById(R.id.rlImage);
        this.rlParent = (RelativeLayout)view.findViewById(R.id.rlParent);
        this.rlImage.setOnClickListener((View.OnClickListener)this);
        this.ivAgentImage = (CircleImageView)view.findViewById(R.id.ivAgentImage);
        this.etAgentName = (EditText)view.findViewById(R.id.etAgentName);
        this.etAgentName.setOnClickListener((View.OnClickListener)this);
        this.etAgentEmail = (EditText)view.findViewById(R.id.etAgentEmail);
        this.etAgentEmail.setOnClickListener((View.OnClickListener)this);
        this.etPhone = (EditText)view.findViewById(R.id.etPhone);
        this.etPhone.setOnClickListener((View.OnClickListener)this);
        this.etAgentName.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 5) {
                    EditProfileFragment.this.etPhone.setFocusableInTouchMode(true);
                    EditProfileFragment.this.etPhone.setFocusable(true);
                    EditProfileFragment.this.etPhone.requestFocus();
                    EditProfileFragment.this.etPhone.setSelection(EditProfileFragment.this.etPhone.length());
                    return true;
                }
                return false;
            }
        });
        this.btnSaveInfo = (Button)view.findViewById(R.id.btnSaveInfo);
        this.btnSaveInfo.setOnClickListener((View.OnClickListener)this);
        if (UserOnBoard.get(this.userOnBoardingValue) == UserOnBoard.BOTH_NAME_PASSWORD) {
            this.btnSaveInfo.setText((CharSequence)this.getString(R.string.next));
        }
        this.imageChooser = new ImageChooser(this);
        this.countryCodePicker.setOnCountryChangeListener(new CountryCodePicker.OnCountryChangeListener(){

            public void onCountrySelected() {
                EditProfileFragment.this.countryCodePicker.setDefaultCountryUsingPhoneCode(Integer.parseInt(EditProfileFragment.this.countryCodePicker.getSelectedCountryCode()));
            }
        });
        this.etPhone.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 6) {
                    ValidateClass validateClass = new ValidateClass((Activity)EditProfileFragment.this.getActivity());
                    if (validateClass.genericEmpty(EditProfileFragment.this.etPhone, EditProfileFragment.this.getString(R.string.phone_empty_msg)) && validateClass.genericEmpty(EditProfileFragment.this.etAgentName, EditProfileFragment.this.getString(R.string.name_empty_msg))) {
                        EditProfileFragment.this.editAgentData();
                    }
                    return true;
                }
                return false;
            }
        });
    }

    private void getSetData() {
        this.agentProfileDetails = new AgentProfileDetails();
        this.agentProfileDetails = (AgentProfileDetails)this.getArguments().getParcelable("agentData");
        if (this.agentProfileDetails != null && this.agentProfileDetails.getData() != null) {
            String countryCode;
            this.etAgentName.setText((CharSequence)this.agentProfileDetails.getData().getFullName());
            this.etAgentEmail.setText((CharSequence)this.agentProfileDetails.getData().getEmail());
            LoadImageFile.getInstance().loadImage((Context)this.getActivity(), this.agentProfileDetails.getData().getUserImage(), (ImageView)this.ivAgentImage);
            this.imageFile = this.agentProfileDetails.getData().getUserImage();
            PhoneFunctions phoneFunctions = new PhoneFunctions();
            String phone = "";
            if (!TextUtils.isEmpty((CharSequence)this.agentProfileDetails.getData().getPhoneNumber()) && this.agentProfileDetails.getData().getPhoneNumber().substring(0, 1).equals("+")) {
                phone = this.agentProfileDetails.getData().getPhoneNumber().substring(1, this.agentProfileDetails.getData().getPhoneNumber().length());
            }
            if ((countryCode = phoneFunctions.getCountry(this.getResources().getStringArray(R.array.CountryCodes), phone)) != null && !countryCode.isEmpty()) {
                this.countryCodePicker.setCountryForPhoneCode(Integer.parseInt(countryCode));
            }
            if (!TextUtils.isEmpty((CharSequence)this.agentProfileDetails.getData().getPhoneNumber())) {
                this.etPhone.setText((CharSequence)this.agentProfileDetails.getData().getPhoneNumber().substring(countryCode.length() + 1));
            }
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.rlImage) {
            this.imageChooser.selectImage();
        } else if (id2 == R.id.btnSaveInfo) {
            this.getActivity().getWindow().getDecorView().clearFocus();
            ValidateClass validateClass = new ValidateClass((Activity)this.getActivity());
            if (this.userOnBoardingValue > 0) {
                if (validateClass.genericEmpty(this.etAgentName, this.getString(R.string.name_empty_msg))) {
                    this.editAgentData(true);
                }
            } else if (validateClass.genericEmpty(this.etPhone, this.getString(R.string.phone_empty_msg)) && validateClass.genericEmpty(this.etAgentName, this.getString(R.string.name_empty_msg))) {
                this.editAgentData();
            }
        } else if (id2 == R.id.etPhone || id2 == R.id.etAgentName) {
            // empty if block
        }
    }

    private void editAgentData() {
        try {
            if (!this.etAgentName.getText().toString().equals(this.agentProfileDetails.getData().getFullName()) || !this.agentProfileDetails.getData().getPhoneNumber().equals("+" + this.countryCodePicker.getSelectedCountryCode() + this.etPhone.getText().toString()) || this.profileImgFile != null) {
                this.editAgentData(true);
            }
        }
        catch (Exception e) {
            this.editAgentData(true);
        }
    }

    private void editAgentData(boolean flag) {
        if (this.profileActivity.isNetworkAvailable()) {
            MultipartParams multipartParams;
            MultipartParams.Builder multipartBuilder = new MultipartParams.Builder();
            if (this.profileImgFile != null) {
                this.imageFile = null;
                this.imageFile = this.profileImgFile.toString();
                multipartParams = multipartBuilder.addFile("file", new File(this.imageFile)).add("access_token", HippoApplication.getInstance().getUserData().getAccessToken()).add("en_user_id", String.valueOf(HippoApplication.getInstance().getUserData().getEnUserId())).add("agent_type", String.valueOf(HippoApplication.getInstance().getUserData().getAgentType())).add("business_id", String.valueOf(HippoApplication.getInstance().getUserData().getBusinessId())).add("full_name", this.etAgentName.getText().toString()).add("device_id", UniqueIMEIID.getUniqueIMEIId((Context)this.getActivity())).add("device_type", "1").add("phone_number", TextUtils.isEmpty((CharSequence)this.etPhone.getText().toString().trim()) ? "" : "+" + this.countryCodePicker.getSelectedCountryCode() + this.etPhone.getText().toString()).build();
            } else {
                multipartParams = multipartBuilder.add("access_token", HippoApplication.getInstance().getUserData().getAccessToken()).add("en_user_id", HippoApplication.getInstance().getUserData().getEnUserId()).add("agent_type", String.valueOf(HippoApplication.getInstance().getUserData().getAgentType())).add("business_id", String.valueOf(HippoApplication.getInstance().getUserData().getBusinessId())).add("full_name", this.etAgentName.getText().toString()).add("device_type", "1").add("device_id", UniqueIMEIID.getUniqueIMEIId((Context)this.getActivity())).add("phone_number", TextUtils.isEmpty((CharSequence)this.etPhone.getText().toString().trim()) ? "" : "+" + this.countryCodePicker.getSelectedCountryCode() + this.etPhone.getText().toString()).build();
            }
            String value = new Gson().toJson(multipartParams.getMap());
            Logger.INSTANCE.apiRequest("/api/agent/editInfo", value);
            RestClient.getApiInterface().editAgentInfo(multipartParams.getMap()).enqueue((Callback)new ResponseResolver<EditProfileResponse>((Activity)this.getActivity(), Boolean.valueOf(true), Boolean.valueOf(true)){

                @Override
                public void success(EditProfileResponse editProfileResponse) {
                    Logger.INSTANCE.apiResponse("/api/agent/editInfo", "");
                    Intent iRec = new Intent("com.fugu.agent.update");
                    iRec.putExtra("agent_name", EditProfileFragment.this.etAgentName.getText().toString());
                    iRec.putExtra("agent_pic", EditProfileFragment.this.imageFile);
                    EditProfileFragment.this.getActivity().sendBroadcast(iRec);
                    try {
                        HippoApplication.getInstance().getUserData().setFullName(EditProfileFragment.this.etAgentName.getText().toString());
                        HippoApplication.getInstance().getUserData().setPhoneNumber("+" + EditProfileFragment.this.countryCodePicker.getSelectedCountryCode() + EditProfileFragment.this.etPhone.getText().toString());
                        if (EditProfileFragment.this.profileImgFile != null) {
                            if (editProfileResponse.getData() != null && !TextUtils.isEmpty((CharSequence)editProfileResponse.getData().getUserImage())) {
                                HippoApplication.getInstance().getAgentProfileDetails().getData().setUserImage(editProfileResponse.getData().getUserImage());
                                HippoApplication.getInstance().getUserData().setUserImage(editProfileResponse.getData().getUserImage());
                            } else {
                                EditProfileFragment.this.profileActivity.getAgentData();
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (UserOnBoard.get(EditProfileFragment.this.userOnBoardingValue) == UserOnBoard.BOTH_NAME_PASSWORD) {
                        EditProfileFragment.this.profileActivity.openPasswordFragment();
                    } else if (UserOnBoard.get(EditProfileFragment.this.userOnBoardingValue) == UserOnBoard.ONLY_NAME) {
                        EditProfileFragment.this.getActivity().finish();
                        EditProfileFragment.this.startActivity(new Intent((Context)EditProfileFragment.this.getActivity(), HomeActivity.class));
                    } else {
                        EditProfileFragment.this.getActivity().finish();
                        EditProfileFragment.this.startActivity(new Intent((Context)EditProfileFragment.this.getActivity(), HomeActivity.class));
                    }
                }

                @Override
                public void failure(APIError error) {
                    Logger.INSTANCE.apiFailed("/api/agent/editInfo", error.getMessage());
                    Toast.makeText((Context)EditProfileFragment.this.getActivity(), (CharSequence)error.getMessage(), (int)0).show();
                }
            });
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 3111 || requestCode == 4222) {
            this.imageChooser.onActivityResult(requestCode, resultCode, data);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 1900) {
            this.imageChooser.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    @Override
    public void loadImage(List<ChosenImage> list) {
        this.profileImgFile = new File(list.get(0).getThumbnailPath());
        LoadImageFile.getInstance().loadImage((Context)this.getActivity(), list.get(0).getThumbnailPath(), R.drawable.agent_ic_profile_placeholder, (ImageView)this.ivAgentImage, 3);
    }
}

