/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.fragments;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.google.android.material.bottomsheet.BottomSheetDialogFragment;
import com.hippoagent.HippoApplication;
import com.hippoagent.R;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.langs.Restring;
import com.hippoagent.model.Message;
import com.hippoagent.utils.DateUtils;
import java.util.Date;

public class BottomSheetMsgFragment
extends BottomSheetDialogFragment
implements FuguAppConstant,
View.OnClickListener {
    private LinearLayout copy;
    private LinearLayout react;
    private LinearLayout reply;
    private LinearLayout delete;
    private LinearLayout email;
    private LinearLayout star;
    private LinearLayout edit;
    private LinearLayout forward;
    private FuguChatActivity fuguChatActivity;
    private int position;
    private String Muid;
    private int messsagetype;
    private boolean IsSelf;
    private int MessageStatus;
    private String SentAtUtc;
    private TextView tvDelete;
    private TextView tvStar;
    private Boolean isReplied;
    private TextView copyTxt;

    public static BottomSheetMsgFragment newInstance(int pos, Message message, boolean isSelf, boolean isReplied) {
        BottomSheetMsgFragment frag = new BottomSheetMsgFragment();
        Bundle args = new Bundle();
        frag.setArguments(args);
        frag.setPostion(pos);
        frag.setMuid(message.getMuid());
        frag.setIsSelf(isSelf);
        frag.setMessageType(message.getOriginalMessageType());
        frag.setMessageStatus(message.getMessageStatus());
        frag.setSentAtUtc(message.getSentAtUtc());
        frag.setReplied(isReplied);
        return frag;
    }

    private void setReplied(boolean isReplied) {
        this.isReplied = isReplied;
    }

    private void setSentAtUtc(String sentAtUtc) {
        this.SentAtUtc = sentAtUtc;
    }

    private void setMessageStatus(int messsageStatus) {
        this.MessageStatus = messsageStatus;
    }

    private void setIsSelf(boolean isSelf) {
        this.IsSelf = isSelf;
    }

    private void setMessageType(int messageType) {
        this.messsagetype = messageType;
    }

    private void setMuid(String muid) {
        this.Muid = muid;
    }

    private void setPostion(int pos) {
        this.position = pos;
    }

    public int getTheme() {
        return R.style.HippoBottomSheetDialogTheme;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.message_bottom_sheet, container, false);
        this.fuguChatActivity = (FuguChatActivity)this.getActivity();
        this.copy = (LinearLayout)view.findViewById(R.id.copy);
        this.react = (LinearLayout)view.findViewById(R.id.react);
        this.reply = (LinearLayout)view.findViewById(R.id.reply);
        this.delete = (LinearLayout)view.findViewById(R.id.delete);
        this.email = (LinearLayout)view.findViewById(R.id.email);
        this.edit = (LinearLayout)view.findViewById(R.id.edit);
        this.forward = (LinearLayout)view.findViewById(R.id.forward);
        this.copyTxt = (TextView)view.findViewById(R.id.copyTxt);
        this.copyTxt.setText((CharSequence)Restring.getString((Context)this.getActivity(), R.string.hippo_copy_text));
        this.star = (LinearLayout)view.findViewById(R.id.star);
        this.tvDelete = (TextView)view.findViewById(R.id.tvDelete);
        this.tvStar = (TextView)view.findViewById(R.id.tvStar);
        String localDate = DateUtils.getFormattedDate(new Date());
        int newTime = DateUtils.getTimeInMinutes(DateUtils.getInstance().convertToUTC(localDate));
        int oldTime = DateUtils.getTimeInMinutes(this.SentAtUtc);
        int editableDuration = HippoApplication.getInstance().getUserData().getBusinessProperty().getMaxEditMessageTime();
        if (this.IsSelf && this.messsagetype == 1 && editableDuration > -1 && (editableDuration == 0 || Math.abs(newTime - oldTime) < editableDuration / 60)) {
            this.edit.setVisibility(0);
        } else {
            this.edit.setVisibility(8);
        }
        this.copy.setOnClickListener((View.OnClickListener)this);
        this.reply.setOnClickListener((View.OnClickListener)this);
        this.react.setOnClickListener((View.OnClickListener)this);
        this.delete.setOnClickListener((View.OnClickListener)this);
        this.email.setOnClickListener((View.OnClickListener)this);
        this.star.setOnClickListener((View.OnClickListener)this);
        this.edit.setOnClickListener((View.OnClickListener)this);
        this.forward.setOnClickListener((View.OnClickListener)this);
        return view;
    }

    public void onClick(View v) {
        this.dismiss();
        int id2 = v.getId();
        if (id2 != R.id.react && id2 != R.id.reply) {
            if (id2 == R.id.edit) {
                this.fuguChatActivity.editText(this.position);
            } else if (id2 == R.id.copy) {
                this.fuguChatActivity.copyText(this.position, this.isReplied);
                Toast.makeText((Context)this.getActivity(), (CharSequence)Restring.getString((Context)this.getActivity(), R.string.hippo_copy_to_clipboard), (int)0).show();
            } else if (id2 == R.id.email || id2 == R.id.star || id2 == R.id.forward || id2 == R.id.delete) {
                // empty if block
            }
        }
    }

    public void onCancel(DialogInterface dialog) {
        if (this.fuguChatActivity != null) {
            this.fuguChatActivity.setOnLongClickValue();
        }
        super.onCancel(dialog);
    }
}

