/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.fcm;

import com.hippoagent.database.CommonData;
import com.hippoagent.fcm.PushNotification;
import io.paperdb.Paper;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006J\u001b\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0013J#\u0010\u0014\u001a\u00020\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0018\u001a\u00020\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/hippoagent/fcm/NotificationDatabase;", "", "()V", "HIPPO_NOTIFICATION_TIMESTAMP", "", "NOTIFICATION_TIMESTAMP", "Ljava/util/TreeMap;", "", "", "STACK_NOTIFICATIONS", "STACK_NOTIFICATIONS_MAP", "Ljava/util/ArrayList;", "Lcom/hippoagent/fcm/PushNotification;", "getNotificationTime", "getNotifications", "channelId", "(Ljava/lang/Integer;)Ljava/util/ArrayList;", "removeNotifications", "", "(Ljava/lang/Integer;)V", "setNotification", "notificationsList", "(Ljava/lang/Integer;Ljava/util/ArrayList;)V", "updateNotiTimeStamp", "updateNotificationTimeStamp", "hippoagentsdk_release"})
public final class NotificationDatabase {
    private static TreeMap<Integer, ArrayList<PushNotification>> STACK_NOTIFICATIONS_MAP;
    private static TreeMap<Integer, Long> NOTIFICATION_TIMESTAMP;
    private static final String STACK_NOTIFICATIONS = "hippo_stack_notifications";
    private static final String HIPPO_NOTIFICATION_TIMESTAMP = "hippo_notification_timestamp";
    public static final NotificationDatabase INSTANCE;

    public final void setNotification(@Nullable Integer channelId, @NotNull ArrayList<PushNotification> notificationsList) {
        Intrinsics.checkParameterIsNotNull(notificationsList, (String)"notificationsList");
        try {
            Integer n = channelId;
            if (n == null) {
                Intrinsics.throwNpe();
            }
            STACK_NOTIFICATIONS_MAP.put(n, notificationsList);
            Paper.book((String)CommonData.name).write(STACK_NOTIFICATIONS, STACK_NOTIFICATIONS_MAP);
        }
        catch (Exception e) {
            Paper.book((String)CommonData.name).delete(STACK_NOTIFICATIONS);
        }
        this.updateNotiTimeStamp(channelId);
    }

    public final void updateNotiTimeStamp(@Nullable Integer channelId) {
        try {
            NOTIFICATION_TIMESTAMP = this.getNotificationTime();
            Integer n = channelId;
            if (n == null) {
                Intrinsics.throwNpe();
            }
            NOTIFICATION_TIMESTAMP.put(n, System.currentTimeMillis());
            Paper.book((String)CommonData.name).write(HIPPO_NOTIFICATION_TIMESTAMP, NOTIFICATION_TIMESTAMP);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    public final ArrayList<PushNotification> getNotifications(@Nullable Integer channelId) {
        try {
            if (STACK_NOTIFICATIONS_MAP.isEmpty()) {
                Object object = Paper.book((String)CommonData.name).read(STACK_NOTIFICATIONS, new TreeMap());
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Paper.book(CommonData.na\u2026ist<PushNotification>>())");
                STACK_NOTIFICATIONS_MAP = (TreeMap)object;
            }
            Map map = STACK_NOTIFICATIONS_MAP;
            boolean bl = false;
            Object v = map.get(channelId);
            if (v == null) {
                Intrinsics.throwNpe();
            }
            return (ArrayList)v;
        }
        catch (Exception e) {
            Paper.book((String)CommonData.name).delete(STACK_NOTIFICATIONS);
            return new ArrayList<PushNotification>();
        }
    }

    @NotNull
    public final TreeMap<Integer, Long> getNotificationTime() {
        Object object = Paper.book((String)CommonData.name).read(HIPPO_NOTIFICATION_TIMESTAMP, new TreeMap());
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Paper.book(CommonData.na\u2026MP, TreeMap<Int, Long>())");
        NOTIFICATION_TIMESTAMP = (TreeMap)object;
        return NOTIFICATION_TIMESTAMP;
    }

    public final void updateNotificationTimeStamp(@Nullable Integer channelId) {
        try {
            TreeMap<Integer, Long> nTimeStamp = this.getNotificationTime();
            Map map = nTimeStamp;
            boolean bl = false;
            Map map2 = map;
            if (map2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
            }
            TypeIntrinsics.asMutableMap((Object)map2).remove(channelId);
            Paper.book((String)CommonData.name).write(HIPPO_NOTIFICATION_TIMESTAMP, nTimeStamp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void removeNotifications(@Nullable Integer channelId) {
        try {
            if (!STACK_NOTIFICATIONS_MAP.isEmpty()) {
                TreeMap<Integer, ArrayList<PushNotification>> NEW_STACk_NOTIFICATIONS_MAP = STACK_NOTIFICATIONS_MAP;
                Map map = NEW_STACk_NOTIFICATIONS_MAP;
                boolean bl = false;
                Map map2 = map;
                if (map2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
                }
                TypeIntrinsics.asMutableMap((Object)map2).remove(channelId);
                Paper.book((String)CommonData.name).write(STACK_NOTIFICATIONS, NEW_STACk_NOTIFICATIONS_MAP);
                STACK_NOTIFICATIONS_MAP = NEW_STACk_NOTIFICATIONS_MAP;
            } else {
                TreeMap NEW_STACk_NOTIFICATIONS_MAP;
                TreeMap treeMap = NEW_STACk_NOTIFICATIONS_MAP = (TreeMap)Paper.book((String)CommonData.name).read(STACK_NOTIFICATIONS, new TreeMap());
                Intrinsics.checkExpressionValueIsNotNull((Object)treeMap, (String)"NEW_STACk_NOTIFICATIONS_MAP");
                Map map = treeMap;
                boolean bl = false;
                Map map3 = map;
                if (map3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
                }
                if (map3.containsKey(channelId)) {
                    map = NEW_STACk_NOTIFICATIONS_MAP;
                    bl = false;
                    TypeIntrinsics.asMutableMap((Object)map).remove(channelId);
                    Paper.book((String)CommonData.name).write(STACK_NOTIFICATIONS, (Object)NEW_STACk_NOTIFICATIONS_MAP);
                    STACK_NOTIFICATIONS_MAP = NEW_STACk_NOTIFICATIONS_MAP;
                }
            }
        }
        catch (Exception e) {
            Paper.book((String)CommonData.name).delete(STACK_NOTIFICATIONS);
        }
        this.updateNotificationTimeStamp(channelId);
    }

    private NotificationDatabase() {
    }

    static {
        NotificationDatabase notificationDatabase;
        INSTANCE = notificationDatabase = new NotificationDatabase();
        STACK_NOTIFICATIONS_MAP = new TreeMap();
        NOTIFICATION_TIMESTAMP = new TreeMap();
        STACK_NOTIFICATIONS = STACK_NOTIFICATIONS;
        HIPPO_NOTIFICATION_TIMESTAMP = HIPPO_NOTIFICATION_TIMESTAMP;
    }
}

