/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.fcm;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.IBinder;
import android.os.Vibrator;
import androidx.annotation.Nullable;
import com.google.gson.Gson;
import com.hippoagent.R;
import com.hippoagent.database.CommonData;
import com.hippoagent.utils.Log;
import java.util.concurrent.CopyOnWriteArraySet;

public class AudioPlay
extends Service
implements MediaPlayer.OnPreparedListener {
    private static final String TAG = AudioPlay.class.getName();
    public MediaPlayer mediaPlayer;
    public Vibrator vibrator;
    private int playerType = 1;
    private int timeValue = 10;
    private int channelId = -1;

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        Log.d("ClearFromRecentService", "Service Started");
        try {
            this.playerType = intent.getIntExtra("type", 0);
            this.timeValue = intent.getIntExtra("time", 10);
            this.channelId = intent.getIntExtra("channelId", -1);
            if (this.playerType == 1) {
                this.startRing((Context)this, this.timeValue * 1000);
            } else {
                CopyOnWriteArraySet<Integer> arrayList = CommonData.getPushChannelID();
                Log.e(TAG, "arrayList: " + new Gson().toJson(arrayList));
                Log.e(TAG, "Channel id: " + this.channelId);
                if (arrayList == null || arrayList.size() == 0 || this.channelId < -10) {
                    this.stopSelf();
                } else {
                    Integer obj = this.channelId;
                    arrayList.remove(obj);
                    CommonData.savePushChannels(arrayList);
                    Log.e(TAG, "arrayList: " + new Gson().toJson(arrayList));
                    if (arrayList == null || arrayList.size() == 0) {
                        this.stopRing();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }

    public void onDestroy() {
        super.onDestroy();
        CommonData.savePushChannels(new CopyOnWriteArraySet<Integer>());
        this.stopRing();
    }

    public void onCreate() {
        super.onCreate();
    }

    public void onTaskRemoved(Intent rootIntent) {
        super.onTaskRemoved(rootIntent);
        CommonData.savePushChannels(new CopyOnWriteArraySet<Integer>());
        this.stopRing();
    }

    public void startRing(final Context context, long time) {
        try {
            if (this.mediaPlayer != null && this.mediaPlayer.isPlaying()) {
                return;
            }
            this.vibrator = (Vibrator)context.getSystemService("vibrator");
            if (this.vibrator.hasVibrator()) {
                long[] pattern = new long[]{0L, 1350L, 3900L, 1350L, 3900L, 1350L, 3900L, 1350L, 3900L, 1350L, 3900L, 1350L, 3900L, 1350L, 3900L, 1350L, 3900L, 1350L, 3900L, 1350L, 3900L, 1350L, 3900L};
                this.vibrator.vibrate(pattern, 1);
            }
            try {
                AudioManager am = (AudioManager)context.getSystemService("audio");
                am.setStreamVolume(3, am.getStreamMaxVolume(3), 0);
            }
            catch (Exception am) {
                // empty catch block
            }
            if (this.mediaPlayer != null && this.mediaPlayer.isPlaying()) {
                this.stopRing(new restartMedia(){

                    @Override
                    public void onRestart() {
                        AudioPlay.this.startMedia(context);
                    }
                });
            } else {
                this.startMedia(context);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startMedia(Context context) {
        this.mediaPlayer = MediaPlayer.create((Context)context, (int)R.raw.telephone_ring);
        this.mediaPlayer.setLooping(true);
        this.mediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
    }

    public void stopRing() {
        this.stopRing(null);
    }

    public void stopRing(restartMedia media) {
        try {
            if (this.vibrator != null) {
                this.vibrator.cancel();
            }
            if (this.mediaPlayer != null && this.mediaPlayer.isPlaying()) {
                this.mediaPlayer.stop();
                this.mediaPlayer.reset();
                this.mediaPlayer.release();
                this.mediaPlayer = null;
            }
            if (media != null) {
                media.onRestart();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onPrepared(MediaPlayer mp) {
        mp.start();
    }

    public static interface restartMedia {
        public void onRestart();
    }
}

