/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.database;

import android.content.Context;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.hippoagent.HippoConfig;
import com.hippoagent.HippoConfigAttributes;
import com.hippoagent.database.PaperDbConstant;
import com.hippoagent.helper.VersionUpdate;
import com.hippoagent.langs.Translation;
import com.hippoagent.model.FuguConversation;
import com.hippoagent.model.FuguGetMessageResponse;
import com.hippoagent.model.Message;
import com.hippoagent.model.UnreadCountData;
import com.hippoagent.model.groupCall.GroupCallData;
import com.hippoagent.model.user_details.DeviceDetails;
import com.hippoagent.utils.FuguColorConfig;
import com.hippoagent.utils.Log;
import io.paperdb.Paper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.json.JSONObject;

public final class CommonData
implements PaperDbConstant {
    public static String name = "hippoagentsdk.paperdb";
    public static List<FuguConversation> CONVERSATION_LIST = Collections.emptyList();
    public static FuguColorConfig COLOR_CONFIG = new FuguColorConfig();
    private static HashMap<String, UnreadCountData> UNREAD_COUNT = new HashMap();
    private static HashMap<Integer, Integer> TOTAL_UNREAD_COUNT = new HashMap();
    public static TreeMap<Integer, String> typedMessages = new TreeMap();
    private static HashMap<String, GroupCallData> GROUP_CALL_DATA = new HashMap();

    private CommonData() {
    }

    public static void clearOldData() {
        try {
            Paper.book((String)name).delete("fugu_get_message_response_map");
            Paper.book((String)name).delete("fugu_unsent_message_map_new");
            Paper.book((String)name).delete("hippo_unsent_messages");
            Paper.book((String)name).delete("hippo_sent_messages");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setlineBeforeFeedback(String key, String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return;
        }
        Paper.book((String)name).write(key, (Object)value);
    }

    public static String getLineFeedback(String key) {
        return (String)Paper.book((String)name).read(key);
    }

    public static void setMessageResponse(Integer channelId, FuguGetMessageResponse getMessageResponse) {
        try {
            Paper.book((String)name).write("fugu_get_message_response_map" + channelId, (Object)getMessageResponse);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static FuguGetMessageResponse getMessageResponse(Integer channelId) {
        try {
            return (FuguGetMessageResponse)Paper.book((String)name).read("fugu_get_message_response_map" + channelId, (Object)new FuguGetMessageResponse());
        }
        catch (Exception e) {
            return new FuguGetMessageResponse();
        }
    }

    public static void removeMessageResponse(Integer channelId) {
        Paper.book((String)name).delete("fugu_get_message_response_map" + channelId);
    }

    public static FuguColorConfig getColorConfig() {
        if (COLOR_CONFIG == null) {
            COLOR_CONFIG = (FuguColorConfig)Paper.book((String)name).read("paper_color_config", null);
        }
        return COLOR_CONFIG;
    }

    public static void setConversationList(List<FuguConversation> conversationList) {
        CONVERSATION_LIST = conversationList;
        Paper.book((String)name).write("fugu_conversation_list", conversationList);
    }

    public static List<FuguConversation> getConversationList() {
        CONVERSATION_LIST = (List)Paper.book((String)name).read("fugu_conversation_list", Collections.emptyList());
        return CONVERSATION_LIST;
    }

    public static void setUnsentMessageMapByChannel(int channelId, LinkedHashMap<String, JSONObject> unsentMessageMap) {
        Paper.book((String)name).write("fugu_unsent_message_map_new" + channelId, unsentMessageMap);
    }

    public static void removeUnsentMessageMapChannel(Integer channelId) {
        Paper.book((String)name).delete("fugu_unsent_message_map_new" + channelId);
    }

    public static LinkedHashMap<String, JSONObject> getUnsentMessageMapByChannel(Integer channelId) {
        return (LinkedHashMap)Paper.book((String)name).read("fugu_unsent_message_map_new" + channelId, new LinkedHashMap());
    }

    public static void setUnsentMessageByChannel(Integer channelId, LinkedHashMap<String, Message> unsentMessage) {
        Paper.book((String)name).write("hippo_unsent_messages" + channelId, unsentMessage);
    }

    public static void removeUnsentMessageChannel(Integer channelId) {
        Paper.book((String)name).delete("hippo_unsent_messages" + channelId);
    }

    public static LinkedHashMap<String, Message> getUnsentMessageByChannel(Integer channelId) {
        return (LinkedHashMap)Paper.book((String)name).read("hippo_unsent_messages" + channelId, new LinkedHashMap());
    }

    public static void addExistingMessages(Integer channelId, LinkedHashMap<String, Message> sentMessage) {
        LinkedHashMap<String, Message> allSentMessages = CommonData.getSentMessageByChannel(channelId);
        allSentMessages.putAll(sentMessage);
        CommonData.setSentMessageByChannel(channelId, allSentMessages);
    }

    public static void setSentMessageByChannel(Integer channelId, LinkedHashMap<String, Message> sentMessage) {
        Paper.book((String)name).write("hippo_sent_messages" + channelId, sentMessage);
    }

    public static void removeSentMessageChannel(Integer channelId) {
        Paper.book((String)name).delete("hippo_sent_messages" + channelId);
    }

    public static LinkedHashMap<String, Message> getSentMessageByChannel(Integer channelId) {
        return (LinkedHashMap)Paper.book((String)name).read("hippo_sent_messages" + channelId, new LinkedHashMap());
    }

    public static void setIsBkUser(boolean bkUser) {
        Paper.book((String)name).write("hippo_bk_user", (Object)bkUser);
    }

    public static boolean isBkUser() {
        return (Boolean)Paper.book((String)name).read("hippo_bk_user", (Object)false);
    }

    public static HashMap<Integer, ArrayList<Integer>> getAllNotificationChannels() {
        return (HashMap)Paper.book((String)name).read("hippo_notifications", new HashMap());
    }

    public static ArrayList<Integer> getNotificationArray(Integer channelId) {
        HashMap<Integer, ArrayList<Integer>> hashMap = CommonData.getAllNotificationChannels();
        return hashMap.get(channelId);
    }

    public static void saveNotificationId(Integer channelId, Integer notificationChannel) {
        ArrayList<Integer> ids = CommonData.getNotificationArray(channelId);
        if (ids == null || ids.size() == 0) {
            ids = new ArrayList();
        }
        ids.add(notificationChannel);
        HashMap<Integer, ArrayList<Integer>> hashMap = CommonData.getAllNotificationChannels();
        hashMap.put(channelId, ids);
        Paper.book((String)name).write("hippo_notifications", hashMap);
    }

    public static void removeNotificationChannel(Integer channelId) {
        try {
            HashMap<Integer, ArrayList<Integer>> hashMap = CommonData.getAllNotificationChannels();
            if (hashMap.containsKey(channelId)) {
                hashMap.remove(channelId);
                Paper.book((String)name).write("hippo_notifications", hashMap);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void removeAllNotificationChannel() {
        Paper.book((String)name).delete("hippo_notifications");
    }

    public static void clearData() {
        CONVERSATION_LIST = Collections.emptyList();
        Paper.book((String)name).destroy();
        try {
            Paper.book().destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getProvider() {
        return HippoConfig.getInstance().getAttributes().getProvider();
    }

    public static CopyOnWriteArraySet<Integer> getPushChannelID() {
        return (CopyOnWriteArraySet)Paper.book((String)name).read("new_hippo_push_channel_Id", new CopyOnWriteArraySet());
    }

    public static void savePushChannels(CopyOnWriteArraySet<Integer> arrayList) {
        Paper.book((String)name).write("new_hippo_push_channel_Id", arrayList);
    }

    public static void savePushChannelID(int channelId) {
        CopyOnWriteArraySet<Integer> arrayList = CommonData.getPushChannelID();
        if (arrayList == null) {
            arrayList = new CopyOnWriteArraySet();
        }
        Integer integer = channelId;
        arrayList.add(integer);
        Paper.book((String)name).write("new_hippo_push_channel_Id", arrayList);
    }

    public static String getCallStatus() {
        return (String)Paper.book((String)name).read("hippo_call_status");
    }

    public static void setCallStatus(String callStatus) {
        Paper.book((String)name).write("hippo_call_status", (Object)callStatus);
    }

    public static JsonObject deviceDetails(Context context) {
        Gson gson = new GsonBuilder().create();
        JsonObject deviceDetailsJson = null;
        try {
            deviceDetailsJson = gson.toJsonTree((Object)new DeviceDetails(CommonData.getAppVersion(context)).getDeviceDetails()).getAsJsonObject();
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return deviceDetailsJson;
    }

    public static int getAppVersion(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static void setCallAnswered(boolean b) {
        Paper.book((String)name).write("hippo_call_answer", (Object)b);
    }

    public static boolean isCallAnswered() {
        return (Boolean)Paper.book((String)name).read("hippo_call_answer", (Object)false);
    }

    public static void saveDeepLinkURI(String uridata) {
        Paper.book((String)name).write("hippo_deeplink_uri", (Object)uridata);
    }

    public static String getDeepLinkURI() {
        return (String)Paper.book((String)name).read("hippo_deeplink_uri");
    }

    public static void clearDeepLinkData() {
        Paper.book((String)name).delete("hippo_deeplink_uri");
    }

    public static String getUserCountryCode() {
        return (String)Paper.book((String)name).read("hippo_country_code", (Object)"");
    }

    public static String getUserContCode() {
        return (String)Paper.book((String)name).read("hippo_cont_code", (Object)"");
    }

    public static void setUserCountryCode(String userCountryCode) {
        Paper.book((String)name).write("hippo_country_code", (Object)userCountryCode);
    }

    public static void setUserContCode(String userContCode) {
        Paper.book((String)name).write("hippo_cont_code", (Object)userContCode);
    }

    public static void setTime(String timeStamp) {
        Paper.book((String)name).write("hippo_time_stamp", (Object)timeStamp);
    }

    public static String getTime() {
        return (String)Paper.book((String)name).read("hippo_time_stamp");
    }

    public static void setImageMuid(String imageMuid) {
        Paper.book((String)name).write("hippo_image_muid", (Object)imageMuid);
    }

    public static String getImageMuid() {
        return (String)Paper.book((String)name).read("hippo_image_muid");
    }

    public static void setFayeListener(boolean b) {
        Paper.book((String)name).write("reset_faye_listener", (Object)b);
    }

    public static boolean isListenerReset() {
        return (Boolean)Paper.book((String)name).read("reset_faye_listener", (Object)false);
    }

    public static void saveVersionInfo(VersionUpdate update) {
        Paper.book((String)name).write("hippo_version_check", (Object)update);
    }

    public static VersionUpdate getVersionInfo() {
        try {
            return (VersionUpdate)Paper.book((String)name).read("hippo_version_check", null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int getInstallType() {
        return (Integer)Paper.book((String)name).read("installType", (Object)0);
    }

    public static void saveInstallType(int installType) {
        Paper.book((String)name).write("installType", (Object)installType);
    }

    public static void saveTypedMessage(int channelId, String message) {
        try {
            if (TextUtils.isEmpty((CharSequence)message)) {
                typedMessages.remove(channelId);
                Paper.book((String)name).write("hippo_typed_message", typedMessages);
                Log.e("channelId", channelId + " *********** " + new Gson().toJson(typedMessages));
            } else {
                typedMessages.put(channelId, message);
                Paper.book((String)name).write("hippo_typed_message", typedMessages);
                Log.e("channelId", channelId + " <------> " + message + " *********** " + new Gson().toJson(typedMessages));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getTypedMessage(int channelId) {
        try {
            if (typedMessages == null || typedMessages.size() == 0) {
                typedMessages = (TreeMap)Paper.book((String)name).read("hippo_typed_message", new TreeMap());
            }
            Log.e("channelId", channelId + " = " + new Gson().toJson(typedMessages));
            return typedMessages.get(channelId);
        }
        catch (Exception e) {
            typedMessages = new TreeMap();
            return "";
        }
    }

    public static void saveAttributes(HippoConfigAttributes configAttributes) {
        Paper.book((String)name).write("configAttributes", (Object)configAttributes);
    }

    public static HippoConfigAttributes getConfigAttributes() {
        return (HippoConfigAttributes)Paper.book((String)name).read("configAttributes");
    }

    public static HashMap<String, UnreadCountData> getUnreadCount() {
        UNREAD_COUNT = (HashMap)Paper.book((String)name).read("hippo_agent_unread_count", new HashMap());
        return UNREAD_COUNT;
    }

    public static void addAllUnreadCount(HashMap<String, UnreadCountData> hashMap) {
        Paper.book((String)name).write("hippo_agent_unread_count", hashMap);
    }

    public static UnreadCountData getUnreadCount(String userUniqueKey) {
        return CommonData.getUnreadCount().get(userUniqueKey);
    }

    public static HashMap<String, UnreadCountData> addUnreadCount(String userUniqueKey, UnreadCountData unreadCountData) {
        UNREAD_COUNT = CommonData.getUnreadCount();
        UNREAD_COUNT.put(userUniqueKey, unreadCountData);
        Paper.book((String)name).write("hippo_agent_unread_count", UNREAD_COUNT);
        return UNREAD_COUNT;
    }

    public static HashMap<String, UnreadCountData> removeUnreadCount(String userUniqueKey) {
        UNREAD_COUNT = CommonData.getUnreadCount();
        UNREAD_COUNT.remove(userUniqueKey);
        Paper.book((String)name).write("hippo_agent_unread_count", UNREAD_COUNT);
        return UNREAD_COUNT;
    }

    public static void clearUnreadCount() {
        Paper.book((String)name).delete("hippo_agent_unread_count");
    }

    public static HashMap<Integer, Integer> getTotalUnreadCount() {
        TOTAL_UNREAD_COUNT = (HashMap)Paper.book((String)name).read("hippo_agent_all_unread_count", new HashMap());
        return TOTAL_UNREAD_COUNT;
    }

    public static void addTotalUnreadCount(HashMap<Integer, Integer> hashMap) {
        Paper.book((String)name).write("hippo_agent_all_unread_count", hashMap);
    }

    public static Integer getTotalUnreadCount(Integer channelId) {
        return CommonData.getTotalUnreadCount().get(channelId);
    }

    public static HashMap<Integer, Integer> addTotalUnreadCount(Integer channelId, Integer count) {
        TOTAL_UNREAD_COUNT = CommonData.getTotalUnreadCount();
        TOTAL_UNREAD_COUNT.put(channelId, count);
        Paper.book((String)name).write("hippo_agent_all_unread_count", TOTAL_UNREAD_COUNT);
        return TOTAL_UNREAD_COUNT;
    }

    public static HashMap<Integer, Integer> removeTotalUnreadCount(Integer channelId) {
        TOTAL_UNREAD_COUNT = CommonData.getTotalUnreadCount();
        TOTAL_UNREAD_COUNT.remove(channelId);
        Paper.book((String)name).write("hippo_agent_all_unread_count", TOTAL_UNREAD_COUNT);
        return TOTAL_UNREAD_COUNT;
    }

    public static void clearTotalUnreadCount() {
        Paper.book((String)name).delete("hippo_agent_all_unread_count");
    }

    public static ArrayList<String> getAgentUniqueKey() {
        return (ArrayList)Paper.book((String)name).read("hippo_agent_list", null);
    }

    public static void setAgentUniqueKey(ArrayList<String> strings) {
        Paper.book((String)name).write("hippo_agent_list", strings);
    }

    public static void saveLangKeys(Translation translation) {
        Paper.book((String)name).write("hippo_lang_keys", (Object)translation);
    }

    public static Translation getLangKeys() {
        return (Translation)Paper.book((String)name).read("hippo_lang_keys", (Object)new Translation());
    }

    public static String getCurrentLanguage() {
        return (String)Paper.book((String)name).read("hippo_current_lang", (Object)"");
    }

    public static void saveCurrentLang(String lang) {
        Paper.book((String)name).write("hippo_current_lang", (Object)lang);
    }

    public static void saveGroupCall(String transactionId, GroupCallData callResponse) {
        GROUP_CALL_DATA = CommonData.getAllGroupCallData();
        GROUP_CALL_DATA.put(transactionId, callResponse);
        Paper.book((String)name).write("hippo_group_call_data", GROUP_CALL_DATA);
    }

    public static GroupCallData getGroupData(String transactionId) {
        GROUP_CALL_DATA = CommonData.getAllGroupCallData();
        return GROUP_CALL_DATA.get(transactionId);
    }

    public static GroupCallData deleteGroupData(String transactionId) {
        GROUP_CALL_DATA = CommonData.getAllGroupCallData();
        GROUP_CALL_DATA.remove(transactionId);
        return GROUP_CALL_DATA.get(transactionId);
    }

    private static HashMap<String, GroupCallData> getAllGroupCallData() {
        return (HashMap)Paper.book((String)name).read("hippo_group_call_data", new HashMap());
    }
}

