/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.confcall;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.util.Log;
import androidx.annotation.NonNull;
import com.hippoagent.R;
import java.io.IOException;

public class OutgoingRinger {
    private static final String TAG = OutgoingRinger.class.getSimpleName();
    private final Context context;
    private MediaPlayer mediaPlayer;

    public OutgoingRinger(@NonNull Context context) {
        this.context = context;
    }

    public void start(Type type) {
        int soundId;
        if (type == Type.RINGING) {
            soundId = R.raw.ringing;
        } else if (type == Type.BUSY) {
            soundId = R.raw.busy_tone;
        } else {
            throw new IllegalArgumentException("Not a valid sound type");
        }
        if (this.mediaPlayer != null) {
            this.mediaPlayer.release();
        }
        this.mediaPlayer = new MediaPlayer();
        this.mediaPlayer.setAudioStreamType(0);
        this.mediaPlayer.setLooping(true);
        String packageName = this.context.getPackageName();
        Uri dataUri = Uri.parse((String)("android.resource://" + packageName + "/" + soundId));
        try {
            this.mediaPlayer.setDataSource(this.context, dataUri);
            this.mediaPlayer.prepare();
            this.mediaPlayer.start();
        }
        catch (IOException | IllegalArgumentException | IllegalStateException | SecurityException e) {
            Log.w((String)TAG, (Throwable)e);
        }
    }

    public void stop() {
        if (this.mediaPlayer == null) {
            return;
        }
        this.mediaPlayer.release();
        this.mediaPlayer = null;
    }

    public static enum Type {
        RINGING,
        BUSY;

    }
}

