/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.adapters;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.databinding.DataBindingUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.hippoagent.R;
import com.hippoagent.databinding.CustomAttributeBinding;
import com.hippoagent.langs.Restring;
import com.hippoagent.model.user_details.CustomAttributeList;
import java.util.ArrayList;

public class VisitorInfoAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private ArrayList<CustomAttributeList> visitorInfo;
    private Context context;
    private boolean hasShowMore;

    public VisitorInfoAdapter(ArrayList<CustomAttributeList> visitorInfo, boolean hasShowMore) {
        this.visitorInfo = visitorInfo;
        this.hasShowMore = hasShowMore;
    }

    public void setData(ArrayList<CustomAttributeList> visitorInfo) {
        this.visitorInfo = visitorInfo;
        this.notifyDataSetChanged();
    }

    public void showData(boolean hasShowMore) {
        this.hasShowMore = hasShowMore;
        if (!hasShowMore) {
            this.notifyItemRangeInserted(2, this.visitorInfo.size());
        } else {
            this.notifyItemRangeRemoved(2, this.visitorInfo.size());
        }
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        this.context = parent.getContext();
        return new ViewHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.custom_attribute, parent, false));
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        try {
            ((ViewHolder)holder).binding.tvKeyView.setText((CharSequence)this.visitorInfo.get(position).getKey());
            String txt = Restring.getString(this.context, R.string.hippo_na);
            ((ViewHolder)holder).binding.tvValueView.setText((CharSequence)(TextUtils.isEmpty((CharSequence)this.visitorInfo.get(position).getValue()) ? txt : this.visitorInfo.get(position).getValue()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getItemCount() {
        return this.visitorInfo == null ? 0 : (this.hasShowMore ? 2 : this.visitorInfo.size());
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private CustomAttributeBinding binding;

        public ViewHolder(View itemView) {
            super(itemView);
            this.binding = (CustomAttributeBinding)DataBindingUtil.bind((View)itemView);
        }
    }
}

