/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.adapters;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.text.Html;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.text.style.RelativeSizeSpan;
import android.text.style.URLSpan;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatButton;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.core.app.ActivityOptionsCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.downloader.Error;
import com.downloader.OnDownloadListener;
import com.downloader.OnPauseListener;
import com.downloader.OnProgressListener;
import com.downloader.OnStartOrResumeListener;
import com.downloader.PRDownloader;
import com.downloader.Progress;
import com.google.android.flexbox.FlexboxLayoutManager;
import com.hippoagent.HippoApplication;
import com.hippoagent.R;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.activities.ImageDisplayActivity;
import com.hippoagent.activities.VideoPlayerActivity;
import com.hippoagent.adapters.CustomActionButtonsAdapter;
import com.hippoagent.adapters.CustomActionDescriptionAdapter;
import com.hippoagent.adapters.ListItem;
import com.hippoagent.adapters.MultiSelectionAdapter;
import com.hippoagent.adapters.OnRecyclerListener;
import com.hippoagent.adapters.PaymentAdapter;
import com.hippoagent.adapters.TagsAdapter;
import com.hippoagent.adapters.UserConcentListener;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.fragments.BottomSheetMsgFragment;
import com.hippoagent.langs.Restring;
import com.hippoagent.model.CallModel;
import com.hippoagent.model.Conversation;
import com.hippoagent.model.CustomAction;
import com.hippoagent.model.FileuploadModel;
import com.hippoagent.model.Image;
import com.hippoagent.model.Message;
import com.hippoagent.utils.BetterLinkMovementMethod;
import com.hippoagent.utils.ColorPicker.ColorGenerator;
import com.hippoagent.utils.ColorPicker.TextDrawable;
import com.hippoagent.utils.CommonMediaPlayer;
import com.hippoagent.utils.DateUtils;
import com.hippoagent.utils.FuguColorConfig;
import com.hippoagent.utils.GridDividerItemDecoration;
import com.hippoagent.utils.LoadImageFile;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.RatingBar;
import com.hippoagent.utils.RoundedCornersTransformation;
import com.hippoagent.utils.URLSpanNoUnderline;
import com.hippoagent.utils.Utils;
import com.hippoagent.utils.filePicker.FileManager;
import com.hippoagent.utils.loadingBox.FuguAgentProgressWheel;
import com.hippoagent.utils.loadingBox.LoadingBox;
import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.TypeCastException;

public class FuguMessageAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements FuguAppConstant,
ListItem,
OnRecyclerListener,
UserConcentListener {
    private static final String TAG = FuguMessageAdapter.class.getSimpleName();
    private FuguChatActivity context;
    private DateUtils dateUtil = DateUtils.getInstance();
    private OnRetryListener mOnRetry;
    private FuguColorConfig fuguColorConfig;
    private Conversation conversation;
    private onVideoCall onVideoCall;
    private String customerName;
    private String agentName;
    private boolean isChatAssignToMe = false;
    private boolean isVideoCallEnabled = true;
    private boolean isAudioCallEnabled = false;
    private int agentId;
    @NonNull
    private List<Message> items = Collections.emptyList();
    private RecyclerView recyclerView;
    private OnUserConcent onUserConcent;
    private static final ColorMatrix BW_MATRIX = new ColorMatrix();
    private static final ColorMatrixColorFilter BW_FILTER;
    private boolean onLongClick = false;
    private AdapterCallback adapterCallBack;
    private RequestOptions options;
    private RequestOptions myOptions;
    int currentProgress = -1;
    boolean receiverRegistered;
    private BroadcastReceiver mProgressReceiver = null;
    boolean onLinkLongClick = false;
    private BetterLinkMovementMethod.OnLinkLongClickListener urlClickListenerLong = new BetterLinkMovementMethod.OnLinkLongClickListener(){

        @Override
        public boolean onLongClick(TextView textView, String url) {
            if (url.toLowerCase().contains("http") || url.toLowerCase().contains("www")) {
                FuguMessageAdapter.this.onLinkLongClick = true;
                ClipboardManager clipboard = (ClipboardManager)FuguMessageAdapter.this.context.getSystemService("clipboard");
                ClipData clip = ClipData.newPlainText((CharSequence)"", (CharSequence)url);
                clipboard.setPrimaryClip(clip);
                Toast.makeText((Context)FuguMessageAdapter.this.context, (CharSequence)Restring.getString((Context)FuguMessageAdapter.this.context, R.string.hippo_copy_to_clipboard), (int)0).show();
            }
            return true;
        }
    };
    private BetterLinkMovementMethod.OnLinkClickListener urlClickListener = new BetterLinkMovementMethod.OnLinkClickListener(){

        @Override
        public boolean onClick(TextView textView, String url) {
            if (!FuguMessageAdapter.this.onLongClick && (url.toLowerCase().contains("http") || url.toLowerCase().contains("www"))) {
                String clickableLink = url;
                clickableLink = clickableLink.replace("<b>", "");
                clickableLink = clickableLink.replace("<i>", "");
                clickableLink = clickableLink.replace("</i>", "");
                clickableLink = clickableLink.replace("</b>", "");
                clickableLink = clickableLink.replace("</br>", "");
                clickableLink = clickableLink.replace("<br>", "");
                try {
                    if (clickableLink.startsWith("www")) {
                        clickableLink = "http://" + clickableLink;
                    }
                    Intent i = new Intent("android.intent.action.VIEW");
                    i.setData(Uri.parse((String)clickableLink));
                    FuguMessageAdapter.this.context.startActivity(i);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
    };
    int dp1 = 0;
    int dp2 = 0;
    int dp4 = 0;
    int dp8 = 0;
    int dp30 = 0;
    String botImage = "";

    public void setOnLongClickValue(Boolean onLongClick) {
        this.onLongClick = onLongClick;
    }

    public FuguMessageAdapter(FuguChatActivity context, @NonNull List<Message> items, RecyclerView recyclerView, Conversation conversation, OnUserConcent onUserConcent) {
        this.items = items;
        this.recyclerView = recyclerView;
        this.context = context;
        this.fuguColorConfig = CommonData.getColorConfig();
        this.conversation = conversation;
        this.onUserConcent = onUserConcent;
        this.myOptions = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)RequestOptions.bitmapTransform((Transformation)new RoundedCornersTransformation((Context)context, 7, 2)).placeholder(ContextCompat.getDrawable((Context)context, (int)R.drawable.hippo_placeholder))).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(ContextCompat.getDrawable((Context)context, (int)R.drawable.hippo_placeholder));
    }

    @Override
    public void onUserConcent(int position, String btnId, Message message) {
        if (this.onUserConcent != null) {
            this.onUserConcent.onConcentClicked(message);
        }
    }

    public void setOnVideoCallListener(onVideoCall onVideoCall2) {
        this.onVideoCall = onVideoCall2;
    }

    public void setCallModel(CallModel callModel) {
        this.customerName = callModel.getCustomerName();
        this.agentName = callModel.getAgentName();
        this.isChatAssignToMe = callModel.isChatAssignToMe();
        this.isVideoCallEnabled = callModel.isVideoCallEnabled();
        this.isAudioCallEnabled = callModel.isAudioCallEnabled();
    }

    public void updateList(@NonNull List<Message> items) {
        this.items = items;
    }

    public void setOnRetryListener(OnRetryListener OnRetryListener2) {
        this.mOnRetry = OnRetryListener2;
    }

    public void setAdapterCallBack(AdapterCallback adapterCallBack) {
        this.adapterCallBack = adapterCallBack;
    }

    @Override
    public void onItemLongClick(View viewClicked, final View parentView, int position, final boolean isRight) {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (!FuguMessageAdapter.this.onLinkLongClick) {
                    int positionInList = FuguMessageAdapter.this.recyclerView.getChildLayoutPosition(parentView);
                    if (positionInList != -1) {
                        Message message;
                        if (!Utils.preventMultipleClicks()) {
                            return;
                        }
                        BottomSheetMsgFragment sheetMsgFragment = BottomSheetMsgFragment.newInstance(positionInList, message, (message = (Message)FuguMessageAdapter.this.items.get(positionInList)).getUserId().compareTo(HippoApplication.getInstance().getUserData().getUserId()) == 0, isRight);
                        sheetMsgFragment.show(FuguMessageAdapter.this.context.getSupportFragmentManager(), BottomSheetMsgFragment.class.getSimpleName());
                    }
                } else {
                    FuguMessageAdapter.this.onLinkLongClick = false;
                }
            }
        }, 100L);
    }

    private void openBottomSheet() {
    }

    public long getItemId(int position) {
        try {
            return this.items.get(position).getMessageIndex();
        }
        catch (Exception e) {
            return position;
        }
    }

    @Override
    public void onItemClick(View viewClicked, View parentView, int position) {
        int positionInList = this.recyclerView.getChildLayoutPosition(parentView);
        if (positionInList != -1) {
            if (!Utils.preventMultipleClicks()) {
                return;
            }
            Message otherVideoMessage = this.items.get(positionInList);
            String fname = Utils.getFileName(otherVideoMessage.getFileName(), otherVideoMessage.getMuid());
            String localPath = FileManager.getInstance().getLocalPath(fname, (String)FOLDER_TYPE.get(otherVideoMessage.getDocumentType()));
            Intent intent = new Intent((Context)this.context, VideoPlayerActivity.class);
            intent.putExtra("url", localPath);
            intent.putExtra("title", otherVideoMessage.getFileName());
            this.context.startActivity(intent);
        }
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        switch (viewType) {
            case 0: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.fugu_item_message_date, parent, false);
                return new DateViewHolder(normalView);
            }
            case 1: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.afugu_item_message_left, parent, false);
                return new OtherMessageViewHolder(normalView, this);
            }
            case 2: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.fugu_item_message_right, parent, false);
                return new SelfMessageViewHolder(normalView, this);
            }
            case 3: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.fugu_item_assignment, parent, false);
                return new AssignmentViewHolder(normalView);
            }
            case 4: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_feedback_dialog, parent, false);
                return new RatingViewHolder(normalView);
            }
            case 5: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.lead_layout_item, parent, false);
                return new LeadFormViewHolder(normalView);
            }
            case 6: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_video_self_side, parent, false);
                return new SelfVideoViewHolder(normalView);
            }
            case 7: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_video_other_side, parent, false);
                return new VideoViewHolder(normalView);
            }
            case 8: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_layout_custom_action, parent, false);
                return new CustomViewHolder(normalView);
            }
            case 9: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_file_sent, parent, false);
                return new SentFileViewHolder(normalView);
            }
            case 10: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_file_received, parent, false);
                return new ReceivedFileViewHolder(normalView);
            }
            case 11: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_item_video_self, parent, false);
                return new SelfVideoMessageViewHolder(normalView, this);
            }
            case 12: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_item_video_other, parent, false);
                return new OtherVideoMessageViewHolder(normalView, this);
            }
            case 13: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_user_concent, parent, false);
                return new UserConcentViewHolder(normalView, this);
            }
            case 14: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_item_video_other, parent, false);
                return new OtherVideoMessageViewHolder(normalView, this);
            }
            case 15: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_item_video_self, parent, false);
                return new SelfVideoMessageViewHolder(normalView, this);
            }
            case 16: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_payment_view, parent, false);
                return new PaymentView(normalView);
            }
            case 17: {
                View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_multi_selection_view, parent, false);
                return new MultiSelectionView(normalView);
            }
        }
        View normalView = LayoutInflater.from((Context)this.context).inflate(R.layout.empty_layout_item, parent, false);
        return new EmptyViewHolder(normalView);
    }

    @TargetApi(value=21)
    public void onBindViewHolder(RecyclerView.ViewHolder holder, final int position) {
        int itemType = this.getItemViewType(position);
        if (itemType == 6) {
            SelfVideoViewHolder videoViewHolder = (SelfVideoViewHolder)holder;
            final Message videoMessage = this.items.get(position);
            String message = "";
            if (videoMessage.getMessageState() != null && videoMessage.getMessageState() == 2) {
                videoViewHolder.callAgain.setText((CharSequence)Restring.getString((Context)this.context, R.string.hippo_call_back));
                if (!TextUtils.isEmpty((CharSequence)videoMessage.getCallType()) && videoMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
                    message = Restring.getString((Context)this.context, R.string.hippo_missed_call);
                    videoViewHolder.tvDuration.setText((CharSequence)Restring.getString((Context)this.context, R.string.hippo_voice_call));
                } else {
                    message = Restring.getString((Context)this.context, R.string.hippo_missed_call);
                    videoViewHolder.tvDuration.setText((CharSequence)Restring.getString((Context)this.context, R.string.hippo_video_call));
                }
            } else {
                videoViewHolder.callAgain.setText((CharSequence)Restring.getString((Context)this.context, R.string.call_again));
                message = !TextUtils.isEmpty((CharSequence)videoMessage.getCallType()) && videoMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString()) ? Restring.getString((Context)this.context, R.string.hippo_voice_call_ended) : Restring.getString((Context)this.context, R.string.hippo_video_call_ended);
            }
            videoViewHolder.tvMsg.setText((CharSequence)message);
            if (videoMessage.getSentAtUtc().isEmpty()) {
                videoViewHolder.tvTime.setVisibility(8);
            } else {
                videoViewHolder.tvTime.setText((CharSequence)DateUtils.getTime(this.dateUtil.convertToLocal(videoMessage.getSentAtUtc())));
                videoViewHolder.tvTime.setVisibility(0);
            }
            if (videoMessage.getVideoCallDuration() > 0) {
                videoViewHolder.ivCallIcon.setVisibility(0);
                videoViewHolder.tvDuration.setVisibility(0);
                videoViewHolder.tvDuration.setText((CharSequence)(this.convertSeconds(videoMessage.getVideoCallDuration()) + ""));
            }
            boolean buttonFlag = false;
            if (!TextUtils.isEmpty((CharSequence)videoMessage.getCallType()) && videoMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
                if (!(this.isChatAssignToMe && HippoApplication.getInstance().getUserData().isAudioCallEnabled() && this.isAudioCallEnabled)) {
                    buttonFlag = true;
                }
            } else if (!(this.isChatAssignToMe && HippoApplication.getInstance().getUserData().isVideoCallEnabled() && this.isVideoCallEnabled)) {
                buttonFlag = true;
            }
            if (buttonFlag) {
                videoViewHolder.callAgain.setVisibility(8);
                videoViewHolder.dividerView.setVisibility(8);
            }
            videoViewHolder.callAgain.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (FuguMessageAdapter.this.onVideoCall != null) {
                        int callType = 1;
                        if (!TextUtils.isEmpty((CharSequence)videoMessage.getCallType()) && videoMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
                            callType = 2;
                        }
                        FuguMessageAdapter.this.onVideoCall.onVideoCallClicked(callType);
                    }
                }
            });
            String userNameText71 = "";
            try {
                if (!TextUtils.isEmpty((CharSequence)videoMessage.getfromName())) {
                    userNameText71 = videoMessage.getfromName().trim();
                }
            }
            catch (Exception e) {
                userNameText71 = videoMessage.getfromName();
            }
            videoViewHolder.tvUserName.setText((CharSequence)userNameText71);
            this.setUserName(videoViewHolder.tvUserName);
            this.loadUserImage(videoViewHolder.userImage, userNameText71, videoMessage.getUserImage());
        } else if (itemType == 7) {
            VideoViewHolder videoOtherViewHolder = (VideoViewHolder)holder;
            final Message videoOtherMessage = this.items.get(position);
            if (videoOtherMessage.getSentAtUtc().isEmpty()) {
                videoOtherViewHolder.tvTime.setVisibility(8);
            } else {
                videoOtherViewHolder.tvTime.setText((CharSequence)DateUtils.getTime(this.dateUtil.convertToLocal(videoOtherMessage.getSentAtUtc())));
                videoOtherViewHolder.tvTime.setVisibility(0);
            }
            String message = "";
            if (videoOtherMessage.getMessageState() != null && videoOtherMessage.getMessageState() == 2) {
                videoOtherViewHolder.callAgain.setText((CharSequence)Restring.getString((Context)this.context, R.string.hippo_call_back));
                if (!TextUtils.isEmpty((CharSequence)videoOtherMessage.getCallType()) && videoOtherMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
                    message = Restring.getString((Context)this.context, R.string.hippo_missed_call);
                    videoOtherViewHolder.tvDuration.setText((CharSequence)Restring.getString((Context)this.context, R.string.hippo_voice_call));
                } else {
                    message = Restring.getString((Context)this.context, R.string.hippo_missed_call);
                    videoOtherViewHolder.tvDuration.setText((CharSequence)Restring.getString((Context)this.context, R.string.hippo_video_call));
                }
            } else {
                videoOtherViewHolder.callAgain.setText((CharSequence)Restring.getString((Context)this.context, R.string.call_again));
                message = !TextUtils.isEmpty((CharSequence)videoOtherMessage.getCallType()) && videoOtherMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString()) ? Restring.getString((Context)this.context, R.string.hippo_voice_call_ended) : Restring.getString((Context)this.context, R.string.hippo_video_call_ended);
            }
            videoOtherViewHolder.tvMsg.setText((CharSequence)message);
            if (videoOtherMessage.getVideoCallDuration() > 0) {
                videoOtherViewHolder.ivCallIcon.setVisibility(0);
                videoOtherViewHolder.tvDuration.setVisibility(0);
                videoOtherViewHolder.tvDuration.setText((CharSequence)(this.convertSeconds(videoOtherMessage.getVideoCallDuration()) + ""));
            }
            boolean buttonFlag = false;
            if (!TextUtils.isEmpty((CharSequence)videoOtherMessage.getCallType()) && videoOtherMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
                if (!(this.isChatAssignToMe && HippoApplication.getInstance().getUserData().isAudioCallEnabled() && this.isAudioCallEnabled)) {
                    buttonFlag = true;
                }
            } else if (!(this.isChatAssignToMe && HippoApplication.getInstance().getUserData().isVideoCallEnabled() && this.isVideoCallEnabled)) {
                buttonFlag = true;
            }
            videoOtherViewHolder.callAgain.setVisibility(0);
            videoOtherViewHolder.callDivider.setVisibility(0);
            if (buttonFlag) {
                videoOtherViewHolder.callAgain.setVisibility(8);
                videoOtherViewHolder.callDivider.setVisibility(8);
            }
            String userNameText7 = "";
            try {
                if (!TextUtils.isEmpty((CharSequence)videoOtherMessage.getfromName())) {
                    userNameText7 = videoOtherMessage.getfromName().trim();
                }
            }
            catch (Exception e) {
                userNameText7 = videoOtherMessage.getfromName();
            }
            videoOtherViewHolder.tvUserName.setVisibility(0);
            videoOtherViewHolder.userImage.setVisibility(0);
            videoOtherViewHolder.tvUserName.setText((CharSequence)(userNameText7 + ""));
            this.loadUserImage(videoOtherViewHolder.userImage, userNameText7, videoOtherMessage.getUserImage());
            this.setUserName(videoOtherViewHolder.tvUserName);
            videoOtherViewHolder.callAgain.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (FuguMessageAdapter.this.onVideoCall != null) {
                        int callType = 1;
                        if (!TextUtils.isEmpty((CharSequence)videoOtherMessage.getCallType()) && videoOtherMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
                            callType = 2;
                        }
                        FuguMessageAdapter.this.onVideoCall.onVideoCallClicked(callType);
                    }
                }
            });
            if (videoOtherMessage.getMessageState() != null && videoOtherMessage.getMessageState() == 2) {
                videoOtherViewHolder.llChat.setBackgroundResource(R.drawable.missed_call_other);
                videoOtherViewHolder.ivCallIcon.setImageResource(R.drawable.ic_missed_call);
            } else {
                videoOtherViewHolder.llChat.setBackgroundResource(R.drawable.call_other);
                videoOtherViewHolder.ivCallIcon.setImageResource(R.drawable.ic_call_received_white);
            }
        } else if (itemType == 0) {
            DateViewHolder dateViewHolder = (DateViewHolder)holder;
            Message headerItem = this.items.get(position);
            if (headerItem.getDate().isEmpty()) {
                dateViewHolder.tvDate.setVisibility(8);
            } else {
                DateUtils.getInstance();
                String date = DateUtils.getDate(headerItem.getDate());
                if (date.equalsIgnoreCase("Today")) {
                    date = Restring.getString((Context)this.context, R.string.hippo_today);
                } else if (date.equalsIgnoreCase("Yesterday")) {
                    date = Restring.getString((Context)this.context, R.string.hippo_yesterday);
                }
                dateViewHolder.tvDate.setText((CharSequence)date);
                dateViewHolder.tvDate.setVisibility(0);
            }
        } else if (itemType == 1) {
            final OtherMessageViewHolder otherMessageViewHolder = (OtherMessageViewHolder)holder;
            final Message currentOrderItem = this.items.get(position);
            if (position == this.items.size() - 1) {
                Message lastMessage = this.items.get(position);
                this.context.lastMessage = lastMessage.getMessage();
            }
            if (currentOrderItem.getMessage().isEmpty()) {
                otherMessageViewHolder.tvMsg.setVisibility(4);
                LinearLayout.LayoutParams params2 = new LinearLayout.LayoutParams(-2, -1);
                params2.weight = 1.0f;
                params2.gravity = 0x800005;
                params2.bottomMargin = this.pxToDp(3);
                otherMessageViewHolder.rlMessages.setLayoutParams((ViewGroup.LayoutParams)params2);
            } else {
                otherMessageViewHolder.tvMsg.setText((CharSequence)currentOrderItem.getMessage());
                String msg = currentOrderItem.getMessage().replace(" ", "&nbsp;");
                otherMessageViewHolder.tvMsg.setText((CharSequence)Html.fromHtml((String)msg.replace("\n", "<br /> ")));
                otherMessageViewHolder.tvMsg.setVisibility(0);
            }
            otherMessageViewHolder.tvUserName.setText((CharSequence)currentOrderItem.getfromName());
            this.setIntegrationSource(otherMessageViewHolder.messageSourceType, otherMessageViewHolder.messageSourceType1, otherMessageViewHolder.messageSourceType2, currentOrderItem.getIntegrationSource());
            if (currentOrderItem.getSentAtUtc().isEmpty()) {
                otherMessageViewHolder.tvTime.setVisibility(8);
            } else {
                otherMessageViewHolder.tvTime.setText((CharSequence)DateUtils.getTime(this.dateUtil.convertToLocal(currentOrderItem.getSentAtUtc())));
                otherMessageViewHolder.tvTime.setVisibility(0);
            }
            String userNameText = "";
            if (!TextUtils.isEmpty((CharSequence)currentOrderItem.getfromName())) {
                userNameText = currentOrderItem.getfromName().trim();
            }
            int typePre = 0;
            if (position > 0) {
                typePre = this.getItemViewType(position - 1);
            }
            int typeNext = -1;
            if (position + 1 != this.items.size()) {
                typeNext = this.getItemViewType(position + 1);
            }
            boolean hasImage = this.checkLeftImage(position, typePre, typeNext, currentOrderItem);
            otherMessageViewHolder.userImage.setVisibility(4);
            otherMessageViewHolder.tvUserName.setVisibility(8);
            if (hasImage) {
                otherMessageViewHolder.tvUserName.setVisibility(0);
                otherMessageViewHolder.tvUserName.setText((CharSequence)userNameText);
                otherMessageViewHolder.userImage.setVisibility(0);
                this.loadUserImage(otherMessageViewHolder.userImage, userNameText, currentOrderItem.getUserImage());
                this.setUserName(otherMessageViewHolder.tvUserName);
                otherMessageViewHolder.llRoot.setPadding(0, this.pxToDp(20), 0, this.pxToDp(2));
            } else {
                otherMessageViewHolder.llRoot.setPadding(0, this.pxToDp(2), 0, this.pxToDp(2));
            }
            if (!currentOrderItem.getThumbnailUrl().isEmpty()) {
                LoadImageFile.getInstance().loadImage((Context)this.context, currentOrderItem.getThumbnailUrl(), otherMessageViewHolder.ivMsgImage);
                otherMessageViewHolder.rlImageMessage.setVisibility(0);
            } else {
                otherMessageViewHolder.rlImageMessage.setVisibility(8);
            }
            otherMessageViewHolder.rlImageMessage.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (FuguMessageAdapter.this.adapterCallBack != null) {
                        FuguMessageAdapter.this.adapterCallBack.showImageDialog((Activity)FuguMessageAdapter.this.context, currentOrderItem.getImageUrl(), otherMessageViewHolder.ivMsgImage, currentOrderItem);
                    } else {
                        FuguMessageAdapter.this.showImageDialog((Activity)FuguMessageAdapter.this.context, currentOrderItem.getImageUrl(), otherMessageViewHolder.ivMsgImage, currentOrderItem);
                    }
                }
            });
        } else if (itemType == 2) {
            boolean hasImage;
            final SelfMessageViewHolder selfMessageViewHolder = (SelfMessageViewHolder)holder;
            final Message currentOrderItem = this.items.get(position);
            if (currentOrderItem.getOriginalMessageType() == 3) {
                selfMessageViewHolder.llChat.setBackgroundResource(R.drawable.chat_self_bg_private);
            } else {
                selfMessageViewHolder.llChat.setBackgroundResource(R.drawable.chat_self_bg);
            }
            selfMessageViewHolder.tvName.setText((CharSequence)currentOrderItem.getfromName());
            if (currentOrderItem.getMessage().isEmpty()) {
                selfMessageViewHolder.tvMsg.setVisibility(4);
                LinearLayout.LayoutParams params2 = new LinearLayout.LayoutParams(-2, -1);
                params2.weight = 1.0f;
                params2.gravity = 0x800005;
                selfMessageViewHolder.rlMessages.setLayoutParams((ViewGroup.LayoutParams)params2);
            } else {
                String messageText = currentOrderItem.getMessage();
                if (currentOrderItem.getIsEdited() == 1) {
                    messageText = messageText + " <font  color='grey'><small> (edited)</small></font>";
                }
                this.setTextMessage(selfMessageViewHolder.tvMsg, messageText);
                selfMessageViewHolder.tvMsg.setVisibility(0);
            }
            if (currentOrderItem.getSentAtUtc().isEmpty()) {
                selfMessageViewHolder.tvTime.setVisibility(8);
            } else {
                selfMessageViewHolder.tvTime.setText((CharSequence)DateUtils.getTime(this.dateUtil.convertToLocal(currentOrderItem.getSentAtUtc())));
                selfMessageViewHolder.tvTime.setVisibility(0);
            }
            int typePre = 0;
            if (position > 0) {
                typePre = this.getItemViewType(position - 1);
            }
            int typeNext = -1;
            if (position + 1 != this.items.size()) {
                typeNext = this.getItemViewType(position + 1);
            }
            if (hasImage = this.checkRightImage(position, typePre, typeNext, currentOrderItem)) {
                selfMessageViewHolder.tvName.setVisibility(0);
                selfMessageViewHolder.userImage.setVisibility(0);
                this.loadUserImage(selfMessageViewHolder.userImage, currentOrderItem.getfromName(), currentOrderItem.getUserImage());
                this.setUserName(selfMessageViewHolder.tvName);
                selfMessageViewHolder.llRoot.setPadding(0, this.pxToDp(20), 0, this.pxToDp(2));
            } else {
                selfMessageViewHolder.userImage.setVisibility(4);
                selfMessageViewHolder.tvName.setVisibility(8);
                selfMessageViewHolder.llRoot.setPadding(0, this.pxToDp(2), 0, this.pxToDp(2));
            }
            this.setIntegrationSource(selfMessageViewHolder.messageSourceType, selfMessageViewHolder.messageSourceType1, selfMessageViewHolder.messageSourceType2, currentOrderItem.getIntegrationSource());
            try {
                switch (currentOrderItem.getMessageStatus()) {
                    case 4: 
                    case 5: 
                    case 6: {
                        selfMessageViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_ic_waiting));
                        selfMessageViewHolder.ivMessageState.setVisibility(0);
                        break;
                    }
                    case 3: {
                        selfMessageViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.agent_icon_blue_tick));
                        selfMessageViewHolder.ivMessageState.setVisibility(0);
                        break;
                    }
                    case 1: {
                        selfMessageViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_tick_single));
                        selfMessageViewHolder.ivMessageState.setVisibility(0);
                        break;
                    }
                    case 2: {
                        selfMessageViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.agent_icon_blue_tick));
                        selfMessageViewHolder.ivMessageState.setVisibility(0);
                        break;
                    }
                    default: {
                        selfMessageViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_tick_single));
                        selfMessageViewHolder.ivMessageState.setVisibility(0);
                        break;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            selfMessageViewHolder.btnRetry.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (FuguMessageAdapter.this.mOnRetry != null) {
                        selfMessageViewHolder.pbLoading.setVisibility(0);
                        selfMessageViewHolder.btnRetry.setVisibility(8);
                        String muid = currentOrderItem.getMuid();
                        FuguMessageAdapter.this.mOnRetry.onRetry(currentOrderItem.getImageUrl(), "image/*", currentOrderItem.getMessageIndex(), muid);
                    }
                }
            });
            if (currentOrderItem.getIsMessageExpired() == 1 && currentOrderItem.getOriginalMessageType() != 10) {
                selfMessageViewHolder.llRetry.setVisibility(0);
                selfMessageViewHolder.tvTryAgain.setTag((Object)position);
                selfMessageViewHolder.tvCancel.setTag((Object)position);
                selfMessageViewHolder.tvTryAgain.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (FuguMessageAdapter.this.mOnRetry != null) {
                            String muid = currentOrderItem.getMuid();
                            int pos = selfMessageViewHolder.getAdapterPosition();
                            FuguMessageAdapter.this.mOnRetry.onMessageRetry(muid, pos);
                        }
                    }
                });
                selfMessageViewHolder.tvCancel.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        int pos = selfMessageViewHolder.getAdapterPosition();
                        if (FuguMessageAdapter.this.mOnRetry != null) {
                            String muid = currentOrderItem.getMuid();
                            FuguMessageAdapter.this.mOnRetry.onMessageCancel(muid, pos);
                        }
                    }
                });
            } else {
                selfMessageViewHolder.llRetry.setVisibility(8);
            }
            selfMessageViewHolder.btnRetry.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (FuguMessageAdapter.this.mOnRetry != null) {
                        selfMessageViewHolder.pbLoading.setVisibility(0);
                        selfMessageViewHolder.btnRetry.setVisibility(8);
                        String muid = currentOrderItem.getMuid();
                        int pos = selfMessageViewHolder.getAdapterPosition();
                        FuguMessageAdapter.this.mOnRetry.onFileMessageRetry(muid, pos);
                    }
                }
            });
            selfMessageViewHolder.btnCancel.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (FuguMessageAdapter.this.mOnRetry != null) {
                        String muid = currentOrderItem.getMuid();
                        int pos = selfMessageViewHolder.getAdapterPosition();
                        FuguMessageAdapter.this.mOnRetry.onMessageCancel(muid, pos);
                    }
                }
            });
        } else if (itemType == 13) {
            UserConcentViewHolder userConcentViewHolder = (UserConcentViewHolder)holder;
            Message userConcentMessage = this.items.get(position);
            this.setBotSelfView(userConcentViewHolder.tvNameRight, userConcentViewHolder.tvMsgRight, userConcentViewHolder.tvTimeRight, userConcentViewHolder.llRootRight, userConcentViewHolder.llChatRight, userConcentViewHolder.rlMessagesRight, position, userConcentMessage);
            this.loadUserImage(userConcentViewHolder.userImageRight, userConcentMessage.getfromName(), userConcentMessage.getUserImage());
            this.setUserName(userConcentViewHolder.tvNameRight);
            String selectedBtnId = "";
            if (!TextUtils.isEmpty((CharSequence)userConcentMessage.getSelectedBtnId())) {
                selectedBtnId = userConcentMessage.getSelectedBtnId();
            }
            if (TextUtils.isEmpty((CharSequence)selectedBtnId)) {
                userConcentViewHolder.recyclerView.setVisibility(0);
                userConcentViewHolder.tvTagsTime.setVisibility(0);
                userConcentViewHolder.leftrootview.setVisibility(8);
                if (userConcentMessage.getSentAtUtc().isEmpty()) {
                    userConcentViewHolder.tvTagsTime.setVisibility(8);
                } else {
                    userConcentViewHolder.tvTagsTime.setText((CharSequence)DateUtils.getTime(this.dateUtil.convertToLocal(userConcentMessage.getSentAtUtc())));
                    userConcentViewHolder.tvTagsTime.setVisibility(0);
                }
                TagsAdapter tagsAdapter = new TagsAdapter((ArrayList)userConcentMessage.getContentValue());
                FlexboxLayoutManager flayoutManager = new FlexboxLayoutManager((Context)this.context);
                flayoutManager.setFlexDirection(0);
                flayoutManager.setJustifyContent(0);
                userConcentViewHolder.recyclerView.setLayoutManager((RecyclerView.LayoutManager)flayoutManager);
                userConcentViewHolder.recyclerView.setAdapter((RecyclerView.Adapter)tagsAdapter);
            } else {
                userConcentViewHolder.leftrootview.setVisibility(0);
                userConcentViewHolder.recyclerView.setVisibility(8);
                userConcentViewHolder.tvTagsTime.setVisibility(8);
                int selectedPosition = 0;
                for (int i = 0; i < userConcentMessage.getContentValue().size(); ++i) {
                    if (!selectedBtnId.equalsIgnoreCase(userConcentMessage.getContentValue().get(i).getBtnId())) continue;
                    selectedPosition = i;
                    break;
                }
                this.setBotOtherView(position, selectedPosition, userConcentViewHolder, userConcentMessage);
            }
            int typePre = 0;
            if (position > 0) {
                typePre = this.getItemViewType(position - 1);
            }
            int typeNext = -1;
            if (position + 1 != this.items.size()) {
                typeNext = this.getItemViewType(position + 1);
            }
            boolean hasImage = this.checkUserConsent(position, typePre, typeNext, userConcentMessage);
            userConcentViewHolder.userImageRight.setVisibility(4);
            userConcentViewHolder.tvNameRight.setVisibility(8);
            if (hasImage) {
                userConcentViewHolder.userImageRight.setVisibility(0);
                userConcentViewHolder.tvNameRight.setVisibility(0);
                this.loadUserImage(userConcentViewHolder.userImageRight, userConcentMessage.getfromName(), userConcentMessage.getUserImage());
                this.setUserName(userConcentViewHolder.tvNameRight);
                userConcentViewHolder.llRootRight.setPadding(0, this.pxToDp(20), 0, this.pxToDp(2));
            } else {
                userConcentViewHolder.llRootRight.setPadding(0, this.pxToDp(20), 0, this.pxToDp(2));
            }
            try {
                switch (userConcentMessage.getMessageStatus()) {
                    case 4: 
                    case 5: 
                    case 6: {
                        userConcentViewHolder.ivMessageStateRight.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_ic_waiting));
                        userConcentViewHolder.ivMessageStateRight.setVisibility(0);
                        break;
                    }
                    case 3: {
                        userConcentViewHolder.ivMessageStateRight.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.agent_icon_blue_tick));
                        userConcentViewHolder.ivMessageStateRight.setVisibility(0);
                        break;
                    }
                    case 1: {
                        userConcentViewHolder.ivMessageStateRight.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_tick_single));
                        userConcentViewHolder.ivMessageStateRight.setVisibility(0);
                        break;
                    }
                    case 2: {
                        userConcentViewHolder.ivMessageStateRight.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.agent_icon_blue_tick));
                        userConcentViewHolder.ivMessageStateRight.setVisibility(0);
                        break;
                    }
                    default: {
                        userConcentViewHolder.ivMessageStateRight.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_tick_single));
                        userConcentViewHolder.ivMessageStateRight.setVisibility(0);
                        break;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (itemType == 3) {
            AssignmentViewHolder assignmentViewHolder = (AssignmentViewHolder)holder;
            Message currentOrderItem = this.items.get(position);
            String message = currentOrderItem.getMessage();
            try {
                String key;
                String value;
                Pattern pattern;
                Matcher matcher;
                if (!TextUtils.isEmpty((CharSequence)currentOrderItem.getMultiLangMessage()) && (matcher = (pattern = Pattern.compile("\\{\\{\\{(.*?)\\}\\}\\}")).matcher(currentOrderItem.getMultiLangMessage())).find() && !TextUtils.isEmpty((CharSequence)(value = Restring.getString(key = matcher.group(1))))) {
                    String oldStr = "{{{" + key + "}}}";
                    message = currentOrderItem.getMultiLangMessage().replace(oldStr, value);
                }
            }
            catch (Exception pattern) {
                // empty catch block
            }
            assignmentViewHolder.tvAssignment.setText((CharSequence)Html.fromHtml((String)message));
        } else if (itemType == 4) {
            RatingViewHolder viewHolder = (RatingViewHolder)holder;
            Message currentMessage = this.items.get(position);
            if (currentMessage.isRatingGiven()) {
                viewHolder.ratingView1.setVisibility(8);
                viewHolder.ratingView2.setVisibility(0);
                int totalStar = currentMessage.getTotalRating();
                int givenStar = currentMessage.getRatingGiven();
                viewHolder.selectedStar.setText((CharSequence)(givenStar + "/" + totalStar));
                if (TextUtils.isEmpty((CharSequence)currentMessage.getComment())) {
                    viewHolder.comment.setVisibility(8);
                } else {
                    viewHolder.comment.setText((CharSequence)currentMessage.getComment());
                    viewHolder.comment.setVisibility(0);
                }
                viewHolder.thanksText.setText((CharSequence)Restring.getString((Context)this.context, R.string.hippo_thanks_feedback));
            } else {
                viewHolder.ratingView1.setVisibility(0);
                viewHolder.ratingView2.setVisibility(8);
                viewHolder.ratingView.setRating(0.0f);
            }
            String message = currentMessage.getMessage();
            try {
                String key;
                String value;
                Pattern pattern;
                Matcher matcher;
                if (!TextUtils.isEmpty((CharSequence)currentMessage.getMultiLangMessage()) && (matcher = (pattern = Pattern.compile("\\{\\{\\{(.*?)\\}\\}\\}")).matcher(currentMessage.getMultiLangMessage())).find() && !TextUtils.isEmpty((CharSequence)(value = Restring.getString(key = matcher.group(1))))) {
                    String oldStr = "{{{" + key + "}}}";
                    message = currentMessage.getMultiLangMessage().replace(oldStr, value);
                }
            }
            catch (Exception pattern) {
                // empty catch block
            }
            viewHolder.title.setText((CharSequence)message);
            viewHolder.userName.setText((CharSequence)currentMessage.getfromName());
            this.loadUserImage(viewHolder.userImage, currentMessage.getfromName(), currentMessage.getUserImage());
            this.setUserName(viewHolder.userName);
        } else if (itemType == 5) {
            LeadFormViewHolder viewHolder = (LeadFormViewHolder)holder;
            Message currentMessage = this.items.get(position);
            this.setLeadFormData(viewHolder.lead_form_data, currentMessage);
            viewHolder.tvUserName.setText((CharSequence)currentMessage.getfromName());
            this.loadUserImage(viewHolder.userImage, currentMessage.getfromName(), currentMessage.getUserImage());
            this.setUserName(viewHolder.tvUserName);
        } else if (itemType == 8) {
            CustomViewHolder customViewHolder = (CustomViewHolder)holder;
            Message currentOrderItem = this.items.get(position);
            CustomAction customAction = currentOrderItem.getCustomAction();
            customViewHolder.userName.setText((CharSequence)currentOrderItem.getfromName());
            this.setUserName(customViewHolder.userName);
            this.loadUserImage(customViewHolder.userImage, currentOrderItem.getfromName(), currentOrderItem.getUserImage());
            if (customAction != null) {
                if (customAction.getTitle() != null && !TextUtils.isEmpty((CharSequence)customAction.getTitle())) {
                    customViewHolder.tvActionTitle.setVisibility(0);
                    customViewHolder.tvActionTitle.setText((CharSequence)customAction.getTitle());
                    customViewHolder.tvActionTitle.setTextColor(this.fuguColorConfig.getFuguPrimaryTextMsgFrom());
                } else {
                    customViewHolder.tvActionTitle.setVisibility(8);
                }
                if (customAction.getTitleDescription() != null && !TextUtils.isEmpty((CharSequence)customAction.getTitleDescription())) {
                    customViewHolder.tvActionTitleDescription.setVisibility(0);
                    customViewHolder.tvActionTitleDescription.setText((CharSequence)customAction.getTitleDescription());
                    customViewHolder.tvActionTitleDescription.setTextColor(this.fuguColorConfig.getFuguPrimaryTextMsgFrom());
                } else {
                    customViewHolder.tvActionTitleDescription.setVisibility(8);
                }
                if (customAction.getImageUrl() != null && !TextUtils.isEmpty((CharSequence)customAction.getImageUrl())) {
                    customViewHolder.ivActionImage.setVisibility(0);
                    LoadImageFile.getInstance().loadImage((Context)this.context, customAction.getImageUrl(), R.drawable.placeholder, customViewHolder.ivActionImage, 1);
                } else {
                    customViewHolder.ivActionImage.setVisibility(8);
                }
                if (customAction.getDescriptionObjects() != null && customAction.getDescriptionObjects().size() != 0) {
                    customViewHolder.rvActionDescription.setVisibility(0);
                    customViewHolder.rvActionDescription.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.context));
                    customViewHolder.rvActionDescription.setNestedScrollingEnabled(false);
                    customViewHolder.rvActionDescription.setAdapter((RecyclerView.Adapter)new CustomActionDescriptionAdapter((Context)this.context, customAction.getDescriptionObjects()));
                } else {
                    customViewHolder.rvActionDescription.setVisibility(8);
                }
                if (customAction.getActionButtons() != null && customAction.getActionButtons().size() != 0) {
                    customViewHolder.vwActionButtonDivider.setVisibility(0);
                    customViewHolder.rvActionButtons.setVisibility(0);
                    customViewHolder.rvActionButtons.setNestedScrollingEnabled(false);
                    int span = 2;
                    int size = customAction.getActionButtons().size();
                    span = size == 1 ? 1 : (size % 3 == 0 ? 3 : 2);
                    customViewHolder.rvActionButtons.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager((Context)this.context, span));
                    customViewHolder.rvActionButtons.addItemDecoration((RecyclerView.ItemDecoration)new GridDividerItemDecoration((Context)this.context));
                    customViewHolder.rvActionButtons.setAdapter((RecyclerView.Adapter)new CustomActionButtonsAdapter((Context)this.context, customAction.getActionButtons()));
                } else {
                    customViewHolder.vwActionButtonDivider.setVisibility(8);
                    customViewHolder.rvActionButtons.setVisibility(8);
                }
            }
        } else if (itemType == 9) {
            boolean hasImage;
            Integer dimage;
            final SentFileViewHolder sentFileViewHolder = (SentFileViewHolder)holder;
            final Message fileSentMessage = this.items.get(position);
            this.setIntegrationSource(sentFileViewHolder.messageSourceType, sentFileViewHolder.messageSourceType1, sentFileViewHolder.messageSourceType2, fileSentMessage.getIntegrationSource());
            sentFileViewHolder.circleProgress.setBarColor(ContextCompat.getColor((Context)this.context, (int)R.color.colorPrimary));
            String fileExt = Utils.getExtension(fileSentMessage.getFileName());
            if (TextUtils.isEmpty((CharSequence)fileExt)) {
                fileExt = Utils.getExtension(fileSentMessage.getFileUrl());
            }
            if ((dimage = (Integer)IMAGE_MAP.get(fileExt.toLowerCase())) != null) {
                sentFileViewHolder.ivFileImage.setImageResource(dimage.intValue());
            } else {
                sentFileViewHolder.ivFileImage.setImageResource(R.drawable.hippo_attachment);
            }
            sentFileViewHolder.tvFileName.setText((CharSequence)fileSentMessage.getFileName());
            if (fileExt.length() > 4) {
                fileExt = fileExt.substring(0, 4) + "..";
            }
            sentFileViewHolder.tvFileExtension.setText((CharSequence)fileExt);
            if (!TextUtils.isEmpty((CharSequence)fileSentMessage.getFileSize())) {
                try {
                    sentFileViewHolder.tvFileSize.setText((CharSequence)fileSentMessage.getFileSize());
                }
                catch (Exception e) {
                    sentFileViewHolder.tvFileSize.setText((CharSequence)fileSentMessage.getFileSize());
                }
            }
            this.messageStatusTick(sentFileViewHolder.ivMessageState, fileSentMessage);
            this.setFileUploadStatus(sentFileViewHolder.ivFileImage, sentFileViewHolder.ivFilePlay, sentFileViewHolder.circleProgress, sentFileViewHolder.ivFileDownload, sentFileViewHolder.ivFileUpload, fileSentMessage, position);
            this.setDownloadClick(sentFileViewHolder.ivFileDownload, sentFileViewHolder.circleProgress, fileSentMessage, position);
            this.setUploadClick(sentFileViewHolder.ivFileUpload, sentFileViewHolder.circleProgress, fileSentMessage);
            sentFileViewHolder.ivFilePlay.setImageResource(R.drawable.hippo_music_player);
            if (!fileSentMessage.isAudioPlaying()) {
                sentFileViewHolder.ivFilePlay.setImageResource(R.drawable.hippo_music_player);
            } else {
                sentFileViewHolder.ivFilePlay.setImageResource(R.drawable.hippo_song_pause);
            }
            this.setFileCLickListener(sentFileViewHolder.llMessage, fileSentMessage, sentFileViewHolder.ivFilePlay, position);
            sentFileViewHolder.ivFileUpload.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int pos = sentFileViewHolder.getAdapterPosition();
                    if (FuguMessageAdapter.this.mOnRetry != null) {
                        FuguMessageAdapter.this.mOnRetry.onFileMessageRetry(fileSentMessage.getMuid(), pos);
                    }
                }
            });
            if (fileSentMessage.getSentAtUtc().isEmpty()) {
                sentFileViewHolder.tvFileTime.setVisibility(8);
            } else {
                sentFileViewHolder.tvFileTime.setText((CharSequence)DateUtils.getTime(this.dateUtil.convertToLocal(fileSentMessage.getSentAtUtc())));
                sentFileViewHolder.tvFileTime.setVisibility(0);
            }
            int typePre = 0;
            if (position > 0) {
                typePre = this.getItemViewType(position - 1);
            }
            int typeNext = -1;
            if (position + 1 != this.items.size()) {
                typeNext = this.getItemViewType(position + 1);
            }
            if (hasImage = this.checkRightImage(position, typePre, typeNext, fileSentMessage)) {
                sentFileViewHolder.tvName.setText((CharSequence)fileSentMessage.getfromName());
                sentFileViewHolder.tvName.setVisibility(0);
                sentFileViewHolder.userImage.setVisibility(0);
                this.loadUserImage(sentFileViewHolder.userImage, fileSentMessage.getfromName(), fileSentMessage.getUserImage());
                this.setUserName(sentFileViewHolder.tvName);
                sentFileViewHolder.llRoot.setPadding(0, this.pxToDp(20), 0, this.pxToDp(2));
            } else {
                sentFileViewHolder.userImage.setVisibility(4);
                sentFileViewHolder.tvName.setVisibility(8);
                sentFileViewHolder.llRoot.setPadding(0, this.pxToDp(2), 0, this.pxToDp(2));
            }
        } else if (itemType == 10) {
            String fileExt;
            String receivedFileExt;
            Integer dimage1;
            ReceivedFileViewHolder fHolder = (ReceivedFileViewHolder)holder;
            Message fileReceivedMessage = this.items.get(position);
            fHolder.progressBar.setBarColor(ContextCompat.getColor((Context)this.context, (int)R.color.colorPrimary));
            this.setIntegrationSource(fHolder.messageSourceType, fHolder.messageSourceType1, fHolder.messageSourceType2, fileReceivedMessage.getIntegrationSource());
            String fuserNameText = "";
            if (!TextUtils.isEmpty((CharSequence)fileReceivedMessage.getfromName())) {
                fuserNameText = fileReceivedMessage.getfromName().trim();
            }
            if ((dimage1 = (Integer)IMAGE_MAP.get((receivedFileExt = Utils.getExtension(fileReceivedMessage.getFileUrl())).toLowerCase())) != null) {
                fHolder.ivFileImage.setImageResource(dimage1.intValue());
            } else {
                fHolder.ivFileImage.setImageResource(R.drawable.hippo_attachment);
            }
            fHolder.tvFileName.setText((CharSequence)fileReceivedMessage.getFileName());
            String string2 = fileExt = TextUtils.isEmpty((CharSequence)fileReceivedMessage.getFileExtension()) ? receivedFileExt : fileReceivedMessage.getFileExtension();
            if (fileExt.length() > 4) {
                fileExt = fileExt.substring(0, 4) + "..";
            }
            fHolder.tvFileExtension.setText((CharSequence)fileExt);
            fHolder.tvFileSize.setText((CharSequence)fileReceivedMessage.getFileSize());
            this.setFileDownLoadStatus(fHolder.ivFileImage, fHolder.ivFilePlay, fHolder.progressBar, fHolder.ivFileDownload, fHolder.ivFileUpload, fileReceivedMessage, position);
            this.setDownloadClick(fHolder.ivFileDownload, fHolder.progressBar, fileReceivedMessage, position);
            if (!fileReceivedMessage.isAudioPlaying()) {
                fHolder.ivFilePlay.setImageResource(R.drawable.hippo_music_player);
            } else {
                fHolder.ivFilePlay.setImageResource(R.drawable.hippo_song_pause);
            }
            this.setFileCLickListener(fHolder.llMessage, fileReceivedMessage, fHolder.ivFilePlay, position);
            if (fileReceivedMessage.getSentAtUtc().isEmpty()) {
                fHolder.tvFileTime.setVisibility(8);
            } else {
                fHolder.tvFileTime.setText((CharSequence)DateUtils.getTime(this.dateUtil.convertToLocal(fileReceivedMessage.getSentAtUtc())));
                fHolder.tvFileTime.setVisibility(0);
            }
            int typePre = 0;
            if (position > 0) {
                typePre = this.getItemViewType(position - 1);
            }
            int typeNext = -1;
            if (position + 1 != this.items.size()) {
                typeNext = this.getItemViewType(position + 1);
            }
            boolean hasImage = this.checkLeftImage(position, typePre, typeNext, fileReceivedMessage);
            fHolder.userImage.setVisibility(4);
            fHolder.tvUserName.setVisibility(8);
            if (hasImage) {
                fHolder.tvUserName.setVisibility(0);
                fHolder.tvUserName.setText((CharSequence)fileReceivedMessage.getfromName());
                fHolder.userImage.setVisibility(0);
                this.loadUserImage(fHolder.userImage, fileReceivedMessage.getfromName(), fileReceivedMessage.getUserImage());
                this.setUserName(fHolder.tvUserName);
                fHolder.llRoot.setPadding(0, this.pxToDp(20), 0, this.pxToDp(2));
            } else {
                fHolder.llRoot.setPadding(0, this.pxToDp(2), 0, this.pxToDp(2));
            }
        } else if (itemType == 11) {
            boolean hasImage;
            final SelfVideoMessageViewHolder selfVideoMessageViewHolder = (SelfVideoMessageViewHolder)holder;
            final Message selfVideoMessage = this.items.get(position);
            this.setIntegrationSource(selfVideoMessageViewHolder.messageSourceType, selfVideoMessageViewHolder.messageSourceType1, selfVideoMessageViewHolder.messageSourceType2, selfVideoMessage.getIntegrationSource());
            selfVideoMessageViewHolder.circle_progress.setBarColor(ContextCompat.getColor((Context)this.context, (int)R.color.colorPrimary));
            this.setTime(selfVideoMessageViewHolder.tvImageTime, selfVideoMessage.getSentAtUtc());
            this.setMessageStatus(selfVideoMessageViewHolder.ivMessageState, selfVideoMessage.getMessageStatus(), true);
            if (!TextUtils.isEmpty((CharSequence)selfVideoMessage.getThumbnailUrl())) {
                this.setImage((Activity)this.context, selfVideoMessageViewHolder.ivImageMsg, selfVideoMessage.getThumbnailUrl());
            } else {
                selfVideoMessageViewHolder.ivImageMsg.setVisibility(8);
            }
            int typePre = 0;
            if (position > 0) {
                typePre = this.getItemViewType(position - 1);
            }
            int typeNext = -1;
            if (position + 1 != this.items.size()) {
                typeNext = this.getItemViewType(position + 1);
            }
            if (hasImage = this.checkRightImage(position, typePre, typeNext, selfVideoMessage)) {
                selfVideoMessageViewHolder.userName.setVisibility(0);
                selfVideoMessageViewHolder.userImage.setVisibility(0);
                this.loadUserImage(selfVideoMessageViewHolder.userImage, selfVideoMessage.getfromName(), selfVideoMessage.getUserImage());
                this.setUserName(selfVideoMessageViewHolder.userName);
                selfVideoMessageViewHolder.llRoot.setPadding(0, this.pxToDp(20), 0, this.pxToDp(2));
            } else {
                selfVideoMessageViewHolder.userImage.setVisibility(4);
                selfVideoMessageViewHolder.userName.setVisibility(8);
                selfVideoMessageViewHolder.llRoot.setPadding(0, this.pxToDp(2), 0, this.pxToDp(2));
            }
            selfVideoMessageViewHolder.ivPlay.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (!Utils.preventMultipleClicks()) {
                        return;
                    }
                    String fname = Utils.getFileName(selfVideoMessage.getFileName(), selfVideoMessage.getMuid());
                    String localPath = FileManager.getInstance().getLocalPath(fname, FuguAppConstant.FOLDER_TYPE.get(selfVideoMessage.getDocumentType()));
                    if (TextUtils.isEmpty((CharSequence)localPath)) {
                        localPath = selfVideoMessage.getFileUrl();
                    }
                    Intent intent = new Intent((Context)FuguMessageAdapter.this.context, VideoPlayerActivity.class);
                    intent.putExtra("url", localPath);
                    intent.putExtra("title", selfVideoMessage.getFileName());
                    FuguMessageAdapter.this.context.startActivity(intent);
                }
            });
            this.setVideoUiStatus(true, selfVideoMessage, selfVideoMessageViewHolder.llDownload, selfVideoMessageViewHolder.ivPlay, selfVideoMessageViewHolder.btnRetry, selfVideoMessageViewHolder.btnCancel, selfVideoMessageViewHolder.circle_progress, false);
            selfVideoMessageViewHolder.btnCancel.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int pos = selfVideoMessageViewHolder.getAdapterPosition();
                    if (FuguMessageAdapter.this.mOnRetry != null) {
                        FuguMessageAdapter.this.mOnRetry.onMessageCancel(selfVideoMessage.getMuid(), pos);
                    }
                }
            });
            selfVideoMessageViewHolder.btnRetry.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int pos = selfVideoMessageViewHolder.getAdapterPosition();
                    if (FuguMessageAdapter.this.mOnRetry != null) {
                        FuguMessageAdapter.this.mOnRetry.onFileMessageRetry(selfVideoMessage.getMuid(), pos);
                    }
                }
            });
            selfVideoMessageViewHolder.llDownload.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    String fullPath;
                    File file;
                    String fileName;
                    selfVideoMessageViewHolder.circle_progress.setVisibility(0);
                    selfVideoMessageViewHolder.llDownload.setVisibility(8);
                    String docType = "video";
                    if (selfVideoMessage.getOriginalMessageType() == 11) {
                        docType = selfVideoMessage.getDocumentType();
                    }
                    if (TextUtils.isEmpty((CharSequence)(fileName = selfVideoMessage.getFileName()))) {
                        String timeStamp = new SimpleDateFormat("ddMMyyyy_hhmmss", Locale.ENGLISH).format(new Date());
                        fileName = "Hippochat_" + timeStamp + ".jpg";
                    }
                    if (!(file = new File(fullPath = Utils.getDirectoryPath(FuguAppConstant.FOLDER_TYPE.get(docType)))).exists()) {
                        file.mkdir();
                    }
                    int downloadId = FuguMessageAdapter.this.downloadFileFromUrl(fullPath, fileName, selfVideoMessage, position);
                    selfVideoMessage.setDownloadId(downloadId);
                }
            });
        } else if (itemType == 12) {
            final OtherVideoMessageViewHolder otherVideoMessageViewHolder = (OtherVideoMessageViewHolder)holder;
            final Message otherVideoMessage = this.items.get(position);
            otherVideoMessageViewHolder.progressBar.setBarColor(ContextCompat.getColor((Context)this.context, (int)R.color.colorPrimary));
            this.setTime(otherVideoMessageViewHolder.tvImageTime, otherVideoMessage.getSentAtUtc());
            if (!TextUtils.isEmpty((CharSequence)otherVideoMessage.getThumbnailUrl())) {
                this.setImage((Activity)this.context, otherVideoMessageViewHolder.ivImageMsg, otherVideoMessage.getThumbnailUrl());
            } else {
                otherVideoMessageViewHolder.ivImageMsg.setVisibility(8);
            }
            this.setVideoDownloadStatus(otherVideoMessageViewHolder.llDownload, otherVideoMessageViewHolder.ivPlay, otherVideoMessageViewHolder.tvFileSize, otherVideoMessageViewHolder.progressBar, otherVideoMessage, position);
            this.setIntegrationSource(otherVideoMessageViewHolder.messageSourceType, otherVideoMessageViewHolder.messageSourceType1, otherVideoMessageViewHolder.messageSourceType2, otherVideoMessage.getIntegrationSource());
            String vuserNameText = "";
            if (!TextUtils.isEmpty((CharSequence)otherVideoMessage.getfromName())) {
                vuserNameText = otherVideoMessage.getfromName().trim();
            }
            int typePre = 0;
            if (position > 0) {
                typePre = this.getItemViewType(position - 1);
            }
            int typeNext = -1;
            if (position + 1 != this.items.size()) {
                typeNext = this.getItemViewType(position + 1);
            }
            boolean hasImage = this.checkLeftImage(position, typePre, typeNext, otherVideoMessage);
            otherVideoMessageViewHolder.userImage.setVisibility(4);
            otherVideoMessageViewHolder.tvUserName.setVisibility(8);
            if (hasImage) {
                otherVideoMessageViewHolder.tvUserName.setVisibility(0);
                otherVideoMessageViewHolder.tvUserName.setText((CharSequence)vuserNameText);
                otherVideoMessageViewHolder.userImage.setVisibility(0);
                this.loadUserImage(otherVideoMessageViewHolder.userImage, vuserNameText, otherVideoMessage.getUserImage());
                this.setUserName(otherVideoMessageViewHolder.tvUserName);
                otherVideoMessageViewHolder.llRoot.setPadding(0, this.pxToDp(20), 0, this.pxToDp(2));
            } else {
                otherVideoMessageViewHolder.llRoot.setPadding(0, this.pxToDp(2), 0, this.pxToDp(2));
            }
            otherVideoMessageViewHolder.llDownload.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (FuguMessageAdapter.this.context.isNetworkAvailable()) {
                        String fullPath;
                        File file;
                        String fileName;
                        otherVideoMessageViewHolder.progressBar.setVisibility(0);
                        otherVideoMessageViewHolder.llDownload.setVisibility(8);
                        String docType = "video";
                        if (otherVideoMessage.getOriginalMessageType() == 11) {
                            docType = otherVideoMessage.getDocumentType();
                        }
                        if (TextUtils.isEmpty((CharSequence)(fileName = otherVideoMessage.getFileName()))) {
                            String timeStamp = new SimpleDateFormat("ddMMyyyy_hhmmss", Locale.ENGLISH).format(new Date());
                            fileName = "Hippochat_" + timeStamp + ".jpg";
                        }
                        if (!(file = new File(fullPath = Utils.getDirectoryPath(FuguAppConstant.FOLDER_TYPE.get(docType)))).exists()) {
                            file.mkdir();
                        }
                        int downloadId = FuguMessageAdapter.this.downloadFileFromUrl(fullPath, fileName, otherVideoMessage, position);
                        otherVideoMessage.setDownloadId(downloadId);
                    } else {
                        Toast.makeText((Context)FuguMessageAdapter.this.context, (CharSequence)FuguMessageAdapter.this.context.getString(R.string.fugu_unable_to_connect_internet), (int)0).show();
                    }
                }
            });
        } else if (itemType == 14) {
            final OtherVideoMessageViewHolder otherVideoMessageViewHolder = (OtherVideoMessageViewHolder)holder;
            final Message otherVideoMessage = this.items.get(position);
            otherVideoMessageViewHolder.progressBar.setBarColor(ContextCompat.getColor((Context)this.context, (int)R.color.colorPrimary));
            this.setTime(otherVideoMessageViewHolder.tvImageTime, otherVideoMessage.getSentAtUtc());
            otherVideoMessageViewHolder.llDownload.setVisibility(8);
            otherVideoMessageViewHolder.ivPlay.setVisibility(8);
            otherVideoMessageViewHolder.tvFileSize.setVisibility(8);
            this.setIntegrationSource(otherVideoMessageViewHolder.messageSourceType, otherVideoMessageViewHolder.messageSourceType1, otherVideoMessageViewHolder.messageSourceType2, otherVideoMessage.getIntegrationSource());
            String vuserNameText = otherVideoMessage.getfromName();
            int typePre = 0;
            if (position > 0) {
                typePre = this.getItemViewType(position - 1);
            }
            int typeNext = -1;
            if (position + 1 != this.items.size()) {
                typeNext = this.getItemViewType(position + 1);
            }
            boolean hasImage = this.checkLeftImage(position, typePre, typeNext, otherVideoMessage);
            otherVideoMessageViewHolder.userImage.setVisibility(4);
            otherVideoMessageViewHolder.tvUserName.setVisibility(8);
            if (hasImage) {
                otherVideoMessageViewHolder.tvUserName.setVisibility(0);
                otherVideoMessageViewHolder.tvUserName.setText((CharSequence)vuserNameText);
                otherVideoMessageViewHolder.userImage.setVisibility(0);
                this.loadUserImage(otherVideoMessageViewHolder.userImage, vuserNameText, otherVideoMessage.getUserImage());
                this.setUserName(otherVideoMessageViewHolder.tvUserName);
                otherVideoMessageViewHolder.llRoot.setPadding(0, this.pxToDp(20), 0, this.pxToDp(2));
            } else {
                otherVideoMessageViewHolder.llRoot.setPadding(0, this.pxToDp(2), 0, this.pxToDp(2));
            }
            if (!TextUtils.isEmpty((CharSequence)otherVideoMessage.getThumbnailUrl())) {
                this.setImage((Activity)this.context, otherVideoMessageViewHolder.ivImageMsg, otherVideoMessage.getThumbnailUrl());
            } else {
                otherVideoMessageViewHolder.ivImageMsg.setVisibility(8);
            }
            otherVideoMessageViewHolder.ivImageMsg.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (FuguMessageAdapter.this.adapterCallBack != null) {
                        FuguMessageAdapter.this.adapterCallBack.showImageDialog((Activity)FuguMessageAdapter.this.context, otherVideoMessage.getImageUrl(), (ImageView)otherVideoMessageViewHolder.ivImageMsg, otherVideoMessage);
                    } else {
                        FuguMessageAdapter.this.showImageDialog((Activity)FuguMessageAdapter.this.context, otherVideoMessage.getImageUrl(), (ImageView)otherVideoMessageViewHolder.ivImageMsg, otherVideoMessage);
                    }
                }
            });
        } else if (itemType == 15) {
            boolean hasImage;
            final SelfVideoMessageViewHolder selfImageMessageViewHolder = (SelfVideoMessageViewHolder)holder;
            final Message selfVideoMessage = this.items.get(position);
            this.setIntegrationSource(selfImageMessageViewHolder.messageSourceType, selfImageMessageViewHolder.messageSourceType1, selfImageMessageViewHolder.messageSourceType2, selfVideoMessage.getIntegrationSource());
            selfImageMessageViewHolder.circle_progress.setBarColor(ContextCompat.getColor((Context)this.context, (int)R.color.colorPrimary));
            this.setTime(selfImageMessageViewHolder.tvImageTime, selfVideoMessage.getSentAtUtc());
            this.setMessageStatus(selfImageMessageViewHolder.ivMessageState, selfVideoMessage.getMessageStatus(), true);
            if (!TextUtils.isEmpty((CharSequence)selfVideoMessage.getThumbnailUrl())) {
                this.setImage((Activity)this.context, selfImageMessageViewHolder.ivImageMsg, selfVideoMessage.getThumbnailUrl());
            } else {
                selfImageMessageViewHolder.ivImageMsg.setVisibility(8);
            }
            selfImageMessageViewHolder.ivPlay.setVisibility(8);
            final boolean isClickable = this.setVideoUiStatus(true, selfVideoMessage, selfImageMessageViewHolder.llDownload, selfImageMessageViewHolder.ivPlay, selfImageMessageViewHolder.btnRetry, selfImageMessageViewHolder.btnCancel, selfImageMessageViewHolder.circle_progress, true);
            selfImageMessageViewHolder.btnCancel.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int pos = selfImageMessageViewHolder.getAdapterPosition();
                    if (FuguMessageAdapter.this.mOnRetry != null) {
                        FuguMessageAdapter.this.mOnRetry.onMessageCancel(selfVideoMessage.getMuid(), pos);
                    }
                }
            });
            selfImageMessageViewHolder.btnRetry.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int pos = selfImageMessageViewHolder.getAdapterPosition();
                    if (FuguMessageAdapter.this.mOnRetry != null) {
                        FuguMessageAdapter.this.mOnRetry.onFileMessageRetry(selfVideoMessage.getMuid(), pos);
                    }
                }
            });
            selfImageMessageViewHolder.ivImageMsg.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (isClickable) {
                        if (FuguMessageAdapter.this.adapterCallBack != null) {
                            FuguMessageAdapter.this.adapterCallBack.showImageDialog((Activity)FuguMessageAdapter.this.context, selfVideoMessage.getImageUrl(), (ImageView)selfImageMessageViewHolder.ivImageMsg, selfVideoMessage);
                        } else {
                            FuguMessageAdapter.this.showImageDialog((Activity)FuguMessageAdapter.this.context, selfVideoMessage.getImageUrl(), (ImageView)selfImageMessageViewHolder.ivImageMsg, selfVideoMessage);
                        }
                    }
                }
            });
            int typePre = 0;
            if (position > 0) {
                typePre = this.getItemViewType(position - 1);
            }
            int typeNext = -1;
            if (position + 1 != this.items.size()) {
                typeNext = this.getItemViewType(position + 1);
            }
            if (hasImage = this.checkRightImage(position, typePre, typeNext, selfVideoMessage)) {
                selfImageMessageViewHolder.userName.setText((CharSequence)selfVideoMessage.getfromName());
                selfImageMessageViewHolder.userName.setVisibility(0);
                selfImageMessageViewHolder.userImage.setVisibility(0);
                this.loadUserImage(selfImageMessageViewHolder.userImage, selfVideoMessage.getfromName(), selfVideoMessage.getUserImage());
                this.setUserName(selfImageMessageViewHolder.userName);
                selfImageMessageViewHolder.llRoot.setPadding(0, this.pxToDp(20), 0, this.pxToDp(2));
            } else {
                selfImageMessageViewHolder.userImage.setVisibility(4);
                selfImageMessageViewHolder.userName.setVisibility(8);
                selfImageMessageViewHolder.llRoot.setPadding(0, this.pxToDp(2), 0, this.pxToDp(2));
            }
        } else if (itemType == 16) {
            PaymentView paymentView = (PaymentView)holder;
            Message paymentMsg = this.items.get(position);
            LinearLayoutManager paymentLayoutManager = new LinearLayoutManager((Context)this.context);
            paymentLayoutManager.setOrientation(1);
            paymentView.recyclerView.setLayoutManager((RecyclerView.LayoutManager)paymentLayoutManager);
            PaymentAdapter paymentAdapter = new PaymentAdapter(paymentMsg, paymentMsg.getCustomAction().getHippoPayment(), paymentMsg.getCustomAction().getSelectedId());
            paymentView.recyclerView.setAdapter((RecyclerView.Adapter)paymentAdapter);
        } else if (itemType == 17) {
            MultiSelectionView selectionView = (MultiSelectionView)holder;
            Message selectionMsg = this.items.get(position);
            LinearLayoutManager paymentLayoutManager = new LinearLayoutManager((Context)this.context);
            paymentLayoutManager.setOrientation(1);
            selectionView.recyclerView.setLayoutManager((RecyclerView.LayoutManager)paymentLayoutManager);
            boolean isMultiSelected = true;
            int max = -1;
            try {
                max = selectionMsg.getCustomAction().getMaxSelection();
                if (selectionMsg.getCustomAction().getMinSelection() < 1) {
                    max = -1;
                }
                if (selectionMsg.getCustomAction().getMinSelection() == 1 && selectionMsg.getCustomAction().getMaxSelection() == 1) {
                    isMultiSelected = false;
                }
            }
            catch (Exception hasImage) {
                // empty catch block
            }
            MultiSelectionAdapter adapter = new MultiSelectionAdapter(selectionMsg.getCustomAction().getMultiSelectButtons(), isMultiSelected);
            selectionView.recyclerView.setAdapter((RecyclerView.Adapter)adapter);
            selectionView.tvUserName.setText((CharSequence)selectionMsg.getfromName());
            selectionView.tvMsg.setText((CharSequence)selectionMsg.getMessage());
            if (selectionMsg.getSentAtUtc().isEmpty()) {
                selectionView.tvTime.setVisibility(8);
            } else {
                selectionView.tvTime.setText((CharSequence)DateUtils.getTime(this.dateUtil.convertToLocal(selectionMsg.getSentAtUtc())));
                selectionView.tvTime.setVisibility(0);
            }
            this.loadUserImage(selectionView.userImage, selectionMsg.getfromName(), selectionMsg.getUserImage());
            this.setBotSelfView(selectionView.tvUserName, selectionView.tvMsg, selectionView.tvTime, selectionView.llRootRight, selectionView.llMessageBgLeft, null, position, selectionMsg);
            try {
                switch (selectionMsg.getMessageStatus()) {
                    case 4: 
                    case 5: 
                    case 6: {
                        selectionView.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_ic_waiting));
                        selectionView.ivMessageState.setVisibility(0);
                        break;
                    }
                    case 3: {
                        selectionView.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.agent_icon_blue_tick));
                        selectionView.ivMessageState.setVisibility(0);
                        break;
                    }
                    case 1: {
                        selectionView.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_tick_single));
                        selectionView.ivMessageState.setVisibility(0);
                        break;
                    }
                    case 2: {
                        selectionView.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.agent_icon_blue_tick));
                        selectionView.ivMessageState.setVisibility(0);
                        break;
                    }
                    default: {
                        selectionView.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_tick_single));
                        selectionView.ivMessageState.setVisibility(0);
                        break;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private RequestOptions getRequestOptions(String name) {
        ColorGenerator generator = ColorGenerator.MATERIAL;
        int color2 = generator.getColor(name.trim());
        if (this.options == null) {
            this.options = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)new RequestOptions().centerCrop()).fitCenter()).priority(Priority.HIGH)).transform(new Transformation[]{new CenterCrop(), new RoundedCorners(10)})).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL);
        }
        TextDrawable drawable2 = null;
        try {
            Resources r = this.context.getResources();
            float px = TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)r.getDisplayMetrics());
            name = name.trim();
            char text = ' ';
            text = name.charAt(0);
            drawable2 = TextDrawable.builder().buildRoundRect((text + "").toUpperCase(), color2, Math.round(px));
            this.options.placeholder((Drawable)drawable2);
            this.options.error((Drawable)drawable2);
        }
        catch (Exception e) {
            this.options.placeholder(R.drawable.placeholder);
            this.options.error(R.drawable.placeholder);
        }
        this.options.placeholder(drawable2);
        this.options.error(drawable2);
        return this.options;
    }

    private void setUserName(TextView userName) {
        ColorGenerator colorGenerator = ColorGenerator.MATERIAL_NAME;
        int color2 = colorGenerator.getColor(userName.getText().toString().trim());
        userName.setTextColor(color2);
    }

    private void loadUserImage(ImageView imageView, String name, String url) {
        Glide.with((FragmentActivity)this.context).asBitmap().apply((BaseRequestOptions)this.getRequestOptions(name)).load(url).into(imageView);
    }

    private boolean checkRightImage(int position, int typePre, int typeNext, Message message) {
        if (position == 0) {
            return true;
        }
        if (typePre == 2 || typePre == 15 || typePre == 9) {
            Message lastOrderItem = this.items.get(position - 1);
            if (message.getUserId().compareTo(lastOrderItem.getUserId()) == 0) {
                return false;
            }
        }
        return true;
    }

    private boolean checkUserConsent(int position, int typePre, int typeNext, Message message) {
        if (position == 0) {
            return true;
        }
        if (typePre == 2 || typePre == 15 || typePre == 9) {
            Message lastOrderItem = this.items.get(position - 1);
            if (message.getUserId().compareTo(lastOrderItem.getUserId()) == 0) {
                return false;
            }
        }
        return true;
    }

    private boolean checkLeftImage(int position, int typePre, int typeNext, Message currentOrderItem) {
        if (position == 0) {
            return true;
        }
        if (typePre == 13 && !TextUtils.isEmpty((CharSequence)this.items.get(position - 1).getSelectedBtnId())) {
            return false;
        }
        return typePre != 1 && typePre != 7 && typePre != 10 && typePre != 12 && typePre != 14;
    }

    public static int getColorWrapper(Context context, int id2) {
        try {
            if (Build.VERSION.SDK_INT >= 23) {
                return ContextCompat.getColor((Context)context, (int)id2);
            }
            return context.getResources().getColor(id2);
        }
        catch (Resources.NotFoundException e) {
            return Color.parseColor((String)"@color/colorPrimary");
        }
    }

    private void setBotOtherView(int position, int selectedBtn, UserConcentViewHolder userConcentViewHolder, Message userConcentMessage) {
        userConcentViewHolder.tvMsg.setText((CharSequence)userConcentMessage.getContentValue().get(selectedBtn).getBtnTitle());
        if (userConcentMessage.getSentAtUtc().isEmpty()) {
            userConcentViewHolder.tvTime.setVisibility(8);
        } else {
            userConcentViewHolder.tvTime.setText((CharSequence)DateUtils.getTime(this.dateUtil.convertToLocal(userConcentMessage.getSentAtUtc())));
            userConcentViewHolder.tvTime.setVisibility(0);
        }
        String userNameText = userConcentMessage.getRepliedBy();
        if (!TextUtils.isEmpty((CharSequence)userNameText)) {
            userConcentViewHolder.tvUserName.setVisibility(0);
            userConcentViewHolder.tvUserName.setText((CharSequence)userNameText);
        } else {
            userConcentViewHolder.tvUserName.setVisibility(8);
        }
        int typePre = 0;
        if (position > 0) {
            typePre = this.getItemViewType(position - 1);
        }
        int typeNext = -1;
        if (position + 1 != this.items.size()) {
            typeNext = this.getItemViewType(position + 1);
        }
        boolean hasImage = true;
        userConcentViewHolder.tvUserName.setVisibility(8);
        if (hasImage && !TextUtils.isEmpty((CharSequence)userNameText)) {
            userConcentViewHolder.tvUserName.setVisibility(0);
            userConcentViewHolder.tvUserName.setText((CharSequence)userNameText);
        }
        userConcentViewHolder.userImage.setVisibility(0);
        this.loadUserImage(userConcentViewHolder.userImage, userNameText, userConcentMessage.getRepliedUserImage());
        this.setUserName(userConcentViewHolder.tvUserName);
        userConcentViewHolder.leftrootview.setPadding(0, this.pxToDp(8), 0, this.pxToDp(1));
    }

    private void setBotSelfView(TextView tvNameRight, TextView tvMsgRight, TextView tvTimeRight, LinearLayout llRootRight, LinearLayout llChatRight, RelativeLayout rlMessagesRight, int position, Message userConcentMessage) {
        tvNameRight.setText((CharSequence)userConcentMessage.getfromName());
        tvMsgRight.setText((CharSequence)userConcentMessage.getMessage());
        if (userConcentMessage.getSentAtUtc().isEmpty()) {
            tvTimeRight.setVisibility(8);
        } else {
            tvTimeRight.setText((CharSequence)DateUtils.getTime(this.dateUtil.convertToLocal(userConcentMessage.getSentAtUtc())));
            tvTimeRight.setVisibility(0);
        }
    }

    private boolean isNotSelfViewType(int position) {
        int itemType = this.getItemViewType(position);
        return itemType != 2 && itemType != 9 && itemType != 11 && itemType != 6;
    }

    private void setIntegrationSource(ImageView source, ImageView messenger, ImageView fugu, int type) {
        source.setVisibility(8);
        messenger.setVisibility(8);
        fugu.setVisibility(8);
        int color2 = ContextCompat.getColor((Context)this.context, (int)R.color.colorPrimary);
        switch (type) {
            case 5: {
                source.setImageResource(R.drawable.ic_email);
                source.setVisibility(0);
                source.setColorFilter((ColorFilter)new PorterDuffColorFilter(color2, PorterDuff.Mode.SRC_IN));
                break;
            }
            case 6: {
                messenger.setVisibility(0);
                break;
            }
            case 7: {
                source.setImageResource(R.drawable.ic_sms);
                source.setVisibility(0);
                source.setColorFilter((ColorFilter)new PorterDuffColorFilter(color2, PorterDuff.Mode.SRC_IN));
                break;
            }
            case 8: {
                fugu.setVisibility(0);
                break;
            }
        }
    }

    private void setLeadFormData(LinearLayout leadFormData, Message currentMessage) {
        leadFormData.removeAllViews();
        for (int i = 0; i < currentMessage.getContentValue().get(0).getQuestions().size(); ++i) {
            LayoutInflater layoutInflater = (LayoutInflater)this.context.getBaseContext().getSystemService("layout_inflater");
            View addView = layoutInflater.inflate(R.layout.lead_form_item, null);
            TextView title = (TextView)addView.findViewById(R.id.title_view);
            TextView value = (TextView)addView.findViewById(R.id.value_view);
            TextView countView = (TextView)addView.findViewById(R.id.count_view);
            ImageView actionView = (ImageView)addView.findViewById(R.id.action_view);
            ImageView arrowBgView = (ImageView)addView.findViewById(R.id.arrow_background_view);
            countView.setVisibility(8);
            String txtTitle = currentMessage.getContentValue().get(0).getQuestions().get(i);
            title.setText((CharSequence)txtTitle);
            String txtValue = "";
            try {
                if (currentMessage.getValues() != null && currentMessage.getValues().get(i) != null) {
                    txtValue = currentMessage.getValues().get(i);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!TextUtils.isEmpty((CharSequence)txtValue)) {
                value.setText((CharSequence)txtValue);
                actionView.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ic_tick));
                actionView.setVisibility(0);
            } else {
                value.setText((CharSequence)txtTitle);
                actionView.setVisibility(8);
            }
            leadFormData.addView(addView);
            if (currentMessage.getValues().size() != i) continue;
            return;
        }
    }

    private void setMargins(View view, int left, int top, int right, int bottom) {
        if (view.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
            p.setMargins(left, top, right, bottom);
            view.requestLayout();
        }
    }

    private int pxToDp(int dpParam) {
        int dpValue = dpParam;
        float d = this.context.getResources().getDisplayMetrics().density;
        return (int)((float)dpValue * d);
    }

    public int getItemViewType(int position) {
        return this.items.get(position).getType();
    }

    public int getItemCount() {
        return this.items.size();
    }

    private void showImageDialog(Activity context, String imgUrl, ImageView imageView, Message message) {
        try {
            if (!Utils.preventMultipleClicks()) {
                return;
            }
            Intent imageIntent = new Intent((Context)context, ImageDisplayActivity.class);
            Image image = new Image(message.getImageUrl(), message.getThumbnailUrl(), message.getMuid(), message.getSentAtUtc(), "");
            imageIntent.putExtra("image", (Serializable)image);
            ActivityOptionsCompat options = ActivityOptionsCompat.makeSceneTransitionAnimation((Activity)context, (View)imageView, (String)message.getMuid());
            context.startActivity(imageIntent, options.toBundle());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean setVideoUiStatus(boolean isSelf, Message message, LinearLayout download, ImageView playBtn, AppCompatButton btnRetry, AppCompatButton btnCancel, FuguAgentProgressWheel progress, boolean isImageView) {
        if (!isSelf) return false;
        download.setVisibility(8);
        playBtn.setVisibility(8);
        btnRetry.setVisibility(8);
        btnCancel.setVisibility(8);
        progress.setVisibility(8);
        if (message.getMessageStatus() == 3 || message.getMessageStatus() == 2 || message.getMessageStatus() == 1) {
            if (isImageView) return true;
            String fname = Utils.getFileName(message.getFileName(), message.getMuid());
            String localPath = FileManager.getInstance().getLocalPath(fname, (String)FOLDER_TYPE.get(message.getDocumentType()));
            if (TextUtils.isEmpty((CharSequence)localPath)) {
                download.setVisibility(0);
                return false;
            } else {
                playBtn.setVisibility(0);
            }
            return false;
        } else if (message.getUploadStatus() == 1) {
            progress.setVisibility(0);
            return false;
        } else {
            if (message.getIsMessageExpired() != 1) return false;
            btnRetry.setVisibility(0);
            btnCancel.setVisibility(0);
        }
        return false;
    }

    private void setVideoDownloadStatus(LinearLayout videoDownloadStatus, ImageView playBtn, TextView fileSize, FuguAgentProgressWheel progressBar, Message message, int position) {
        String fname = Utils.getFileName(message.getFileName(), message.getMuid());
        String localPath = FileManager.getInstance().getLocalPath(fname, (String)FOLDER_TYPE.get(message.getDocumentType()));
        videoDownloadStatus.setVisibility(8);
        progressBar.setVisibility(8);
        playBtn.setVisibility(8);
        if (!(TextUtils.isEmpty((CharSequence)localPath) || message.getMessageStatus() != 3 && message.getMessageStatus() != 2 && message.getMessageStatus() != 1)) {
            playBtn.setVisibility(0);
        } else {
            switch (message.getDownloadStatus()) {
                case 1: {
                    progressBar.setVisibility(0);
                    break;
                }
                case 3: {
                    playBtn.setVisibility(0);
                    break;
                }
                default: {
                    videoDownloadStatus.setVisibility(0);
                    fileSize.setText((CharSequence)message.getFileSize());
                }
            }
        }
    }

    private void setMessageStatus(AppCompatImageView ivMessageState, int messageStatus, Boolean isImage) {
        if (isImage.booleanValue()) {
            switch (messageStatus) {
                case 1: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_tick_single));
                    break;
                }
                case 4: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_ic_waiting_white));
                    break;
                }
                case 2: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.agent_icon_blue_tick));
                    break;
                }
                case 3: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.agent_icon_blue_tick));
                    break;
                }
                case 6: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_ic_waiting_white));
                    break;
                }
                case 5: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_ic_waiting_white));
                    break;
                }
            }
        } else {
            switch (messageStatus) {
                case 1: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_tick_single));
                    break;
                }
                case 4: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_ic_waiting));
                    break;
                }
                case 2: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.agent_icon_blue_tick));
                    break;
                }
                case 3: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.agent_icon_blue_tick));
                    break;
                }
                case 6: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_ic_waiting));
                    break;
                }
                case 5: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_ic_waiting));
                    break;
                }
            }
        }
    }

    private void setImageHeightAndWidth(ImageView imageView, RelativeLayout rlImageMessage, LinearLayoutCompat llImageMessage, Message message, Boolean isSpiked) {
        int imageHeight = message.getImageHeight();
        int imageWidth = message.getImageWidth();
        if (imageHeight != 0 && message.getImageWidth() != 0) {
            float ratio = imageHeight / imageWidth;
            if (ratio < 1.0f) {
                rlImageMessage.getLayoutParams().height = (int)((float)this.pxToDp(250) * ratio);
                rlImageMessage.getLayoutParams().width = this.pxToDp(250);
                llImageMessage.getLayoutParams().width = isSpiked.booleanValue() ? this.pxToDp(255) : this.pxToDp(252);
            } else {
                rlImageMessage.getLayoutParams().height = this.pxToDp(250);
                rlImageMessage.getLayoutParams().width = this.pxToDp(250);
                llImageMessage.getLayoutParams().width = isSpiked.booleanValue() ? this.pxToDp(255) : this.pxToDp(252);
            }
        } else {
            rlImageMessage.getLayoutParams().height = this.pxToDp(250);
            rlImageMessage.getLayoutParams().width = this.pxToDp(250);
            llImageMessage.getLayoutParams().width = isSpiked != false ? this.pxToDp(255) : this.pxToDp(252);
        }
    }

    private void setTime(AppCompatTextView tvImageTime, String sentAtUtc) {
        tvImageTime.setText((CharSequence)DateUtils.getTime(DateUtils.getInstance().convertToLocal(sentAtUtc)));
    }

    private RequestOptions getRequestOption() {
        if (this.myOptions == null) {
            this.myOptions = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)RequestOptions.bitmapTransform((Transformation)new RoundedCornersTransformation((Context)this.context, 7, 2)).placeholder(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.hippo_placeholder))).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.hippo_placeholder));
        }
        return this.myOptions;
    }

    private void setImage(Activity activity, AppCompatImageView ivImageMessage, String thumbnailUrl) {
        try {
            Log.e(TAG, "thumbnailUrl = " + thumbnailUrl);
            Glide.with((Activity)activity).load(thumbnailUrl).apply((BaseRequestOptions)this.getRequestOption()).into((ImageView)ivImageMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean setSelfMessageBackground(View viewMessage, View viewBg, int position) {
        int oneDp = this.pxToDp(1);
        int sixDp = this.pxToDp(6);
        int sevenDp = this.pxToDp(7);
        if (this.items.size() == 1) {
            viewBg.setBackgroundResource(R.drawable.agent_chat_bg_right);
            viewMessage.setPadding(0, sixDp, sevenDp, oneDp);
            viewBg.setPadding(sixDp, sixDp, this.pxToDp(17), sixDp);
            return true;
        }
        if (position == 0) {
            viewBg.setBackgroundResource(R.drawable.agent_chat_bg_right);
            viewMessage.setPadding(0, sixDp, this.pxToDp(7), sevenDp);
            viewBg.setPadding(sixDp, sixDp, this.pxToDp(17), sixDp);
            return true;
        }
        if (this.getItemViewType(position - 1) == 2 || this.getItemViewType(position - 1) == 6 || this.getItemViewType(position - 1) == 9 || this.getItemViewType(position - 1) == 11) {
            viewBg.setBackgroundResource(R.drawable.agent_chat_bg_right_normal);
            viewMessage.setPadding(0, oneDp, this.pxToDp(10), oneDp);
            viewBg.setPadding(sixDp, sixDp, sixDp, sixDp);
            return false;
        }
        viewBg.setBackgroundResource(R.drawable.agent_chat_bg_right);
        viewMessage.setPadding(0, sixDp, sevenDp, oneDp);
        viewBg.setPadding(sixDp, sixDp, this.pxToDp(17), sixDp);
        return true;
    }

    private void setFileMessageOtherNew(View viewMessage, View viewBg, int position, TextView userName, String name, RelativeLayout timelayout) {
        int oneDp = this.pxToDp(1);
        int sixDp = this.pxToDp(6);
        int sevenDp = this.pxToDp(7);
        int eightDp = this.pxToDp(8);
        if (this.items.size() == 1) {
            viewBg.setBackgroundResource(R.drawable.agent_chat_bg_left_normal);
            if (userName != null) {
                userName.setVisibility(0);
                userName.setText((CharSequence)name);
            } else if (TextUtils.isEmpty((CharSequence)name)) {
                userName.setVisibility(8);
            }
        } else if (position == 0) {
            viewBg.setBackgroundResource(R.drawable.agent_chat_bg_left_normal);
            if (userName != null) {
                userName.setVisibility(0);
                userName.setText((CharSequence)name);
            } else if (TextUtils.isEmpty((CharSequence)name)) {
                userName.setVisibility(8);
            }
        } else if (this.getItemViewType(position - 1) == 1 || this.getItemViewType(position - 1) == 7 || this.getItemViewType(position - 1) == 12 || this.getItemViewType(position - 1) == 10) {
            viewBg.setBackgroundResource(R.drawable.agent_chat_bg_left_normal);
            if (userName != null) {
                userName.setVisibility(8);
            }
        } else {
            if (Build.VERSION.SDK_INT >= 17) {
                viewBg.setPaddingRelative(this.pxToDp(4), this.pxToDp(2), 0, oneDp);
            } else {
                viewBg.setPadding(this.pxToDp(4), this.pxToDp(2), 0, oneDp);
            }
            viewBg.setBackgroundResource(R.drawable.agent_chat_bg_left_normal);
            if (userName != null) {
                userName.setVisibility(0);
                userName.setText((CharSequence)name);
            } else if (TextUtils.isEmpty((CharSequence)name)) {
                userName.setVisibility(8);
            }
        }
    }

    private boolean setFileMessageOther(View viewMessage, View viewBg, int position, TextView userName, String name) {
        if (userName != null && !TextUtils.isEmpty((CharSequence)name)) {
            userName.setVisibility(0);
            userName.setText((CharSequence)name);
        } else if (userName != null) {
            userName.setVisibility(8);
        }
        return true;
    }

    private void messageStatusTick(ImageView fuguIvMessageState, Message currentOrderItem2) {
        switch (currentOrderItem2.getMessageStatus()) {
            case 4: 
            case 5: 
            case 6: {
                fuguIvMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_ic_waiting));
                fuguIvMessageState.setVisibility(0);
                break;
            }
            case 3: {
                fuguIvMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.agent_icon_blue_tick));
                fuguIvMessageState.setVisibility(0);
                break;
            }
            case 1: {
                fuguIvMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_tick_single));
                fuguIvMessageState.setVisibility(0);
                break;
            }
            case 2: {
                fuguIvMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.agent_icon_blue_tick));
                if (Build.VERSION.SDK_INT >= 21) {
                    fuguIvMessageState.getDrawable().setTint(ContextCompat.getColor((Context)this.context, (int)R.color.fugu_drawable_color));
                }
                fuguIvMessageState.setVisibility(0);
                break;
            }
            default: {
                fuguIvMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.fugu_tick_single));
                fuguIvMessageState.setVisibility(0);
            }
        }
    }

    private void setUploadClick(AppCompatImageView ivFileUpload, FuguAgentProgressWheel circleProgress, Message message) {
        ivFileUpload.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!FuguMessageAdapter.this.context.isNetworkAvailable() || FuguMessageAdapter.this.mOnRetry != null) {
                    // empty if block
                }
            }
        });
    }

    private void setFileCLickListener(LinearLayoutCompat llFile, final Message message, final AppCompatImageView ivFilePlay, final int position) {
        ivFilePlay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FuguMessageAdapter.this.onPlaySound(message, ivFilePlay, position);
            }
        });
        llFile.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    if (message.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.AUDIO.toString())) {
                        return;
                    }
                    String fname = Utils.getFileName(message.getFileName(), message.getMuid());
                    String localPath = FileManager.getInstance().getLocalPath(fname, FuguAppConstant.FOLDER_TYPE.get(message.getDocumentType()));
                    if (!TextUtils.isEmpty((CharSequence)localPath)) {
                        FileManager.getInstance().openFileInDevice((Context)FuguMessageAdapter.this.context, localPath, new FileManager.FileCopyListener(){

                            @Override
                            public void onCopingFile(boolean flag, FileuploadModel fileuploadModel) {
                            }

                            @Override
                            public void largeFileSize() {
                            }

                            @Override
                            public void onError() {
                                Toast.makeText((Context)FuguMessageAdapter.this.context, (CharSequence)FuguMessageAdapter.this.context.getString(R.string.no_handler), (int)1).show();
                            }
                        });
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void setFileDownLoadStatus(ImageView fileView, final AppCompatImageView ivFilePlay, FuguAgentProgressWheel circleProgress, AppCompatImageView ivFileDownload, AppCompatImageView ivFileUpload, final Message currentOrderItem2, final int position) {
        ivFileDownload.setVisibility(8);
        circleProgress.setVisibility(8);
        ivFileUpload.setVisibility(8);
        ivFilePlay.setVisibility(8);
        String fname = Utils.getFileName(currentOrderItem2.getFileName(), currentOrderItem2.getMuid());
        String localPath = FileManager.getInstance().getLocalPath(fname, (String)FOLDER_TYPE.get(currentOrderItem2.getDocumentType()));
        Log.v("localPath", "localPath ********* = " + localPath);
        if (!TextUtils.isEmpty((CharSequence)localPath)) {
            if (currentOrderItem2.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.AUDIO.toString())) {
                ivFilePlay.setVisibility(0);
            }
        } else {
            switch (currentOrderItem2.getDownloadStatus()) {
                case 1: {
                    circleProgress.setVisibility(0);
                    break;
                }
                case 3: {
                    if (!currentOrderItem2.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.AUDIO.toString())) break;
                    ivFilePlay.setVisibility(0);
                    break;
                }
                default: {
                    ivFileDownload.setVisibility(0);
                }
            }
        }
        ivFilePlay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FuguMessageAdapter.this.onPlaySound(currentOrderItem2, ivFilePlay, position);
            }
        });
    }

    private void setFileUploadStatus(ImageView fileView, final AppCompatImageView ivFilePlay, FuguAgentProgressWheel circleProgress, AppCompatImageView ivFileDownload, AppCompatImageView ivFileUpload, final Message currentOrderItem2, final int position) {
        block10: {
            block11: {
                block9: {
                    ivFileDownload.setVisibility(8);
                    circleProgress.setVisibility(8);
                    ivFileUpload.setVisibility(8);
                    ivFilePlay.setVisibility(8);
                    if (currentOrderItem2.getIsMessageExpired() != 1) break block9;
                    ivFileUpload.setVisibility(0);
                    break block10;
                }
                if (currentOrderItem2.getMessageStatus() != 4) break block11;
                switch (currentOrderItem2.getUploadStatus()) {
                    case 0: {
                        ivFileUpload.setVisibility(0);
                        break;
                    }
                    case 1: {
                        circleProgress.setVisibility(0);
                        break;
                    }
                    case 3: {
                        if (currentOrderItem2.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.AUDIO.toString())) {
                            ivFilePlay.setVisibility(0);
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block10;
            }
            String fname = Utils.getFileName(currentOrderItem2.getFileName(), currentOrderItem2.getMuid());
            String localPath = FileManager.getInstance().getLocalPath(fname, (String)FOLDER_TYPE.get(currentOrderItem2.getDocumentType()));
            Log.v("localPath", "localPath ********* = " + currentOrderItem2.getFileName());
            if (!TextUtils.isEmpty((CharSequence)localPath)) {
                if (currentOrderItem2.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.AUDIO.toString())) {
                    ivFilePlay.setVisibility(0);
                }
            } else {
                ivFileDownload.setVisibility(0);
            }
        }
        ivFilePlay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FuguMessageAdapter.this.onPlaySound(currentOrderItem2, ivFilePlay, position);
            }
        });
    }

    public void onPauseActivity() {
        try {
            if (!TextUtils.isEmpty((CharSequence)this.context.audioMuid)) {
                CommonMediaPlayer.getInstance().stopMedia();
                Message listItem = this.items.get(this.context.playingItem);
                listItem.setAudioPlaying(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void onPlaySound(final Message currentOrderItem2, final AppCompatImageView ivFilePlay, final int position) {
        if (!TextUtils.isEmpty((CharSequence)this.context.audioMuid)) {
            if (this.context.audioMuid.equalsIgnoreCase(currentOrderItem2.getMuid())) {
                this.context.audioMuid = "";
                currentOrderItem2.setAudioPlaying(false);
                ivFilePlay.setImageResource(R.drawable.hippo_music_player);
                CommonMediaPlayer.getInstance().stopMedia();
                this.notifyItemChanged(position);
                return;
            }
            Message listItem = this.items.get(this.context.playingItem);
            listItem.setAudioPlaying(false);
            this.notifyItemChanged(this.context.playingItem);
        }
        String fname = Utils.getFileName(currentOrderItem2.getFileName(), currentOrderItem2.getMuid());
        String localPath = FileManager.getInstance().getLocalPath(fname, (String)FOLDER_TYPE.get(currentOrderItem2.getDocumentType()));
        CommonMediaPlayer.getInstance().playMediaPlayer((Context)this.context, localPath, new CommonMediaPlayer.MediaPlayerStatus(){

            @Override
            public void onPlaying() {
                currentOrderItem2.setAudioPlaying(true);
                ((FuguMessageAdapter)FuguMessageAdapter.this).context.audioMuid = currentOrderItem2.getMuid();
                ((FuguMessageAdapter)FuguMessageAdapter.this).context.playingItem = position;
                ivFilePlay.setImageResource(R.drawable.hippo_song_pause);
                currentOrderItem2.setAudioPlaying(true);
                FuguMessageAdapter.this.notifyItemChanged(position);
            }

            @Override
            public void onCompletion(MediaPlayer mp) {
                ((FuguMessageAdapter)FuguMessageAdapter.this).context.audioMuid = "";
                ivFilePlay.setImageResource(R.drawable.hippo_music_player);
                currentOrderItem2.setAudioPlaying(false);
                CommonMediaPlayer.getInstance().stopMedia();
                FuguMessageAdapter.this.notifyItemChanged(position);
            }

            @Override
            public void onError(MediaPlayer mp, int what, int extra) {
                ((FuguMessageAdapter)FuguMessageAdapter.this).context.audioMuid = "";
                ivFilePlay.setImageResource(R.drawable.hippo_music_player);
                currentOrderItem2.setAudioPlaying(false);
                CommonMediaPlayer.getInstance().stopMedia();
                FuguMessageAdapter.this.notifyItemChanged(position);
            }
        });
    }

    private void setDownloadClick(final AppCompatImageView ivFileDownload, final FuguAgentProgressWheel circleProgress, final Message message, final int position) {
        if (!this.context.isNetworkAvailable()) {
            return;
        }
        ivFileDownload.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String fileName;
                if (!FuguMessageAdapter.this.context.checkPermission()) {
                    FuguMessageAdapter.this.context.readExternalStorage();
                    return;
                }
                circleProgress.setVisibility(0);
                ivFileDownload.setVisibility(8);
                String docType = "image";
                if (message.getOriginalMessageType() == 11) {
                    docType = message.getDocumentType();
                }
                if (TextUtils.isEmpty((CharSequence)(fileName = message.getFileName()))) {
                    String timeStamp = new SimpleDateFormat("ddMMyyyy_hhmmss", Locale.ENGLISH).format(new Date());
                    fileName = "Hippochat_" + timeStamp + ".jpg";
                }
                String fullPath = Utils.getOrCreateDirectoryPath(FuguAppConstant.FOLDER_TYPE.get(docType));
                int downloadId = FuguMessageAdapter.this.downloadFileFromUrl(fullPath, fileName, message, position);
                message.setDownloadId(downloadId);
            }
        });
    }

    private int downloadFileFromUrl(String dirPath, String fileName, final Message message, final int position) {
        if (!fileName.contains(message.getMuid())) {
            String muid = message.getMuid();
            String ext = Utils.getExtension(fileName);
            String name = Utils.extractFileNameWithoutSuffix(fileName);
            fileName = name + "_" + muid + "." + ext;
        }
        this.currentProgress = -1;
        return PRDownloader.download((String)message.getFileUrl(), (String)dirPath, (String)fileName).build().setOnStartOrResumeListener(new OnStartOrResumeListener(){

            public void onStartOrResume() {
                Log.v(TAG, "OnStartOrResumeListener");
            }
        }).setOnPauseListener(new OnPauseListener(){

            public void onPause() {
                message.setDownloadStatus(FuguAppConstant.DownloadStatus.DOWNLOAD_PAUSED.downloadStatus);
            }
        }).setOnProgressListener(new OnProgressListener(){

            public void onProgress(Progress progress) {
                int cProgress = (int)(progress.currentBytes * 100L / progress.totalBytes);
                if (FuguMessageAdapter.this.currentProgress < cProgress) {
                    ++FuguMessageAdapter.this.currentProgress;
                }
                message.setCurrentprogress(cProgress);
                message.setDownloadStatus(FuguAppConstant.DownloadStatus.DOWNLOAD_IN_PROGRESS.downloadStatus);
            }
        }).start(new OnDownloadListener(){

            public void onDownloadComplete() {
                message.setDownloadStatus(FuguAppConstant.DownloadStatus.DOWNLOAD_COMPLETED.downloadStatus);
                Intent mIntent = FuguMessageAdapter.this.getIntentExtraData(position, 100, message.getMuid(), FuguAppConstant.DownloadStatus.DOWNLOAD_COMPLETED.downloadStatus);
                LocalBroadcastManager.getInstance((Context)FuguMessageAdapter.this.context).sendBroadcast(mIntent);
            }

            public void onError(Error error) {
                message.setDownloadStatus(FuguAppConstant.DownloadStatus.DOWNLOAD_FAILED.downloadStatus);
                Intent mIntent = FuguMessageAdapter.this.getIntentExtraData(position, 0, message.getMuid(), FuguAppConstant.DownloadStatus.DOWNLOAD_FAILED.downloadStatus);
                LocalBroadcastManager.getInstance((Context)FuguMessageAdapter.this.context).sendBroadcast(mIntent);
            }
        });
    }

    private Intent getIntentExtraData(int position, int progress, String muid, int status2) {
        Intent mIntent = new Intent("hippo_progress_intent");
        mIntent.putExtra("hippo_position", position);
        mIntent.putExtra("hippo_progress", progress);
        mIntent.putExtra("muid", muid);
        mIntent.putExtra("hippo_statusUpload", status2);
        return mIntent;
    }

    private void setTimeView(TextView tvMsg, RelativeLayout rlMessages, View time, int itemType, Message message, int position) {
        View vTime = itemType == 1 ? time : time;
        int lineCount = 0;
        int difference = 0;
        lineCount = tvMsg.getLineCount();
        if (lineCount != 0) {
            difference = tvMsg.getLayout().getLineStart(lineCount) - tvMsg.getLayout().getLineStart(lineCount - 1);
        }
        String completeString = tvMsg.getText().toString();
        boolean lineCountGreater = lineCount > 1;
        String stringInLastLine = lineCountGreater ? completeString.substring(tvMsg.getText().toString().length() - difference, tvMsg.getText().toString().length()) : tvMsg.getText().toString();
        float emptySpaceLeft = (float)rlMessages.getMeasuredWidth() - tvMsg.getPaint().measureText(stringInLastLine);
        RelativeLayout.LayoutParams layout2 = (RelativeLayout.LayoutParams)vTime.getLayoutParams();
        if (emptySpaceLeft > (float)this.context.getResources().getDimensionPixelSize(R.dimen.height_ll_time)) {
            if (lineCountGreater) {
                layout2.addRule(11);
                layout2.addRule(1, -1);
                message.setTimeIndex(2);
            } else {
                layout2.addRule(11, 0);
                layout2.addRule(1, tvMsg.getId());
                message.setTimeIndex(3);
            }
            layout2.addRule(3, -1);
            layout2.addRule(8, tvMsg.getId());
        } else if (!tvMsg.getText().toString().contains("/n")) {
            layout2.addRule(8, -1);
            layout2.addRule(1, -1);
            layout2.addRule(3, tvMsg.getId());
            layout2.addRule(11);
            message.setTimeIndex(1);
        }
        vTime.setLayoutParams((ViewGroup.LayoutParams)layout2);
    }

    private void setAlpha() {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                LoadingBox.hide();
                FuguMessageAdapter.this.conversation.setIsTimeSet(1);
                if (FuguMessageAdapter.this.context.getRvMessages().getAlpha() != 1.0f) {
                    FuguMessageAdapter.this.context.getRvMessages().setAlpha(1.0f);
                }
            }
        }, 150L);
    }

    private float convertDpToPixel(float dp) {
        DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
        float px = dp * ((float)metrics.densityDpi / 160.0f);
        return Math.round(px);
    }

    private String convertSeconds(int seconds) {
        int h = seconds / 3600;
        int m = seconds % 3600 / 60;
        int s = seconds % 60;
        String sh = h > 0 ? String.valueOf(h) + " h" : "";
        String sm = (m < 10 && m > 0 && h > 0 ? "0" : "") + (m > 0 ? (h > 0 && s == 0 ? String.valueOf(m) : String.valueOf(m) + " m") : "");
        String ss = s == 0 && (h > 0 || m > 0) ? "" : (s < 10 && (h > 0 || m > 0) ? "0" : "") + String.valueOf(s) + " s";
        return sh + (h > 0 ? " " : "") + sm + (m > 0 ? " " : "") + ss;
    }

    private String getMessage(Message videoMessage, int userType) {
        String message = "The video call ended";
        String agentType = "you";
        message = userType == 6 ? (videoMessage.getMessageState() != null && videoMessage.getMessageState() == 2 ? (!TextUtils.isEmpty((CharSequence)videoMessage.getCallType()) && videoMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString()) ? "Missed Call" : "Missed Call") : (!TextUtils.isEmpty((CharSequence)videoMessage.getCallType()) && videoMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString()) ? "The voice call ended" : "The video call ended")) : (videoMessage.getMessageState() != null && videoMessage.getMessageState() == 2 ? (!TextUtils.isEmpty((CharSequence)videoMessage.getCallType()) && videoMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString()) ? "Missed Call" : "Missed Call") : (!TextUtils.isEmpty((CharSequence)videoMessage.getCallType()) && videoMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString()) ? "The voice call ended" : "The video call ended"));
        return message;
    }

    public void attachObservers(Boolean attach) {
    }

    private void detachObserver() {
        this.receiverRegistered = false;
        try {
            LocalBroadcastManager.getInstance((Context)this.context).unregisterReceiver(this.mProgressReceiver);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void attachObserver() {
        if (this.mProgressReceiver == null) {
            if (this.receiverRegistered) {
                return;
            }
            this.initializeReciever();
        }
        LocalBroadcastManager.getInstance((Context)this.context).registerReceiver(this.mProgressReceiver, new IntentFilter("hippo_progress_intent"));
        this.receiverRegistered = true;
    }

    private void initializeReciever() {
        this.mProgressReceiver = new BroadcastReceiver(){

            public void onReceive(Context ctx, Intent intent) {
                FuguMessageAdapter.this.context.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
            }
        };
    }

    public void checkHolderAndUpdateProgress(Message currentOrderItem, int position) {
        if (this.recyclerView.findViewHolderForAdapterPosition(position) instanceof ReceivedFileViewHolder) {
            this.setOtherHolderFileProgress(currentOrderItem, position);
        } else if (this.recyclerView.findViewHolderForAdapterPosition(position) instanceof SentFileViewHolder) {
            this.setSelfHolderFileProgress(currentOrderItem, position);
        } else if (this.recyclerView.findViewHolderForAdapterPosition(position) instanceof SelfVideoMessageViewHolder) {
            this.setSelfHolderVideoProgress(currentOrderItem, position);
        } else if (this.recyclerView.findViewHolderForAdapterPosition(position) instanceof OtherVideoMessageViewHolder) {
            this.setOtherHolderVideoProgress(currentOrderItem, position);
        }
    }

    private void setOtherHolderImageProgress(Message currentOrderItem, int position) {
    }

    private void setSelfHolderImageProgress(Message currentOrderItem, int position) {
    }

    private void setOtherHolderVideoProgress(Message currentOrderItem, int position) {
        OtherVideoMessageViewHolder otherImageMessageViewHolder = (OtherVideoMessageViewHolder)this.recyclerView.findViewHolderForAdapterPosition(position);
        otherImageMessageViewHolder.llDownload.setVisibility(8);
        this.notifyItemChanged(position);
    }

    private void setSelfHolderVideoProgress(Message currentOrderItem, int position) {
        SelfVideoMessageViewHolder selfImageMessageViewHolder = (SelfVideoMessageViewHolder)this.recyclerView.findViewHolderForAdapterPosition(position);
        selfImageMessageViewHolder.circle_progress.setVisibility(0);
        this.notifyItemChanged(position);
    }

    private void setOtherHolderFileProgress(Message currentOrderItem, int position) {
        ReceivedFileViewHolder otherFileMessageViewHolder = (ReceivedFileViewHolder)this.recyclerView.findViewHolderForAdapterPosition(position);
        otherFileMessageViewHolder.progressBar.setVisibility(0);
        otherFileMessageViewHolder.ivFilePlay.setVisibility(8);
        this.notifyItemChanged(position);
    }

    private void setSelfHolderFileProgress(Message currentOrderItem, int position) {
        SentFileViewHolder selfFileMessageViewHolder = (SentFileViewHolder)this.recyclerView.findViewHolderForAdapterPosition(position);
        selfFileMessageViewHolder.circleProgress.setVisibility(0);
        selfFileMessageViewHolder.ivFilePlay.setVisibility(8);
        this.notifyItemChanged(position);
    }

    private void setTextMessage(TextView tvMessage, String message) {
        URLSpan[] spans;
        Spannable var15;
        Spanned var14;
        String[] textArray = message.toString().split(" ");
        String text = "";
        for (String msg : textArray) {
            text = msg.toLowerCase().contains("http") || msg.toLowerCase().contains("www") ? text + " <a href=\"" + msg + "\">" + msg + "</a> " : text + " " + msg;
        }
        text = text.replace("Http", "http");
        text = text.replace("Https", "https");
        text = text.replace("WWW", "www");
        text = text.trim().replace("\n", "<br>");
        if (Build.VERSION.SDK_INT >= 24) {
            var14 = Html.fromHtml((String)text.toString(), (int)256);
            if (var14 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.text.Spannable");
            }
            var15 = (Spannable)var14;
        } else {
            var14 = Html.fromHtml((String)text.toString());
            if (var14 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.text.Spannable");
            }
            var15 = (Spannable)var14;
        }
        Spannable s = var15;
        URLSpan[] var9 = (URLSpan[])s.getSpans(0, s.length(), URLSpan.class);
        int var10 = var9.length;
        for (URLSpan span : spans = (URLSpan[])s.getSpans(0, s.length(), URLSpan.class)) {
            int start = s.getSpanStart((Object)span);
            int end = s.getSpanEnd((Object)span);
            s.removeSpan((Object)span);
            span = new URLSpanNoUnderline(span.getURL());
            s.setSpan((Object)span, start, end, 0);
        }
        tvMessage.setLinkTextColor(this.context.getResources().getColor(R.color.color_tag));
        tvMessage.setText((CharSequence)s);
        tvMessage.setMovementMethod((MovementMethod)BetterLinkMovementMethod.getInstance());
        SpannableString ss1 = new SpannableString((CharSequence)s);
        ss1.setSpan((Object)new RelativeSizeSpan(1.0f), 0, s.length(), 0);
        tvMessage.setText((CharSequence)ss1);
        BetterLinkMovementMethod.linkifyHtmlNone(tvMessage).setOnLinkLongClickListener(this.urlClickListenerLong).setOnLinkClickListener(this.urlClickListener);
    }

    private String getBotImage() {
        return "";
    }

    private int dp1() {
        if (this.dp1 == 0) {
            this.dp1 = this.pxToDp(1);
        }
        return this.dp1;
    }

    private int dp2() {
        if (this.dp2 == 0) {
            this.dp2 = this.pxToDp(2);
        }
        return this.dp2;
    }

    private int dp4() {
        if (this.dp4 == 0) {
            this.dp4 = this.pxToDp(4);
        }
        return this.dp4;
    }

    private int dp8() {
        if (this.dp8 == 0) {
            this.dp8 = this.pxToDp(8);
        }
        return this.dp8;
    }

    private int dp30() {
        if (this.dp30 == 0) {
            this.dp30 = this.pxToDp(35);
        }
        return this.dp30;
    }

    static {
        BW_MATRIX.setSaturation(0.0f);
        BW_FILTER = new ColorMatrixColorFilter(BW_MATRIX);
    }

    class OtherVideoMessageViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayoutCompat llRoot;
        private LinearLayoutCompat llImageMessage;
        private RelativeLayout timelayout;
        private LinearLayout llDownload;
        private TextView tvUserName;
        private TextView tvFileSize;
        private RelativeLayout rlImageMessage;
        private AppCompatImageView ivImageMsg;
        private AppCompatTextView tvImageTime;
        private AppCompatTextView tvImgWithText;
        private ImageView ivPlay;
        private ImageView ivDownload;
        private ImageView messageSourceType;
        private ImageView messageSourceType1;
        private ImageView messageSourceType2;
        private FuguAgentProgressWheel progressBar;
        private ImageView userImage;

        public OtherVideoMessageViewHolder(final View itemView, final OnRecyclerListener itemClickListener) {
            super(itemView);
            this.llRoot = (LinearLayoutCompat)itemView.findViewById(R.id.llRoot);
            this.llImageMessage = (LinearLayoutCompat)itemView.findViewById(R.id.llImageMessage);
            this.llDownload = (LinearLayout)itemView.findViewById(R.id.llDownload);
            this.timelayout = (RelativeLayout)itemView.findViewById(R.id.timelayout);
            this.rlImageMessage = (RelativeLayout)itemView.findViewById(R.id.rlImageMessage);
            this.tvUserName = (TextView)itemView.findViewById(R.id.tvUserName);
            this.tvFileSize = (TextView)itemView.findViewById(R.id.tvFileSize);
            this.ivImageMsg = (AppCompatImageView)itemView.findViewById(R.id.ivImageMsg);
            this.tvImageTime = (AppCompatTextView)itemView.findViewById(R.id.tvImageTime);
            this.tvImgWithText = (AppCompatTextView)itemView.findViewById(R.id.tvImgWithText);
            this.ivPlay = (ImageView)itemView.findViewById(R.id.ivPlay);
            this.ivDownload = (ImageView)itemView.findViewById(R.id.ivDownload);
            this.progressBar = (FuguAgentProgressWheel)itemView.findViewById(R.id.circle_progress);
            this.messageSourceType = (ImageView)itemView.findViewById(R.id.message_source_type);
            this.messageSourceType1 = (ImageView)itemView.findViewById(R.id.message_source_type1);
            this.messageSourceType2 = (ImageView)itemView.findViewById(R.id.message_source_type2);
            this.userImage = (ImageView)itemView.findViewById(R.id.user_image);
            this.tvUserName = (TextView)itemView.findViewById(R.id.tvUserName);
            this.ivPlay.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    itemClickListener.onItemClick((View)OtherVideoMessageViewHolder.this.llRoot, itemView, OtherVideoMessageViewHolder.this.getAdapterPosition());
                }
            });
        }
    }

    class MultiSelectionView
    extends RecyclerView.ViewHolder {
        private LinearLayout llRootRight;
        private LinearLayout llMessageBgLeft;
        private ImageView ivMessageState;
        private ImageView userImage;
        private TextView tvUserName;
        private TextView tvMsg;
        private TextView tvTime;
        private RecyclerView recyclerView;

        public MultiSelectionView(View itemView) {
            super(itemView);
            this.llRootRight = (LinearLayout)itemView.findViewById(R.id.root_right);
            this.llMessageBgLeft = (LinearLayout)itemView.findViewById(R.id.llMessageBgLeft);
            this.ivMessageState = (ImageView)itemView.findViewById(R.id.ivMessageState);
            this.userImage = (ImageView)itemView.findViewById(R.id.user_image);
            this.tvUserName = (TextView)itemView.findViewById(R.id.tvUserName);
            this.tvMsg = (TextView)itemView.findViewById(R.id.tvMsg);
            this.tvTime = (TextView)itemView.findViewById(R.id.tvTime);
            this.recyclerView = (RecyclerView)itemView.findViewById(R.id.recyclerView);
        }
    }

    class PaymentView
    extends RecyclerView.ViewHolder {
        private RecyclerView recyclerView;

        public PaymentView(View itemView) {
            super(itemView);
            this.recyclerView = (RecyclerView)itemView.findViewById(R.id.tagView);
        }
    }

    class UserConcentViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayout main_root;
        private LinearLayout llRootRight;
        private LinearLayout llChatRight;
        private LinearLayout llTimeRight;
        private RelativeLayout rlMessagesRight;
        private TextView tvNameRight;
        private TextView tvMsgRight;
        private TextView tvTimeRight;
        private ImageView ivMessageStateRight;
        private TextView tvTagsTime;
        private RecyclerView recyclerView;
        private LinearLayout llChatLeft;
        private LinearLayout llTime;
        private TextView tvUserName;
        private TextView tvMsg;
        private TextView tvTime;
        private RelativeLayout rlMessages;
        private RelativeLayout leftrootview;
        private ImageView userImage;
        private ImageView userImageRight;

        public UserConcentViewHolder(final View itemView, final OnRecyclerListener itemClickListener) {
            super(itemView);
            this.main_root = (LinearLayout)itemView.findViewById(R.id.main_root);
            this.llRootRight = (LinearLayout)itemView.findViewById(R.id.llRootRight);
            this.llChatRight = (LinearLayout)itemView.findViewById(R.id.llChatRight);
            this.llTimeRight = (LinearLayout)itemView.findViewById(R.id.llTimeRight);
            this.rlMessagesRight = (RelativeLayout)itemView.findViewById(R.id.rlMessagesRight);
            this.tvNameRight = (TextView)itemView.findViewById(R.id.tvNameRight);
            this.tvMsgRight = (TextView)itemView.findViewById(R.id.tvMsgRight);
            this.tvTimeRight = (TextView)itemView.findViewById(R.id.tvTimeRight);
            this.ivMessageStateRight = (ImageView)itemView.findViewById(R.id.ivMessageStateRight);
            this.userImageRight = (ImageView)itemView.findViewById(R.id.user_image_right);
            this.tvTagsTime = (TextView)itemView.findViewById(R.id.tvTagsTime);
            this.recyclerView = (RecyclerView)itemView.findViewById(R.id.recyclerView);
            this.llChatLeft = (LinearLayout)itemView.findViewById(R.id.llChatLeft);
            this.llTime = (LinearLayout)itemView.findViewById(R.id.llTime);
            this.tvUserName = (TextView)itemView.findViewById(R.id.tvUserName);
            this.tvMsg = (TextView)itemView.findViewById(R.id.tvMsg);
            this.tvTime = (TextView)itemView.findViewById(R.id.tvTime);
            this.rlMessages = (RelativeLayout)itemView.findViewById(R.id.rlMessages);
            this.leftrootview = (RelativeLayout)itemView.findViewById(R.id.leftrootview);
            this.userImage = (ImageView)itemView.findViewById(R.id.user_image);
            this.tvMsgRight.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    itemClickListener.onItemLongClick((View)UserConcentViewHolder.this.llChatRight, itemView, UserConcentViewHolder.this.getAdapterPosition(), false);
                    return true;
                }
            });
            this.llRootRight.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    itemClickListener.onItemLongClick((View)UserConcentViewHolder.this.llChatRight, itemView, UserConcentViewHolder.this.getAdapterPosition(), false);
                    return true;
                }
            });
            this.tvMsg.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    itemClickListener.onItemLongClick((View)UserConcentViewHolder.this.main_root, itemView, UserConcentViewHolder.this.getAdapterPosition(), true);
                    return true;
                }
            });
            this.leftrootview.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    itemClickListener.onItemLongClick((View)UserConcentViewHolder.this.main_root, itemView, UserConcentViewHolder.this.getAdapterPosition(), true);
                    return true;
                }
            });
        }
    }

    class SelfVideoMessageViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayout llDownload;
        private LinearLayoutCompat llRoot;
        private LinearLayoutCompat llImageMessage;
        private RelativeLayout rlImageMessage;
        private AppCompatImageView ivImageMsg;
        private AppCompatImageView ivMessageState;
        private ImageView ivPlay;
        private ImageView ivDownload;
        private ImageView messageSourceType;
        private ImageView messageSourceType1;
        private ImageView messageSourceType2;
        private AppCompatTextView tvImageTime;
        private TextView tvFileSize;
        private TextView tvImgWithText;
        private AppCompatButton btnRetry;
        private AppCompatButton btnCancel;
        private FuguAgentProgressWheel circle_progress;
        private ImageView userImage;
        private TextView userName;

        public SelfVideoMessageViewHolder(View itemView, OnRecyclerListener itemClickListener) {
            super(itemView);
            this.llRoot = (LinearLayoutCompat)itemView.findViewById(R.id.llRoot);
            this.llImageMessage = (LinearLayoutCompat)itemView.findViewById(R.id.llImageMessage);
            this.llDownload = (LinearLayout)itemView.findViewById(R.id.llDownload);
            this.rlImageMessage = (RelativeLayout)itemView.findViewById(R.id.rlImageMessage);
            this.ivImageMsg = (AppCompatImageView)itemView.findViewById(R.id.ivImageMsg);
            this.ivPlay = (ImageView)itemView.findViewById(R.id.ivPlay);
            this.ivDownload = (ImageView)itemView.findViewById(R.id.ivDownload);
            this.ivMessageState = (AppCompatImageView)itemView.findViewById(R.id.ivMessageState);
            this.tvFileSize = (TextView)itemView.findViewById(R.id.tvFileSize);
            this.tvImageTime = (AppCompatTextView)itemView.findViewById(R.id.tvImageTime);
            this.tvImgWithText = (TextView)itemView.findViewById(R.id.tvImgWithText);
            this.circle_progress = (FuguAgentProgressWheel)itemView.findViewById(R.id.circle_progress);
            this.btnRetry = (AppCompatButton)itemView.findViewById(R.id.btnRetry);
            this.btnCancel = (AppCompatButton)itemView.findViewById(R.id.btnCancel);
            this.messageSourceType = (ImageView)itemView.findViewById(R.id.message_source_type);
            this.messageSourceType1 = (ImageView)itemView.findViewById(R.id.message_source_type1);
            this.messageSourceType2 = (ImageView)itemView.findViewById(R.id.message_source_type2);
            this.userName = (TextView)itemView.findViewById(R.id.tvName);
            this.userImage = (ImageView)itemView.findViewById(R.id.user_image);
        }
    }

    class SentFileViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayoutCompat llRoot;
        private LinearLayoutCompat llMessage;
        private LinearLayoutCompat llImages;
        private TextView tvFileName;
        private TextView tvFileSize;
        private TextView tvFileExtension;
        private TextView tvFileTime;
        private AppCompatImageView ivFilePlay;
        private AppCompatImageView ivFileDownload;
        private AppCompatImageView ivFileUpload;
        private ImageView ivFileImage;
        private ImageView ivMessageState;
        private ImageView messageSourceType;
        private ImageView messageSourceType1;
        private ImageView messageSourceType2;
        private FuguAgentProgressWheel circleProgress;
        private ImageView userImage;
        private TextView tvName;

        public SentFileViewHolder(View itemView) {
            super(itemView);
            this.llRoot = (LinearLayoutCompat)itemView.findViewById(R.id.llRoot);
            this.llMessage = (LinearLayoutCompat)itemView.findViewById(R.id.llMessage);
            this.llImages = (LinearLayoutCompat)itemView.findViewById(R.id.llImages);
            this.tvFileName = (TextView)itemView.findViewById(R.id.tvFileName);
            this.tvFileSize = (TextView)itemView.findViewById(R.id.tvFileSize);
            this.tvFileExtension = (TextView)itemView.findViewById(R.id.tvFileExtension);
            this.tvFileTime = (TextView)itemView.findViewById(R.id.tvFileTime);
            this.ivFileImage = (ImageView)itemView.findViewById(R.id.ivFileImage);
            this.ivFilePlay = (AppCompatImageView)itemView.findViewById(R.id.ivFilePlay);
            this.ivFileDownload = (AppCompatImageView)itemView.findViewById(R.id.ivFileDownload);
            this.ivFileUpload = (AppCompatImageView)itemView.findViewById(R.id.ivFileUpload);
            this.ivMessageState = (ImageView)itemView.findViewById(R.id.ivMessageState);
            this.circleProgress = (FuguAgentProgressWheel)itemView.findViewById(R.id.circle_progress);
            this.messageSourceType = (ImageView)itemView.findViewById(R.id.message_source_type);
            this.messageSourceType1 = (ImageView)itemView.findViewById(R.id.message_source_type1);
            this.messageSourceType2 = (ImageView)itemView.findViewById(R.id.message_source_type2);
            this.tvName = (TextView)itemView.findViewById(R.id.tvName);
            this.userImage = (ImageView)itemView.findViewById(R.id.user_image);
        }
    }

    class ReceivedFileViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayoutCompat llRoot;
        private LinearLayoutCompat llMessage;
        private LinearLayoutCompat llFile;
        private LinearLayoutCompat llImages;
        private TextView tvUserName;
        private TextView tvFileName;
        private TextView tvFileSize;
        private TextView tvFileExtension;
        private TextView tvFileTime;
        private ImageView ivFileImage;
        private ImageView messageSourceType;
        private ImageView messageSourceType1;
        private ImageView messageSourceType2;
        private AppCompatImageView ivFileDownload;
        private AppCompatImageView ivFilePlay;
        private AppCompatImageView ivFileUpload;
        private FuguAgentProgressWheel progressBar;
        private ImageView userImage;

        public ReceivedFileViewHolder(View itemView) {
            super(itemView);
            this.llRoot = (LinearLayoutCompat)itemView.findViewById(R.id.llRoot);
            this.llMessage = (LinearLayoutCompat)itemView.findViewById(R.id.llMessage);
            this.llFile = (LinearLayoutCompat)itemView.findViewById(R.id.llFile);
            this.llImages = (LinearLayoutCompat)itemView.findViewById(R.id.llImages);
            this.tvUserName = (TextView)itemView.findViewById(R.id.tvUserName);
            this.tvFileName = (TextView)itemView.findViewById(R.id.tvFileName);
            this.tvFileSize = (TextView)itemView.findViewById(R.id.tvFileSize);
            this.tvFileExtension = (TextView)itemView.findViewById(R.id.tvFileExtension);
            this.tvFileTime = (TextView)itemView.findViewById(R.id.tvFileTime);
            this.ivFileImage = (ImageView)itemView.findViewById(R.id.ivFileImage);
            this.ivFilePlay = (AppCompatImageView)itemView.findViewById(R.id.ivFilePlay);
            this.ivFileDownload = (AppCompatImageView)itemView.findViewById(R.id.ivFileDownload);
            this.ivFileUpload = (AppCompatImageView)itemView.findViewById(R.id.ivFileUpload);
            this.progressBar = (FuguAgentProgressWheel)itemView.findViewById(R.id.circle_progress);
            this.messageSourceType = (ImageView)itemView.findViewById(R.id.message_source_type);
            this.messageSourceType1 = (ImageView)itemView.findViewById(R.id.message_source_type1);
            this.messageSourceType2 = (ImageView)itemView.findViewById(R.id.message_source_type2);
            this.userImage = (ImageView)itemView.findViewById(R.id.user_image);
        }
    }

    class DateViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tvDate;

        public DateViewHolder(View itemView) {
            super(itemView);
            this.tvDate = (TextView)itemView.findViewById(R.id.tvDate);
        }
    }

    class AssignmentViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tvAssignment;

        public AssignmentViewHolder(View itemView) {
            super(itemView);
            this.tvAssignment = (TextView)itemView.findViewById(R.id.tvAssignment);
        }
    }

    class RatingViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayout rootView;
        private LinearLayout ratingView1;
        private LinearLayout ratingView2;
        private TextView title;
        private TextView userName;
        private TextView selectedStar;
        private TextView comment;
        private TextView thanksText;
        private ImageView userImage;
        private RatingBar ratingView;

        public RatingViewHolder(View itemView) {
            super(itemView);
            this.rootView = (LinearLayout)itemView.findViewById(R.id.llRoot);
            this.ratingView1 = (LinearLayout)itemView.findViewById(R.id.ratingView1);
            this.ratingView2 = (LinearLayout)itemView.findViewById(R.id.ratingView2);
            this.userImage = (ImageView)itemView.findViewById(R.id.user_image);
            this.userName = (TextView)itemView.findViewById(R.id.tvUserName);
            this.title = (TextView)itemView.findViewById(R.id.title);
            this.ratingView = (RatingBar)itemView.findViewById(R.id.ratingView);
            this.selectedStar = (TextView)itemView.findViewById(R.id.selectedStar);
            this.thanksText = (TextView)itemView.findViewById(R.id.thanks_text);
            this.comment = (TextView)itemView.findViewById(R.id.comment);
        }
    }

    class CustomViewHolder
    extends RecyclerView.ViewHolder {
        private RelativeLayout rlCustomAction;
        private ImageView ivActionImage;
        private TextView tvActionTitle;
        private TextView tvActionTitleDescription;
        private RecyclerView rvActionDescription;
        private RecyclerView rvActionButtons;
        private View vwActionButtonDivider;
        private LinearLayout llTextualContent;
        private LinearLayout llRoot;
        private RelativeLayout llChatLeft;
        private ImageView userImage;
        private TextView userName;

        public CustomViewHolder(View itemView) {
            super(itemView);
            this.llRoot = (LinearLayout)itemView.findViewById(R.id.llRoot);
            this.llChatLeft = (RelativeLayout)itemView.findViewById(R.id.llChatLeft);
            this.rlCustomAction = (RelativeLayout)itemView.findViewById(R.id.layoutCustomAction);
            this.tvActionTitle = (TextView)itemView.findViewById(R.id.tvActionTitle);
            this.rvActionDescription = (RecyclerView)itemView.findViewById(R.id.rvActionDescription);
            this.rvActionButtons = (RecyclerView)itemView.findViewById(R.id.rvActionButtons);
            this.ivActionImage = (ImageView)itemView.findViewById(R.id.ivActionImage);
            this.vwActionButtonDivider = itemView.findViewById(R.id.vwActionButtonDivider);
            this.tvActionTitleDescription = (TextView)itemView.findViewById(R.id.tvActionDescription);
            this.llTextualContent = (LinearLayout)itemView.findViewById(R.id.llTextualContent);
            this.userImage = (ImageView)itemView.findViewById(R.id.user_image);
            this.userName = (TextView)itemView.findViewById(R.id.tvUserName);
        }
    }

    class VideoViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tvMsg;
        private TextView tvTime;
        private TextView callAgain;
        private TextView tvDuration;
        private ImageView ivCallIcon;
        private LinearLayout llChat;
        private ImageView userImage;
        private TextView tvUserName;
        private View callDivider;

        public VideoViewHolder(View itemView) {
            super(itemView);
            this.tvMsg = (TextView)itemView.findViewById(R.id.tvMsg);
            this.tvTime = (TextView)itemView.findViewById(R.id.tvTime);
            this.callAgain = (TextView)itemView.findViewById(R.id.callAgain);
            this.tvDuration = (TextView)itemView.findViewById(R.id.tvDuration);
            this.llChat = (LinearLayout)itemView.findViewById(R.id.llMessage);
            this.ivCallIcon = (ImageView)itemView.findViewById(R.id.ivCallIcon);
            this.userImage = (ImageView)itemView.findViewById(R.id.user_image);
            this.tvUserName = (TextView)itemView.findViewById(R.id.tvUserName);
            this.callDivider = itemView.findViewById(R.id.call_divider);
        }
    }

    class SelfVideoViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tvMsg;
        private TextView tvTime;
        private TextView callAgain;
        private TextView tvDuration;
        private ImageView ivCallIcon;
        private LinearLayout llChat;
        private ImageView userImage;
        private TextView tvUserName;
        private View dividerView;

        public SelfVideoViewHolder(View itemView) {
            super(itemView);
            this.tvMsg = (TextView)itemView.findViewById(R.id.tvMsg);
            this.tvTime = (TextView)itemView.findViewById(R.id.tvTime);
            this.callAgain = (TextView)itemView.findViewById(R.id.callAgain);
            this.tvDuration = (TextView)itemView.findViewById(R.id.tvDuration);
            this.llChat = (LinearLayout)itemView.findViewById(R.id.llMessage);
            this.ivCallIcon = (ImageView)itemView.findViewById(R.id.ivCallIcon);
            this.userImage = (ImageView)itemView.findViewById(R.id.user_image);
            this.tvUserName = (TextView)itemView.findViewById(R.id.tvName);
            this.dividerView = itemView.findViewById(R.id.dividerView);
        }
    }

    class EmptyViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayout lead_form_data;

        public EmptyViewHolder(View itemView) {
            super(itemView);
        }
    }

    class LeadFormViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayout lead_form_data;
        private RelativeLayout mainLayout;
        private ImageView userImage;
        private TextView tvUserName;

        public LeadFormViewHolder(View itemView) {
            super(itemView);
            this.mainLayout = (RelativeLayout)itemView.findViewById(R.id.main_layout);
            this.lead_form_data = (LinearLayout)itemView.findViewById(R.id.lead_form_data);
            this.userImage = (ImageView)itemView.findViewById(R.id.user_image);
            this.tvUserName = (TextView)itemView.findViewById(R.id.tvUserName);
        }
    }

    class SelfMessageViewHolder
    extends RecyclerView.ViewHolder {
        private RelativeLayout llRoot;
        private LinearLayout llTime;
        private TextView tvMsg;
        private TextView tvTime;
        private TextView tvName;
        private TextView tvTryAgain;
        private TextView tvCancel;
        private RelativeLayout rlImageMessage;
        private RelativeLayout rlMessages;
        private LinearLayout llChat;
        private ImageView ivMessageState;
        private ImageView ivMsgImage;
        private ImageView messageSourceType;
        private ImageView messageSourceType1;
        private ImageView messageSourceType2;
        private ProgressBar pbLoading;
        private Button btnRetry;
        private Button btnCancel;
        private LinearLayout llRetry;
        private ImageView userImage;

        public SelfMessageViewHolder(final View itemView, final OnRecyclerListener itemClickListener) {
            super(itemView);
            this.llRoot = (RelativeLayout)itemView.findViewById(R.id.llRoot);
            this.llTime = (LinearLayout)itemView.findViewById(R.id.llTime);
            this.tvMsg = (TextView)itemView.findViewById(R.id.tvMsg);
            this.tvName = (TextView)itemView.findViewById(R.id.tvName);
            this.tvTime = (TextView)itemView.findViewById(R.id.tvTime);
            this.llChat = (LinearLayout)itemView.findViewById(R.id.llChat);
            this.rlImageMessage = (RelativeLayout)itemView.findViewById(R.id.rlImageMessage);
            this.rlMessages = (RelativeLayout)itemView.findViewById(R.id.rlMessages);
            this.ivMessageState = (ImageView)itemView.findViewById(R.id.ivMessageState);
            this.ivMsgImage = (ImageView)itemView.findViewById(R.id.ivMsgImage);
            this.pbLoading = (ProgressBar)itemView.findViewById(R.id.pbLoading);
            this.btnRetry = (Button)itemView.findViewById(R.id.btnRetry);
            this.btnCancel = (Button)itemView.findViewById(R.id.btnCancel);
            this.llRetry = (LinearLayout)itemView.findViewById(R.id.llRetry);
            this.tvTryAgain = (TextView)itemView.findViewById(R.id.tvTryAgain);
            this.tvCancel = (TextView)itemView.findViewById(R.id.tvCancel);
            this.messageSourceType = (ImageView)itemView.findViewById(R.id.message_source_type);
            this.messageSourceType1 = (ImageView)itemView.findViewById(R.id.message_source_type1);
            this.messageSourceType2 = (ImageView)itemView.findViewById(R.id.message_source_type2);
            this.userImage = (ImageView)itemView.findViewById(R.id.user_image);
            this.tvMsg.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    itemClickListener.onItemLongClick((View)SelfMessageViewHolder.this.llRoot, itemView, SelfMessageViewHolder.this.getAdapterPosition(), false);
                    return true;
                }
            });
            this.llRoot.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    itemClickListener.onItemLongClick((View)SelfMessageViewHolder.this.llRoot, itemView, SelfMessageViewHolder.this.getAdapterPosition(), false);
                    return true;
                }
            });
        }
    }

    class OtherMessageViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayout llRoot;
        private LinearLayout llChatLeft;
        private TextView tvUserName;
        private TextView tvMsg;
        private TextView tvTime;
        private TextView tvTimeNew;
        private RelativeLayout rlImageMessage;
        private RelativeLayout rlMessages;
        private RelativeLayout rlimagetime;
        private ImageView ivMsgImage;
        private ImageView userImage;
        private ImageView messageSourceType;
        private ImageView messageSourceType1;
        private ImageView messageSourceType2;

        public OtherMessageViewHolder(final View itemView, final OnRecyclerListener itemClickListener) {
            super(itemView);
            this.llRoot = (LinearLayout)itemView.findViewById(R.id.llRoot);
            this.llChatLeft = (LinearLayout)itemView.findViewById(R.id.llChatLeft);
            this.tvUserName = (TextView)itemView.findViewById(R.id.tvUserName);
            this.tvMsg = (TextView)itemView.findViewById(R.id.tvMsg);
            this.tvTime = (TextView)itemView.findViewById(R.id.tvTime);
            this.rlimagetime = (RelativeLayout)itemView.findViewById(R.id.rlimagetime);
            this.tvTimeNew = (TextView)itemView.findViewById(R.id.tvImageTime);
            this.rlImageMessage = (RelativeLayout)itemView.findViewById(R.id.rlImageMessage);
            this.rlMessages = (RelativeLayout)itemView.findViewById(R.id.rlMessages);
            this.ivMsgImage = (ImageView)itemView.findViewById(R.id.ivMsgImage);
            this.userImage = (ImageView)itemView.findViewById(R.id.user_image);
            this.messageSourceType = (ImageView)itemView.findViewById(R.id.message_source_type);
            this.messageSourceType1 = (ImageView)itemView.findViewById(R.id.message_source_type1);
            this.messageSourceType2 = (ImageView)itemView.findViewById(R.id.message_source_type2);
            this.tvMsg.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    itemClickListener.onItemLongClick((View)OtherMessageViewHolder.this.llRoot, itemView, OtherMessageViewHolder.this.getAdapterPosition(), false);
                    return true;
                }
            });
            this.llRoot.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    itemClickListener.onItemLongClick((View)OtherMessageViewHolder.this.llRoot, itemView, OtherMessageViewHolder.this.getAdapterPosition(), false);
                    return true;
                }
            });
        }
    }

    public static interface AdapterCallback {
        public void showImageDialog(Activity var1, String var2, ImageView var3, Message var4);
    }

    public static interface OnRetryListener {
        public void onRetry(String var1, String var2, int var3, String var4);

        public void onMessageRetry(String var1, int var2);

        public void onMessageCancel(String var1, int var2);

        public void onFileMessageRetry(String var1, int var2);
    }

    public static interface OnUserConcent {
        public void onConcentClicked(Message var1);
    }

    public static interface onVideoCall {
        public void onVideoCallClicked(int var1);
    }
}

