/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import androidx.recyclerview.widget.RecyclerView;
import com.hippoagent.R;
import com.hippoagent.database.CommonData;
import com.hippoagent.model.ActionButtonModel;
import com.hippoagent.utils.FuguColorConfig;
import java.util.ArrayList;

public class CustomActionButtonsAdapter
extends RecyclerView.Adapter<ActionButtonViewHolder> {
    private Context mContext;
    private LayoutInflater mLayoutInflater;
    private ArrayList<ActionButtonModel> mActionButtons;
    private FuguColorConfig fuguColorConfig;

    public CustomActionButtonsAdapter(Context context, ArrayList<ActionButtonModel> actionButtons) {
        this.mContext = context;
        this.mLayoutInflater = LayoutInflater.from((Context)context);
        this.mActionButtons = actionButtons;
        this.fuguColorConfig = CommonData.getColorConfig();
    }

    public ActionButtonViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View main = this.mLayoutInflater.inflate(R.layout.hippo_list_item_action_button, parent, false);
        return new ActionButtonViewHolder(main);
    }

    public void onBindViewHolder(ActionButtonViewHolder holder, int position) {
        int pos = holder.getAdapterPosition();
        ActionButtonModel actionButton = this.mActionButtons.get(pos);
        holder.btnAction.setText((CharSequence)actionButton.getButtonText());
        holder.btnAction.setTextColor(this.fuguColorConfig.getFuguPrimaryTextMsgFrom());
    }

    public int getItemCount() {
        return this.mActionButtons.size();
    }

    class ActionButtonViewHolder
    extends RecyclerView.ViewHolder {
        Button btnAction;

        ActionButtonViewHolder(View itemView) {
            super(itemView);
            this.btnAction = (Button)itemView.findViewById(R.id.btnAction);
            this.btnAction.setClickable(false);
            this.btnAction.setEnabled(false);
        }
    }
}

