/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.activities;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.google.gson.Gson;
import com.hippoagent.HippoApplication;
import com.hippoagent.R;
import com.hippoagent.activities.FuguBaseActivity;
import com.hippoagent.fragments.AddCardFragment;
import com.hippoagent.fragments.PaymentAgentFragment;
import com.hippoagent.langs.Restring;
import com.hippoagent.model.LoginResponse.ExpiryInfo;
import com.hippoagent.model.LoginResponse.UserData;
import com.hippoagent.model.payment.ActiveAgent;
import com.hippoagent.model.payment.Data;
import com.hippoagent.model.payment.PaymentModel;
import com.hippoagent.model.payment.Properties;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.filelogger.Logger;
import java.io.Serializable;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Callback;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\u0012\u0010\u0019\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u0017H\u0014J\b\u0010\u001d\u001a\u00020\u0017H\u0014J\b\u0010\u001e\u001a\u00020\u0017H\u0014J\u0006\u0010\u001f\u001a\u00020\u0017J\u0016\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000bJ\u0015\u0010$\u001a\u00020\u000b2\b\u0010%\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010&J\u000e\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u0011R\"\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006)"}, d2={"Lcom/hippoagent/activities/PaymentViewActivity;", "Lcom/hippoagent/activities/FuguBaseActivity;", "()V", "agents", "Ljava/util/ArrayList;", "Lcom/hippoagent/model/payment/ActiveAgent;", "getAgents", "()Ljava/util/ArrayList;", "setAgents", "(Ljava/util/ArrayList;)V", "baseAmount", "", "getBaseAmount", "()D", "setBaseAmount", "(D)V", "errorMessage", "", "getErrorMessage", "()Ljava/lang/String;", "setErrorMessage", "(Ljava/lang/String;)V", "getAgentData", "", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "onPause", "onResume", "openAddCardView", "openPaymentAgent", "count", "", "total", "roundOffDecimal", "number", "(Ljava/lang/Double;)D", "updateTitle", "title", "hippoagentsdk_release"})
public final class PaymentViewActivity
extends FuguBaseActivity {
    @Nullable
    private ArrayList<ActiveAgent> agents;
    private double baseAmount;
    @NotNull
    private String errorMessage = "";
    private HashMap _$_findViewCache;

    @Nullable
    public final ArrayList<ActiveAgent> getAgents() {
        return this.agents;
    }

    public final void setAgents(@Nullable ArrayList<ActiveAgent> arrayList) {
        this.agents = arrayList;
    }

    public final double getBaseAmount() {
        return this.baseAmount;
    }

    public final void setBaseAmount(double d) {
        this.baseAmount = d;
    }

    @NotNull
    public final String getErrorMessage() {
        return this.errorMessage;
    }

    public final void setErrorMessage(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        this.errorMessage = string2;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_payment);
        this.setSupportActionBar((Toolbar)this._$_findCachedViewById(R.id.my_toolbar));
        HippoApplication hippoApplication = HippoApplication.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication), (String)"HippoApplication.getInstance()");
        UserData userData = hippoApplication.getUserData();
        Intrinsics.checkExpressionValueIsNotNull((Object)userData, (String)"HippoApplication.getInstance().userData");
        ExpiryInfo expiryInfo = userData.getExpiryInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)expiryInfo, (String)"HippoApplication.getInstance().userData.expiryInfo");
        if (expiryInfo.isAskCardDetails()) {
            this.setToolbar((Toolbar)this._$_findCachedViewById(R.id.my_toolbar), Restring.getString((Context)this, R.string.hippo_payment));
        } else {
            this.setToolbar((Toolbar)this._$_findCachedViewById(R.id.my_toolbar), Restring.getString((Context)this, R.string.hippo_verify_details));
        }
        this.getAgentData();
        ((Toolbar)this._$_findCachedViewById(R.id.my_toolbar)).setNavigationOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ PaymentViewActivity this$0;

            public final void onClick(View it) {
                this.this$0.onBackPressed();
            }
            {
                this.this$0 = paymentViewActivity;
            }
        });
    }

    public final void updateTitle(@NotNull String title) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        this.updateToolbar((Toolbar)this._$_findCachedViewById(R.id.my_toolbar), title);
    }

    public final void openPaymentAgent(int count, double total) {
        Bundle bundle = new Bundle();
        bundle.putSerializable("agents", (Serializable)this.agents);
        bundle.putInt("count", count);
        bundle.putDouble("total", total);
        PaymentAgentFragment fragment = new PaymentAgentFragment();
        fragment.setArguments(bundle);
        this.getSupportFragmentManager().beginTransaction().add(R.id.main_layout, (Fragment)fragment, PaymentAgentFragment.class.getName()).addToBackStack(PaymentAgentFragment.class.getName()).commitAllowingStateLoss();
    }

    public final void openAddCardView() {
        Bundle bundle = new Bundle();
        bundle.putSerializable("agents", (Serializable)this.agents);
        AddCardFragment fragment = new AddCardFragment();
        fragment.setArguments(bundle);
        this.getSupportFragmentManager().beginTransaction().add(R.id.main_layout, (Fragment)fragment, AddCardFragment.class.getName()).addToBackStack(AddCardFragment.class.getName()).commitAllowingStateLoss();
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    protected void onPause() {
        super.onPause();
    }

    public void onBackPressed() {
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentManager, (String)"supportFragmentManager");
        if (fragmentManager.getBackStackEntryCount() < 2) {
            this.finish();
        } else {
            super.onBackPressed();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    public final void getAgentData() {
        CommonParams.Builder builder2 = new CommonParams.Builder();
        HippoApplication hippoApplication = HippoApplication.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication), (String)"HippoApplication.getInstance()");
        UserData userData = hippoApplication.getUserData();
        Intrinsics.checkExpressionValueIsNotNull((Object)userData, (String)"HippoApplication.getInstance().userData");
        CommonParams commonParams = builder2.add("access_token", userData.getAccessToken()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)commonParams, (String)"CommonParams.Builder()\n \u2026\n                .build()");
        CommonParams params = commonParams;
        String string2 = new Gson().toJson(params.getMap());
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Gson().toJson(params.map)");
        Logger.INSTANCE.apiRequest("/api/billing/getProperties", string2);
        RestClient.getApiInterface().getPayemtAgent((Map<String, String>)params.getMap()).enqueue((Callback)new ResponseResolver<PaymentModel>(this, (Activity)this, Boolean.valueOf(true), Boolean.valueOf(false)){
            final /* synthetic */ PaymentViewActivity this$0;

            public void success(@NotNull PaymentModel paymentModel) {
                Object object;
                ActiveAgent activeAgent;
                Intrinsics.checkParameterIsNotNull((Object)paymentModel, (String)"paymentModel");
                Logger.INSTANCE.apiResponse("/api/billing/getProperties", "");
                this.this$0.setAgents(new ArrayList<ActiveAgent>());
                Data data = paymentModel.getData();
                if ((data != null ? data.getActiveAgents() : null) != null) {
                    Data data2 = paymentModel.getData();
                    List<ActiveAgent> list = data2 != null ? data2.getActiveAgents() : null;
                    if (list == null) {
                        Intrinsics.throwNpe();
                    }
                    if (list.size() > 0) {
                        activeAgent = new ActiveAgent();
                        activeAgent.setStatus(-100);
                        activeAgent.setFullName("Active Agent");
                        Data data3 = paymentModel.getData();
                        List<ActiveAgent> list2 = data3 != null ? data3.getActiveAgents() : null;
                        if (list2 == null) {
                            Intrinsics.throwNpe();
                        }
                        if (list2.size() > 1) {
                            activeAgent.setFullName("Active Agents");
                        }
                        activeAgent.setChecked(false);
                        ArrayList<ActiveAgent> arrayList = this.this$0.getAgents();
                        if (arrayList == null) {
                            Intrinsics.throwNpe();
                        }
                        arrayList.add(activeAgent);
                        ArrayList<ActiveAgent> arrayList2 = this.this$0.getAgents();
                        if (arrayList2 == null) {
                            Intrinsics.throwNpe();
                        }
                        Data data4 = paymentModel.getData();
                        Intrinsics.checkExpressionValueIsNotNull((Object)data4, (String)"paymentModel.data");
                        arrayList2.addAll((Collection<ActiveAgent>)data4.getActiveAgents());
                    }
                }
                Data data5 = paymentModel.getData();
                if ((data5 != null ? data5.getInvitedAgents() : null) != null) {
                    Data data6 = paymentModel.getData();
                    List<ActiveAgent> list = data6 != null ? data6.getInvitedAgents() : null;
                    if (list == null) {
                        Intrinsics.throwNpe();
                    }
                    if (list.size() > 0) {
                        activeAgent = new ActiveAgent();
                        activeAgent.setStatus(-101);
                        activeAgent.setFullName("Invited Agent");
                        Data data7 = paymentModel.getData();
                        List<ActiveAgent> list3 = data7 != null ? data7.getInvitedAgents() : null;
                        if (list3 == null) {
                            Intrinsics.throwNpe();
                        }
                        if (list3.size() > 1) {
                            activeAgent.setFullName("Invited Agents");
                        }
                        activeAgent.setChecked(false);
                        ArrayList<ActiveAgent> arrayList = this.this$0.getAgents();
                        if (arrayList == null) {
                            Intrinsics.throwNpe();
                        }
                        arrayList.add(activeAgent);
                        ArrayList<ActiveAgent> arrayList3 = this.this$0.getAgents();
                        if (arrayList3 == null) {
                            Intrinsics.throwNpe();
                        }
                        Data data8 = paymentModel.getData();
                        Intrinsics.checkExpressionValueIsNotNull((Object)data8, (String)"paymentModel.data");
                        arrayList3.addAll((Collection<ActiveAgent>)data8.getInvitedAgents());
                    }
                }
                Double d = (object = paymentModel.getData()) != null && (object = ((Data)object).getProperties()) != null ? ((Properties)object).getAgentBased() : null;
                if (d == null) {
                    Intrinsics.throwNpe();
                }
                this.this$0.setBaseAmount(d);
                Integer count = 0;
                ArrayList<ActiveAgent> arrayList = this.this$0.getAgents();
                if (arrayList == null) {
                    Intrinsics.throwNpe();
                }
                Iterator<ActiveAgent> iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    ActiveAgent agent;
                    ActiveAgent activeAgent2 = agent = iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)activeAgent2, (String)"agent");
                    if (!activeAgent2.isChecked() || Intrinsics.compare((int)agent.getStatus(), (int)-1) <= 0) continue;
                    Integer n = count;
                    count = n != null ? Integer.valueOf(n + 1) : null;
                }
                double total = 0.0;
                Integer n = count;
                if (n == null) {
                    Intrinsics.throwNpe();
                }
                if (n > 0) {
                    total = this.this$0.roundOffDecimal((double)count.intValue() * this.this$0.getBaseAmount());
                }
                HippoApplication hippoApplication = HippoApplication.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)hippoApplication), (String)"HippoApplication.getInstance()");
                UserData userData = hippoApplication.getUserData();
                Intrinsics.checkExpressionValueIsNotNull((Object)userData, (String)"HippoApplication.getInstance().userData");
                ExpiryInfo expiryInfo = userData.getExpiryInfo();
                Intrinsics.checkExpressionValueIsNotNull((Object)expiryInfo, (String)"HippoApplication.getInstance().userData.expiryInfo");
                if (expiryInfo.isAskCardDetails()) {
                    this.this$0.openAddCardView();
                } else {
                    this.this$0.openPaymentAgent(count, total);
                }
            }

            public void failure(@NotNull APIError error) {
                String string2;
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                if (!TextUtils.isEmpty((CharSequence)error.getMessage())) {
                    String string3 = error.getMessage();
                    string2 = string3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"error.message");
                } else {
                    string2 = "Something went wrong";
                }
                this.this$0.setErrorMessage(string2);
                Logger.INSTANCE.apiFailed("/api/billing/getProperties", this.this$0.getErrorMessage());
                Bundle bundle = new Bundle();
                bundle.putString("errorMessage", this.this$0.getErrorMessage());
                PaymentAgentFragment fragment = new PaymentAgentFragment();
                fragment.setArguments(bundle);
                this.this$0.getSupportFragmentManager().beginTransaction().add(R.id.main_layout, (Fragment)fragment, PaymentAgentFragment.class.getName()).addToBackStack(PaymentAgentFragment.class.getName()).commitAllowingStateLoss();
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        });
    }

    public final double roundOffDecimal(@Nullable Double number) {
        try {
            DecimalFormat df = new DecimalFormat("#.##");
            df.setRoundingMode(RoundingMode.HALF_UP);
            String string2 = df.format(number);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"df.format(number)");
            String string3 = string2;
            boolean bl = false;
            return Double.parseDouble(string3);
        }
        catch (Exception e) {
            Double d = number;
            if (d == null) {
                Intrinsics.throwNpe();
            }
            return d;
        }
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

