/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.activities;

import android.animation.ObjectAnimator;
import android.app.Activity;
import android.app.DownloadManager;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import android.util.Property;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.CustomViewTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.easyfilepicker.easypermissions.AfterPermissionGranted;
import com.easyfilepicker.easypermissions.AppSettingsDialog;
import com.easyfilepicker.easypermissions.EasyPermissions;
import com.hippoagent.HippoApplication;
import com.hippoagent.R;
import com.hippoagent.activities.FuguBaseActivity;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.langs.Restring;
import com.hippoagent.model.Image;
import com.hippoagent.utils.DateUtils;
import com.hippoagent.utils.Utils;
import com.hippoagent.utils.loadingBox.FuguAgentProgressWheel;
import com.hippoagent.utils.zoomview.ZoomageView;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;

public class ImageDisplayActivity
extends FuguBaseActivity
implements EasyPermissions.PermissionCallbacks {
    private static final String TAG = ImageDisplayActivity.class.getSimpleName();
    private String imageUrl = "";
    ImageView ivImage;
    ImageView ivDownload;
    LinearLayout llTopBar;
    TextView tvDateTime;
    ZoomageView ivOriginalImage;
    FuguAgentProgressWheel progressWheel;
    private Image image;
    private RelativeLayout mainLayout;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.hippo_activity_image_display);
        if (Build.VERSION.SDK_INT < 26) {
            this.setRequestedOrientation(1);
        } else {
            this.setRequestedOrientation(-1);
        }
        this.mainLayout = (RelativeLayout)this.findViewById(R.id.main_layout);
        this.progressWheel = (FuguAgentProgressWheel)this.findViewById(R.id.progress);
        this.progressWheel.spin();
        this.ivImage = (ImageView)this.findViewById(R.id.ivMsgImage);
        this.ivDownload = (ImageView)this.findViewById(R.id.ivDownload);
        this.ivOriginalImage = (ZoomageView)this.findViewById(R.id.ivOriginalImage);
        this.llTopBar = (LinearLayout)this.findViewById(R.id.llTopBar);
        TextView tvChannelName = (TextView)this.findViewById(R.id.tvChannelName);
        this.tvDateTime = (TextView)this.findViewById(R.id.tvDateTime);
        ImageView ivBack = (ImageView)this.findViewById(R.id.ivBack);
        this.image = (Image)this.getIntent().getSerializableExtra("image");
        if (!TextUtils.isEmpty((CharSequence)this.image.getChannelName())) {
            tvChannelName.setText((CharSequence)this.image.getChannelName());
        } else {
            tvChannelName.setText((CharSequence)"Message");
        }
        this.ivImage.setVisibility(0);
        SimpleDateFormat formatter = new SimpleDateFormat("dd MMM, hh:mm a");
        SimpleDateFormat formatter2 = new SimpleDateFormat("hh:mm a");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.ENGLISH);
        try {
            String date = formatter.format(sdf.parse(DateUtils.getInstance().convertToLocal(this.image.getDateTime())));
            if (android.text.format.DateUtils.isToday((long)sdf.parse(DateUtils.getInstance().convertToLocal(this.image.getDateTime())).getTime())) {
                String time = formatter2.format(sdf.parse(DateUtils.getInstance().convertToLocal(this.image.getDateTime())));
                this.tvDateTime.setText((CharSequence)(Restring.getString((Context)this, R.string.today) + ", " + time));
            } else {
                this.tvDateTime.setText((CharSequence)formatter.format(sdf.parse(DateUtils.getInstance().convertToLocal(this.image.getDateTime()))));
            }
        }
        catch (Exception e) {
            this.tvDateTime.setVisibility(8);
        }
        ivBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ImageDisplayActivity.this.onBackPressed();
            }
        });
        this.ivDownload.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ImageDisplayActivity.this.downloadFile(ImageDisplayActivity.this.image.getImageUrl());
            }
        });
        new RequestOptions();
        RequestOptions requestOptions = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)RequestOptions.placeholderOf((int)R.drawable.hippo_placeholder).dontAnimate()).onlyRetrieveFromCache(true)).diskCacheStrategy(DiskCacheStrategy.ALL)).error(R.drawable.hippo_call_placeholder)).dontTransform();
        final RequestOptions requestOptions2 = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)new RequestOptions().dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(R.drawable.hippo_call_placeholder)).dontTransform();
        Glide.with((FragmentActivity)this).load(this.image.getThumbnailUrl()).apply((BaseRequestOptions)requestOptions).into((Target)new CustomViewTarget<RelativeLayout, Drawable>(this.mainLayout){

            public void onLoadFailed(@Nullable Drawable errorDrawable) {
                ImageDisplayActivity.this.ivImage.setVisibility(8);
                ImageDisplayActivity.this.progressWheel.setVisibility(8);
                Glide.with((FragmentActivity)ImageDisplayActivity.this).asBitmap().apply((BaseRequestOptions)requestOptions2).load(ImageDisplayActivity.this.image.getImageUrl()).into((ImageView)ImageDisplayActivity.this.ivOriginalImage);
            }

            public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
                ImageDisplayActivity.this.supportStartPostponedEnterTransition();
                ImageDisplayActivity.this.ivImage.setVisibility(0);
                ImageDisplayActivity.this.ivImage.setImageDrawable(resource);
                ImageDisplayActivity.this.progressWheel.setVisibility(8);
                new ObjectAnimator();
                ObjectAnimator alphaAnimation = ObjectAnimator.ofFloat((Object)ImageDisplayActivity.this.llTopBar, (Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f});
                alphaAnimation.setDuration(500L);
                alphaAnimation.setStartDelay(200L);
                alphaAnimation.start();
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Glide.with((FragmentActivity)ImageDisplayActivity.this).load(ImageDisplayActivity.this.image.getImageUrl()).apply((BaseRequestOptions)requestOptions2).into((Target)new CustomViewTarget<RelativeLayout, Drawable>(ImageDisplayActivity.this.mainLayout){

                            protected void onResourceCleared(@Nullable Drawable placeholder) {
                            }

                            public void onLoadFailed(@Nullable Drawable errorDrawable) {
                                ImageDisplayActivity.this.ivImage.setVisibility(8);
                                ImageDisplayActivity.this.progressWheel.setVisibility(8);
                                Glide.with((FragmentActivity)ImageDisplayActivity.this).asBitmap().apply((BaseRequestOptions)requestOptions2).load(ImageDisplayActivity.this.image.getThumbnailUrl()).into((ImageView)ImageDisplayActivity.this.ivOriginalImage);
                            }

                            public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
                                ImageDisplayActivity.this.supportStartPostponedEnterTransition();
                                ImageDisplayActivity.this.ivImage.setVisibility(8);
                                ImageDisplayActivity.this.ivOriginalImage.setImageDrawable(resource);
                                if (Build.VERSION.SDK_INT >= 21) {
                                    ImageDisplayActivity.this.ivImage.setTransitionName("");
                                    ImageDisplayActivity.this.ivOriginalImage.setTransitionName(ImageDisplayActivity.this.getString(R.string.activity_image_trans));
                                }
                            }
                        });
                    }
                }, 500L);
            }

            protected void onResourceCleared(@Nullable Drawable placeholder) {
            }
        });
    }

    public void onBackPressed() {
        this.supportFinishAfterTransition();
        super.onBackPressed();
    }

    private Long downloadFile(String url) {
        if (!this.checkPermission()) {
            this.readExternalStorage();
            return null;
        }
        String fileName = Utils.extractFileNameWithoutSuffix(url);
        String ext = Utils.getExtension(url);
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)url));
        request.setDescription((CharSequence)HippoApplication.getInstance().getUserData().getBusinessName());
        request.setTitle((CharSequence)fileName);
        request.allowScanningByMediaScanner();
        request.setNotificationVisibility(1);
        String directory = Utils.getOrCreateDirectoryPath(FuguAppConstant.DocumentType.IMAGE.toString());
        request.setDestinationInExternalPublicDir(directory, fileName + ext);
        request.setMimeType("image/jpeg");
        DownloadManager manager = (DownloadManager)this.getSystemService("download");
        if (manager != null) {
            return manager.enqueue(request);
        }
        return null;
    }

    public boolean checkPermission() {
        return EasyPermissions.hasPermissions((Context)this, (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"});
    }

    @AfterPermissionGranted(value=123)
    public void readExternalStorage() {
        boolean isGranted = EasyPermissions.hasPermissions((Context)this, (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"});
        if (isGranted) {
            this.permissionGranted();
        } else {
            EasyPermissions.requestPermissions((Activity)this, (String)Restring.getString((Context)this, R.string.vw_rationale_storage), (int)123, (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"});
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        EasyPermissions.onRequestPermissionsResult((int)requestCode, (String[])permissions, (int[])grantResults, (Object[])new Object[]{this});
    }

    public void onPermissionsGranted(int requestCode, List<String> perms) {
        Log.d((String)TAG, (String)("onPermissionsGranted:" + requestCode + ":" + perms.size()));
        this.permissionGranted();
    }

    public void onPermissionsDenied(int requestCode, List<String> perms) {
        Log.d((String)TAG, (String)("onPermissionsDenied:" + requestCode + ":" + perms.size()));
        if (EasyPermissions.somePermissionPermanentlyDenied((Activity)this, perms)) {
            new AppSettingsDialog.Builder((Activity)this).build().show();
        } else {
            this.finish();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 16061) {
            if (EasyPermissions.hasPermissions((Context)this, (String[])new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"})) {
                this.permissionGranted();
            } else {
                this.finish();
            }
        }
    }

    private void permissionGranted() {
        this.downloadFile(this.image.getImageUrl());
    }
}

