/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.MenuItem;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.Toolbar;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.gson.Gson;
import com.hippoagent.HippoApplication;
import com.hippoagent.R;
import com.hippoagent.activities.BroadcastDetailsActivity;
import com.hippoagent.activities.FuguBaseActivity;
import com.hippoagent.adapters.BroadcastListAdapter;
import com.hippoagent.adapters.OnItemClickListener;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.langs.Restring;
import com.hippoagent.model.BroadCastObjectModel;
import com.hippoagent.model.BroadcastResponse;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.filelogger.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import retrofit2.Callback;

public class BroadcastListActivity
extends FuguBaseActivity
implements FuguAppConstant,
OnItemClickListener {
    private static final String TAG = BroadcastListActivity.class.getSimpleName();
    private RecyclerView recyclerView;
    private BroadcastListAdapter listAdapter;
    private Toolbar toolbar;
    private LinearLayout llNoConversation;
    private ArrayList<BroadCastObjectModel> objectModels = new ArrayList();
    private int pastVisiblesItems;
    private int visibleItemCount;
    private int totalItemCount;
    private boolean hasMorePages;
    private boolean isPagingApiInProgress;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_broadcast_list);
        this.toolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(this.toolbar);
        this.setToolbar(this.toolbar, Restring.getString((Context)this, R.string.broadcast_history));
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recyclerView);
        this.listAdapter = new BroadcastListAdapter(this.recyclerView, this);
        final LinearLayoutManager layoutManager = new LinearLayoutManager((Context)this);
        layoutManager.setOrientation(1);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.llNoConversation = (LinearLayout)this.findViewById(R.id.llNoConversation);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.listAdapter);
        this.getBroadcastData(0);
        this.recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (dy > 0) {
                    BroadcastListActivity.this.visibleItemCount = layoutManager.getChildCount();
                    BroadcastListActivity.this.totalItemCount = layoutManager.getItemCount();
                    BroadcastListActivity.this.pastVisiblesItems = layoutManager.findFirstVisibleItemPosition();
                    if (!BroadcastListActivity.this.isPagingApiInProgress && BroadcastListActivity.this.hasMorePages && BroadcastListActivity.this.visibleItemCount + BroadcastListActivity.this.pastVisiblesItems >= BroadcastListActivity.this.totalItemCount) {
                        BroadcastListActivity.this.getBroadcastData(BroadcastListActivity.this.objectModels.size());
                    }
                }
            }
        });
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
        }
        return true;
    }

    public void onBackPressed() {
        super.onBackPressed();
    }

    private void getBroadcastData(final int offset) {
        if (offset != 0) {
            this.isPagingApiInProgress = true;
            this.listAdapter.showPaginationProgressBar(true, true);
        }
        CommonParams commonParams = new CommonParams.Builder().add("access_token", HippoApplication.getInstance().getUserData().getAccessToken()).add("page_offset", offset).build();
        Logger.INSTANCE.apiRequest("api/broadcast/getBroadcastList", new Gson().toJson(commonParams.getMap()));
        RestClient.getApiInterface().getBroadcastList(commonParams.getMap()).enqueue((Callback)new ResponseResolver<BroadcastResponse>((Activity)this, Boolean.valueOf(offset == 0), Boolean.valueOf(false)){

            @Override
            public void success(BroadcastResponse broadCastObjectModel) {
                Logger.INSTANCE.apiResponse("api/broadcast/getBroadcastList", "");
                if (offset != 0) {
                    BroadcastListActivity.this.isPagingApiInProgress = false;
                    BroadcastListActivity.this.listAdapter.showPaginationProgressBar(false, true);
                }
                if (BroadcastListActivity.this.objectModels == null) {
                    BroadcastListActivity.this.objectModels = new ArrayList();
                }
                if (offset == 0) {
                    BroadcastListActivity.this.objectModels.clear();
                }
                BroadcastListActivity.this.objectModels.addAll(broadCastObjectModel.getData().getBroadcastedChannels());
                BroadcastListActivity.this.listAdapter.setData(BroadcastListActivity.this.objectModels);
                BroadcastListActivity.this.hasMorePages = broadCastObjectModel.getData().getBroadcastedChannels().size() == broadCastObjectModel.getData().getPageSize().intValue();
                if (offset == 0 && broadCastObjectModel.getData().getBroadcastedChannels() == null || broadCastObjectModel.getData().getBroadcastedChannels().size() == 0) {
                    BroadcastListActivity.this.llNoConversation.setVisibility(0);
                } else {
                    BroadcastListActivity.this.llNoConversation.setVisibility(8);
                }
            }

            @Override
            public void failure(APIError error) {
                Logger.INSTANCE.apiFailed("api/broadcast/getBroadcastList", error.getMessage());
            }
        });
    }

    @Override
    public void onClickItem(int position) {
        Intent intent = new Intent((Context)this, BroadcastDetailsActivity.class);
        BroadCastObjectModel objectModel = this.objectModels.get(position);
        intent.putExtra("objectModel", (Serializable)objectModel);
        this.startActivity(intent);
    }
}

