/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import androidx.core.app.NotificationCompat;
import com.google.gson.Gson;
import com.hippoagent.HippoConfig;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.activities.HomeActivity;
import com.hippoagent.database.CommonData;
import com.hippoagent.fcm.NotificationUtils;
import com.hippoagent.fcm.PushHandler;
import com.hippoagent.helper.ConnectionManager;
import com.hippoagent.helper.ConnectionUtils;
import com.hippoagent.hippocall.HippoCallConfig;
import com.hippoagent.model.FuguConversation;
import com.hippoagent.model.LoginResponse.UserData;
import io.paperdb.Paper;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public class HippoNotificationConfig {
    private static String TAG = HippoNotificationConfig.class.getSimpleName();
    UserData userData;
    private int smallIcon = -1;
    private int priority;
    private NotificationUtils notificationUtils;
    Context mcontext;

    public boolean isHippoNotification(@NotNull Context applicationContext, @NotNull Map<String, String> data) {
        this.mcontext = applicationContext;
        return data.containsKey("push_source") && data.get("push_source").equalsIgnoreCase("FUGU");
    }

    public void showNotification(@Nullable Context applicationContext, @NotNull Map<String, String> data) {
        JSONObject object = null;
        try {
            object = new JSONObject(data.get("message"));
            this.handleDataMessage(applicationContext, object);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void handleHippoPushNotification(Context context, Bundle bundle) {
        if (bundle != null) {
            new Handler().postDelayed(() -> {
                FuguConversation conversation = (FuguConversation)new Gson().fromJson(bundle.getString("conversation"), FuguConversation.class);
                if (conversation != null && HippoConfig.getInstance() != null) {
                    Log.e((String)TAG, (String)("conversation: " + new Gson().toJson((Object)conversation)));
                    Intent conversationIntent = new Intent(context, FuguChatActivity.class);
                    if (conversation.getChannelId() < 0L && conversation.getLabelId() < 0L) {
                        conversationIntent = new Intent(context, HomeActivity.class);
                    }
                    conversationIntent.putExtra("conversation", new Gson().toJson((Object)conversation, FuguConversation.class));
                    context.startActivity(conversationIntent);
                }
            }, 400L);
        }
    }

    private UserData getUserData() {
        if (this.userData == null) {
            this.userData = (UserData)Paper.book((String)CommonData.name).read("user_data");
        }
        return this.userData;
    }

    private void handleDataMessage(@Nullable Context context, JSONObject data) {
        block11: {
            try {
                try {
                    if (this.getUserData() != null && this.getUserData().isVideoCallEnabled() && data.optInt("notification_type") == 14 && (data.optString("video_call_type").equalsIgnoreCase("START_CALL") || data.optString("video_call_type").equalsIgnoreCase("CALL_HUNG_UP"))) {
                        this.videoCallPush(context, data);
                        return;
                    }
                    if (data.optInt("notification_type") == 14) {
                        return;
                    }
                    if (this.getUserData() != null && this.getUserData().isVideoCallEnabled() && data.optInt("notification_type") == 20) {
                        this.HippoConfCallPush(context, data);
                        break block11;
                    }
                    if (data.optInt("notification_type") == 21) {
                        int channedId = data.optInt("channel_id", -1);
                        if (channedId > 0) {
                            NotificationUtils.clearNotifications(context, channedId);
                        }
                        this.checkConnection(context);
                        break block11;
                    }
                    if (data.optInt("notification_type") == 23) {
                        new PushHandler().notificationMissedCall(context, data);
                        this.checkConnection(context);
                        break block11;
                    }
                    int channedId = data.optInt("channel_id", -1);
                    if (FuguChatActivity.pushChannelId != channedId && channedId > 0) {
                        new PushHandler().notificationHelper(context, data);
                        this.updateUnreadCount(channedId);
                    }
                    this.checkConnection(context);
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Json Exception: " + e.getMessage()));
            }
        }
    }

    private void updateUnreadCount(int channedId) {
    }

    private void checkConnection(Context context) {
        if (ConnectionUtils.INSTANCE.isAppRunning(context)) {
            ConnectionManager.INSTANCE.onInitialized();
        }
    }

    private void showNotificationMessage(Context context, String title, String message, String timeStamp, Intent intent, int channedId, int userId, int disableReply) {
        this.notificationUtils = new NotificationUtils(context);
        intent.setFlags(0x10008000);
        if (channedId != -1) {
            intent.putExtra("channed_id", channedId);
        }
        if (userId != -1) {
            intent.putExtra("user_id", userId);
        }
        intent.putExtra("disable_reply", disableReply);
        this.notificationUtils.showNotificationMessage(title, message, timeStamp, intent, channedId);
    }

    private void showNotificationMessageWithBigImage(Context context, String title, String message, String timeStamp, Intent intent, String imageUrl, int channedId, int userId, int disableReply) {
        this.notificationUtils = new NotificationUtils(context);
        intent.setFlags(0x10008000);
        if (channedId != -1) {
            intent.putExtra("channed_id", channedId);
        }
        if (userId != -1) {
            intent.putExtra("user_id", userId);
        }
        intent.putExtra("disable_reply", disableReply);
        this.notificationUtils.showNotificationMessage(title, message, timeStamp, intent, imageUrl, channedId);
    }

    private void playSound() {
    }

    private void videoCallPush(Context context, JSONObject jsonObject) throws Exception {
        HippoCallConfig.getInstance().onNotificationReceived(context, jsonObject);
    }

    private void HippoConfCallPush(Context context, JSONObject jsonObject) throws Exception {
        HippoCallConfig.getInstance().onConfNotificationReceived(context, jsonObject);
    }

    public void setNotificationSoundEnabled(boolean isSoundEnbled) {
        if (isSoundEnbled) {
            this.notificationUtils = new NotificationUtils(this.mcontext);
            this.notificationUtils.playNotificationSound();
        }
    }

    public void setPriority(int priority) {
        NotificationCompat.Builder builder2 = new NotificationCompat.Builder(this.mcontext, "12001");
        builder2.setPriority(priority);
    }

    public void setSmallIcon(int smallIcon) {
        this.smallIcon = smallIcon;
    }
}

