/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent;

import android.text.TextUtils;
import java.util.HashMap;

public class HippoConfigAttributes {
    private Integer appType;
    private String appKey;
    private String environment;
    private String provider;
    private boolean showLog;
    private String deviceToken;
    private String authToken;
    private int versionCode;
    private boolean debugType;
    private boolean isWhitelabel;
    private String appName;
    private boolean hasAccessToken;
    private HashMap<String, Object> customAttributes;
    private String lang;

    public HashMap<String, Object> getCustomAttributes() {
        return this.customAttributes;
    }

    public Integer getAppType() {
        return this.appType;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public int getVersionCode() {
        return this.versionCode;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public boolean getIsWhitelabel() {
        return this.isWhitelabel;
    }

    public boolean hasAccessToken() {
        return this.hasAccessToken;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getDeviceToken() {
        return this.deviceToken;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public boolean isShowLog() {
        return this.showLog;
    }

    public boolean isdebugType() {
        return this.debugType;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getLang() {
        return this.lang;
    }

    private HippoConfigAttributes(Builder builder2) {
        this.appType = builder2.appType;
        this.appKey = builder2.appKey;
        this.environment = builder2.environment;
        this.provider = builder2.provider;
        this.showLog = builder2.showLog;
        this.authToken = builder2.authToken;
        this.deviceToken = builder2.deviceToken;
        this.versionCode = builder2.versionCode;
        this.isWhitelabel = builder2.isWhitelabel;
        this.appName = builder2.appName;
        this.hasAccessToken = builder2.hasAccessToken;
        this.customAttributes = builder2.customAttributes;
        this.lang = builder2.lang;
    }

    public static class Builder {
        private String appName;
        private Integer appType;
        private String appKey;
        private String environment;
        private String provider;
        private boolean showLog;
        private boolean debugType;
        private String authToken;
        private String deviceToken;
        private int versionCode;
        private boolean isWhitelabel;
        private boolean hasAccessToken;
        private HashMap<String, Object> customAttributes;
        private String lang;
        private HippoConfigAttributes attributes = new HippoConfigAttributes(this);

        public Builder setAuthToken(String authToken) {
            this.attributes.authToken = authToken;
            return this;
        }

        public Builder setLanguage(String lang) {
            this.attributes.lang = lang;
            return this;
        }

        public Builder hasAccessToken(boolean hasAccessToken) {
            this.attributes.hasAccessToken = hasAccessToken;
            return this;
        }

        public Builder setAppType(Integer appType) {
            this.attributes.appType = appType;
            return this;
        }

        public Builder setAppName(String appName) {
            this.attributes.appName = appName;
            return this;
        }

        public Builder setAppSecretKey(String appKey) {
            this.attributes.appKey = appKey;
            return this;
        }

        public Builder setEnvironment(String environment) {
            this.attributes.environment = environment;
            return this;
        }

        public Builder setIsWhitelabel(boolean isWhitelabel) {
            this.attributes.isWhitelabel = isWhitelabel;
            return this;
        }

        public Builder setProvider(String provider) {
            this.attributes.provider = provider;
            return this;
        }

        public Builder setShowLog(boolean showLog) {
            this.attributes.showLog = showLog;
            return this;
        }

        public Builder setdebugType(boolean debugType) {
            this.attributes.debugType = debugType;
            return this;
        }

        public Builder setDeviceToken(String deviceToken) {
            this.attributes.deviceToken = deviceToken;
            return this;
        }

        public Builder setVersionCode(int versionCode) {
            this.attributes.versionCode = versionCode;
            return this;
        }

        public Builder setCustomAttributes(HashMap<String, Object> customAttributes) {
            this.attributes.customAttributes = customAttributes;
            return this;
        }

        public HippoConfigAttributes build() {
            if (TextUtils.isEmpty((CharSequence)this.attributes.provider)) {
                throw new IllegalStateException("Provider can not be empty!");
            }
            if (TextUtils.isEmpty((CharSequence)this.attributes.authToken)) {
                throw new IllegalArgumentException("AuthToken can not be empty!");
            }
            return this.attributes;
        }
    }
}

