/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.hippoagent.utils.Log;
import java.util.HashSet;

public final class HippoActivityLifecycleCallback {
    static boolean registered = false;
    private static final String TAG = HippoActivityLifecycleCallback.class.getSimpleName();
    public static HashSet<String> hippoClasses;

    @TargetApi(value=14)
    public static synchronized void registerApplication(Application application) {
        if (application == null) {
            Log.i("register", "Application instance is null/system API is too old");
            return;
        }
        if (registered) {
            Log.v("register", "Lifecycle callbacks have already been registered");
            return;
        }
        hippoClasses = new HashSet();
        registered = true;
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle bundle) {
                hippoClasses.add(activity.getClass().getName());
                Log.v(TAG, "onActivityCreated " + activity.getClass().getName());
            }

            public void onActivityStarted(Activity activity) {
                Log.v(TAG, "onActivityStarted " + activity.getClass().getSimpleName());
            }

            public void onActivityResumed(Activity activity) {
                Log.v(TAG, "onActivityResumed " + activity.getClass().getSimpleName());
            }

            public void onActivityPaused(Activity activity) {
                Log.v(TAG, "onActivityPaused " + activity.getClass().getSimpleName());
            }

            public void onActivityStopped(Activity activity) {
                Log.v(TAG, "onActivityStopped " + activity.getClass().getSimpleName());
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
                Log.v(TAG, "onActivitySaveInstanceState " + activity.getClass().getSimpleName());
            }

            public void onActivityDestroyed(Activity activity) {
                Log.v(TAG, "onActivityDestroyed " + activity.getClass().getSimpleName());
                hippoClasses.remove(activity.getClass().getSimpleName());
            }
        });
        Log.i("In callback", "Activity Lifecycle Callback successfully registered");
    }

    @TargetApi(value=14)
    public static synchronized void register(Application application) {
        HippoActivityLifecycleCallback.registerApplication(application);
    }
}

