/*
 * Decompiled with CFR 0.152.
 */
package com.hippoagent;

import com.hippoagent.database.CommonData;
import com.hippoagent.utils.ConfigMode;
import com.hippoagent.utils.Log;
import io.paperdb.Paper;

public class Config {
    public static final int REQUEST_CODE_PICK_PAYMENT = 1536;
    private static final String DEBUG_PASSWORD = "098673";
    private static final String LIVE_SERVER_URL = "https://hippo-api.fuguchat.com";
    private static final String LIVE_BETA_SERVER_URL = "https://beta-live-api.fuguchat.com";
    private static final String BETA_SERVER_URL = "https://hippo-api-dev.fuguchat.com:3011";
    private static final String ALPHA_SERVER_URL = "https://hippo-api-dev.fuguchat.com:3002";
    private static final String DEV3003 = "https://hippo-api-dev.fuguchat.com:3003";
    private static final String DEV_SERVER_URL = "https://hippo-api-dev.fuguchat.com:3004";
    private static final String FAYE_LIVE_SERVER_URL = "https://api.fuguchat.com";
    private static final String FAYE_LIVE_BETA_SERVER_URL = "https://beta-live-api.fuguchat.com:3001/";
    private static final String FAYE_BETA_SERVER_URL = "https://hippo-api-dev.fuguchat.com:3012/";
    private static final String FAYE_ALPHA_SERVER_URL = "https://hippo-api-dev.fuguchat.com:3002/";
    private static final String FAYE_DEV3003 = "https://hippo-api-dev.fuguchat.com:3003/";
    private static final String FAYE_DEV_SERVER_URL = "https://hippo-api-dev.fuguchat.com:3004/";
    private static final String DEFAULT_SERVER_URL = "https://hippo-api.fuguchat.com";
    private static String SERVER_URL = "https://hippo-api.fuguchat.com";
    private static ConfigMode configMode = ConfigMode.LIVE;

    public static String getDebugPassword() {
        return DEBUG_PASSWORD;
    }

    public static String getServerUrl() {
        Config.init(configMode);
        return SERVER_URL;
    }

    public static String getBetaServerUrl() {
        return BETA_SERVER_URL;
    }

    public static String getAlphaUrl() {
        return ALPHA_SERVER_URL;
    }

    public static String getDevServerUrl() {
        return DEV_SERVER_URL;
    }

    public static String getLiveServerUrl() {
        return "https://hippo-api.fuguchat.com";
    }

    public static String getLiveBetaServerUrl() {
        return LIVE_BETA_SERVER_URL;
    }

    public static void setConfigMode(ConfigMode configMode) {
        Config.configMode = configMode;
        Config.init(configMode);
    }

    public static ConfigMode getConfigMode() {
        return configMode;
    }

    public static String getDefaultServerUrl() {
        return "https://hippo-api.fuguchat.com";
    }

    public static void init(ConfigMode appMode) {
        switch (appMode) {
            case DEV: {
                SERVER_URL = DEV_SERVER_URL;
                break;
            }
            case BETA: {
                SERVER_URL = BETA_SERVER_URL;
                break;
            }
            case ALPHA: {
                SERVER_URL = ALPHA_SERVER_URL;
                break;
            }
            case LIVE: {
                SERVER_URL = "https://hippo-api.fuguchat.com";
                break;
            }
            case LIVE_BETA: {
                SERVER_URL = LIVE_BETA_SERVER_URL;
                break;
            }
            case DEV3003: {
                SERVER_URL = DEV3003;
                break;
            }
            default: {
                SERVER_URL = "https://hippo-api.fuguchat.com";
            }
        }
    }

    public static String getFayeUrlPort() {
        String port = Config.getConfigMode() == ConfigMode.LIVE ? ":3002/" : ":3012/";
        return port;
    }

    public static String getFayeServerUrl() {
        String link = (String)Paper.book((String)CommonData.name).read("server_selected", (Object)Config.getDefaultServerUrl());
        String url = "https://api.fuguchat.com:3002/";
        switch (link) {
            case "https://hippo-api-dev.fuguchat.com:3004": {
                url = FAYE_DEV_SERVER_URL;
                break;
            }
            case "https://hippo-api-dev.fuguchat.com:3011": {
                url = FAYE_BETA_SERVER_URL;
                break;
            }
            case "https://hippo-api-dev.fuguchat.com:3002": {
                url = FAYE_ALPHA_SERVER_URL;
                break;
            }
            case "https://hippo-api.fuguchat.com": {
                url = "https://api.fuguchat.com:3002/";
                break;
            }
            case "https://beta-live-api.fuguchat.com": {
                url = FAYE_LIVE_BETA_SERVER_URL;
                break;
            }
            case "https://hippo-api-dev.fuguchat.com:3003": {
                url = FAYE_DEV3003;
            }
        }
        Log.e("TAG", "faye listen at: " + url);
        return url;
    }

    public static String getFayeServerUrl(ConfigMode configModeToSet) {
        String url = "https://api.fuguchat.com:3002/";
        switch (configModeToSet) {
            case DEV: {
                url = FAYE_DEV_SERVER_URL;
                break;
            }
            case BETA: {
                url = FAYE_BETA_SERVER_URL;
                break;
            }
            case ALPHA: {
                url = FAYE_ALPHA_SERVER_URL;
                break;
            }
            case LIVE: {
                url = "https://api.fuguchat.com:3002/";
                break;
            }
            case LIVE_BETA: {
                url = FAYE_LIVE_BETA_SERVER_URL;
            }
        }
        Log.e("TAG", "faye listen at: " + url);
        return url;
    }
}

