package com.hippoagent.utils.filelogger

import android.content.Context
import android.os.AsyncTask
import com.hippoagent.utils.Log
import com.google.gson.Gson
import java.io.File
import java.io.FileWriter
import java.util.concurrent.CopyOnWriteArrayList

/**
 * Created by gurmail on 13/05/19.
 * @author gurmail
 */
class FileWriterTask(var context: Context) : AsyncTask<CopyOnWriteArrayList<LoggerObj>, Void, Boolean>() {

    lateinit var mLogPath :String
    lateinit var mFilePath: String
//    private val keyLocker = KeyLocker() // To sync key-dependent operations by key
    private val KEY = "/logs"
    private val fileName = "${File.separator}logs.txt"
    @Volatile
    private var mLogDirIsCreated: Boolean = false

    override fun doInBackground(vararg params: CopyOnWriteArrayList<LoggerObj>?): Boolean {
        mLogPath = context.getFilesDir().path + KEY
        mFilePath = mLogPath + fileName
        Log.e(KEY, "logFile path -> $mLogPath")
        return writeFile(params[0]!!)
    }

    override fun onPostExecute(result: Boolean?) {
        super.onPostExecute(result)
        if(result!!) {
            Logger.deleteData()
            Logger.setFileUploading(false)
            UploadLogFile().execute(mFilePath)
        }
    }

    @Synchronized
    fun writeFile(log: CopyOnWriteArrayList<LoggerObj>) : Boolean {
        var status = true
        //keyLocker.acquire(KEY)
        assertInit()
        try {
            Log.e(KEY, "logFile path = $mFilePath")
            val writer = FileWriter(mFilePath, true)
            writer.append("\n").append(Gson().toJson(log))
            writer.flush()
            writer.close()
        } catch (e: Exception) {
            e.printStackTrace()
            status = false
        } finally {
            //keyLocker.release(KEY)
        }
        return status
    }


    private fun assertInit() {
        if (!mLogDirIsCreated) {
            createPaperDir()
            mLogDirIsCreated = true
        }
    }

    private fun createPaperDir() {
        if (!File(mLogPath).exists()) {
            val isReady = File(mLogPath).mkdirs()

            if (!isReady) {
                throw RuntimeException("Couldn't create Log dir: $mLogPath")
            }
        }
        createFile()
    }

    private fun createFile() {
        if(!File(mFilePath).exists()) {
            val isDone = File(mFilePath).createNewFile()
            if (!isDone) {
                throw RuntimeException("Couldn't create Log file: $mFilePath")
            }
        }
    }

    private fun deleteFile() {
        val path = "$mLogPath + $fileName"

    }

}