package com.hippoagent.utils.filePicker;

import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Environment;
import android.provider.MediaStore;
import androidx.core.content.FileProvider;
import android.widget.Toast;

import com.easyfilepicker.Constant;
import com.hippoagent.BuildConfig;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.Utils;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;


/**
 * Created by Bhavya on 12-05-2016.
 */
public class ImageUtils implements FuguAppConstant {

    private static final String TAG = ImageUtils.class.getSimpleName();
    private Activity activity;
    private int cameraRequestCode;
    private int galleryRequestCode;
    private int cameraPermission;
    private int readFilePermission;
    private int openGalleryPermission;
    private int saveBitmapPermission;

    public ImageUtils(Activity activity) {
        this.activity = activity;
        cameraPermission = PERMISSION_CONSTANT_CAMERA;
        readFilePermission = PERMISSION_READ_FILE;
        openGalleryPermission = PERMISSION_CONSTANT_GALLERY;
        saveBitmapPermission = PERMISSION_SAVE_BITMAP;
    }


    /**
     * Method to start the Camera
     */
    public void startCamera() {
        Log.e(TAG, "startCamera");

        /*  Check whether the Camera feature is available or not    */
        if (!isCameraAvailable()) {
            Toast.makeText(activity, "Camera feature unavailable!", Toast.LENGTH_SHORT).show();
            return;
        }

        /*  Check for the SD CARD or External Storage   */
        if (!isExternalStorageAvailable()) {
            Toast.makeText(activity, "External storage unavailable!", Toast.LENGTH_SHORT).show();
            return;
        }

        Intent takePictureIntent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
        if (takePictureIntent.resolveActivity(activity.getPackageManager()) != null) {
            String timeStamp = new SimpleDateFormat("ddMMyyyy_hhmmss", Locale.ENGLISH).format(new Date());
            String muid = UUID.randomUUID().toString() + "." + new Date().getTime();
            String fileName = "Hippochat_" + muid + ".jpg";
            File fileToBeWritten = new File(Utils.getDirectoryPath(FOLDER_TYPE.get(DocumentType.IMAGE.type)), fileName);
            Log.d(TAG, "Path: " + fileToBeWritten.getPath());
            Log.d(TAG, "AbsolutePath: " + fileToBeWritten.getAbsolutePath());
            CommonData.setTime(fileToBeWritten.getAbsolutePath());
            CommonData.setImageMuid(muid);
            try {
                File file = fileToBeWritten.getParentFile();
                if (!file.exists()) {
                    file.mkdirs();
                }
                fileToBeWritten.createNewFile();
            } catch (Exception e) {
                e.printStackTrace();
            }

            String provider = CommonData.getProvider();
            takePictureIntent.putExtra(MediaStore.EXTRA_OUTPUT, FileProvider.getUriForFile(activity, provider, fileToBeWritten));
            activity.startActivityForResult(takePictureIntent, Constant.REQUEST_CODE_TAKE_IMAGE);
        }
    }

    /**
     * Method to check whether the Camera feature
     * is Available or not
     *
     * @return
     */
    private boolean isCameraAvailable() {

        Log.e(TAG, "isCameraAvailable");

        return activity.getPackageManager().hasSystemFeature(PackageManager.FEATURE_CAMERA_ANY);
    }

    /**
     * Method to check whether the Camera feature
     * is Available or not
     *
     * @return
     */
    private boolean isExternalStorageAvailable() {

        Log.e(TAG, "isExternalStorageAvailable");

        return Environment.MEDIA_MOUNTED.equals(Environment.getExternalStorageState());
    }
}
