package com.hippoagent.utils;

import android.graphics.Color;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RoundRectShape;

public class FuguColorConfig {

    public int getFuguBgMessageYou() {
        return Color.parseColor(fuguBgMessageYou);
    }

    public int getFuguPrivateMsg(){
        return Color.parseColor(fuguBgPrivateMessageYou);
    }

    public int getFuguBgMessageFrom() {
        return Color.parseColor(fuguBgMessageFrom);
    }

    public int getFuguMessageRead() {
        return Color.parseColor(fuguMessageRead);
    }

    public int getFuguPrimaryTextMsgFrom() {
        return Color.parseColor(fuguPrimaryTextMsgFrom);
    }

    public int getFuguSecondaryTextMsgYou() {
        return Color.parseColor(fuguSecondaryTextMsgYou);
    }

    public int getHippoTabTextColor() {
        return Color.parseColor(hippoTabTextColor);
    }

    public int getHippoTabSelectedTextColor() {
        return Color.parseColor(hippoTabSelectedTextColor);
    }

    public int getHippoSelectedTabIndicatorColor() {
        return Color.parseColor(hippoSelectedTabIndicatorColor);
    }

    private String fuguBgMessageYou = "#E9EFFD";
    private String fuguBgMessageFrom = "#50EDEDED";
    private String fuguBgPrivateMessageYou = "#FEF8E3";
    private String fuguMessageRead = "#627de3";
    private String fuguPrimaryTextMsgFrom = "#2c2333";
    private String fuguSecondaryTextMsgYou = "#8e8e8e";


    private String hippoTabTextColor = "#000000"; // Disable text color of a tab
    private String hippoTabSelectedTextColor = "#000000"; // Selected text color of a tab
    private String hippoSelectedTabIndicatorColor = "#5b9f0d"; // selected tab underline color


    public static class Builder {
        private FuguColorConfig fuguColorConfig = new FuguColorConfig();

        public Builder hippoTabTextColor(String hippoTabTextColor) {
            fuguColorConfig.hippoTabTextColor = hippoTabTextColor;
            return this;
        }

        public Builder hippoTabSelectedTextColor(String hippoTabSelectedTextColor) {
            fuguColorConfig.hippoTabSelectedTextColor = hippoTabSelectedTextColor;
            return this;
        }

        public Builder hippoSelectedTabIndicatorColor(String hippoSelectedTabIndicatorColor) {
            fuguColorConfig.hippoSelectedTabIndicatorColor = hippoSelectedTabIndicatorColor;
            return this;
        }

        public Builder fuguBgMessageYou(String fuguBgMessageYou) {
            fuguColorConfig.fuguBgMessageYou = fuguBgMessageYou;
            return this;
        }

        public Builder fuguBgMessageFrom(String fuguBgMessageFrom) {
            fuguColorConfig.fuguBgMessageFrom = fuguBgMessageFrom;
            return this;
        }


        public Builder fuguMessageRead(String fuguMessageRead) {
            fuguColorConfig.fuguMessageRead = fuguMessageRead;
            return this;
        }

        public Builder fuguPrimaryTextMsgFrom(String fuguPrimaryTextMsgFrom) {
            fuguColorConfig.fuguPrimaryTextMsgFrom = fuguPrimaryTextMsgFrom;
            return this;
        }

        public Builder fuguSecondaryTextMsgYou(String fuguSecondaryTextMsgYou) {
            fuguColorConfig.fuguSecondaryTextMsgYou = fuguSecondaryTextMsgYou;
            return this;
        }

        public FuguColorConfig build() {
            return fuguColorConfig;
        }

    }

}
