package com.hippoagent.utils

import android.annotation.SuppressLint
import android.content.Context
import android.util.AttributeSet
import android.view.MotionEvent

/**
 * Created by gurmail on 2019-12-27.
 * @author gurmail
 */
class CustomViewPager constructor(context: Context, attributes: AttributeSet): androidx.viewpager.widget.ViewPager(context, attributes) {


    @SuppressLint("ClickableViewAccessibility")
    override fun onTouchEvent(event: MotionEvent): Boolean {
        if (this.enableSwipe) {
            return super.onTouchEvent(event);
        }
        return false

    }

    override fun onInterceptTouchEvent(event: MotionEvent): Boolean {
        if (this.enableSwipe) {
            return super.onInterceptTouchEvent(event);
        }
        return false

    }

    private var enableSwipe: Boolean = false

    fun setPagingEnabled(enableSwipe: Boolean) {
        this.enableSwipe = enableSwipe
    }
}