package com.hippoagent.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import androidx.annotation.NonNull;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import android.text.TextUtils;

import com.hippoagent.HippoApplication;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.helper.ConnectionManager;
import com.hippoagent.hippocall.HippoCallConfig;
import com.hippoagent.model.FuguUploadImageResponse;
import com.hippoagent.model.Message;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.MultipartParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.Constants;
import com.hippoagent.utils.DateUtils;
import com.hippoagent.utils.Log;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

import faye.FuguAgentFayeClient;
import faye.FuguAgentFayeClientListener;

/**
 * Created by Bhavya Rattan on 23/06/17
 * Click Labs
 * bhavya.rattan@click-labs.com
 */

public class FuguNetworkStateReceiver extends BroadcastReceiver implements FuguAppConstant, FuguAgentFayeClientListener {

    private String TAG = "FuguNetworkStateReceiver";

    @NonNull
    private HashMap<Integer, LinkedHashMap<String, JSONObject>> unsentMessageMap = new HashMap<>();
    public static HashMap<Integer, LinkedHashMap<String, Message>> UNSENT_MESSAGES = new HashMap<>();

    public void onReceive(Context context, Intent intent) {

        int status = NetworkUtil.getConnectivityStatusString(context);
        try {
            ConnectionManager.INSTANCE.changeStatus(status);
        } catch (Exception e) {
            e.printStackTrace();
        }

        Log.d("app", "Network connectivity change");
        if (intent.getExtras() != null) {
            boolean isEnabled;
            NetworkInfo ni = (NetworkInfo) intent.getExtras().get(ConnectivityManager.EXTRA_NETWORK_INFO);
            if (ni != null && ni.getState() == NetworkInfo.State.CONNECTED) {
                isEnabled = true;
                //sendPushMessages();
                Log.i("app", "Network " + ni.getTypeName() + " connected");
            } else {
                isEnabled = false;
            }


            HippoCallConfig.getInstance().networkStatus(isEnabled);
            Intent mIntent = new Intent(NETWORK_STATE_INTENT);
            mIntent.putExtra("isConnected", isEnabled);
            LocalBroadcastManager.getInstance(context).sendBroadcast(mIntent);

        }
    }

    private void uploadFileServerCall(String file, String fileType, final Integer channelId, final JSONObject messageJson) {

        MultipartParams.Builder multipartBuilder = new MultipartParams.Builder();
        MultipartParams multipartParams = multipartBuilder
                .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().getUserData().getAccessToken())
                .addFile("file", new File(file))
                .add("file_type", fileType).build();

        Log.v("map = ", multipartParams.getMap().toString());
        RestClient.getApiInterface()
                .uploadFile(multipartParams.getMap())
                .enqueue(new ResponseResolver<FuguUploadImageResponse>() {
                    @Override
                    public void success(FuguUploadImageResponse fuguUploadImageResponse) {

                        try {
                            messageJson.remove("image_path");
                            messageJson.put("image_url", fuguUploadImageResponse.getData().getImageUrl());
                            messageJson.put("thumbnail_url", fuguUploadImageResponse.getData().getThumbnailUrl());


                            ConnectionManager.INSTANCE.publish("/" + String.valueOf(channelId), messageJson);

                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void failure(APIError error) {
                        if (unsentMessageMap != null) {
                            if (unsentMessageMap.get(channelId).size() == 1) {
                                unsentMessageMap.remove(channelId);
                                CommonData.removeUnsentMessageMapChannel(channelId);
                            } else {
                                try {
                                    unsentMessageMap.get(channelId).remove(messageJson.getString("muid"));
                                    CommonData.setUnsentMessageMapByChannel(channelId, unsentMessageMap.get(channelId));
                                } catch (JSONException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                });
    }
    private Integer channelId;
    private HashMap<Integer, LinkedHashMap<String, JSONObject>> allUnsentMessageMap = new HashMap<>();
    private LinkedHashMap<String, JSONObject> sendingMessages = new LinkedHashMap<>();

    private String tempDate = "";
    private String inputFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private String outputFormat = "yyyy-MM-dd";

    private LinkedHashMap<String, Message> sendingMessagesList = new LinkedHashMap<>();
    private LinkedHashMap<String, Message> sentMessages = new LinkedHashMap<>();

    @Override
    public void onConnectedServer(FuguAgentFayeClient fc) {
        try {
            setDateExpireDate();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void setDateExpireDate() throws Exception {
        for (Integer channelId : unsentMessageMap.keySet()) {
            if (FuguChatActivity.currentChannelId != channelId) {
                LinkedHashMap<String, Message> unsentMessage = UNSENT_MESSAGES.get(channelId);
                LinkedHashMap<String, JSONObject> unsentMessageObj = unsentMessageMap.get(channelId);
                if(unsentMessageObj != null && unsentMessageObj.size() == 0) {
                    CommonData.removeUnsentMessageChannel(channelId);
                    CommonData.removeUnsentMessageMapChannel(channelId);
                    continue;
                }
                LinkedHashMap<String, JSONObject> unsentMessageMapNew = new LinkedHashMap<>();
                for (String key : unsentMessage.keySet()) {
                    Message listItem = unsentMessage.get(key);
                    String time = listItem.getSentAtUtc();
                    int expireTimeCheck = listItem.getIsMessageExpired();
                    if (listItem.getMessageType() != IMAGE_MESSAGE
                            && expireTimeCheck == 0 && DateUtils.getTimeDiff(time)) {
                        listItem.setIsMessageExpired(1);
                        try {
                            JSONObject messageJson = unsentMessageObj.get(key);
                            messageJson.put("is_message_expired", 1);
                            unsentMessageObj.put(key, messageJson);
                        } catch (Exception e) {
                            //e.printStackTrace();
                        }
                    }  else if(listItem.getMessageType() == IMAGE_MESSAGE) {
                        JSONObject messageJson = unsentMessageMapNew.get(key);
                        if(messageJson == null) {
                            listItem.setMessageStatus(MESSAGE_IMAGE_RETRY);
                        }
                    }
                    /*else {
                        unsentMessageMapNew.put(key, unsentMessageObj.get(key));
                    }*/
                }

                allUnsentMessageMap.put(channelId, unsentMessageMapNew);

                if (FuguChatActivity.currentChannelId != channelId) {
                    UNSENT_MESSAGES.put(channelId, unsentMessage);
                    unsentMessageMap.put(channelId, unsentMessageObj);
                    CommonData.setUnsentMessageByChannel(channelId, unsentMessage);
                    CommonData.setUnsentMessageMapByChannel(channelId, unsentMessageObj);
                }
            }
        }
        sentMessages.clear();
        sendMessages();


    }

    private void sendMessages() throws Exception {
        if (allUnsentMessageMap != null && allUnsentMessageMap.size() > 0) {
            new android.os.Handler().postDelayed(new Runnable() {
                @Override
                public void run() {
                    for (final Integer key : allUnsentMessageMap.keySet()) {
                        if (FuguChatActivity.currentChannelId != key) {
                            //publishUnsentMessages(key, allUnsentMessageMap.get(key));
                            channelId = key;
                            if (FuguChatActivity.currentChannelId != channelId) {
                                ConnectionManager.INSTANCE.subScribeChannel("/" + String.valueOf(key));
                            }

                            sendingMessages = allUnsentMessageMap.get(key);
                            sendingMessagesList = UNSENT_MESSAGES.get(key);

                            List<String> reverseOrderedKeys = new ArrayList<>(sentMessages.keySet());
                            Collections.reverse(reverseOrderedKeys);
                            for(String key1 : reverseOrderedKeys) {
                                if(sentMessages.get(key1).isDateView()) {
                                    tempDate = key1;
                                    break;
                                }
                            }


                            try {
                                sendingMessages();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            allUnsentMessageMap.remove(channelId);
                            try {
                                sendMessages();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        break;
                    }
                }
            }, 1000);
        } else {
            //HippoApplication.getInstance().removeFayeListener(this);
        }
    }

    private void sendingMessages() throws Exception {
        if(sendingMessages.size() == 0) {
            allUnsentMessageMap.remove(channelId);
            ConnectionManager.INSTANCE.unsubScribeChannel(String.valueOf(channelId));
            CommonData.removeUnsentMessageMapChannel(channelId);
            CommonData.removeUnsentMessageChannel(channelId);
            if(sentMessages != null && sentMessages.size()>0) {
                CommonData.addExistingMessages(channelId, sentMessages);
            }
            sendMessages();
        } else {
            for (String key : sendingMessages.keySet()) {
                JSONObject messageJson = sendingMessages.get(key);
                if (messageJson.optInt("is_message_expired", 0) == 0 && messageJson.has("local_url") && !TextUtils.isEmpty(messageJson.optString("local_url", ""))) {
                    uploadFileServerCall(messageJson.optString("local_url", ""), "image/*", channelId, messageJson);
                    continue;
                } else if(messageJson.optInt("is_message_expired", 0) == 0) {
                    Log.e(TAG, "**************");
                    ConnectionManager.INSTANCE.publish("/" + String.valueOf(channelId), messageJson);
                }
                break;
            }
        }

    }

    @Override
    public void onDisconnectedServer(FuguAgentFayeClient fc) {
        Log.e(TAG, "Disconnected");
    }


    @Override
    public void onReceivedMessage(FuguAgentFayeClient fc, String msg, String channel) {
        Log.e(TAG, "FuguMessage: " + msg);
        if (channel.substring(1).equals(HippoApplication.getInstance().getUserData().getUserChannel())) {
            //sendingMessages();
            return;
        }

        Integer channelid = null;
        channelid = Integer.parseInt(channel.substring(1));
        try {
            final JSONObject messageJson = new JSONObject(msg);

            if ((messageJson.has("message") && !messageJson.getString("message").isEmpty()) ||
                    (messageJson.has("image_url") && !messageJson.getString("image_url").isEmpty())) {

                String muid = messageJson.getString("muid");
                if(FuguChatActivity.currentChannelId != channelid) {

                    if(channelid != channelId && messageJson.optInt("message_type") == 10) {
                        // TODO: 08/08/18 Update the particular channel
                        return;
                    }

                    Message listItem = sendingMessagesList.get(messageJson.getString("muid"));
                    listItem.setMessageStatus(MESSAGE_SENT);


                    String time = listItem.getSentAtUtc();
                    String localDate = DateUtils.getInstance().convertToLocal(time, inputFormat, outputFormat);
                    if (!tempDate.equalsIgnoreCase(localDate)) {
                        sentMessages.put(localDate, new Message(localDate, true));
                        //fuguMessageList.add(new HeaderItem(localDate));
                    }


                    sentMessages.put(messageJson.getString("muid"), listItem);

                    sendingMessages.remove(muid);
                    UNSENT_MESSAGES.remove(muid);
                    unsentMessageMap.remove(muid);
                    sendingMessages();
                } else {
                    if(sentMessages != null || sentMessages.size()>0) {
                        CommonData.addExistingMessages(channelid, sentMessages);
                    }
                    allUnsentMessageMap.remove(channelid);
                    sendMessages();
                }

            }
        } catch (JSONException e) {
            e.printStackTrace();
        } catch (Exception e){
            e.printStackTrace();
        }

    }

    @Override
    public void onPongReceived() {

    }

    @Override
    public void onWebSocketError() {

    }

    @Override
    public void onNotConnected() {

    }

    @Override
    public void onErrorReceived(FuguAgentFayeClient fc, String msg, String channel) {

    }
}
