package com.hippoagent.model.graph;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

import java.util.Comparator;

/**
 * Created by mohitkr.dhiman on 15/02/18.
 */

public class AgentsDatum {

    @SerializedName("agent_id")
    @Expose
    private Integer agentId;
    @SerializedName("agent_name")
    @Expose
    private String agentName;
    @SerializedName("assigned_count")
    @Expose
    private Integer assignedCount;
    @SerializedName("replied_count")
    @Expose
    private Integer repliedCount;
    @SerializedName("closed_count")
    @Expose
    private Integer closedCount;
    @SerializedName("avg_first_response")
    @Expose
    private Double avgFirstResponse;
    @SerializedName("avg_closed_time")
    @Expose
    private Double avgClosedTime;
    @SerializedName("currently_assigned")
    @Expose
    private Integer currentlyAssigned;
    @SerializedName("currently_replied")
    @Expose
    private Integer currentlyReplied;
    @SerializedName("currently_closed")
    @Expose
    private Integer currentlyClosed;

    public Integer getAgentId() {
        return agentId;
    }

    public void setAgentId(Integer agentId) {
        this.agentId = agentId;
    }

    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public Integer getAssignedCount() {
        return assignedCount;
    }

    public void setAssignedCount(Integer assignedCount) {
        this.assignedCount = assignedCount;
    }

    public Integer getRepliedCount() {
        return repliedCount;
    }

    public void setRepliedCount(Integer repliedCount) {
        this.repliedCount = repliedCount;
    }

    public Integer getClosedCount() {
        return closedCount;
    }

    public void setClosedCount(Integer closedCount) {
        this.closedCount = closedCount;
    }

    public Double getAvgFirstResponse() {
        return avgFirstResponse;
    }

    public void setAvgFirstResponse(Double avgFirstResponse) {
        this.avgFirstResponse = avgFirstResponse;
    }

    public Double getAvgClosedTime() {
        return avgClosedTime;
    }

    public void setAvgClosedTime(Double avgClosedTime) {
        this.avgClosedTime = avgClosedTime;
    }

    public Integer getCurrentlyAssigned() {
        return currentlyAssigned;
    }

    public void setCurrentlyAssigned(Integer currentlyAssigned) {
        this.currentlyAssigned = currentlyAssigned;
    }

    public Integer getCurrentlyReplied() {
        return currentlyReplied;
    }

    public void setCurrentlyReplied(Integer currentlyReplied) {
        this.currentlyReplied = currentlyReplied;
    }

    public Integer getCurrentlyClosed() {
        return currentlyClosed;
    }

    public void setCurrentlyClosed(Integer currentlyClosed) {
        this.currentlyClosed = currentlyClosed;
    }

    /**
     * Comparator for sorting the list by Agent Name ascending order
     */
    public static Comparator<AgentsDatum> agentNameAscComparator = new Comparator<AgentsDatum>() {

        public int compare(AgentsDatum s1, AgentsDatum s2) {
            String agentName1 = s1.getAgentName().toUpperCase().trim();
            String agentName2 = s2.getAgentName().toUpperCase().trim();

            return agentName1.compareTo(agentName2);
        }
    };


    /**
     * Comparator for sorting the list by Agent Name descending order
     */
    public static Comparator<AgentsDatum> agentNameDesComparator = new Comparator<AgentsDatum>() {

        public int compare(AgentsDatum s1, AgentsDatum s2) {
            String agentName1 = s1.getAgentName().toUpperCase().trim();
            String agentName2 = s2.getAgentName().toUpperCase().trim();

            return agentName2.compareTo(agentName1);
        }
    };

    public static Comparator<AgentsDatum> agentAssignedAscComparator = new Comparator<AgentsDatum>() {
        @Override
        public int compare(AgentsDatum o1, AgentsDatum o2) {
            return o1.getAssignedCount() - o2.getAssignedCount();
        }
    };


    public static Comparator<AgentsDatum> agentAssignedDecComparator = new Comparator<AgentsDatum>() {
        @Override
        public int compare(AgentsDatum o1, AgentsDatum o2) {
            return o2.getAssignedCount() - o1.getAssignedCount();
        }
    };


    public static Comparator<AgentsDatum> agentClosedAscComparator = new Comparator<AgentsDatum>() {
        @Override
        public int compare(AgentsDatum o1, AgentsDatum o2) {
            return o1.getCurrentlyClosed() - o2.getCurrentlyClosed();
        }
    };


    public static Comparator<AgentsDatum> agentClosedDecComparator = new Comparator<AgentsDatum>() {
        @Override
        public int compare(AgentsDatum o1, AgentsDatum o2) {
            return o2.getCurrentlyClosed() - o1.getCurrentlyClosed();
        }
    };


    public static Comparator<AgentsDatum> agentAvgRespAscComparator = new Comparator<AgentsDatum>() {
        @Override
        public int compare(AgentsDatum o1, AgentsDatum o2) {
            return Double.compare(o1.getAvgFirstResponse(), o2.getAvgFirstResponse());
        }
    };


    public static Comparator<AgentsDatum> agentAvgRespDecComparator = new Comparator<AgentsDatum>() {
        @Override
        public int compare(AgentsDatum o1, AgentsDatum o2) {
            return Double.compare(o2.getAvgFirstResponse(), o1.getAvgFirstResponse());
        }
    };

}