package com.hippoagent.model;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

import java.util.ArrayList;
import java.util.List;

import static com.hippoagent.adapters.ListItem.FUGU_RATING_VIEW;
import static com.hippoagent.adapters.ListItem.LEAD_FORM_VIEW;
import static com.hippoagent.datastructure.FuguAppConstant.FEEDBACK_MESSAGE;

/**
 * Created by Bhavya Rattan on 12/06/17
 * Click Labs
 * bhavya.rattan@click-labs.com
 */

public class Message implements Parcelable {

    @SerializedName("full_name")
    @Expose
    private String fromName;
    @SerializedName("user_id")
    @Expose
    private Integer userId;

    private ArrayList<Integer> taggedUsers = new ArrayList<>();

    public void setSentAtUtc(String sentAtUtc) {
        this.sentAtUtc = sentAtUtc;
    }

    @SerializedName("user_type")
    @Expose
    private Integer userType;

    @SerializedName("date_time")
    @Expose
    private String sentAtUtc = "";
    @SerializedName("message")
    @Expose
    private String message;

    @SerializedName("user_image")
    @Expose
    private String userImage = "";

    public void setMessageStatus(Integer messageStatus) {
        this.messageStatus = messageStatus;
    }

    @SerializedName("message_status")
    @Expose
    private Integer messageStatus;
    @SerializedName("image_url")
    @Expose
    private String imageUrl = "";
    @SerializedName("thumbnail_url")
    @Expose
    private String thumbnailUrl = "";
    private int timeIndex = 0;

    public Integer getMessageType() {
        return messageType;
    }

    public void setMessageType(Integer messageType) {
        this.messageType = messageType;
    }

    public int getType() {
        return messageType;
    }

    @SerializedName("message_type")
    @Expose
    private Integer messageType;

    private Integer originalMessageType;

    public int getOriginalMessageType() {
        return originalMessageType;
    }

    public void setOriginalMessageType(int originalMessageType) {
        this.originalMessageType = originalMessageType;
    }

    private int messageIndex = 0;

    public int getIsMessageExpired() {
        return isMessageExpired;
    }

    public void setIsMessageExpired(int isMessageExpired) {
        this.isMessageExpired = isMessageExpired;
    }

    private int isMessageExpired = 0;
    private boolean isSelf;

    public Integer getMessageStatus() {
        return messageStatus;
    }

    public String getfromName() {
        return fromName;
    }

    public Integer getUserId() {
        return userId;
    }

    public String getSentAtUtc() {
        return sentAtUtc;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public String getThumbnailUrl() {
        return thumbnailUrl;
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    public void setUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public String getFileUrl() {
        return fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    @SerializedName("is_rating_given")
    @Expose
    private int isRatingGiven;
    @SerializedName("total_rating")
    @Expose
    private int totalRating;
    @SerializedName("rating_given")
    @Expose
    private int ratingGiven;
    @SerializedName("muid")
    @Expose
    private String muid;
    @SerializedName("comment")
    @Expose
    private String comment;

    @SerializedName("line_before_feedback")
    @Expose
    private String lineBeforeFeedback;
    @SerializedName("line_after_feedback_1")
    @Expose
    private String lineAfterFeedback_1;
    @SerializedName("line_after_feedback_2")
    @Expose
    private String lineAfterFeedback_2;

    @SerializedName("values")
    @Expose
    private ArrayList<String> values;
    @SerializedName("content_value")
    @Expose
    private List<ContentValue> contentValue = new ArrayList<>();
    @SerializedName("id")
    @Expose
    private String id;
    @SerializedName("video_call_duration")
    @Expose
    private int videoCallDuration;
    @SerializedName("message_state")
    @Expose
    private int messageState;
    @SerializedName("call_type")
    @Expose
    private String callType;

    @SerializedName("custom_action")
    @Expose
    private CustomAction customAction;

    @SerializedName("url")
    @Expose
    private String fileUrl = "";
    @SerializedName("document_type")
    @Expose
    private String documentType;
    @SerializedName("currentprogress")
    private int currentprogress;

    @SerializedName("downloadStatus")
    private int downloadStatus = -1;
    @SerializedName("uploadStatus")
    private int uploadStatus = 0;
    @SerializedName("isAudioPlaying")
    private boolean isAudioPlaying = false;


    @SerializedName("file_name")
    @Expose
    String fileName = "";
    @SerializedName("file_size")
    @Expose
    String fileSize = "";
    @SerializedName("file_extension")
    @Expose
    String fileExtension = "";
    @SerializedName("file_path")
    @Expose
    String filePath = "";
    @SerializedName("image_height")
    @Expose
    private int imageHeight = 700;

    @SerializedName("image_width")
    @Expose
    private int imageWidth = 700;

    @SerializedName("selected_btn_id")
    @Expose
    private String selectedBtnId;
    @SerializedName("is_active")
    @Expose
    private int isActive;
    @SerializedName("integration_source")
    @Expose
    private int integrationSource = 0;

    @SerializedName("replied_by")
    @Expose
    String replied_by = "";
    @SerializedName("replied_user_image")
    @Expose
    String repliedUserImage = "";
    @SerializedName("multi_lang_message")
    @Expose
    String multiLangMessage = "";


    @SerializedName("is_edited")
    @Expose
    private int isEdited = 0;

    private Boolean isEditMode = false;

    private String aboveMuid;
    private Integer aboveUserId = -1;
    private String belowMuid;
    private Integer belowUserId = -1;

    private boolean hasImageView = false;

    private boolean hasNameView = false;

    /*public boolean isHasNameView() {
        return userId.compareTo(aboveUserId) != 0;
    }

    public boolean isHasImageView() {
        return belowUserId == -2 || belowUserId.compareTo(userId) != 0;
    }*/

    public boolean isHasNameView() {
        return userId.compareTo(belowUserId) != 0;
    }

    public boolean isHasImageView() {
        return belowUserId == -2 || (aboveUserId.compareTo(userId) != 0
                && messageType != FUGU_RATING_VIEW && messageType != LEAD_FORM_VIEW);
    }

    public String getAboveMuid() {
        return aboveMuid;
    }

    public void setAboveMuid(String aboveMuid) {
        this.aboveMuid = aboveMuid;
    }

    public Integer getAboveUserId() {
        return aboveUserId;
    }

    public void setAboveUserId(Integer aboveUserId) {
        this.aboveUserId = aboveUserId;
    }

    public String getBelowMuid() {
        return belowMuid;
    }

    public void setBelowMuid(String belowMuid) {
        this.belowMuid = belowMuid;
    }

    public Integer getBelowUserId() {
        return belowUserId;
    }

    public void setBelowUserId(Integer belowUserId) {
        this.belowUserId = belowUserId;
    }

    public int getIsEdited() {
        return isEdited;
    }

    public void setIsEdited(int isEdited) {
        this.isEdited = isEdited;
    }

    public Boolean isEditMode() {
        return isEditMode;
    }

    public void setEditMode(Boolean editMode) {
        isEditMode = editMode;
    }

    public String getRepliedBy() {
        return replied_by;
    }

    public void setRepliedBy(String replied_by) {
        this.replied_by = replied_by;
    }

    public String getRepliedUserImage() {
        return repliedUserImage;
    }

    public void setRepliedUserImage(String repliedUserImage) {
        this.repliedUserImage = repliedUserImage;
    }

    //    @SerializedName("file_size")
//    @Expose
//    String fileSize = "";

    public int getIntegrationSource() {
        return integrationSource;
    }

    public void setIntegrationSource(int integrationSource) {
        this.integrationSource = integrationSource;
    }

    public int getIsActive() {
        return isActive;
    }

    public void setIsActive(int isActive) {
        this.isActive = isActive;
    }

    public String getSelectedBtnId() {
        return selectedBtnId;
    }

    public void setSelectedBtnId(String selectedBtnId) {
        this.selectedBtnId = selectedBtnId;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileSize() {
        return fileSize;
    }

    public void setFileSize(String fileSize) {
        this.fileSize = fileSize;
    }

    public String getFileExtension() {
        return fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public int getImageHeight() {
        return imageHeight;
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
    }

    public int getImageWidth() {
        return imageWidth;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public boolean isAudioPlaying() {
        return isAudioPlaying;
    }

    public void setAudioPlaying(boolean audioPlaying) {
        isAudioPlaying = audioPlaying;
    }

    public int getCurrentprogress() {
        return currentprogress;
    }

    public void setCurrentprogress(int currentprogress) {
        this.currentprogress = currentprogress;
    }

    public int getDownloadStatus() {
        return downloadStatus;
    }

    public void setDownloadStatus(int downloadStatus) {
        this.downloadStatus = downloadStatus;
    }

    public int getUploadStatus() {
        return uploadStatus;
    }

    public void setUploadStatus(int uploadStatus) {
        this.uploadStatus = uploadStatus;
    }
    public String getDocumentType() {
        return documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public int getDownloadId() {
        return downloadId;
    }

    public void setDownloadId(int downloadId) {
        this.downloadId = downloadId;
    }

    private int downloadId;


    public void setCustomAction(final CustomAction customAction) {
        this.customAction = customAction;
    }

    public CustomAction getCustomAction() {
        return customAction;
    }


    public String getCallType() {
        return callType;
    }

    public void setCallType(String callType) {
        this.callType = callType;
    }

    public int getVideoCallDuration() {
        return videoCallDuration;
    }

    public void setVideoCallDuration(int videoCallDuration) {
        this.videoCallDuration = videoCallDuration;
    }

    public Integer getMessageState() {
        return messageState;
    }

    public void setMessageState(Integer messageState) {
        this.messageState = messageState;
    }


    public String getLocalImagePath() {
        return localImagePath;
    }

    private String localImagePath;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }


    public List<ContentValue> getContentValue() {
        return contentValue;
    }

    public void setContentValue(List<ContentValue> contentValue) {
        this.contentValue = contentValue;
    }

    public ArrayList<String> getValues() {
        return values;
    }

    public void setValues(ArrayList<String> values) {
        this.values = values;
    }

    public int getTotalRating() {
        return totalRating;
    }

    public void setTotalRating(int totalRating) {
        this.totalRating = totalRating;
    }

    public int getRatingGiven() {
        return ratingGiven;
    }

    public void setRatingGiven(int ratingGiven) {
        this.ratingGiven = ratingGiven;
    }

    public String getMuid() {
        return muid;
    }

    public void setMuid(String muid) {
        this.muid = muid;
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }


    public void setIsRatingGiven(int isRatingGiven) {
        this.isRatingGiven = isRatingGiven;
    }

    public int getIsRatingGiven() {
        return isRatingGiven;
    }

    public boolean isRatingGiven() {
        return isRatingGiven == 1;
    }

    public String getLineBeforeFeedback() {
        return lineBeforeFeedback;
    }

    public void setLineBeforeFeedback(String lineBeforeFeedback) {
        this.lineBeforeFeedback = lineBeforeFeedback;
    }

    public String getLineAfterFeedback_1() {
        return lineAfterFeedback_1;
    }

    public void setLineAfterFeedback_1(String lineAfterFeedback_1) {
        this.lineAfterFeedback_1 = lineAfterFeedback_1;
    }

    public String getLineAfterFeedback_2() {
        return lineAfterFeedback_2;
    }

    public void setLineAfterFeedback_2(String lineAfterFeedback_2) {
        this.lineAfterFeedback_2 = lineAfterFeedback_2;
    }

    public void setTaggedUsers(ArrayList<Integer> taggedUsers) {
        this.taggedUsers = taggedUsers;
    }

    public String getUserImage() {
        return userImage;
    }

    public void setUserImage(String userImage) {
        this.userImage = userImage;
    }

    public String getMultiLangMessage() {
        return multiLangMessage;
    }

    public void setMultiLangMessage(String multiLangMessage) {
        this.multiLangMessage = multiLangMessage;
    }

    public Message() {
    }

    public Message(String fromName, Integer userId, String sentAtUtc, String message,
                   Integer messageStatus, String imageUrl, String thumbnailUrl, Integer messageType, Integer userType) {
        this.fromName = fromName;
        this.userId = userId;
        this.sentAtUtc = sentAtUtc;
        this.message = message;
        this.messageStatus = messageStatus;
        this.imageUrl = imageUrl;
        this.thumbnailUrl = thumbnailUrl;
        this.messageType = messageType;
        this.userType = userType;
    }


    public Message(String fromName, Integer userId, String message, String sentAtUtc, boolean isSelf,
                   int messageStatus, int messageIndex, Integer messageType, Integer userType) {
        this.fromName = fromName;
        this.userId = userId;
        this.message = message;
        this.sentAtUtc = sentAtUtc;
        this.isSelf = isSelf;
        this.messageStatus = messageStatus;
        this.messageIndex = messageIndex;
        this.messageType = messageType;
        this.userType = userType;
    }

    public Message(String fromName, Integer userId, String message, String sentAtUtc, boolean isSelf,
                   int messageStatus, int messageIndex, String imageUrl, String thumbnailUrl,
                   Integer messageType, Integer userType) {

        this.fromName = fromName;
        this.userId = userId;
        this.message = message;
        this.sentAtUtc = sentAtUtc;
        this.isSelf = isSelf;
        this.messageStatus = messageStatus;
        this.messageIndex = messageIndex;
        this.imageUrl = imageUrl;
        this.thumbnailUrl = thumbnailUrl;
        this.messageType = messageType;
        this.userType = userType;
    }

    public void setMessageIndex(int messageIndex) {
        this.messageIndex = messageIndex;
    }

    public int getMessageIndex() {
        return messageIndex;
    }

    public boolean isSelf() {
        return isSelf;
    }

    public boolean isRating() {
        return messageType == FEEDBACK_MESSAGE;
    }

    public Integer getUserType() {
        return userType;
    }

    public int getTimeIndex() {
        return timeIndex;
    }

    public void setTimeIndex(int timeIndex) {
        this.timeIndex = timeIndex;
    }

    public void setLocalImagePath(String localImagePath) {
        this.localImagePath = localImagePath;
    }

    private String date;
    private boolean isDateView = false;

    public boolean isDateView() {
        return isDateView;
    }

    public void setDateView(boolean dateView) {
        isDateView = dateView;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public Message(String date, boolean isDateView) {
        this.date = date;
        this.isDateView = isDateView;
        this.messageType = 0;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.fromName);
        dest.writeValue(this.userId);
        dest.writeList(this.taggedUsers);
        dest.writeValue(this.userType);
        dest.writeString(this.sentAtUtc);
        dest.writeString(this.message);
        dest.writeValue(this.messageStatus);
        dest.writeString(this.imageUrl);
        dest.writeString(this.thumbnailUrl);
        dest.writeInt(this.timeIndex);
        dest.writeValue(this.messageType);
        dest.writeInt(this.messageIndex);
        dest.writeInt(this.isMessageExpired);
        dest.writeByte(this.isSelf ? (byte) 1 : (byte) 0);
        dest.writeInt(this.isRatingGiven);
        dest.writeInt(this.totalRating);
        dest.writeInt(this.ratingGiven);
        dest.writeString(this.muid);
        dest.writeString(this.comment);
        dest.writeString(this.lineBeforeFeedback);
        dest.writeString(this.lineAfterFeedback_1);
        dest.writeString(this.lineAfterFeedback_2);
        dest.writeStringList(this.values);
        dest.writeTypedList(this.contentValue);
        dest.writeString(this.id);
        dest.writeInt(this.videoCallDuration);
        dest.writeInt(this.messageState);
        dest.writeString(this.callType);
        dest.writeParcelable(this.customAction, flags);
        dest.writeString(this.localImagePath);
        dest.writeInt(this.integrationSource);
        dest.writeString(this.replied_by);
        dest.writeInt(this.isEdited);
        dest.writeValue(this.aboveUserId);
        dest.writeValue(this.belowUserId);
        dest.writeString(this.aboveMuid);
        dest.writeString(this.belowMuid);
        dest.writeString(this.userImage);
        dest.writeString(this.repliedUserImage);
        dest.writeString(this.multiLangMessage);

    }

    protected Message(Parcel in) {
        this.fromName = in.readString();
        this.userId = (Integer) in.readValue(Integer.class.getClassLoader());
        this.taggedUsers = new ArrayList<Integer>();
        in.readList(this.taggedUsers, Integer.class.getClassLoader());
        this.userType = (Integer) in.readValue(Integer.class.getClassLoader());
        this.sentAtUtc = in.readString();
        this.message = in.readString();
        this.messageStatus = (Integer) in.readValue(Integer.class.getClassLoader());
        this.imageUrl = in.readString();
        this.thumbnailUrl = in.readString();
        this.timeIndex = in.readInt();
        this.messageType = (Integer) in.readValue(Integer.class.getClassLoader());
        this.messageIndex = in.readInt();
        this.isMessageExpired = in.readInt();
        this.isSelf = in.readByte() != 0;
        this.isRatingGiven = in.readInt();
        this.totalRating = in.readInt();
        this.ratingGiven = in.readInt();
        this.muid = in.readString();
        this.comment = in.readString();
        this.lineBeforeFeedback = in.readString();
        this.lineAfterFeedback_1 = in.readString();
        this.lineAfterFeedback_2 = in.readString();
        this.values = in.createStringArrayList();
        this.contentValue = in.createTypedArrayList(ContentValue.CREATOR);
        this.id = in.readString();
        this.videoCallDuration = in.readInt();
        this.messageState = in.readInt();
        this.callType = in.readString();
        this.customAction = in.readParcelable(CustomAction.class.getClassLoader());
        this.localImagePath = in.readString();
        this.integrationSource = in.readInt();
        this.replied_by = in.readString();
        this.isEdited = in.readInt();
        this.aboveUserId = (Integer) in.readValue(Integer.class.getClassLoader());
        this.belowUserId = (Integer) in.readValue(Integer.class.getClassLoader());
        this.aboveMuid = in.readString();
        this.belowMuid = in.readString();
        this.userImage = in.readString();
        this.repliedUserImage = in.readString();
        this.multiLangMessage = in.readString();
    }

    public static final Creator<Message> CREATOR = new Creator<Message>() {
        @Override
        public Message createFromParcel(Parcel source) {
            return new Message(source);
        }

        @Override
        public Message[] newArray(int size) {
            return new Message[size];
        }
    };
}

